<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=WIPFromProductionResults.xls");
header("Pragma: no-cache");
header("Expires: 0");
## get all jobs that are open - get job#, item,  quantity good, SO Line #, SO#
## walk through each job
## check for production results for that job - get the quantity_good and the routing number
## cap the quantity good for the step at the quantity scheduled for the job
## subtract the job quantity good from the step
## get PPH and people from the routing number, and get operation cost from operation table
## get consumed parts from the routing number/BOM - add those costs in based on step quantity
## I think we also need to take inventory of all components, subassemblies, and painted parts

$sql="SELECT j.job_id, j.item_id, quantity_scheduled, quantity_good, j.line_id, l.order_id, l.due_date FROM jobs j left outer join order_lines l on j.line_id=l.line_id ";
$sql.=" left outer join orders o on l.order_id=o.order_id ";
$sql.=" where j.status=1 and quantity_good < quantity_scheduled  and coalesce(o.status,1) not in (3,4,5,6) and quantity_scheduled < 10000 and ";
$sql.=" coalesce(shipped_quantity,0) < quantity_scheduled order by start_date";
list($rs,$err)=runIQuery($db,$sql);
print "Job\tOrder Due\tPart\tSO\tStep\tQuantity\tLabor\tMaterial\tTotal Value\n";
$totalLabor=0;
$totalMaterial=0;
foreach ($rs as $data) {
    $job=$data['job_id'];
    $item=$data['item_id'];
    $jobGood=$data['quantity_good'];
    $line=$data['line_id'];
    $order=$data['order_id'];
    $scheduled=$data['quantity_scheduled'];
    $due=formatDateDBToWeb($data['due_date']);
    ## exclude Outside Process, material handling, and quality inspection from this
    $sql="select pr.routing_id, operation_name, r.people, r.pph, operation_cost,  sum(quantity_good) as good from production_results pr ";
    $sql.=" inner join routing r on pr.routing_id=r.routing_id ";
    $sql.=" inner join operations op on r.operation_id=op.operation_id ";
    $sql.=" where job_id=? and r.operation_id <> 3106 and r.operation_id <> 3090 and r.operation_id <> 3107 ";
    $sql.=" group by pr.routing_id, operation_name, r.people, r.pph, operation_cost ";
    list($rrs,$err)=runIQuery($db,$sql,array("i",$job));
    foreach ($rrs as $rdata) {
        $routing=$rdata['routing_id'];
        $operation=$rdata['operation_name'];
        $people=$rdata['people'];
        if ($people == 0) {
            $people=1;
        }
        $pph=$rdata['pph'];
        $cost=$rdata['operation_cost'];
        $good=$rdata['good'];
        ## cap quantity good at quantity scheduled because people hit buttons too many times
        if ($good > $scheduled) {
            $good=$scheduled;
        }
        ## they are not WIP if they are finished - remainder is how many you can count
        $remainder=$good - $jobGood;
        if ($remainder > 0) {
            if ($cost == 0) {
                print "Operation Cost Zero $operation<br>";
            }
            if ($pph == 0) {
                print "PPH zero for item $item, operation $operation<br>";
                $labor=0;
            } else {
                $labor=$remainder / $pph * $cost;
            }
            $material=0;
            $sql="select quantity_per, cost from billofmaterial b, items i where b.parent_item=? and routing_id=? and child_item=i.item_name ";
            list($mrs,$err)=runIQuery($db,$sql,array("si",$item,$routing));
            foreach($mrs as $mdata) {
                $thisMaterial=$mdata['quantity_per'] * $mdata['cost'] * $remainder;
                $material+=$thisMaterial;
            }
            $labor=round($labor,2);
            $material=round($material,2);
            $totalLabor+=$labor;
            $totalMaterial+=$material;
            $wip=$labor+$material;
            $labor=number_format($labor,2);
            $material=number_format($material,2);
            $wip=number_format($wip,2);
            print "Job\tOrder Due\tPart\tSO\tStep\tQuantity\tLabor\tMaterial\tTotal Value\n";
            print "$job\t$due\t$item\t$order\t$operation\t$remainder\t$labor\t$material\t$wip\n";
        }
    }
}
$total=$totalLabor+$totalMaterial;
print "\t\t\t\t\t\t$total\n";
print "<tr><td colspan='5'>Total WIP Step 1</td><td>";
print number_format($totalLabor,2);
print "</td><td>";
print number_format($totalMaterial,2);
print "</td><td>";
print number_format($total,2);
print "</td></tr>\n";
print "</tbody>";
print "</table>";
print "<center>Inventory that is WIP</center>";
print "<table class='table table-striped'>";
print "<thead><tr><th>Part</th><th>Cost</th><th>Quantity On Hand</th><th>Value</th></thead><tbody>\n";
$sql="select item_name, item_category, cost, wip_cost, quantity_on_hand from items where item_category in (14,17, 18, 19, 21, 24) and vendor_id=0 and item_name in (select child_item from billofmaterial) ";
$sql.=" order by wip_cost * quantity_on_hand, item_name ";
list($rs,$err)=runIQuery($db,$sql);
$totalInventory=0;
foreach ($rs as $data) {
    $item=$data['item_name'];
    $cost=$data['cost'];
    $wipcost=$data['wip_cost'];
    $category=$data['item_category'];
    if ($wipcost == 0 ) {
        ## need to calculate the cost
        if (in_array($category, array(14, 17, 24))) {
            $wipcost=$cost;
            $sql="update items set wip_cost=? where item_name=?";
            list($updrs,$err)=runIQuery($db,$sql,array("ds",$wipcost,$item));
        } else {
            $wipcost=calculateCost($db,$item);
            $sql="update items set wip_cost=? where item_name=?";
            list($updrs,$err)=runIQuery($db,$sql,array("ds",$wipcost,$item));
        }
    }
    $qty=$data['quantity_on_hand'];
    if ($qty < 0) {
        $qty=0;
    }
    if ($qty > 0) {
        $ext=$wipcost*$qty;
        $totalInventory+=$ext;
        $wipcost=number_format($wipcost,4);
        $ext=number_format($ext,2);
        print "<tr><td>$item</td><td>$wipcost</td><td>$qty</td><td>$ext</td></tr>";
    }
}
print "<tr><td colspan='3'>Total</td><td>";
print number_format($totalInventory,2);
print "</td></tr>";
print "</tbody>";
print "</table>";
$totalWIP=$total+$totalInventory;
print "Total WIP From Production Results: ";
print number_format($total,2);
print "<br>";
print "Total WIP From Inventory: ";
print number_format($totalInventory,2);
print "<br><BR>";
print "Total WIP: ";
print number_format($totalWIP,2);
print "<br>";



print renderClosePanel();
include('footer.php');