<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
$customer=693;
$title="Dematic Orders with Status";
$ttl=str_replace(" ","",$title);
$filename=$userID . "-" . $ttl . "-Export.xls";
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=$filename");
header("Pragma: no-cache");
header("Expires: 0");


$sql="select orders.po_number, customers.name as customer, orders.order_id, status_name as status, ol.item_id as item, orders.ship_name, ";
$sql.=" coalesce(l.quantity, ol.quantity) as quantity, ol.price,  date_order, due_date, coalesce(date_shipped,'0000-00-00') as date_shipped, coalesce(po_date,'') as at_paint ";
$sql.=" from orders inner join customers on orders.customer_id=customers.customer_id inner join order_status on orders.status=order_status.status_id ";
$sql.=" and status_name <> 'Cancelled' inner join order_lines ol on orders.order_id=ol.order_id ";
$sql.=" left outer join  packing_slip_lines l on orders.order_id=l.order_id and ol.line_id=l.order_line ";
$sql.=" left outer join packing_slip p on packing_list_id=packing_slip_id left outer join jobs on jobs.line_id=ol.line_id ";
$sql.=" left outer join po_lines pl on pl.job_id=jobs.job_id left outer join purchase_orders po on pl.po_id=po.po_id ";
$sql.=" where orders.customer_id=? order by orders.po_number  ";

$sql="select orders.po_number, customers.name as customer, orders.order_id, status_name as status, ol.item_id as item, orders.ship_name, ";
$sql.=" ol.quantity, date_order, due_date, ol.line_id";
$sql.=" from orders inner join customers on orders.po_number <> 'Invoice' and orders.po_number <> 'PPAP' and orders.customer_id=customers.customer_id ";
$sql.=" inner join order_status on orders.status=order_status.status_id ";
$sql.=" and status_name <> 'Cancelled' inner join order_lines ol on orders.order_id=ol.order_id ";
$sql.=" where orders.customer_id=? and date_order > '2020-01-01' order by orders.po_number  ";


print "PO Number\tCustomer\tSO\tStatus\tItem\tShip To\tQuantity\tPrice\tCost\tDate Order\tDue Date\tDate Shipped\tAt Processor\r\n";

list($result,$err)=runIQuery($db,$sql,array("i",$customer),false);



$delimiter = "\t";

foreach ($result as $data) {
	set_time_limit(100);
	$po=$data['po_number'];
	$customer=$data['customer'];
	$so=$data['order_id'];
	$status=$data['status'];
	$item=$data['item_id'];
	$ship=$data['ship_name'];
	$qty=$data['quantity'];
	$price=$data['price'];
	$cost=$data['cost'];
	$dateOrder=formatDateDBToWeb($data['date_order']);
	$due=formatDateDBToWeb($data['due_date']);
	$line=$data['line_id'];
	$atPaint="";
	$sql="select po_date from jobs j, po_lines pl, purchase_orders po where j.line_id=? and pl.job_id=j.job_id and pl.po_id=po.po_id ";
	list($rs,$err)=runIQuery($db,$sql,array('i',$line));
	if (count($rs)>0) {
		$pdata=$rs[0];
		$atPaint=formatDateDBToWeb($pdata['po_date']);
	}
	$dt="";
	$sql="select date_shipped, quantity from packing_slip_lines l, packing_slip p where l.order_line=? and l.packing_list_id=p.packing_slip_id";
	list($rs,$err)=runIQuery($db,$sql,array('i',$line));
	if (count($rs)>0) {
		foreach ($rs as $pdata) {
			$dt=formatDateDBToWeb($pdata['date_shipped']);
			$qty=$pdata['quantity'];
			print "$po\t$customer\t$so\t$status\t$item\t$ship\t$qty\t$dateOrder\t$due\t$dt\t$atPaint\r\n";
		}
	} else {
		print "$po\t$customer\t$so\t$status\t$item\t$ship\t$qty\t$dateOrder\t$due\t$dt\t$atPaint\r\n";
	}
}
