<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

print renderPanel("Enter Job Defects","","red","span11","cogs");

// getting the data passed from timeEntry/laserTimeEntry/batchTimeEntry
$job=0;
if (isset($_GET['job'])) {
	$job=$_GET['job'];
} 

$routing=0;
if (isset($_GET['routing'])) {
	$routing=$_GET['routing'];
}

$step=0;
if (isset($_GET['step'])) {
	$step=$_GET['step'];
} 

$who=0;
$type=0;

if ($job) {
    print "<h3>Defects for Job $job</h3>";
} else {
    print "<h3>Missing Job</h3>";
}
print "<h4 style='color: red'>Please provide a detailed root cause and resolution for this job defect.</h4>";
//search form for date range and customer
print "<form name='enterdefects' id='enterdefects' action='enterJobDefects.php' method='POST'>";
//print renderDateBox(TRUE,"start_date",$startDate,"Start Date");
print "<div style='display: flex; flex-direction: row'>";
//quantity of defects
print "<div>";
print "<label for='quantity'>Enter Quantity of Defects</label>";
print "<input id='quantity' name='quantity' type='number' step='1' value='0'>";
print "</div>";
//caused by
$sql="SELECT employee_id, CONCAT(employees.first_name, ' ',employees.last_name) AS full_name FROM employees WHERE inactive<>1 ORDER BY full_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"who",$who,"Caused By","N",$rs,1);
//type of defects
$sql="SELECT defect_id, defect_name FROM defect_types ORDER BY defect_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"type",$type,"Type of Defect","N",$rs,1);
print "</div>";
print "<div>";
## bdoss adding new fields to mimic machine's updates: cause and resolution
print renderTextArea(TRUE,"cause_text","","Cause","400px");
print renderTextArea(TRUE,"resolution_text","","Resolution","400px");
print "</div>";
//notes
print "<div>";
print renderTextArea(TRUE,"notes","","Notes","400px");
print "</div>";
print renderButton("Enter Job Defects","red","enterDefects($job, $userID, $routing, $step);");
print "</form>";


print renderClosePanel();
?>
<style>
	form {
		display: flex;
		flex-direction: column;
	}

	button {
		width: 150px;
	}
	
</style>
<script>

	let cause = document.getElementById('cause_text');
	let resolution = document.getElementById('resolution_text');
	let type = document.getElementById('type');
	let who = document.getElementById('who');
	let quantity = document.getElementById('quantity');

	function page_init() {

	}

	function enterDefects(job, user, routing, step) {

		if (cause.value == 0 || resolution.value == 0 || type.value == 0 || who.value == 0 || !(quantity.value > 0)) {
			if (!(quantity.value > 0)) {
				alert("A quantity greater than 0 must be provided");
			}
			if (cause.value == 0) {
				alert("Cause field is required.")
			}
			if (resolution.value == 0) {
				alert("Resolution field is required.")
			}
		} else {
			var url = `updateJobDefects.php?job=${job}&user=${user}&routing=${routing}&step=${step}&rand=${Math.random()}`; // the script where you handle the form input.
			formdata=$("#enterdefects").serialize();
			
				$.ajax({
				type: "POST",
				url: url,
				data: formdata, // serializes the form's elements.
				success: function(data)
				{
					$.gritter.add("Defect Logged");
					console.log(data);
				}
				});
		}	
	}


</script>

<?php 
include('footer.php');
?>