<?php
include('dbConnection.php');
include('security.php');
include('functions.php');

$export = 0;
if (isset($_GET["export"])) {
    $export = 1;
}
if (!$export) {
    include('header.php');
}

$start = date("Y-m-d", strtotime("last week sunday"));
$end = date("Y-m-d", strtotime("this week sunday"));
if (isset($_GET["start"])) {
    $start=$_GET["start"];
}
if (isset($_GET["end"])) {
    $end=$_GET["end"];
}
$who = 0;
if (isset($_GET["who"])) {
    $who=$_GET["who"];
}
$emp = $who;
if ($who) {
    $sql = "select concat(e.first_name, ' ', e.last_name) as full_name from employees e, site_admins s where s.email=? and s.employee_link=e.employee_id";
    list($rs,$err)=runIQuery($db,$sql,["s",$who]);
    if (count($rs)) {
        $emp = $rs[0][0];
    }
}

if (!$export) {
    print "<form name='eform' id='eform' action='engineeringEfficiency.php' method='GET'>";
    print renderPanel("Engineering Efficiency");

    print renderDateBox(TRUE,"start",$start,"From");
    print renderDateBox(TRUE,"end",$end,"To");
}

$sql = "select s.email, concat(e.first_name, ' ', e.last_name) as full_name from employees e, departments t, site_admins s where e.employee_id=s.employee_link and e.department_id=t.department_id and t.department_id=10";
list($ers,$err)=runIQuery($db,$sql);
$wholist = $ers;
array_unshift($wholist, ["0","Not Selected"]);
if (!$export) {
    print renderSelect(TRUE,"who",$who,"Who","S",$wholist);

    print renderStartItem(TRUE,"","‎");
    print renderButton("Apply","blue");
    print "<a href='#' id='downloader'> " . renderButton("Export","green", "tableToTab('EngineerEfficiency-" . str_replace(" ","_",$emp) . "-$start-$end')") . "</a>";
    print renderEndItem() . "<br><br><br><hr></form>";

    print "<table class='table table-condensed'>
        <thead>
            <tr>
                <th>Employee</th>
                <th>Headers Created</th>
                <th>Planned Headers</th>
                <th>% to Plan</th>
                <th>Lines Entered</th>
                <th>Planned Lines</th>
                <th>% to Plan</th>
                <th>Items Created</th>
                <th>Planned Items</th>
                <th>% to Plan</th>
                <th>KPI %</th>
            </tr>
        </thead>
        <tbody>";
} else {
    header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=EngineerEfficiency.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    print "Employee\tHeaders Created\tPlanned Headers\t% to Plan\tLines Entered\tPlanned Lines\t% to Plan\tItems Created\tPlanned Items\t% to Plan\tKPI %\n";
}
    if ($who) {
        $ers = [["email" => $who, "full_name" => $emp]];
    } else {
        reset($ers);
    }

    $start = formatDateWebtoDB($start);
    $end = formatDateWebtoDB($end);
    $startday = date("z",strtotime($start));
    $endday = date("z",strtotime($end));
    $diff = ($endday - $startday);
    $i=0;
    $weekdays=0;
    while ($diff > $i) { //need to get exactly how many WEEKDAYS have passed between the two dates
        $i++;
        $day = date("w",strtotime($start . " +$i day"));
        if ($day != 0 && $day != 6) {
            $weekdays++;
        }
    }


    $planned_headers = 4*$weekdays;
    $planned_lines = 22*$weekdays;
    $planned_items = 20*$weekdays;

    foreach ($ers as $edata) {
        $ewho = $edata["email"];
        $eemp = $edata["full_name"];

        $sql = "select count(*) from transaction_log where `who`=? and `table_name`='order_lines' and sql_statement like 'insert%' and `when` >= ? and `when` <= ?";
        list($rs,$err)=runIQuery($db,$sql,["sss",$ewho,$start,$end]);
        $linecount = $rs[0][0];

        $sql = "select count(*) from transaction_log where `who`=? and `table_name`='items' and sql_statement like 'insert%' and `when` >= ? and `when` <= ?";
        list($rs,$err)=runIQuery($db,$sql,["sss",$ewho,$start,$end]);
        $itemcount = $rs[0][0];

        $sql = "select count(*) from transaction_log where `who`=? and `table_name`='orders' and sql_statement like 'insert%' and `when` >= ? and `when` <= ?";
        list($rs,$err)=runIQuery($db,$sql,["sss",$ewho,$start,$end]);
        $headercount = $rs[0][0];

        $header_percent = round(($headercount/$planned_headers)*100);
        $line_percent = round(($linecount/$planned_lines)*100);
        $item_percent = round(($itemcount/$planned_items)*100);
        $kpi = round(($item_percent+$line_percent+$header_percent)/3);
        // emp, headers, planned headers, % to plan, lines, planned, %, items, planned, %, kpi

        if ($export) {
            print "$eemp\t$headercount\t$planned_headers\t$header_percent%\t$linecount\t$planned_lines\t$line_percent%\t$itemcount\t$planned_items\t$item_percent%\t$kpi%\n";
        } else {
            print "<tr>";
                print "<th>" . $eemp . "</th>";
                print "<th>" . $headercount . "</th>";
                print "<th>" . $planned_headers . "</th>";
                print "<th>" . $header_percent . "%</th>";
                print "<th>" . $linecount . "</th>";
                print "<th>" . $planned_lines . "</th>";
                print "<th>" . $line_percent . "%</th>";
                print "<th>" . $itemcount . "</th>";
                print "<th>" . $planned_items . "</th>";
                print "<th>" . $item_percent . "%</th>";
                print "<th>" . $kpi . "%</th>";
            print "</tr>";
        }
    }

if (!$export) {
    print "</tbody>
    </table>";

    print renderClosePanel();
    include('footer.php');
?>
<script>
    function tableToTab(name="tablexport") {
        var header = "";
        var body = "";

        $(".table thead").children().each((i,x) => {
            $(x).children().each((i,b) => {
                if (header != "") {
                    header += "\t";
                }
                header += b.innerText;
            });
            header += "\n";
        });
        $(".table tbody").children().each((i,x) => {
            $(x).children().each((i,b) => {
                body += b.innerText + "\t";
            });
            body += "\n";
        });

        var csv = header + body;

        var a = document.getElementById("downloader");
        var file = new Blob([csv], {type: 'text/plain'});
        a.href = URL.createObjectURL(file);
        a.download = name + ".xls";
    }
</script>
<?php } ?>