<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Employee Efficiency";
include('header.php');
date_default_timezone_set('America/Detroit');
$sql="SET time_zone = '" .date('P') . "'";
list($rs,$err)=runIQuery($db,$sql);
$start=Date("m/d/Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
$end=$start;
if (isset($_GET['end'])) {
	$end=$_GET['end'];
}
$team="";
if (isset($_GET['team'])) {
    $team=$_GET['team'];
}
$employee="";
if (isset($_GET['employee'])) {
    $employee=$_GET['employee'];
}
$canView=$isAdmin;
$sql="select * from departments where `lead`=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
if (count($rs)) {
    $canView=1;
}
if (! $canView) {
    $employee=$userEmployeeID;
}

print renderPanel("Employee Efficiency","","blue","span11","cogs");
print "<form name='findform' action='employeeEfficiency.php' method='GET>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print "<div style='clear: both;'></div>\n";
if ($canView) {
$sql="select department_id, department_name from departments order by department_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"team",$team,"Department","N",$rs,1);
$sql="select employee_id, concat(last_name, ', ', first_name) as name from employees order by last_name, first_name ";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"employee",$employee,"Employee","N",$rs,1);
}
print "<div class='btn green hidden-print' onclick='document.findform.submit();'>Find</div>";
print renderButton("Export","blue","exportEfficiency()");
print "</form>";
if ($team == 10) {
    print "<h4>For full activity, Step 2 should be viewed in Preferred Machines ERP</h4>";
}
print "<table class='table table-striped' id='dtResults'>";
print "<thead>";
print "<tr>";
print "<th>Department</th>";
print "<th>Employee</th>";
print "<th>Time Clock Minutes</th>";
print "<th>Production Minutes</th>";
print "<th>Indirect Minutes</th>";
print "<th>Indirect %</th>";
print "<th>Efficiency %</th>";
if ($team == 1) {
    print "<th>Complete Production Minutes</th>";
    print "<th>Complete Planned Minutes</th>";
} else {
    print "<th>Planned Minutes</th>";
}
print "<th>% to Plan</th>";
print "<th>KPI %</th>";
if ($team == 10) {
    ## step 2
    print "<th>Lines Entered</th>";
    print "<th>Lines/Hour</th>";
    print "<th>Expected Lines/Hour</th>";
    print "<th>% to Plan</th>";
} else {
    print "<th>Parts</th>";
    print "<th>Pieces</th>";
    print "<th>Scrap Parts</th>";
    print "<th>Scrap Pieces</th>";
}
print "</tr>";
print "</thead>";
print "<tbody>";

$sql="update routing set people=1 where people=0";
list($rs,$err)=runIQuery($db,$sql);
include('employeeEfficiencySub.php');
$parts=array();
$lc=0;
$totalPct=0;
$totalIndirectPct=0;
$totalPercentToPlan=0;
$totalKPIPercent=0;
foreach ($rs as $data) {
    $lc++;
    $teamName=$data['team'];
    $employee=$data['last_name'] . ", " . $data['first_name'];
    $last=$data['last_name'];
    $first=$data['first_name'];
    $clock=$data['clock_minutes'];
    $employeeID=$data['employee_id'];
    unset($parts);
    $parts=array();
    print "<tr><td>$teamName</td>";
    print "<td><a href='planToActual.php?employee=$employeeID&start=$start&end=$end' target='_blank'>$employee</a></td>";
    print "<td>$clock</td>";
    $sql="select  ";
    $sql.=" sum(duration_hours) as production_hours, sum(r.duration_minutes) as production_minutes ";
    $sql.="  from production_results r inner join employees e on r.employee_id=e.employee_id  ";
    $sql.=" inner join jobs j on r.job_id=j.job_id and j.item_id like 'INDIRECT%' ";
    $sql.=" where result_date >= '$sd' and result_date <= '$ed'  ";
    $sql.=" and e.employee_id=$employeeID ";
    list($prs,$err)=runIQuery($db,$sql);
    $pdata=$prs[0];
    $hours=$pdata['production_hours'];
    $minutes=$pdata['production_minutes'];
    $minutes+=($hours*60);
    $otherMinutes=$minutes;
    ## people is not a factor because each person will get the production results record for themselves

    $sql="select item_id,  r.quantity_good, pph, duration_hours, duration_minutes, r.job_id ";
    $sql.="  from production_results r inner join employees e on r.employee_id=e.employee_id   ";
    $sql.=" inner join routing rt on r.routing_id=rt.routing_id ";
    $sql.=" inner join jobs j on r.job_id=j.job_id and j.item_id not like 'INDIRECT%' ";
    $sql.=" where result_date >= '$sd' and result_date <= '$ed'  ";
    $sql.=" and e.employee_id=$employeeID ";
    list($prs,$err)=runIQuery($db,$sql);
    $plannedMinutes=0;  ## Being updated
    $minutes=0; ## Being updated
    $totalGood=0;
    $totalScrap=0;
    $totalScrapPieces=0;
    $pieces=0;
    $scraplist=array();
    $joblist=array();
    foreach ($prs as $pdata) {
        $good=$pdata['quantity_good'];
        $totalGood+=$good;
        $part=$pdata['item_id'];
        $job=$pdata['job_id'];
        if (! in_array($part,$parts)) {
            $parts[]=$part;
        }
        $pph=$pdata['pph'];
        $hours=$pdata['duration_hours'];
        $jobMinutes=($hours*60)+$pdata['duration_minutes'];
        $minutes+=$jobMinutes;
        if (! $pph) {
            $pph=60;
        }
        if ($pph == 0) {
            $pph=60;
        }
        $plan=60/$pph;
        if ($good > 0) {
            $plan=$plan*$good;
        }
        $plannedMinutes+=$plan;
        $pct="";  ## Being updated
        if ($plan > 0) {
            $pct = $jobMinutes / $plan;
        }
        if (! in_array($job,$joblist)) {
            $joblist[]=$job;
            $sql="select quantity from job_defects where job_id=? and date_reported >= $sd and date_reported <= $ed ";
            list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
            foreach ($jrs as $jdata) {
                if (! in_array($part,$scraplist)) {
                    $scraplist[]=$part;
                }
                $sqty=$jdata['quantity'];
                if ($sqty > 1000) {
                    print "qty is $sqty for job $job<br>";
                }
                $totalScrapPieces+=$jdata['quantity'];
            }
        }
    }
    ## Complete job results for team 1 (fab)
	## TODO change over to departments
    if ($team == 1) {
        $sql="select sum(r.quantity_good) as good, j.item_id, j.status, o.status, rt.pph, r.complete,  j.quantity_scheduled, sum(r.duration_hours) as hours, sum(r.duration_minutes) as minutes";
        $sql.=" from production_results r inner join routing rt on r.routing_id=rt.routing_id inner join jobs j on r.job_id=j.job_id ";
        $sql.=" and j.item_id not like 'INDIRECT%' inner join order_lines l on j.line_id=l.line_id inner join orders o on l.order_id=o.order_id ";
        $sql.=" where r.employee_id=? and rt.pph > 0 ";
        $sql.=" and result_date >= ? and result_date <= ?  ";
        $sql.=" group by j.item_id, j.quantity_scheduled, j.status, o.status, rt.pph, r.complete ";
        $sql.=" having sum(r.quantity_good) >= j.quantity_scheduled or j.status in (2, 9) or o.status in (3,4) or  coalesce(r.complete,0)=1 ";
        list($crs,$err)=runIQuery($db,$sql,array("iss",$employeeID,$sd,$ed));
        if ($err) {
            print "error: $err<br>";
        }
        $completeMinutes=0;
        $completePlannedMinutes=0;
        $completePCT=0;
        foreach ($crs as $cdata) {
            $completeGood=$cdata['good'];
            $completePPH=$cdata['pph'];
            $completeHours=$cdata['hours'];
            $completeJobMinutes=($completeHours*60)+$cdata['minutes'];
            $completeMinutes+=$completeJobMinutes;

            if (! $completePPH) {
                $completePPH=60;
            }
            if ($completePPH == 0) {
                $completePPH=60;
            }
            $completePlan=60/$completePPH;
            if ($completeGood > 0) {
                $completePlan=$completePlan*$completeGood;
            }
            $completePlannedMinutes+=$completePlan;
            $completePCT="";  ## Being updated
            if ($completeMinutes > 0) {
                $completePCT = round($completePlannedMinutes / $completeMinutes * 100);
            }
        }
    }
    ## End of team 1 changes
    $partCount=count($parts);
    $scrapPartCount=count($scraplist);
    print "<td>$minutes</td>";
    print "<td>$otherMinutes</td>";
    if ($clock > 0) {
        $opct=round($otherMinutes / $clock * 100,1);
        $totalIndirectPct+=$opct;
    } else {
        $opct="";
    }
    print "<td>$opct %</td>";
    if ($clock > 0) {
        $epct=($minutes) / $clock * 100;
        $epct=number_format($epct,1);
        $pct=$epct;
    } else {
        $pct=0;
    }
    print "<td>";
    print $pct;
    if ($teamName != "Laser/Bend" and $teamName != "Machining") {
        if ($pct > 100) {
            $pct=100;
            print "<span style='color: red; font-size: 20px;' alt='Only 100 used' title='Only 100 used'>*</span>";
        }
    }
    print "</td>";
    $totalPct+=$pct;
    print "<td>";
    $efficiency=0;
    $efficiency=$pct;
    if ($team == 1) {
        print $completeMinutes;
        print "</td><td>";
        print number_format($completePlannedMinutes);
    } else {
            print number_format($plannedMinutes,1); ## Being updated complete planned minutes
    }
    print "</td>";
    $ppct=0;
    if ($minutes > 0) {
        $ppct=$plannedMinutes/$minutes*100;
    }
    $pct=number_format($ppct,1);
    if ($team != 1) {
        $totalPercentToPlan+=$pct;
    }
    if ($team == 1) {
        if ($completePCT == "") {
            $completePCT = 0;
        }
        $totalPercentToPlan+=$completePCT;
        print "<td>$completePCT</td>";
        $kpi=($efficiency + $completePCT) / 2;
        $totalKPIPercent+=$kpi;
        print "<td>$kpi</td>";
    } else {
        print "<td>$pct</td>"; ## Being updated % to plan
        $avg=($epct+$ppct)/2;
        $pct=number_format($avg,1);
        $totalKPIPercent+=$pct;
        print "<td>$pct</td>";
    }

    if ($team == 10) {
        $sql="select count(*) from transaction_log where `who`=? and table_name='order_lines' and sql_statement like 'insert%' and `when` >= ? and DATE(`when`) <= ? ";
        list($trs,$err)=runIQuery($db,$sql,array("sss",$thisEmail,$start,$end));
        $tdata=$trs[0];
        $lines+=$tdata[0];
        print "<td>$lines</td>";
        $hours=$minutes/60;
        if ($minutes > 0) {
            $lph=round($lines/$minutes*100,1);
        }
        print "<td>$lph</td>";
        print "<td>16</td>";
        $pct=round($lph/16*100,1);
        print "<td>$pct</td>";
    } else {
        print "<td>$partCount</td>";
        print "<td>$totalGood</td>";
        print "<td>$scrapPartCount</td>";
        print "<td>$totalScrapPieces</td>";
    }
    print "</tr>\n";
}
if ($lc > 0) {
    $avgIndirectPct=round($totalIndirectPct/$lc,1);
    $avgPercent=round($totalPct/$lc,1);
    $avgPlan=round($totalPercentToPlan/$lc,1);
    $avgKPI=round($totalKPIPercent/$lc,1);
    print "<tr><td>Averages</td><td></td><td></td><td></td><td></td><td>$avgIndirectPct %</td><td>$avgPercent %</td><td></td>";
    if ($team == 1) {
        print "<td></td>";
    }
    print "<td>$avgPlan %</td><td>$avgKPI %</td>";
    print "<td></td><td></td><td></td><td></td>";
    print "</tr>\n";
}
print "</tbody>";
print "</table>\n";
print renderClosePanel("");
?>
<script>
function page_init() {
  $('#start').datepicker();
  $('#end').datepicker();
  $('#dtResults').DataTable({"bPaginate" : false});
}
function exportEfficiency() {
	document.findform.action='exportEmployeeEfficiency.php';
	document.findform.target='_blank';
	document.findform.submit();
	document.findform.action='employeeEfficiency.php';
	document.findform.target='_self';
}
</script>
<?
include('footer.php');
?>