<?php
## program to return edit window for a child table
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
?>
<style>
	ul.ui-autocomplete {
    list-style: none;
    border: 1px solid black;
    background-color: white;
    width: 200px;
}
</style>

<?php
$id=$_GET['id'];
$parentPart=$_GET['parent'];
$message="Update Routing below.";
$sql="select workcenter_id from workcenters where workcenter_name='Outside Process'";
list($rs,$err)=runIQuery($db,$sql);
$data=$rs[0];
$outsourceID=$data[0];
$sql="select item_name, item_description from items where coalesce(under_review,0)=0 and coalesce(item_type,'') <> 'Service' order by item_name ";
$rs=mysqli_query($db,$sql);
$itemlist=array();
while ($data=mysqli_fetch_array($rs)) {
	$itemlist[]=$data['item_name'];
}
$itemcount=count($itemlist);
print "<script>var itemList=" . json_encode($itemlist) . ";</script>\n";
if ($id==0)
{
	$message="Enter new Routing information below.";
	$sql="select coalesce(max(display_sequence),0) from routing where parent_part=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$parentPart));
	$data=$rs[0];
	$seq=$data[0]+10;
	$operationID=0;
	$operationName="";
	$machineID=0;
	$workcenterID=0;
	$calculate=0;
	$notes="";
	$pph=0;
	$hpp=0;
	$vendorID=0;
	$people=1;
	$cost="";
} else {
	$sql="select * from routing where routing_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$seq=$data['display_sequence'];
	$operationID=$data['operation_id'];
	$machineID=$data['machine_id'];
	$workcenterID=$data['workcenter_id'];
	$calculate=$data['calculate'];
	$pph=$data['pph'];
	$people=$data['people'];
	$cost=$data['step_cost'];
	if ($cost==0) {
		$cost="";
	}
	if ($pph <> 0) {
		$hpp=number_format(1 / $pph, 3);
	} else {
		$hpp=0;
	}
	$notes=$data['notes'];
	$vendorID=$data['vendor_id'];
}
## security check to make sure they can edit this
$allow_edit=0;
if ( $isAdmin or $inventoryAdmin) {
	print "<form name='editForm' id='editForm'><input type='hidden' name='id' id='id' value='$id'><input type='hidden' name='parent_part' value=\"" . htmlspecialchars($parentPart) . "\"><input type='hidden' name='operation_id' value='$operationID'>\n";
	print renderPanel("Routing","Routing","yellow","span11","qrcode");
	print "<h4>$message</h4>";
	print "<div style='float: right'>";
	print renderButton("<i class='icon-plus'></i> Save and Add Next","green","addanother=1;saveTheForm();");
	print renderButton("<i class='icon-ok'></i> Save and Done","blue","addanother=0;saveTheForm();");
	print renderButton("Done","","backToTable();");
	print "</div>";
	print "<div style='clear: both;'></div>";
	##

	print renderTextBox(TRUE,"display_sequence",$seq,"Sequence");
	$listrs=mysqli_query($db,"select workcenter_id, workcenter_name from workcenters order by workcenter_name ");
	print renderSelect(TRUE,"workcenter_id",$workcenterID,"Work Center","N",$listrs,TRUE);
	$listrs=mysqli_query($db,"select machine_id, machine_name from machines order by machine_name ");
	print renderSelect(TRUE,"machine_id",$machineID,"Machine","N",$listrs,TRUE);
	print renderCheckBox(TRUE,"calculate",$calculate,"Auto Calculate PPH");
	print renderTextBox(TRUE,"hpp",$hpp,"Hours Per Part","right");
	print renderTextBox(TRUE,"pph",$pph,"Parts Per Hour","right");
	print renderTextBox(TRUE,"people",$people,"# People");
	print renderTextBox(TRUE,"cost",$cost,"Cost");
	print renderCheckBox(TRUE,"createsub",$createsub,"Create SUB- Part");
	##
	print "<div style='clear: both;'></div>\n";
	if ($workcenterID==$outsourceID) {
		print "<div  id='outsourceSection'>";
	} else {
		print "<div style='display: none;' id='outsourceSection'>";
	}
	print "<fieldset>";
	print "<legend>Outside Process Information</legend>";
	$listrs=mysqli_query($db,"select vendor_id, vendor_name from vendors order by vendor_name='Grand Haven Powder Coating' DESC,vendor_name ");
	print renderSelect(TRUE,"vendor_id",$vendorID,"Vendor","N",$listrs,TRUE);
	$partID=0;
	if ($operationID) {
		$sql="select item_id from items, operations where operation_id=? and operation_name=item_name ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$operationID));
		$data=$rs[0];
		$partID=$data[0];
	}
	$listrs=mysqli_query($db,"select item_id, item_name from items where item_name like 'SUB%$parentPart%' order by item_name ");

	print renderSelect(TRUE,"part_id",$partID,"Part","N",$listrs,false);
	print "</fieldset>";
	print "</div>";

	if ($workcenterID==$outsourceID) {
		print "<div  id='bomSection' class='span8' style='display: none;'>";
	} else {
		print "<div  id='bomSection' class='span8' >";
	}
	print "<fieldset>";
	print "<legend>Bill Of Material (This Step)</legend>";
	print "<table class='table table-striped'>";
	print "<thead><tr><th>Part</th><th align='right'>Quantity Per</th></tr></thead><tbody>\n";
	$sql="select * from billofmaterial where routing_id > 0 and routing_id=? order by child_item";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$lc=0;
	foreach ($rs as $data) {
		$lc++;
		$next=$lc+1;
		print "<tr><td>";
		print "<input type='text' id='child_item$lc' name='child_item$lc'  autocomplete='off'   onfocus=\"$('#bom$next').show();\" value='" . $data['child_item'] . "' class='ui-widget' style='width: 120px; background-color: white;' onchange='checkQuantity($lc)'>";

 		print  "</td><td align='right'>";
		print "<input type='text' name='qtyper$lc' id='qtyper$lc' class='ui-widget' style='text-align: right; background-color: white;' value='" . $data['quantity_per'] . "'>";
 		 print "</td></tr>\n";
	}
	while ($lc < 40) {
		$lc++;
		$next=$lc+1;
		print "<tr id='bom$lc' ";
		if ($lc > 1) {
			print " style='display: none;' ";
		}
		print ">";
		print "<td>";
		print "<input type='text' id='child_item$lc' name='child_item$lc'  autocomplete='off'   onfocus=\"$('#bom$next').show();\" value='' class='ui-widget' style='width: 120px; background-color: white;' onchange='checkQuantity($lc)'>";
		print "</td>";
		print "<td align='right'>";
		print "<input type='text' name='qtyper$lc' id='qtyper$lc' class='ui-widget' style='text-align: right; background-color: white;' value='0'>";
		print "</td>";
		print "<td width='20'>&nbsp;</td>";
		print "<td>";
		print "<div style='cursor: pointer; ' title='Click to Recalculate Quantity Per' onclick=\"basicRecalc('$lc');\">&nbsp;<img src='/images/refresh.png' width='32' border='0'></div>";
		print "</td>";
		print "</tr>\n";
	}
	print "</table>";
	print "</fieldset>";
	print "</div>";


	print "<div style='clear: both;'></div>";
	print "<div id='above_notes'></div>";
	print renderStartItem(TRUE,"notes","Notes","span8");
	print "<textarea class='wysihtml5 m-wrap span12' style='background-color: white;' name='notes' id='notes' cols='100' rows='20' >";
	print stripslashes($notes);
	print "</textarea>\n";
	print renderEndItem();
	print renderClosePanel("");
	print "</form>\n";
}
?>
<script>
	function saveTheForm() {
		if ($("#workcenter_id").val() == 170) { // outside process
			if ($("#cost").val() == "") {
				$.gritter.add("You must specify a cost for routing with Outside Process");
				return;
			}
		}

		document.getElementById('working').style.display='inline';
		var url = "updateRouting.php"; // the script where you handle the form input.
		formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('input[type=checkbox]').each(function() {
		    if (!this.checked) {
		        formdata += '&'+this.name+'=0';
		    }
		});
		formdata+='&rand='+Math.random();
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				document.getElementById('working').style.display='none';
				if (addanother==1) {
					document.location.href='editRouting.php?id=0&parent=<?=$parentPart?>&rand='+Math.random();
				} else {
					if (window.opener) {
						window.opener.reloadPage();
					}
					self.close();
				}
			}
			});
	}

	function checkQuantity(line) {
		if ($("#workcenter_id").val() == 181) { // only calculate sheet size for laser items
			var child = $("#child_item"+line).val();
			var parent = "<?=$parentPart?>";
			url='getQuantityPerByItem.php?parent=' + parent + "&child=" + child;
			$.ajax({
				type: "GET",
				url: url,
				success: function(data) {
					$('#qtyper'+line).val(data);
				}
			});
		}
	}

	function basicRecalc(lc) {
		qtyper=$('#qtyper'+lc).val();
		if (qtyper != '' ) {
			if (qtyper !=0) {
				qtyper=1/qtyper;
				qtyper=qtyper*10000;
				qtyper=Math.round(qtyper);
				qtyper=qtyper/10000;
				$('#qtyper'+lc).val(qtyper);
			}
		}
	}

	function getConfiguration() {
		if ('<?=$id?>'=='0'){
			if (document.getElementById('workcenter_id')) {
				wc=document.getElementById('workcenter_id').value;
				url='getWorkcenterConfiguration.php?wc='+wc+'&rand='+Math.random();
				$.ajax({url: url, success: function(data) { processConfiguration(data); }});
			}
		}
	}

	function processConfiguration(results) {
		$('#above_notes').html(results);
	}

	function page_init() {
		if ('<?=$id?>'=='0') {
			$('#part_id').prepend("<option value='0' selected='selected'>Create New</option>");
		} else {
			$('#workcenter_id').val('<?=$workcenterID?>');
			workCenterChanged();
			$('#part_id').prepend("<option value='0'>Create New</option>");
		}
		getConfiguration();
		$("#pph").change(function() {
			pphChanged();
		});
		$("#workcenter_id").change(function() {
  			workCenterChanged();
		});
		$('#hpp').change(function() {
			hppChanged();
		});
		$('[id^="child"]').autocomplete({source: itemList, minLength: 4, messages: {
        		noResults: '',
        		results: function() {}
    		}
    	});
    	applyConfig();
	}
	var addanother=0;
	function workCenterChanged() {
		// get the proper machine ids for the list
		if ($('#workcenter_id').val()=='<?=$outsourceID?>') {
			$('#outsourceSection').show();
			$('#bomSection').hide();
		} else {
			$('#outsourceSection').hide();
			$('#bomSection').show();
		}
		url='getMachineList.php?workcenter='+$('#workcenter_id').val() + '&rand='+Math.random();
		$.ajax({url: url, success: function(data) { processMachineList(data)}});
		getConfiguration();
	}
	function pphChanged() {
		if ($('#pph').val() != '') {
			if ($('#pph').val() != '0') {
				$('#hpp').val(Math.round(1000 / $('#pph').val())/1000);
			}
		}
	}
	function hppChanged() {
		if ($('#hpp').val() != '') {
			if ($('#hpp').val() != '0') {
				$('#pph').val(Math.round(1000 / $('#hpp').val())/1000);
			}
		}
	}

	function processMachineList(data) {
		$('#machine_id').children().remove().end().append(data) ;
		if ('<?=$id?>'!='0') {
			$('#machine_id').val('<?=$machineID?>');
		}
	}
	function applyConfig() {
		maxc=parseInt($('#config_count').val());
		newlines='';
		for (i=1; i <= maxc; i++ ) {
			newlines=newlines+$('#configName'+i).html();
			if ($('#configVal'+i).val()!='') {
				newlines=newlines+': <b>'+$('#configVal'+i).val()+'</b>';
			}
			newlines=newlines + '<BR>';
		}
		$('#notes').data("wysihtml5").editor.setValue(newlines);
	}
</script>
<?php
include('footer.php');
?>