<?php
include('dbConnection.php');
#error_reporting(E_ERROR);
#ini_set('display_errors','on');
include('security.php');
include('functions.php');
include('header.php');
if (isset($_GET['id'])) {
	$id=$_GET['id'];
	$sql='select item_name from items where item_id=?';
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($rs)>0) {
		$data=$rs[0];
		$itemName=$data['item_name'];
	}
} else {
	$itemName=$_GET['name'];
	$sql="select item_id from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
	if (count($rs)>0) {
		$data=$rs[0];
		$id=$data[0];
	}
}

$table="items";
$key="item_id";

$sql="select item_name, item_description from items order by item_name ";
$rs=mysqli_query($db,$sql);
$itemlist=array();
while ($data=mysqli_fetch_array($rs)) {
	$itemlist[]=$data['item_name'];
}
$itemName="";
?>
<script type="text/javascript">

var itemList=<?=json_encode($itemlist)?>;

var addanother=0;
var currentTable='';

if(!Array.prototype.indexOf) {
    Array.prototype.indexOf = function(needle) {
        for(var i = 0; i < this.length; i++) {
            if(this[i] === needle) {
                return i;
            }
        }
        return -1;
    };
}

var partok=1;

function checkForDuplicates(valtocheck,changed) {
	partok=1;
	if (valtocheck.includes('&')) {
		alert('No ampersands in Part Number');
		partok=0;
	}
	if (valtocheck.includes('\\')) {
		alert('No backslashes in Part Number');
		partok=0;
	}
	if (valtocheck.includes('@')) {
		alert('No at sign in Part Number');
		partok=0;
	}
	if (valtocheck.includes('%')) {
		alert('No percent sign in Part Number');
		partok=0;
	}
	if (valtocheck.includes("'")) {
		alert('No apostrophe in Part Number  - use the word foot or feet instead');
		partok=0;
	}
	if (valtocheck.includes('"')) {
		alert('No quote in Part Number  - use the word inch or inches instead');
		partok=0;
	}
	if (changed == 1) {
		if (itemList.indexOf(valtocheck) > -1) {
			alert('This item already exists');
			partok=0;
		}
	}
}

function checkOtherStuff() {
	// removed redundant code - Josh 01/19/2023
	var cat = $("#item_category").val();
	if (cat==17) {
		checkLaserCut();
	}
	if (cat==21) {
		checkCost();
	}
	if (cat==22) {
		checkCost();
	}
	if (cat==19) {
		checkCost();
	}
	if (cat==24) {
		checkDimensions();
	}

	// added checking values if powder or primer - Josh 01/19/2023
	if ($("#powder_color").val()!="0"||$("#primer_color").val()!="0") {
		checkPaintedPart();
	}
}

function checkCost() {
	if ($('#cost').val()==0) {
		alert('You must enter a cost');
		partok=0;
	}
}
function checkDimensions() {
	if ($('#cost').val()==0) {
		alert('You must enter a cost');
		partok=0;
	}
	if ($('#width').val() == 0) {
		alert('You must enter width and length.  If this is a fab item, enter surface area in width and .5 in length');
		partok=0;
	}
	if ($('#length').val() == 0) {
		alert('You must enter width and length.  If this is a fab item, enter surface area in width and .5 in length');
		partok=0;
	}
	if ($('#thickness').val() == 0) {
		alert('You must enter thickness of the sheet, as it is required for nesting');
		partok=0;
	}
}
function checkLaserCut() {
	if ($('#cost').val()==0) {
		alert('You must enter a cost');
		partok=0;
	}
	if ($('#width').val() == 0) {
		alert('You must enter width and length.  If this is a fab item, enter surface area in width and .5 in length');
		partok=0;
	}
	if ($('#length').val() == 0) {
		alert('You must enter width and length.  If this is a fab item, enter surface area in width and .5 in length');
		partok=0;
	}
}

// check values if painted part - Josh 01/19/2023
function checkPaintedPart() {
	if ($('#width').val() == 0) {
		alert('You must enter width.');
		partok=0;
	}
	if ($('#length').val() == 0) {
		alert('You must enter length.');
		partok=0;
	}
}

function showReturnValue(responseText)
{
	$.gritter.add(responseText);
}

function reloadPage() {
	document.location.href='editRecipe.php?id='+$('#id').val()+'&rand='+Math.random();
}
</script>

<?php
## security check to make sure they can edit this
$sql="select * from admin_access where user_id=$userID and table_name='items' and allow_edit=1 or allow_view=1";
$rs=mysqli_query($db,$sql);
if (! mysqli_num_rows($rs))
{
#	exit;
}
$data=mysqli_fetch_array($rs);$allow_edit=$data['allow_edit'];
$allow_edit=1;
print renderPanel("Item Master","","yellow","span11","qrcode");
print renderButton("<i class='icon-plus'></i> Save and Add New","green","addanother=1;saveTheForm();","btnSaveNew");
print renderButton("<i class='icon-ok'></i> Save","blue","saveTheForm();","btnSave");
print renderButton("<i class='icon-copy'></i> Copy","green","copyTheForm();","btnCopy");
print renderButton("<i class=='icon-cogs'></i> Roll Up","blue","rollCostPrice();");
print renderButton("<i class='icon-picture'></i> Create Color Option","purple","dialogCreateColor();","btnCreateColor");
#print renderButton("<i class='icon-repeat'></i> Roll Up Cost","yellow","rollUpCost();");
print renderButton("<i class='icon-picture'></i> Add Paint Steps","green","addPaintSteps();","btnAddPaint");
print renderButton("Cancel","","backToTable();");
if ($id > 0) {

?>
	<form name='uploader' enctype="multipart/form-data" action='uploadRecipeFiles.php' method="POST" >
	Upload Files<BR>
	<input type='file' name='upload1' id='upload1'>
	<input type='file' name='upload2' id='upload2'>
	<input type='hidden' name='recipe' id='recipe' value='<?=$id?>'>
	<input class='btn red' type='button' onclick='uploadFiles();' value='Upload Files' id='btnUpload'>
	<br>
	<div id='certdiv'>
	<form name='uploadercert' enctype="multipart/form-data" action='uploadCertificateFiles.php' id='uploadercert' method="POST" >
	Upload Material Certificate Files<BR>
	<input type='file' name='uploadcert' id='uploadcert'>
	<input type='hidden' name='recipecert' id='recipecert' value='<?=$id?>'>
	<input class='btn yellow' type='button' onclick='uploadCertFiles();' value='Upload Cert Files'>
	</form>
	</div>
<?php
		$sql="select item_name, items.customer_id, c.name from items left outer join customers c on items.customer_id=c.customer_id where item_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$data=$rs[0];
		$name=$data['item_name'];
		$customer=$data['customer_id'];
		$customerName=$data['name'];
		$basePrefix=-1;
		if ($customer == 693) {
			if (strlen($name)>10) {
				$baseName=substr($name,0,strlen($name)-2);
				$sql="select item_id from items where item_name=?";
				list($brs,$err)=runIQuery($db,$sql,array("s",$baseName));
				if (count($brs)>0) {
					$bdata=$brs[0];
					$basePrefix=$bdata['item_id'];
				}
			}
		}
		require_once('s3.php');

		$dh = listFiles();
		$flist=array();

		$sql = "SELECT item_id FROM items WHERE item_id = ? AND item_category in (20,24)"; ## bdoss this sql statement per josh had been removed at some point and undefined $crs threw errors
		list($crs,$err) = runIQuery($db,$sql,["i",$id]);

		foreach ($dh as $fulldir) {
			$tmp = explode('/', $fulldir); //only get the final file
			$filename = array_pop($tmp);

			if (trim($filename)) {
				if (! in_array($filename,array(".",".."))) {

					if (count($crs)) { //is Finished Good or Sheet Stock
						$prefix = "CERT$id-";
						if (substr($filename,0,strlen($prefix)) == $prefix) {
							$rest=substr($filename,strlen($prefix),999);
							$fid=str_replace("-","",str_replace(".","",$filename));
							$flink = rawurlencode($fulldir);
							print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' download='$filename'>View Material Cert $rest</a>&nbsp;<div class='btn red' id='del$fid' onclick=\"deleteFile('$fulldir','$rest','$fid');\">DELETE</div>";
						}
					}

					//list($prefix,$rest)=explode("-",$filename); ## bdoss was getting errors for undefined array key 1
					$prefix = explode("-",$filename)[0];
					if ($prefix == $id or $prefix == $basePrefix) {
						$rest=substr($filename,strlen($prefix)+1,999);
						$fid=str_replace("-","",str_replace(".","",$filename));
						$link=str_replace(" ","_",$filename);
						$link=str_replace("#","",$link);
						if ($link != $filename) {
							renameFile("$filename","$link");
							$filename=$link;
						}
						if (! in_array($filename,$flist)) {
							$flist[]=$filename;
							$flink = rawurlencode($fulldir);
							print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' download='$filename'>View $rest</a>&nbsp;<div class='btn red btnRouting' id='del$fid' onclick=\"deleteFile('$fulldir','$rest','$fid');\">DELETE</div>";
						}
					}
					if ($filename == "B000301W-ALL.pdf" or $filename == "J031014W-ALL.pdf") {
						if (substr($itemName,0,8) == substr($filename,0,8)) {
							$fid=str_replace("-","",str_replace(".","",$filename));
							$flink = rawurlencode($fulldir);
							print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' download='$filename'>View $filename</a>&nbsp;";
						}
					} else {
						if (substr($itemName,0,5) == substr($filename,0,5)) {
							$fid=str_replace("-","",str_replace(".","",$filename));
							$link=str_replace(" ","_",$filename);
							$link=str_replace("#","",$link);
							if ($link != $filename) {
								renameFile("$filename","$link");
								$filename=$link;
							}
							$flink = rawurlencode($fulldir);
							print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' download='$filename'>View $filename</a>&nbsp;";
						}
					}
				}
			}
		}
	}
	if (shouldIShowWeld($db,$id)) {
		$filename="WeldDiscontinuities.pdf";
		$fid=str_replace("-","",str_replace(".","",str_replace("pdf","",$filename)));
		print "&nbsp;<a id='$fid' href='showDocument.php?id=$filename' target='_blank'>View $filename</a>";
	}
	if ($customer) {
		print  renderPartLink($customerName,$name);

	}
?>
<form name='editForm' id='editForm' ><input type='hidden' name='table' id='table' value='items'><div style='display: none;'><input type='hidden' name='key' id='key' value='<?=$key?>'><input type=hidden name='id' value='<?=$id?>' id='id'></div>
	<?php
	$sql="select * from items where item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($rs)>0) {
		$data=$rs[0];
		$itemName=$data['item_name'];
		$qty=$data['quantity_on_hand'];
		$sql="select sum(quantity) from item_locations where item_id=? and coalesce(available,0) = 1";
		list($lrs,$err)=runIQuery($db,$sql,array("i",$id));
		$qty=$lrs[0][0];
		$loc=$data['default_location'];
		$status=$data['status'];
		$who=$data['salesperson_id'];
		$desc=$data['item_description'];
		$itemNotes=$data['notes'];
		$uom=$data['unit_of_measure'];
		$category=$data['item_category'];
		$option=$data['inventory_option'];
		$useInventory=$data['use_inventory'];
		$price=$data['price'];
		$cost=$data['cost'];
		$length=$data['length'];
		$width=$data['width'];
		$laserPartSpace=$data['laser_part_space'];
		$thickness=$data['thickness'];
		$cutInHouse=$data['cut_in_house'];
		$cycle=$data['cycle_count'];
		$averageCost=$data['average_cost'];
		$vendorID=$data['vendor_id'];
		$vendorPart=$data['vendor_part_number'];
		$safetyStock=$data['safety_stock'];
		$leadTime=$data['lead_time'];
		$orderIncrement=$data['order_increment'];
		$drawing=$data['drawing'];
		$skidQuantity=$data['skid_quantity'];
		$revision=$data['revision'];
		$customer_id=$data['customer_id'];
		$under_review=$data['under_review'];
		$color=$data['powder_color'];
		$primer=$data['primer_color'];
		$pounds=$data['pounds'];
		$markup=$data['markup'];
		$plugs=$data['plugs'];
		$masking=$data['masking'];
	} else {
		$itemName="";
		$qty=0;
		$loc=1;
		$status=1;
		$who=$userSalespersonID;
		$desc="";
		$itemNotes="";
		$uom=1;
		$category=20;
		$option=0;
		$useInventory=0;
		$laserPartSpace=.25;
		$price=0;
		$cost=0;
		$length=0;
		$width=0;
		$thickness=0;
		$cutInHouse=0;
		$cycle=0;
		$averageCost=0;
		$vendorID=0;
		$vendorPart="";
		$laserPartSpace=0.2;
		$safetyStock=0;
		$leadTime=3;
		$orderIncrement=1;
		$drawing="";
		$skidQuantity=0;
		$revision="";
		$customer_id=0;
		$under_review=0;
		$color=0;
		$pounds=0;
		$markup=20;
		$plugs=0;
		$masking=0;
	}

	## bdoss moving below code because it had come after the variables were being used
	$sql="select show_purchasing, show_engineering, show_sheet from item_categories where category_id=$category";
	if ($category) {
		$rs=mysqli_query($db,$sql);
		$data=mysqli_fetch_array($rs);
		$showP=$data['show_purchasing'];
		$showE=$data['show_engineering'];
		$showS=$data['show_sheet'];
	} else {
		$showP=0;
		$showE=0;
		$showS=0;
	}

	print "<input type='hidden' id='oldItemName' name='oldItemName' value='$itemName'>";
	print renderTextBox(TRUE,"item_name",$itemName,"Item","left","checkForDuplicates(this.value,1);");
	print renderStartItem(TRUE,"quantity_on_hand","On Hand");
	print "<input type='text' style='width: 80px; readonly' id='quantity_on_hand' name='quantity_on_hand' value='$qty' >";
	print renderEndItem();
	print renderCheckBox(TRUE,"under_review",$under_review,"Under Review");
	$sql="select status_id, status_name from item_status order by status_name";
	$rs=mysqli_query($db,$sql);
	if (! $status) {
		$status=4;
	}
	print renderSelect(TRUE,"status",$status,"Status","N",$rs);
	$sql="select customer_id, name from customers order by name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"customer_id",$customer_id,"Main Customer","N",$rs,1,"updateSalesPerson(this.value);");
	print "<div class='span1'>";
	print "<a href='allocationReport.php?part_prefix=$itemName' target='_blank' style='font-size: 18px;'>Allocation</a>\n";
	print "</div>";
	print "<div class='span1'>";
	print "<a href='search.php?quick_search=$itemName' target='_blank' style='font-size: 18px;'>Part History</a>\n";
	print "</div>";
	$sql="select salesperson_id, concat(last_name,', ',first_name) as full_name from salespeople where inactive=0 order by last_name, first_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"salesperson_id",$who,"Owner","N",$rs,true);
	$sql="select vc_id, concat(color_code, '-', color_description,'-',vendor_name) as color_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"powder_color",$color,"Color","N",$rs,1);
	$sql="select vc_id, concat(color_code, '-', color_description,'-',vendor_name) as color_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"primer_color",$primer,"Primer Color","N",$rs,1);
	print renderTextBox(TRUE,"drawing",$drawing,"Drawing");
	print renderTextBox(TRUE,"revision",$revision,"Revision");
	print renderTextBox(TRUE,"skid_quantity",$skidQuantity,"Skid Qty");
	$sql="select ccc_id, category_name from cycle_count_categories order by category_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"cycle_count",$cycle,"Cycle Count Group","N",$rs,TRUE);
	print renderTextArea(TRUE,"item_description",$desc,"Description");
	print renderTextArea(TRUE,"notes",$itemNotes,"Item Notes");
	$sql="select category_id, category_name from item_categories order by category_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"item_category",$category,"Category","N",$rs,false,"checkSections(this.value);");
	$sql="select uom_id, uom_name from units_of_measure order by uom_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"unit_of_measure",$uom,"UOM","N",$rs);
	if ($isAdmin) {
		if ($cost == 0 or $cost == .01) {
			if ($price != 0) {
				list($newcost,$newprice)=calculateCostFromOT($db,$id);
				$newprice="Unchanged";
				if ($newcost ==0) {
					$newcost=round($price/(1 + $markup/100),4);
				}
			} else {
				list($newcost,$newprice)=calculateCostFromOT($db,$id);
				if ($newprice == 0) {
					$newprice=round($cost * (1 + $markup/100),2);
				}
			}
			print "<div>Consuela Cost is $newcost, ";
			if ($newprice == "Unchanged") {
				print "Did not touch price";
			} else {
				print "Consuela Price is $newprice";
			}
			if ($newcost > 0) {
				$cost=$newcost;
				print "<br><b>Hit Save if you want to use this cost.</b></br>";
			}

			print "</div>";
		}	
	}
	if ($showE) {
		print renderTextBox(TRUE,"cost",$cost,"Cost","left");
	} else {
		print renderTextBox(TRUE,"cost",$cost,"Cost","left","markupCost(this.value)");
	}
	$sql="select markup, markup from markups order by display_sequence";
	$rs=mysqli_query($db,$sql);
	if ($showE) {
		print renderSelect(TRUE,"markup",$markup,"Markup","N",$rs,0);
	} else {
		print renderSelect(TRUE,"markup",$markup,"Markup","N",$rs,0,"markupPrice(this.value)");
	}
	print renderTextBox(TRUE,"plugs",$plugs,"# Plugs");
	print renderTextBox(TRUE,"masking",$masking,"Masking SQ In");
	print renderTextBox(TRUE,"price",$price,"Price");
	print renderStartItem(FALSE,"","","span2");
	print "<a href='salesHistory.php?part=$itemName' target='_blank' class='btn yellow'>Sales History</a></label>\n";
	print renderEndItem();
	print "<div style='clear: both;'></div>";
	print renderTextBox(TRUE,"width",$width,"Width");
	print renderTextBox(TRUE,"length",$length,"Length");
	print renderTextBox(TRUE,"thickness",$thickness,"Thickness");
	print "<div id='laser_part_space_div'>";
	print renderTextBox(TRUE,"laser_part_space",$laserPartSpace,"Part Spacing");
	print "</div>";
	## calculate powder cost here
	print renderStartItem(FALSE,"","","span2");
	if ($width and $length and $color) {
		list($linePrice,$batchPrice,$price,$explanation,$minCharge)=newPaintCalculator($db,$width+$laserPartSpace,$length+$laserPartSpace,$color,$masking,$plugs,$primer,$batchFlag=0,$debug=0);		
		$powderPrice=calculatePowderCost($db,$itemName,1.3);
		print "Powder Price: " . number_format($powderPrice,2);
		print "<BR>";
		$powderCost=$powderPrice/1.2;
		print "Powder Cost: " . number_format($powderCost,4);
		print "<BR>";
		$sql="update items set powder_price=?, powder_cost=? where item_id=? ";
		list($updrs,$err)=runIQuery($db,$sql,array("ddi",$powderPrice,$powderCost,$id));

	}
	print renderEndItem();
	if ($category==17) {
		print renderCheckBox(TRUE,"cut_in_house",$cutInHouse,"Cut In House");
		print renderChecKBox(TRUE,"use_inventory",$useInventory,"Use Inventory");
	}
	// $sql="select show_purchasing, show_engineering, show_sheet from item_categories where category_id=$category";
	// if ($category) {
	// 	$rs=mysqli_query($db,$sql);
	// 	$data=mysqli_fetch_array($rs);
	// 	$showP=$data['show_purchasing'];
	// 	$showE=$data['show_engineering'];
	// 	$showS=$data['show_sheet'];
	// } else {
	// 	$showP=0;
	// 	$showE=0;
	// 	$showS=0;
	// }
	if ($showS) {
		print renderTextBox(TRUE,"pounds",$pounds,"Pounds Per Sheet","right");
	}
	print "<div id='purchasing' class='row-fluid'>";
	print "<div class='clear' style='clear: both;'>&nbsp;</div>	";
	$sql="select vendor_id, vendor_name from vendors where trim(vendor_name)!='' order by vendor_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"vendor_id",$vendorID,"Vendor","N",$rs,true);
	print renderTextbox(TRUE,"vendor_part_number",$vendorPart,"Vendor Part");
	print "<div style='clear: both;'></div>\n";
	print "<div class='span11' style='border: 1px dashed black;'>";
	print "Additional Vendors<BR>";
	$sql="select * from items_vendors where item_id=? ";
	print "<table><tr><td>Vendor</td><td style='width: 80%'>Description (clear to delete)</td></tr>\n";
	list ($irs,$err)=runIQuery($db,$sql,array("i",$id));
	$icount=0;
	foreach ($irs as $idata) {
		$icount++;
		print "<tr><td>";
		print "<select id='vendor$icount' name='vendor$icount' style='background-color: white;'>";
		$vendorID=$idata['vendor_id'];
		$vd=$idata['vendor_description'];
		$sql="select vendor_id, vendor_name from vendors where trim(vendor_name)!='' order by vendor_name";
		$rs=mysqli_query($db,$sql);
		print renderOptions($rs,$vendorID,true,false);
		print renderOptions($rs,$vendorID,true,false);
		print "</select>";
		print "</td>";
		print "<td>";
		print "<input type='text' style='width: 90%' class='ui-widget' name='vd$icount' id='vd$icount' value='$vd'>";
		print "</td>";
		print "</tr>\n";
	}
	$icount++;
	print "<tr><td>";
	print "<select id='vendor$icount' name='vendor$icount' style='background-color: white;'>";
	$vendorID=$idata['vendor_id'];
	$vd=$idata['vendor_description'];
	$sql="select vendor_id, vendor_name from vendors where trim(vendor_name)!='' order by vendor_name";
	$rs=mysqli_query($db,$sql);
	print renderOptions($rs,0,true,false);
	print "</select>";
	print "</td>";
	print "<td>";
	print "<input type='text' style='width: 90%' class='ui-widget' name='vd$icount' id='vd$icount' value='' placeholder='Select Vendor and Enter Description'>";
	print "</td>";
	print "</tr>\n";
	print "</table>\n";
	print "<input type='hidden' name='vendorCount' value='$icount'>";
	print "</div>\n";
	print "<div style='clear: both;'></div>\n";
	print renderTextBox(TRUE,"safety_stock",$safetyStock,"Safety Stock");
	print renderTextBox(TRUE,"order_increment",$orderIncrement,"Order Increment");
	print renderTextBox(TRUE,"lead_time",$leadTime,"Lead Time");
	print renderStartItem(FALSE,"","","span3");
	print "<a href='purchasingHistory.php?part=$itemName' target='_blank' class='btn yellow'>Purchasing History</a></label>\n";
	print renderEndItem();
	print "</div>"; ## purchasing div
	print "<div class='clear' style='clear: both;'>&nbsp;</div>";
	print "</form>\n";
	print renderEndItem();
	print "<div class='clear' style='clear: both;'>&nbsp;</div>";
	print "<div id='engineering' class='row-fluid'>";
	print "<h3 >Engineering</h3>";
	print "<div style='float: right;'>";
	print "<a href='bomReport.php?item_id=$itemName' target='_blank' class='btn yellow'>Indented BOM</a>";
	print "<a href='deleteRoutingBOM.php?item_id=$itemName'  class='btn red btnRouting'>Delete Routing/BOM</a>";
	print "</div>";
	print "<div class='clear' style='clear: both;'>&nbsp;</div>";
	print "<h4>Routing</h4>";
	print "<table align='center' class='table table-striped' id='operations' cellpadding='3' border='1'>";
	print "<tr>";
	print "<td valign='top' >Sequence";
	print "</td>";
	print "<td valign='top'>Work Center";
	print "</td>";
	print "<td valign='top'>Machine<BR>";
	print "</td>";
	print "<td valign='top' align='right'>PPH<BR>";
	print "</td>";
	print "<td valign='top' align='right'># People<BR>";
	print "</td>";
	print "<td valign='top'>Vendor<BR>";
	print "</td>";
	print "<td>Cost</td>";
	print "<td valign='top'>Notes<BR>";
	print "</td>";
	print "<td>";
	print "<div onclick=\"addRouting();\" style='cursor: pointer;' class='btnRouting'><img src='images/icn_new_article.png' title='Add New Step' alt='Add New Step'></div>";
	$sql="select routing.* from routing, items where parent_part=item_name and item_id=? order by routing.display_sequence";
	list($rs,$err)=runIQuery($db,$sql,array("s",$id));
	$seq=0;
	foreach ($rs as $data) {
		$key=$data['routing_id'];
		$seq=$seq+10;
		$sql="update routing set display_sequence=? where routing_id=?";
		list($urs,$err)=runIQuery($db,$sql,array("ii",$seq,$key));
		#$seq=$data['display_sequence'];
		$op=$data['operation_id'];
		$machine=$data['machine_id'];
		$workcenter=$data['workcenter_id'];
		$pph=$data['pph'];
		$notes=$data['notes'];
		$vendor=$data['vendor_id'];
		$people=$data['people'];
		$cost=$data['step_cost'];
		print "<tr><td valign='top'>$seq</td>";
		$sql="select workcenter_name from workcenters where workcenter_id=?";
		list($srs,$err)=runIQuery($db,$sql,array("i",$workcenter));
		print "<td valign='top'>";
		$wcname=$srs[0][0];
		print $srs[0][0];
		print "</td>";
		$sql="select machine_name from machines where machine_id=?";
		list($mrs,$err)=runIQuery($db,$sql,array("i",$machine));
		print "<td valign='top'>";
		$machine_name = "";
		if (count($mrs)>0) {
			$machine_name = $mrs[0][0];
		}
		print $machine_name;
		print "</td>";
		print "<td valign='top' align='right'>$pph</td>";
		print "<td valign='top'>$people</td>";
		$vendor_name = "";
		if ($vendor > 0) {
			$sql="select vendor_name from vendors where vendor_id=?";
			list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
			if (isset($vrs) && $vrs[0][0]) {
				$vendor_name = $vrs[0][0];
			}
		}
		print "<td valign='top'>";
		print $vendor_name;
		if ($wcname=="Outside Process") {
			$sql="select operation_name from operations where operation_id=?";
			list($srs,$err)=runIQuery($db,$sql,array("i",$op));
			print "<br>";
			print $srs[0][0];
		}
		print "</td>";
		print "<td>$cost</td>";
		print "<td valign='top'>$notes</td>";
		print "<td valign='top'>";
		print "<div onclick=\"editRouting('$key');\" style='cursor: pointer;' class='btnRouting'>";
		print "<img src='images/icn_edit_article.png' border='0' alt='Edit this step'>";
		print "</div>";
		print "<td valign='top'>";
		print "<div onclick=\"deleteRouting('$key');\" style='cursor: pointer;' class='btnRouting'>";
		print "<img src='images/icn_trash.png' border='0' alt='Delete this step'>";
		print "</div>";
		print "</td>";
		print "</tr>";
		print "</tr>\n";
	}
	print "</table>";
	print "<BR>";
	print "<BR>";
	print "<div class='clear' style='clear: both;'>&nbsp;</div>";
	print "<h4>Bill Of Material</h4>";
	print "<table class='table table-striped' align='center' id='bom' cellpadding='3'  border='1'>";
	print "<tr>";
	print "<td valign='top'>Child Part</td>";
	print "<td valign='top'>Description</td>";
	print "<td valign='top'>Category</td>";
	print "<td valign='top' align='right'>Quantity</td>";
	print "<td valign='top' align='center'>Op Sequence</td>";
	print "<td valign='top'>";
	print "<div onclick=\"addBillofmaterial();\" style='cursor: pointer;'><img src='images/icn_new_article.png' title='Add New BOM' alt='Add New BOM' class='btnBOM'></div>";
	print "</td>";
	print "</tr>\n";
	$sql="select billofmaterial.* from billofmaterial, items where parent_item=item_name and item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $data) {
		$item=$data['child_item'];
		$sql="select item_id, item_description, category_name from items left outer join item_categories on item_category=category_id where item_name=?";
		list($irs,$err)=runIQuery($db,$sql,array("s",$item));
		$idata=$irs[0];
		$childID=$idata[0];
		$childDescription=$idata[1];
		$childCategory=$idata['2'];
		$step=$data['routing_id'];
		$key=$data['bom_id'];
		print "<tr>";
		print "<td valign='top'>";
		print "<a href='editRecipe.php?id=$childID' target='_blank'>";
		print $item;
		print "</a>";
		print "</td>";
		print "<td valign='top'>$childDescription</td>";
		print "<td valign='top'>$childCategory</td>";
		print "<td valign='top' align='right'>";
		print $data['quantity_per'];
		print "</td>";
		$sql="select display_sequence, operation_name from routing, operations where routing_id=? and routing.operation_id=operations.operation_id";
		list($srs,$err)=runIQuery($db,$sql,array("i",$step));
		print "<td valign='top' align='center'>";
		print $srs[0][0];
		print "</td>";
		print "<td>";
		print "<div onclick=\"editBillofmaterial('$key');\" style='cursor: pointer;' class='btnBOM'>";
		print "<img src='images/icn_edit_article.png' border='0' alt='Edit Part'>";
		print "</div>";
		print "</td>";
		print "<td>";
		print "<div onclick=\"deleteBillofmaterial('$key');\" style='cursor: pointer;' class='btnBOM'>";
		print "<img src='images/icn_trash.png' border='0' alt='Remove Part'>";
		print "</div>";
		print "</td>";
		print "</tr>\n";
	}
	print "</table>";
	print "</div>";
	print "<div class='span3 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label'>";
	print "<a href='jobHistory.php?part=$itemName' target='_blank' class='btn yellow'>Job History</a></label>\n";
	print "</div>";
	print "</div>";
?>
	</div>
<div id="confirmDeleteBOM" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteBOM" aria-hidden="true">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
		<h3 id="cdb">Confirm Delete</h3>
	</div>
	<div class="modal-body">
		<p>Are you sure you want to delete this Billofmaterial record?</p>
	</div>
	<div class="modal-footer">
		<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
		<button data-dismiss="modal" class="btn blue" onclick='processBDEL();'>Confirm</button>
	</div>
</div>
<div id="confirmDeleteRouting" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteRouting" aria-hidden="true">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
		<h3 id="cdb">Confirm Delete</h3>
	</div>
	<div class="modal-body">
		<p>Are you sure you want to delete this Step?</p>
	</div>
	<div class="modal-footer">
		<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
		<button data-dismiss="modal" class="btn blue" onclick='processRDEL();'>Confirm</button>
	</div>
</div>
<div id="confirmDeleteFile" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteFile" aria-hidden="true">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
		<h3 id="cdb">Confirm Delete</h3>
	</div>
	<div class="modal-body">
		<p>Are you sure you want to delete file <span id='delfname'></span>?</p>
	</div>
	<div class="modal-footer">
		<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
		<button data-dismiss="modal" class="btn blue" onclick='processDeleteFile();'>Confirm</button>
	</div>
</div>

<div id="pnlCreateColor" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="pnlColorOptions" aria-hidden="true">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
		<h3 id="cdb">Enter Color Options</h3>
	</div>
	<div class="modal-body">
	<div class='row'>
<?php
print renderTextBox(TRUE,"txtColorCode","","Color Code");
?>
<?php
print renderTextBox(TRUE,"txtColorName","","Color Name");
?>
	</div>
	</div>
	<div class="modal-footer">
		<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
		<button data-dismiss="modal" class="btn blue" onclick='createColorOption();'>Create Color</button>
	</div>
</div>

<script>
	function saveTheForm() {
		checkForDuplicates($('#item_name').val(),0);
		checkOtherStuff();
		if (partok > 0) {
			$('#working').show();
			var url="checkForRename.php";
			var url = "updateRecord.php"; // the script where you handle the form input.
			formdata=$("#editForm").serialize();
			// because serialize ignores unchecked checkboxes
			$('input[type=checkbox]').each(function() {
				if (!this.checked) {
					formdata += '&'+this.name+'=0';
				} else {
					formdata += '&'+this.name+'=1';
				}
			});
			$.ajax({
				type: "POST",
				url: url,
				data: formdata, // serializes the form's elements.
				success: function(data)
				{
					$('#working').hide();
					if (addanother) {
						document.location.href='editRecipe.php?id=0&table=items&filter=0&rand='+Math.random();
					} else {
						$('#oldItemName').val($('#item_name').val());
						showReturnValue(data);
					}
				}
			});
		} else {
			alert('NOTHING WAS SAVED FIX THE ERROR(S)');
		}
	}
	function copyTheForm() {
		if (!confirm("Really Copy Item?")) {
			return;
		}

		$('#working').show();
		// save current form first
		var url = "updateRecord.php"; // the script where you handle the form input.
		formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('input[type=checkbox]').each(function() {
		    if (!this.checked) {
		        formdata += '&'+this.name+'=0';
		    } else {
		        formdata += '&'+this.name+'=1';
			}
		});
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				url='copyRecipe.php?id='+$('#id').val();
				$.ajax({ url: url,
					success: function(data) {
						$('#working').hide();
						document.location.href='editRecipe.php?id='+data;
					}
				});
			}
			});
	}

	function dialogCreateColor() {
		$('#pnlCreateColor').modal('show');
	}

	function createColorOption() {
		$('#working').show();
		// save current form first
		var url = "updateRecord.php"; // the script where you handle the form input.
		formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('input[type=checkbox]').each(function() {
		    if (!this.checked) {
		        formdata += '&'+this.name+'=0';
		    } else {
		        formdata += '&'+this.name+'=1';
			}
		});
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				url='createColorOption.php?id='+$('#id').val()+'&code='+$('#txtColorCode').val()+'&name='+$('#txtColorName').val();
				$.ajax({ url: url,
					success: function(data) {
						$('#working').hide();
						window.open('editRecipe.php?id='+data,'_blank');
					}
				});
			}
			});
	}


	function demoWorkOrder() {
		$('#working').show();
		// save current form first
		var url = "updateRecord.php"; // the script where you handle the form input.
		formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('input[type=checkbox]').each(function() {
		    if (!this.checked) {
		        formdata += '&'+this.name+'=0';
		    } else {
		        formdata += '&'+this.name+'=1';
			}
		});
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				$('#working').hide();
				window.open('demoTCPDF.php?id='+$('#id').val(),'_blank');
			}
			});
	}

	function updateSalesPerson(newcustomer) {
		var url = "getSalesPerson.php"; // the script where you handle the form input.
		formdata='customer='+newcustomer;
		$.ajax({
			type: "GET",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				$('#salesperson_id').val(data);
			}
		});
	}


	function addRouting() {
		if ($('#id').val() > 0) {
			url='editRouting.php?id=0&parent='+$('#item_name').val();
			window.open(url,'_blank','opener');
		} else {
			$.gritter.add('You must save the Part before adding routing steps');
		}
	}
	function editRouting(rid) {
		url='editRouting.php?id='+rid+'&parent='+$('#item_name').val();
		window.open(url,'_blank','opener');
	}

	function addBillofmaterial() {
		if ($('#id').val() > 0) {
			url='editSubTable.php?section=billofmaterial&masterfield=parent_item&id=0&masterkey='+$('#item_name').val();
			window.open(url,'_blank','opener');
		} else {
			$.gritter.add('You must save the Part before adding components');
		}
	}

	function editBillofmaterial(bomid) {
		url='editSubTable.php?section=billofmaterial&masterfield=parent_item&id='+bomid+'&masterkey='+$('#item_name').val();
		window.open(url,'_blank','opener');
	}

	var currentID=0;
	function deleteRouting(id) {
		currentID=id;
		$('#confirmDeleteRouting').modal('show');
	}
	function processRDEL() {
		var url = "deleteRecord.php"; // the script where you handle the form input.
			$.ajax({
			type: "GET",
			url: url,
			data: "key=routing_id&table=routing&id="+currentID, // serializes the form's elements.
			success: function(data)
			{
				document.location.reload();
			}
		});
	}
	function checkSections(newcat) {
		console.log("check sections");
		showHideCert();
		var url='checkSectionsRecipe.php';
			formdata='category='+newcat+'&rand='+Math.random();
			$.ajax({
			type: "GET",
			url: url,
			data: formdata,
			success: function(data)
			{
				if (data=='N') {
					$('#purchasing').hide();
					$('#vendor_id').val('0');
					$('#engineering').hide();
				}
				if (data=='E') {
					$('#engineering').show();
					$('#purchasing').hide();
					$('#vendor_id').val('0');
				}
				if (data=='P') {
					$('#purchasing').show();
					$('#engineering').hide();
				}
				if (data=='B') {
					$('#purchasing').show();
					$('#engineering').show();
				}
			}
		});
		if (newcat == '24') {
			$('#laser_part_space_div').show();
		} else {
			$('#laser_part_space_div').hide();
		}
	}
	function deleteBillofmaterial(id) {
		currentID=id;
		$('#confirmDeleteBOM').modal('show');
	}
	function processBDEL() {
		var url = "deleteRecord.php"; // the script where you handle the form input.
			$.ajax({
			type: "GET",
			url: url,
			data: "key=bom_id&table=billofmaterial&id="+currentID, // serializes the form's elements.
			success: function(data)
			{
				document.location.reload();
			}
		});
	}
	var currentFile='';
	var currentFileID = '';
	function deleteFile(fname,shortname, fid) {
		currentFile=fname;
		currentFileID=fid;
		$('#delfname').html(shortname);
		$('#confirmDeleteFile').modal('show');
	}
	function processDeleteFile() {
		url='deleteFile.php?file='+currentFile;
		$.ajax({url: url, success: function(data){
			$.gritter.add("Deleted");
			$('#'+currentFileID).hide();
			$('#del'+currentFileID).hide();
		}}
		);
	}
	function rollUpCost() {
		url='rollUpCost.php?id=<?=$itemName?>&rand='+Math.random();
		window.open(url,'rollup','opener');
	}

	function uploadFiles() {
		$('#recipe').val($('#id').val());
		document.uploader.submit();
	}

	function uploadCertFiles() {
		$('#recipecert').val($('#id').val());
		document.uploadercert.submit();
	}

	function page_init() {
	<?php
	if ($under_review) {
		print "alert('under review');\n";
		print "$('.portlet-body').css('background','#990000');\n";
	}
	?>
	//Brittany addition making price field readonly 4/28 per Chris and Justin
	//document.getElementById('price').setAttribute('readonly', true);

	checkSections($('#item_category').val());


<?php
if ($customer == 693) {
	if (! $editDematic) {
		print "		$('#btnSave').hide();\n";
		print "		$('#btnSaveNew').hide();\n";
		print "		$('#btnCopy').hide();\n";
		print "		$('#btnCreateColor').hide();\n";
		print "		$('#btnAddPaint').hide();\n";
		print "		$('#btnUpload').hide();\n";
		print "		$('.btnRouting').hide();\n";
		print "		$('.btnBOM').hide();\n";
	}
}
?>


	}

	function showHideCert() {
		console.log("showhide");
		if ($('#item_category').val()==24) {
			$('#certdiv').show();
		} else {
			$('#certdiv').hide();
		}
	}


	function markupCost(cost) {
		var cat = $('#item_category').val();
		if ((cat == 14) || (cat == 17) || (cat == 19) || (cat == 24)) {
			cost=parseFloat(cost);
			m=parseFloat($('#markup').val())/100;
			p=cost + (cost * m );
			p=Math.round(p*100)/100;
			$('#price').val(p);
		}
	}

	function markupPrice(m) {
		var cat = $('#item_category').val();
		if ((cat == 14) || (cat == 17) || (cat == 19) || (cat == 24)) {
			m=parseFloat(m);
			cost=parseFloat($('#cost').val());
			m=m/100;
			p=cost + (cost * m);
			p=Math.round(p*100)/100;
			$('#price').val(p);
		}
	}
	function rollCostPrice() {
		window.open('showCostPrice.php?prefix=<?=$itemName?>','_blank','opener');
	}

	function createBOM() {
		url='createBOM.php?id='+$('#id').val();
		window.open(url,'_blank','opener');
	}
	function addPaintSteps() {
		url='addPaintSteps.php?id='+$('#id').val();
		$.ajax({url: url, success: function(data) {document.location.href='editRecipe.php?id='+$('#id').val()+'&rand='+Math.random();}});
	}
</script>
<?php
include('footer.php');
?>