<?php
include("dbConnection.php");
include("security.php");
include("functions.php");
include("header.php");

//TODO: Make sure user has permissions
$start=date("m/d/Y", strtotime("last week sunday -7 day"));
if (isset($_GET["start"])) {
    $start=$_GET["start"];
}

$end=date("m/d/Y", strtotime("last day of this month"));
if (isset($_GET["end"])) {
    $end=$_GET["end"];
}
$employee=0;
if (isset($_GET["employee"])) {
    $employee=$_GET["employee"];
}
$company=1;
if (isset($_GET["company"])) {
    $company=$_GET["company"];
}
$listUrl="listPunches.php?start=$start&end=$end&employee=$employee&company=$company";

print "<div id='confModal' class='modal fade' role='dialog'>
    <div class='modal-dialog'>
        <div class='modal-content'>
            <div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
            <div class='modal-body'>
                <span class='confBody'></span>
            </div>
            <div class='modal-footer'>
                <button class='btn btn-success' data-dismiss='modal' onclick='confInput(true)'>Yes</button>
                <button class='btn btn-danger' data-dismiss='modal' onclick='confInput(false)'>No</button>
            </div>
        </div>
    </div>
</div>";

$punch_id=0;
if (isset($_GET["punch_id"])) {
    $punch_id=$_GET["punch_id"];

    $sql = "select tcp.*, concat(emp.first_name, ' ', emp.last_name) as full_name from time_clock_punches tcp, employees emp where tcp.punch_id=? and tcp.employee_id=emp.card_number";
    list($rs)=runIQuery($db,$sql,["i",$punch_id]);

    print renderPanel("Edit Clock Punch", "Edit Clock Punch", "blue");

    if (count($rs)) { //punch exists
        $punch = $rs[0];

        print "<form name='punchForm' method='POST' action='editPunch.php'>";

        print "<input type='hidden' name='punch_id' value='$punch_id'>";
        print "<input type='hidden' name='start' value='" . $_GET["start"] . "'>";
        print "<input type='hidden' name='end' value='" . $_GET["end"] . "'>";
        print "<input type='hidden' name='employee' value='" . $_GET["employee"] . "'>";
        print "<input type='hidden' name='company' value='" . $_GET["company"] . "'>";

        print "<div style='display: flex;' ><div class='span3'>
            <div class='input-group'>
                <label class='control-label' for='in'>In Time</label>
                <input type='datetime-local' class='form-control' name='in' id='in' value='" . date("Y-m-d\TH:i", strtotime($punch["in_date"])) . "'>
            </div>
        </div>";

        print "<div class='span3'>
            <div class='input-group'>
                <label class='control-label' for='out'>Out Time</label>
                <input type='datetime-local' class='form-control' name='out' id='out' value='" . (empty($punch["out_date"]) ? "" : date("Y-m-d\TH:i", strtotime($punch["out_date"]))) . "'>
            </div>
        </div>";

        print "<div class='span3'>
            <div class='input-group'>
                <label class='control-label' for='punch_notes'>Punch Notes</label>
                <textarea class='form-control' name='punch_notes' id='punch_notes' rows='5' readonly> " . $punch["notes"] . "</textarea>
            </div>
        </div>";


        print renderTextArea(TRUE,"notes","","Change Notes");

        print "</div><div style='display: flex;' ><label for='is_lunch'>Is Lunch</label>  <input type='checkbox' id='is_lunch' name='is_lunch' value='" . $punch["is_lunch"] . "' " . ($punch["is_lunch"] ? "checked" : "") . ">";
        print " <label for='holiday'>Is Holiday</label>  <input type='checkbox' id='holiday' name='holiday' value='" . $punch["holiday"] . "' " . ($punch["holiday"] ? "checked" : "") . ">";
        //print renderCheckBox(TRUE,"is_lunch",$punch["is_lunch"],"Is Lunch");


        print "</div></form>";
        print renderButton("Submit","green","applyChanges();") . " ";
        print renderButton("Return","blue","window.location='$listUrl';") . " ";
        print renderButton("Delete","red","deletePunch();") . " ";

        $sql = "select * from time_clock_changes where punch_id=?";
        list($crs)=runIQuery($db,$sql,["i",$punch_id]);

        print "<style>
            th,td {
                width: 14.5%;
            }
        </style>";

        print "<br><h3>Changes</h3><table class='table table-bordered'>
        <thead>
            <tr>
                <td>Who</td>
                <td>When</td>
                <td>Old In</td>
                <td>New In</td>
                <td>Old Out</td>
                <td>New Out</td>
                <td>Change Notes</td>
            </tr>
        </thead><tbody>";

        foreach ($crs as $change) {
            $old_out = "N/A";
            $new_out = "N/A";
            if (!empty($change["old_out"])) {
                $old_out=date("m/d/Y h:i A", strtotime($change['old_out']));
            }
            if (!empty($change["new_out"])) {
                $new_out=date("m/d/Y h:i A", strtotime($change['new_out']));
            }

            print "<tr>
                <td>" . $change["who"] . "</td>
                <td>" . date("m/d/Y h:i A", strtotime($change["when"])) . "</td>
                <td>" . date("m/d/Y h:i A", strtotime($change["old_in"])) . "</td>
                <td" . ($change["old_in"] == $change["new_in"] ? "" : " style='color: #db3939;'") . ">" . date("m/d/Y h:i A", strtotime($change["new_in"])) . "</td>
                <td>" . $old_out . "</td>
                <td" . ($change["old_out"] == $change["new_out"] ? "" : " style='color: #db3939;'") . ">" . $new_out . "</td>
                <td>" . $change["notes"] . "</td>
            </tr>";
        }
        print "</tbody></table>";
    }

    print renderClosePanel();
}

if (isset($_POST["punch_id"])) {
    $punch_id=$_POST["punch_id"];
    $notes = NULL;
    if (isset($_POST["notes"])) {
        $notes=$_POST["notes"];
    }
    $is_lunch = 0;
    if (isset($_POST["is_lunch"])) {
        $is_lunch=$_POST["is_lunch"];
    }
    $holiday=0;
    if (isset($_POST["holiday"])) {
        $holiday=$_POST["holiday"];
    }

    $sql = "select * from time_clock_punches where punch_id=?";
    list($rs)=runIQuery($db,$sql,["i",$punch_id]);

    if (count($rs)) { //punch exists
        $punch = $rs[0];
        $old_in = $punch["in_date"];
        $new_in = date("Y-m-d H:i:00", strtotime($_POST["in"]));
        $old_out = $punch["out_date"];
        $new_out = date("Y-m-d H:i:00", strtotime($_POST["out"]));
        $old_lunch = $punch["is_lunch"];
        $old_holiday = $punch["holiday"];
        if (empty($_POST["out"])) {
            $new_out = NULL;
        }

        if ($old_in != $new_in || $old_out != $new_out || $is_lunch != $old_lunch || $holiday != $old_holiday) {
            $sql = "update time_clock_punches set in_date=?, out_date=?, is_lunch=?, holiday=? where punch_id=?";
            runIQuery($db,$sql,["ssiii",$new_in,$new_out,$is_lunch,$holiday,$punch_id]);
            if ($is_lunch != $old_lunch) {
                $notes .= "- Changed Is Lunch to " . ($is_lunch ? "Yes" : "No");
            }
            if ($holiday != $old_holiday) {
                $notes .= "- Changed Is Holiday to " . ($holiday ? "Yes" : "No");
            }

            $sql = "insert into time_clock_changes (punch_id, who, old_in, new_in, old_out, new_out, notes) values (?,?,?,?,?,?,?)";
            runIQuery($db,$sql,["issssss",$punch_id,$userEmail,$old_in,$new_in,$old_out,$new_out,$notes]);
        }

        print "<script>
            window.location.href = 'editPunch.php?punch_id=$punch_id&start=" . $_POST["start"] . "&end=" . $_POST["end"] . "&employee=" . $_POST["employee"] . "&company=" . $_POST["company"] . "';
        </script>";
    }

    print renderClosePanel();
}
print "</div>";

?>

<script>
    function page_init() {
        $("#is_lunch").on('change', function() {
            if ($(this).is(':checked')) {
                $(this).attr('value', '1');
            } else {
                $(this).attr('value', '0');
            }
        });
        $("#holiday").on('change', function() {
            if ($(this).is(':checked')) {
                $(this).attr('value', '1');
            } else {
                $(this).attr('value', '0');
            }
        });
    }
    function confirmModal(title,body,cb=function(){}) {
        $("#confModal .confTitle").text(title);
        $("#confModal .confBody").text(body);
        window.confInput = cb;
        $("#confModal").modal("show");
    }

    function applyChanges() {
        var in_date = $("#in").val();
        var out_date = $("#out").val();
        var notes = $("#addnotes").val();

        function apply() {
            document.forms.punchForm.submit();
        }
        if (out_date != "") {
            var outdate = new Date(out_date);
            var indate = new Date(in_date);
            if (outdate.getTime() < indate.getTime()) {
                return $.gritter.add("Out time must be later than in time");
            }
            if (outdate.getDate() != indate.getDate()) {
                return confirmModal("Punch Day Mismatch","Are you sure punch out should be on a different day than punch in?", function(yes) {
                    if (yes) {
                        apply();
                    }
                });
            }
        }
        if (in_date == "") {
            return $.gritter.add("In time must be specified");
        }

        apply();
    }
    function deletePunch() {
        confirmModal("Are You Sure?", "Delete this punch?", function(yes) {
            if (yes) {
                var url = "deleteRecord.php?table=time_clock_punches&key=punch_id&id=<?=$punch_id?>&rand=" + Math.random();
                $.ajax({url:url,success: function() { window.location="<?=$listUrl?>"; }});
            }
        });
    }
</script>

<?php
include("footer.php");
?>