<?php

#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$id=$_GET['id'];
$table="orders";

print "<div id='confModal' class='modal fade' role='dialog'>
	<div class='modal-dialog'>
		<div class='modal-content'>
			<div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
			<div class='modal-body'>
				<span class='confBody'></span>
			</div>
			<div class='modal-footer'>
				<button class='btn green' data-dismiss='modal' onclick='confInput(true)'>Yes</button>
				<button class='btn red' data-dismiss='modal' onclick='confInput(false)'>No</button>
			</div>
		</div>
	</div>
</div>";
?>

<style>

#repeatReminderDialog {
	background-color: lightblue;
	font-size: 30px;
}

.showReminder {
	display: block;
}

.hideReminder {
	display: none;
}

	ul.ui-autocomplete {
    list-style: none;
    border: 1px solid black;
    background-color: white;
    width: 200px;
}

.cursor-na {
	cursor: not-allowed !important;
}
</style>
<script type="text/javascript">
<?php
// get list of customers
$sql="select name from customers order by name ";
$rs=mysqli_query($db,$sql);
$customerlist=array();
while ($data=mysqli_fetch_array($rs)) {
	$customerlist[]=$data['name'];
}
$customercount=count($customerlist);

// get list of items

$pitext="";

if ($id) {
	$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id ";
	$sql.=" inner join orders o on items.customer_id=o.customer_id and o.order_id=? ";
	$sql.=" where coalesce(under_review,0)=0 ";
	$sql.=" order by item_name ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
} else {
	$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id where coalesce(under_review,0)=0 ";
	$sql.=" order by item_name ";
    list($rs)=runIQuery($db,$sql);
}
$itemlist=array();
$itemcount=0;
foreach ($rs as $data) {
	if ($data['status_name'] != 'Active') {
		$itemlist[]=$data['item_name'] . "-" . $data['status_name'];
	} else {
		$itemlist[]=$data['item_name'];
	}
	$itemcount++;
}
$itemcount=count($itemlist);

?>
var scheduleIt=0;
var addanother=0;
var currentLine=0;
var linecounter=0;
var itemList=<?=json_encode($itemlist)?>;
function confirmModal(title,body,cb=function(){}) {
	$("#confModal .confTitle").text(title);
	$("#confModal .confBody").html(body);
	window.confInput = cb;
	$("#confModal").modal("show");
}
function lookupItemInfo(itemValue) {
		url='getItemInfo.php?item='+itemValue+'&customer='+$('#customer_id').val()+'&qty='+$('#qty'+currentLine).val()+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){ setLineValues(data); }}
)
}

function lookupFromQuantity(qtyobjid) {
	itemobjid=qtyobjid.replace('qty','item');
	itemobj=document.getElementById(itemobjid);
	qtyobj=document.getElementById(qtyobjid);
		url='getItemInfo.php?item='+itemobj.value+'&customer='+$('#customer_id').val()+'&qty='+qtyobj.value+'&rand='+Math.random();
	$.ajax({url: url, success: function(data){ setLineValues(data); }})
}

function setLineValues(data) {
	vals=data.split('|');
	if ($('#qty'+currentLine).val()=='') {
		$('#qty'+currentLine).val('1');
	}
	if ($('#due'+currentLine).val()=='') {
		$('#due'+currentLine).val($("#date_due").val())
	}
	if (vals[0]=='NOT FOUND') {
		alert('Part Not Found. Using Miscellaneous');
		if ($('#desc'+currentLine).val()=='') {
			$('#desc'+currentLine).val($('#item'+currentLine).val());
		}
		$('#item'+currentLine).val("Miscellaneous");
	} else {
		if ($('#desc'+currentLine).val()=='') {
			$('#desc'+currentLine).val(vals[0]);
		}
		//if ($('#price'+currentLine).val()=='') {
			$('#price'+currentLine).val(vals[1]);
		//}
		if ($('#rev'+currentLine).val()=='') {
			$('#rev'+currentLine).val(vals[2]);
		}
		$('#powder'+currentLine).val(vals[3]);
		if ($('#item'+currentLine).val()=='Miscellaneous') {
			$('#desc'+currentLine).select();
		} else {
			$('#qty'+currentLine).select();
		}
	}
	calculateExt(currentLine);
	getLevels(currentLine,$('#item'+currentLine).val())
}

function getLevels(l,itemValue) {
	url='getItemLevels.php?item='+itemValue+'&rand='+Math.random();
	currentLine=l;
	$.ajax({url: url, success: function(data){ setLineLevels(data,l); }})
}
function setLineLevels(data,l) {
	vals=data.split('|');
	$('#qoh'+l).val(vals[0]);
	$('#qoj'+l).val(vals[1]);
}



function calculateExt(lineno) {
	$("#notice").effect("highlight");
	currentLine=lineno;
	url='getPricing.php?customer='+$('#customer_id').val()+'&item='+$('#item'+currentLine).val()+'&qty='+$('#qty'+currentLine).val()+'&rand='+Math.random();
	$.ajax({url: url, success: function(data){ setPricing(data,lineno); }});
}

function setPricing(data,lineno) {
	if (data!='') {
		if (($('#price'+lineno).val()=='') || $('#price'+lineno).val()=='0.0000') {
			$('#price'+lineno).val(data);
		}
	}
	calculateExtPrice(lineno);
}


function calculateExtPrice(lineno) {
	if ($('#qty'+lineno).val()!='') {
		if ($('#price'+lineno).val()!='') {
			$('#ext'+lineno).val((Math.round($('#qty'+lineno).val()*$('#price'+lineno).val()*100)/100).toFixed(2));
		}
	}
	tot=0;
	for (i=0; i < linecounter; i++) {
		if ($('#qty'+i)) {
			if ($('#qty'+i).val()!='') {
				if ($('#price'+i).val()!='') {
					tot=tot+(Math.round($('#qty'+i).val()*$('#price'+i).val()*100)/100);
				}
			}
		}
	}
	$('#otot').val(tot.toFixed(2));
}
function removeSpaces(obj)
{
	while (obj.value.indexOf(" ")!=-1)
	{
		obj.value=obj.value.replace(" ","-");
	}
	while (obj.value.indexOf(",")!=-1)
	{
		obj.value=obj.value.replace(",","-");
	}
	while (obj.value.indexOf(".")!=-1)
	{
		obj.value=obj.value.replace(".","");
	}
	while (obj.value.indexOf("--")!=-1)
	{
		obj.value=obj.value.replace("--","-");
	}
}

function showReturnValue(responseText)
{
	if (responseText.substring(0,1)!='<') {
		document.location.href='editOrders.php?table=orders&id='+responseText;
	} else {
		$.gritter.add(responseText);
		if (scheduleSet == '1') {
			document.location.href='editOrders.php?table=orders&id='+$('#id').val();
		} else {
			if (scheduleSet == '2') {
				window.open('createOrdersJobs.php?id='+$('#id').val(),'_blank','opener');
				scheduleSet = '1';
			} else {
				if (scheduleSet == '3') {
					window.open('printInvoice.php?id='+$('#id').val(),'_blank','opener');
					scheduleSet = '1';
				} else {
					if (scheduleSet == '4') {
						window.open('orderRFQ.php?id='+$('#id').val(),'_blank','opener');
						scheduleSet = '1';
					} else {
						if (scheduleSet == '5') {
							window.open('createOrdersPOs.php?id='+$('#id').val(),'_blank','opener');
							scheduleSet = '1';
						} else {
							setTimeout(reloadPage,500);
						}
					}
				}
			}
		}
	}
}

function reloadPage() {
	document.location.href='editOrders.php?table=orders&id='+$('#id').val();
}

</script>
<div id='responser'></div>
<?php
## security check to make sure they can edit this
$sql="select * from admin_access where user_id=$userID and table_name='orders' and allow_edit=1 or allow_view=1";
$rs=mysqli_query($db,$sql);
if (! mysqli_num_rows($rs))
{
#	exit;
}
$data=mysqli_fetch_array($rs);
$allow_edit=$data['allow_edit'];
	if ($id) {
		$title= "Order " . $id;
	} else {
		$title= "NEW Order";
	}
	print renderPanel($title,"","green","span11","star");
	print renderButton("<i class='icon-ok'></i> Save","blue","saveTheForm('0');","saveButton");
	##print renderButton("<i class='icon-ok'></i> Save & Schedule","blue","saveTheForm('1');","scheduleButton");
	print renderButton("<i class='icon-cogs'></i> Create All WO","green","saveTheForm('2');","woButton");
	##print renderButton("<i class='icon-ok'></i> Create PO","blue","saveTheForm('2');","poButton");
	print renderButton("<i class='icon-print'></i> Print Invoice","red","saveTheForm('3');","printButton");

	$showButton = true; //Hide button if order status is Quote, Complete, or Canceled -Josh 04-29-2022
	if ($id) {
		$sql = "select status from orders where order_id=?";
		list($rs,$err) = runIQuery($db,$sql,["i",$id]);
		$status = $rs[0]["status"];
		if ($status == 3 || $status == 5 || $status == 6) {
			$showButton = false;
		}
	}

	if ($showButton) {
		print renderButton("<i class='icon-cogs'></i> Create All PO","green","saveTheForm('5');","poButton");
	}

	print renderButton("<i class='icon-print'></i> Add Powder","yellow","window.open('paintInvoice.php?id=$id','_blank','opener');","powderButton");
	print renderButton("<i class='icon-file'></i> RFQ for Order","red","saveTheForm('4');","rfqButton");
	## print renderButton("<i class='icon-file'></i> Copy Order","blue","copyOrder()","copyButton");
	print renderButton("Done","","backToTable();","doneButton");
	print "<span id='choldmsg' style='display: none;'>Customer On Credit Hold</span>";
	print renderButton("Confirm","yellow","confirmOrder();", "confirmButton");
if ($id > 0) {
	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];

?>
<br>
<div id='receipt'></div>
<form name='uploadForm' id='uploadForm' action='uploadSOFiles.php' enctype="multipart/form-data" method=POST>
	<input type=hidden name='id' value='<?=$id ?>' id='id'>
	<input type='file' name='upload1'>
	<?php
	print renderButton("Upload","red","subUpload();","btnUpload");

	if ($dbName     != "prefmach_weld" ) {
		require_once('s3.php');
		$dh = listFiles("SO" . $id);
	
		foreach ($dh as $fulldir) {
			$tmp = explode('/', $fulldir); //only get the final file
			$filename = array_pop($tmp);
	
			if (! in_array($filename,array(".",".."))) {
				list($prefix,$rest)=explode("-",$filename);
				if ($prefix == "SO".$id) {
					$rest=substr($filename,strlen($prefix)+1,999);
					$fid=str_replace("-","",str_replace(".","",$filename));
					$flink = rawurlencode($fulldir);
					print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' target='_blank'>View $rest</a>&nbsp;<div class='btn red' id='del$fid' onclick=\"deleteFile('$flink','$rest','$fid');\">DELETE</div>";
				}
			}
		}
		    // add legacy/machine documents
		$sql="select * from documents d where order_id=?";
		list($drs,$err)=runIQuery($db,$sql,array("i",$id));
		if (count($drs)) {
			print "<br><span style='font-weight: bold;'>Legacy Documents</span><br>";
		}
		foreach ($drs as $ddata) {
			$fname=$ddata['file_name'];
			$docid=$ddata['document_id'];
			print "<a href='showDocumentLegacy.php?id=$docid' target='_blank' style=''>View $fname</a><br>";
			if ($isAdmin or $orderAdmin or $canDeleteAttachments) {
				print "<a href=\"javascript:deleteDocument('$docid');\" style='color: red;' rel='opener'>DELETE $fname</a><br>";
			}
		}
	}

?>
</form>
<div style='float: right;' >
	<form action='uploadQuote.php' name='uploadform' method='POST'  enctype="multipart/form-data" target='_blank' class='form-control' rel='opener' >
	<input type='hidden' name='id' value='<?=$id?>'>
    <div class="form-group">
	    <input type='file' name='quoteinfo' class='form-control'>
    </div>
    <div class="form-group">
        <button type='button' class='btn green' onclick='uploadquote()'>Upload Consuela File</button>
    </div>
</form>
</div>

<?php
	print renderButton("Activity","primary","getActivity('noview')");
?>
<div id='activity'>
</div>
<?php
print "ID is $id<BR>";
	print renderButton("Viewed","primary","getActivity('viewed')");
}
?>
<div id='viewed_activity'>
</div>
<form name='editForm' id='editForm' ><input type='hidden' name='table' id='table' value='<?=$table?>'><div style='display: none;'><input type='hidden=' name='key' id='key' value='<?=$key?>'><input type=hidden name='id' value='<?=$id?>' id='id'></div>
<?php
	if ($id) {
        print_r($data);
		$qbid=$data['quickbooks_order_number'];
		$priority=$data['priority'];
		$order_class=$data['order_class'];
		$order_type=$data['order_type'];
		$priorityColor="black";
		$priorityName="Normal";
		$sql="select priority_color, priority_name from order_priorities where priority_id=?";
		list($prs,$err)=runIQuery($db,$sql,array("i",$priority));
		if (count($prs)>0) {
			$pdata=$prs[0];
			$priorityColor=$pdata['priority_color'];
			$priorityName=$pdata['priority_name'];
		}
		$customer_id=$data['customer_id'];
		if (! $customer_id) {
			$customer_id=0;
		}
		$sql="select * from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
		if ($customer_id==693) {
			if (! $order_class) {
				$order_class=1;
			}
		}
		$cdata=$rs[0];
		$customer_name=$cdata['name'];
		$customer_address=$cdata['address'];
		$customer_address2=$cdata['address2'];
		$customer_city=$cdata['city'];
		$customer_state=$cdata['state'];
		$customer_zip=$cdata['zip'];
		$customer_phone=$cdata['phone'];
		$customer_email=$cdata['email'];
		$date_order=formatDateDBToWeb($data['date_order']);
		$date_due=formatDateDBToWeb($data['date_due']);
		if (! $date_due) {
			$date_due=Date("m/d/Y");
		}
		$status=$data['status'];
		$po_number=$data['po_number'];
		$attention=$data['attention'];
		$salesperson_id=$data['salesperson_id'];
		$notes_to_customer=$data['notes_to_customer'];
		$notes_to_self=$data['notes_to_self'];
		$notes_to_ap=$data['notes_to_ap'];
		$shipping_notes=$data['shipping_notes'];
		$email=$data['email'];
		$phone=$data['phone'];
		$reason_id=$data['rma_reason'];
	} else {
		$priority=1;
		$priorityColor="black";
		$priorityName="Normal";
		$customer_id=0;
		$customer_name="";
		$customer_address="";
		$customer_address2="";
		$customer_city="";
		$customer_state="";
		$customer_zip="";
		$customer_phone="";
		$customer_email="";
		$order_class=0;
		$order_type=1;
		$date_order=Date("m/d/Y");
		$date_due=Date("m/d/Y");
		$status=16;
		$po_number="";
		$attention="";
		$salesperson_id="";
		$notes_to_customer="";
		$shipping_notes="";
		$notes_to_self="";
		$notes_to_ap="";
		$email="";
		$phone="";
		$reason_id=0;
	}
	if ($id) {
		$ship_name=$data['ship_name'];
		$ship_address=$data['ship_address'];
		$ship_address2=$data['ship_address2'];
		$ship_city=$data['ship_city'];
		$ship_state=$data['ship_state'];
		$ship_zip=$data['ship_zip'];
	} else {
		$ship_name="";
		$ship_address="";
		$ship_address2="";
		$ship_city="";
		$ship_state="";
		$ship_zip="";
		$sql="select * from customer_shiptos where customer_id=? and coalesce(is_default,0)=1";
		list($csrs,$err)=runIQuery($db,$sql,array("i",$customer_id));			if (count($csrs)>0) {
			$csdata=$csrs[0];
			$ship_name=$csdata['ship_name'];
			$ship_address=$csdata['ship_address'];
			$ship_address2=$csdata['ship_address2'];
			$ship_city=$csdata['ship_city'];
			$ship_state=$csdata['ship_state'];
			$ship_zip=$csdata['ship_zip'];
		}

	}

	// add inactive customers code -Josh 02/20/2023
	if (! $customer_id) {
		$customer_id=0;
	}
	$sql = "select customer_id, name from customers where inactive_customer=0 OR customer_id=? order by name";
    list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	print renderSelect(TRUE,"customer_id",$customer_id,"Customer","N",$rs,true,"updateCustomer(this.value);this.style.backgroundColor='white';"); //adding code to updateCustomer() to hide buttons if customer is on credit hold Brittany 6/22
    if ($customer_id) {
		$sql="select name from customers where customer_id=$customer_id";
		$rs=mysqli_query($db,$sql);
		$data=mysqli_fetch_array($rs);
		$name=$data['name'];
		$sql="select credit_hold from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
		$creditHold=$rs[0][0];
		if (! $creditHold) {
			$creditHold=0;
		}
	}
	$sql="select priority_id, priority_name from order_priorities order by priority_id ";
	$crs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"order_priority",$priority,"Priority","N",$crs,0,"updatePriority(this.value);");
	print "<span style='font-size: 20px; color: $priorityColor'>Priority: $priorityName</span>";
	print "<BR>";
	print "<div id='customer_info' style='width: 150px; background-color: white;'>";
	if ($customer_id) {
		print $customer_address;
		print "<BR>";
		if ($customer_address2) {
			print $customer_address2;
			print "<BR>";
		}
		print "$customer_city, $customer_state $customer_zip";
		print "<BR>";
		print $customer_phone;
		print "<BR>";
		print "<a href='mailto:$customer_email'>$customer_email</a>";
	}
	print "</div>";
	print renderDateBox(TRUE,"date_due",$date_due,"Date Due");
	print renderTextBox(TRUE,"po_number",$po_number,"PO#");
	$sql="select status_id, status_name from order_status order by status_name";
	$rs=mysqli_query($db,$sql);
	if ($status=="") {
		$status=1;
	}
	print renderSelect(TRUE,"status",$status,"Status","N",$rs,true,"checkStatusChanged(this.value)");
	## preliminary quote addition
	if ($status == 19) {
		print "<p>Preliminary Quote can only be changed by re-uploading quote inside 30 days.</p>";
	}
	## preliminary quote addition
	if (! $salesperson_id) {
		$sql="select salesperson_id from salespeople where email=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));
		if (count($rs)>0) {
			$data=$rs[0];
			$salesperson_id=$data[0];
		}
	}
	$sql="select class_id, class_name from order_classes order by display_sequence";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"order_class",$order_class,"Order Class","N",$rs,1);

	$sql="select type_id, type_name from order_types";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"order_type",$order_type,"Order Type","N",$rs,1);
	$sql="select reason_id, reason_description from rma_reasons where reason_description <> 'See Internal Notes' and category_rma = 1 order by reason_description";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"rma_reason",$reason_id,"RMA Reason","N",$rs,1);
	if ($reason_id == 5) {
		print "PICK NEW REASON";
	}

	$sql="select salesperson_id, full_name from salespeople where inactive=0 order by last_name, first_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"salesperson_id",$salesperson_id,"Salesperson","N",$rs,true);
	print "<div style='clear: both;'></div>\n";
	print "<div class='span2'>";
	print "Ship To <div class='btn yellow' onclick='selectShipTo();'>Select</div><BR>";
	print "</div>";
	print "<div style='clear: both;'></div>\n";
	print renderTextBox(TRUE,"attention",$attention,"Attention");
	## bdoss 11/22/22 added contact dropdown that will autofill email
	print "<div class='span3' id='selectContact'></div>";
	print "<div style='clear: both;'></div>\n";
	## end of contact info additions
	print renderTextBox(TRUE,"ship_name",$ship_name,"Ship To");
	print renderTextBox(TRUE,"ship_address",$ship_address,"Ship Address");
	print renderTextBox(TRUE,"ship_address2",$ship_address2,"Address Line 2");
	print "<div style='clear: both;'></div>";
	print renderTextBox(TRUE,"ship_city",$ship_city,"Ship City");

	$sql="select abbreviation, name from states order by name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"ship_state",$ship_state,"Ship State","C",$rs);
	print renderTextBox(TRUE,"ship_zip",$ship_zip,"Postal");
	print renderTextBox(TRUE,"ship_phone",$phone,"Phone");
	print renderTextBox(TRUE,"ship_email",$email,"Email");
	print "<div style='clear: both;'></div>\n";

	// move notes fields -Josh 02-03-2023

	//changed 02-11-2022 by Josh- Add notesChanged on onchange for auto-save
	print "<hr><div id='notesfields' style='display: flex; width: 100%;'>";
	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_customer'>Notes To Customer</label>\n";
    print "<div class='controls'>\n";
	// made font slightly smaller to allow more in a smaller area -Josh 02-06-2023
	print "<textarea rows=3 class='m-wrap span12'  id='notes_to_customer' name='notes_to_customer' onchange='notesChanged(\"customer\")' style='font-size: 10pt; background-color: white;'>$notes_to_customer</textarea>"; //Notes to customer
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_self'>Internal Notes</label>\n";
    print "<div class='controls'>\n";
	// made font slightly smaller to allow more in a smaller area -Josh 02-06-2023
	print "<textarea  rows=3 style='font-size: 10pt; background-color: white;' class='m-wrap span12'   id='notes_to_self' name='notes_to_self'  onchange='notesChanged(\"self\")'>$notes_to_self</textarea>"; //Notes to self
	//end change

	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	//changed 3/2/23 - cma - added shipping notes
	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='shipping_notes'>Shipping Notes</label>\n";
    print "<div class='controls'>\n";
	// made font slightly smaller to allow more in a smaller area -Josh 02-06-2023
	print "<textarea  rows=3 style='font-size: 10pt; background-color: white;' class='m-wrap span12'   id='shipping_notes' name='shipping_notes'  onchange='notesChanged(\"shipping_notes\")'>$shipping_notes</textarea>"; // shipping notes
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	//end change

	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_ap'>Notes to AP</label>\n";
    print "<div class='controls'>\n";
	// made font slightly smaller to allow more in a smaller area -Josh 02-06-2023
	print "<textarea  rows=3 style='font-size: 10pt; background-color: white;' class='m-wrap span12'   id='notes_to_ap' name='notes_to_ap'  onchange='notesChanged(\"ap\")'>$notes_to_ap</textarea>"; //Notes to ap
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	print "</div>";
	//end change


	## bdoss add reminder notes 10/4/22
	## modal dialog for new orders with customers with existing repeating reminders
	$sql="SELECT repeat_reminders.*, order_status.status_name FROM repeat_reminders
    	INNER JOIN order_status ON repeat_reminders.order_status=order_status.status_id
		WHERE customer=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	if ($rs) {
		$repeatTable= "<table><thead><th>Reminder</th><th>Order Status</th><th>Send To</th><th></th></thead><tbody>";
		foreach($rs as $data) {
			$repeatID=$data['repeat_id'];
			$message=$data['reminder_message'];
			$status=$data['status_name'];
			$statusID=$data['order_status'];
			$reminderRecipients="";
			$reminderID=0;
			## taking most recent reminder to see who it was sent to
			$sql="SELECT reminder_id FROM order_reminders WHERE reminder_message=? AND order_status=? AND customer=? ORDER BY reminder_id DESC LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("sii",$message,$statusID,$customer_id));
			$reminderID=$rs[0][0];
			## get email recipients
			$sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
			list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
			foreach($employee_rs as $employee_data) {
				$reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
			}

			$useRepeatReminder=renderButton("Add","blue","copyReminder($id,$customer_id,$statusID,$reminderID,$repeatID);");
			$repeatTable.="<tr><td>$message</td><td>$status</td><td>$reminderRecipients</td><td><div id='hide$repeatID' >$useRepeatReminder</div><div id='show$repeatID' style='display:none; color: blue'>Added</td></td></tr>";
		}
		$repeatTable.="</tbody></table>";

	}
	print "<div id='repeatReminderDialog' class='modal' role='dialog' style='display: none; border: 1px solid black;'>";
	print "<p>This customer has an existing repeat reminder.  Would you like to add an automated reminder to this order?</p>";
	print $repeatTable;
	print "<div style='float: right; cursor: pointer;' onclick='closeRepeatDialog()' class='ui-dialog-close'>[Close]</div>";
	print "</div>";
	## bdoss end of repeat additions on creation of order
	$reminderNotes = "";
	$reminderClass = "hideReminder";
	if ($id > 0) {
		$sql="SELECT reminder_id, status_name, repeat_reminder, reminder_message FROM order_reminders INNER JOIN order_status ON order_status.status_id=order_reminders.order_status WHERE order_id=? AND sent_on IS NULL";
		list($reminder_rs,$err)=runIQuery($db,$sql,array("i",$id));
		if ($reminder_rs) {
			$reminderClass = "showReminder";
			$reminderNotes.="<p style='color:red'>Below reminders will be sent when the order reaches the shown status</p>";
			$reminderNotes.= "<table><thead><th>Reminder</th><th>Order Status</th><th>Repeat</th><th>Send To</th></thead><th></th><tbody>";
			foreach($reminder_rs as $reminder_data) {
				$reminderID=$reminder_data['reminder_id'];
				$reminderMessage=$reminder_data['reminder_message'];
				$reminder_data['repeat_reminder'] == 1 ? $reminderRepeat = 'Yes' : $reminderRepeat = 'No';
				$reminderStatus=$reminder_data['status_name'];
				$reminderRecipients = "";
				## buttons
				## bdoss this doesn't actually delete the reminder, it sets the sent_on, and reminders with a IS NOT NULL sent_on will not display
				$deleteReminder = renderButton("Delete","red","deleteReminder($reminderID);");
				$editReminder = "<a class='btn yellow' href='updateOrderReminders.php?id=$reminderID&action=edit' target='_blank'>Edit Reminder</a>";

				$sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
				list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
				foreach($employee_rs as $employee_data) {
					$reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
				}
				$reminderNotes.= "<tr id='hideRow$reminderID'><td>$reminderMessage</td><td>$reminderStatus</td><td>$reminderRepeat</td><td>$reminderRecipients</td><td>$deleteReminder $editReminder</td><tr>";
			}
			$reminderNotes.= "</tbody></table>";

		} else {
			$reminderClass = "hideReminder";
		}
		## bdoss 11/22 add so reminders to the reminder display area
		$sql="SELECT reminder_id, reminder_message FROM so_reminders WHERE so_id=? AND sent_on IS NULL";
		list($reminder_rs,$err)=runIQuery($db,$sql,array("i",$id));
		if ($reminder_rs) {
			$reminderClass = "showReminder";
			$reminderNotes.="<p style='color:red'>Below reminders will be sent when the order is received</p>";
			$reminderNotes.= "<table><thead><th>Reminder</th><th>Send To</th></thead><th></th><tbody>";
			foreach($reminder_rs as $reminder_data) {
				$reminderID=$reminder_data['reminder_id'];
				$reminderMessage=$reminder_data['reminder_message'];
				$reminderRecipients = "";
				## buttons
				## bdoss this doesn't actually delete the reminder, it sets the sent_on, and reminders with a IS NOT NULL sent_on will not display
				$deleteSOReminder = renderButton("Delete","red","deleteSOReminder($reminderID);");
				$editSOReminder = "<a class='btn yellow' href='updateSOReminders.php?id=$reminderID&so=$id&action=edit' target='_blank'>Edit Reminder</a>";

				$sql="SELECT first_name, last_name from employees INNER JOIN employee_so_reminders ON employees.employee_id=employee_so_reminders.employee_id WHERE employee_so_reminders.reminder_id=?";
				list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
				foreach($employee_rs as $employee_data) {
					$reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
				}
				$reminderNotes.= "<tr id='hideRow$reminderID'><td>$reminderMessage</td><td>$reminderRecipients</td><td>$deleteSOReminder $editSOReminder</td><tr>";
			}
			$reminderNotes.= "</tbody></table>";
		}
	}
	##bdoss the display area for automated reminders  9/27
	print "<div style='display:flex; flex-direction: column'>";
	print "<div class='span8 $reminderClass' style='margin: 0px'>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='reminder_notes'>Automated Reminder(s)</label>\n";
    print "<div class='controls'>\n";
	print "<div  rows=4 style=' background-color: white; width: 80%' id='reminder_notes' name='reminder_notes'>$reminderNotes</div>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	## bdoss end of automated reminder notes
	print "<div class='buttonContainer' style='margin-top: 10px'>";
	## bdoss adding button for generating a new reminder/ updating
	print "<a class='btn green' href='updateOrderReminders.php?order=$id&customer=$customer_id&action=create' target='_blank'>Create New Reminder (Status Change)</a>";
	print "<a class='btn green' href='updateSOReminders.php?so=$id&action=create' target='_blank' style='margin-left: 10px'>Create New Reminder (SO Received)</a>";
	print "</div></div>";
	## bdoss end of reminder additions
	print "<div style='clear: both;'></div><hr>\n";

	print "<table  class='table-bordered table-striped table-condensed flip-content' style='width: 100%;'>\n<thead class='flip-content'>\n";
	print "<tr><th >Part</th><th>Rev</th><th >Description</th><th class='numeric'>Quantity</th></th><th class='numeric'>Price</th><th >PO Line</th><th>Due Date</th><th>Powder</th><th>Extended</th><th>WO</th><th>Shipped</th></tr></thead><tbody id='orderLineList'>\n";
	$i=0;
	$toggle=1;
	if ($id > 0) {
		$sql="select * from order_lines where order_id=$id order by coalesce(po_line,0) * 1, line_id ";
		$pitext="";
		$rs=mysqli_query($db,$sql);
		while ($ldata=mysqli_fetch_array($rs)) {
			print "<tr>";
			$line_id=$ldata['line_id'];
			$pol=$ldata['po_line'];
			$item=$ldata['item_id'];
			$desc=$ldata['item_description'];
			$qty=$ldata['quantity'];
			$price=$ldata['price'];
			$rev=$ldata['revision'];
			$sq=$ldata['shipped_quantity'];
			$powder=$ldata['powder_color'];
			$sql="select * from jobs, production_results where line_id=$line_id and jobs.job_id=production_results.job_id ";
			$jrs=mysqli_query($db,$sql);
			$readonly="";
			if (mysqli_num_rows($jrs)>0) {
				$readonly=" readonly ";
			}
			$due=formatDateDBToWeb($ldata['due_date']);
			$ext=number_format($qty*$price,2);
			print "<td style='display: flex;'><div class='btn red' onclick='deleteLine($i)'><i class='icon-trash'></i></div><input type='hidden' name='ol$i' id='ol$i' value='$line_id'><input type='text' id='item$i' name='item$i' $readonly autocomplete='off'  onfocus=\"currentLine='$i';\" value='$item' class='ui-widget' style='width: 120px; background-color: white;'></td>"; //Item
			print "<td><input type='text' id='rev$i' name='rev$i' value='$rev' style='width: 24px; background-color: white;' ></td>"; //Revision
			print "<td><input type='text' id='desc$i' name='desc$i'  value='$desc' style=' background-color: white;' ></td>"; //Description
			print "<td class='numeric' valign='top'><input type='text' id='qty$i' name='qty$i' style='width: 40px; text-align: right;background-color: white;'  value='$qty' onchange=\"calculateExt('$i');\"></td>"; //Quantity
			print "<td class='numeric' valign='top'><input type='text' id='price$i' name='price$i' style='width: 60px; text-align: right; background-color: white;' value='$price' onchange=\"calculateExtPrice('$i');\"></td>"; //Price
			print "<td><input type=text id='pol$i' name='pol$i' style='width: 50px; background-color: white;' value='$pol'></td>"; //PO Line
			print "<td><input type=text class='datepicker' id='due$i' name='due$i' style='width: 80px; background-color: white;' value='$due'></td>"; //Date due
			print "<td><select name='powder$i' id='powder$i'>";
			print "<option value='0'>No Powder</option>"; //Powder type
			$sql="select vc_id, color_code, vendor_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by color_code, vendor_name"; //Powder type
			list($crs,$err)=runIQuery($db,$sql);
			foreach ($crs as $cdata) {
				$c=$cdata['color_code'];
				$vc=$cdata['vc_id'];
				$v=$cdata['vendor_name'];
				print "<option value ='$vc' ";
				if ($vc == $powder) {
					print " selected ";
				}
				print ">$c - $v</option>";
			}
			print "</select>";
			print "</td>";
			print "<td class='numeric' valign='top'><input type='text' id='ext$i' readonly name='ext$i' style='border: 0px; width: 60px; text-align: right; background-color: white;' value='$ext' ></td>";
			print "<td valign='top' align='center'>"; //Extended
			$sql="select * from jobs where line_id=$line_id";
			$jrs=mysqli_query($db,$sql);
			$job=0;
			$joblist=array();
			$jobhtml = "";
			while ($jdata=mysqli_fetch_array($jrs)) {
				if ($job) {
					$jobhtml .= "<BR>";
				}
				$job=$jdata['job_id'];
				$jitem=$jdata['item_id'];
				$sql=" select operation_name from jobs j, routing r, operations op where j.job_id=? and j.item_id=r.parent_part and r.operation_id=op.operation_id order by r.display_sequence limit 1	";
				list($ors,$err)=runIQuery($db,$sql,array("i",$job));
				$op="";
				if (count($ors)>0)  {
					$odata=$ors[0];
					$op=$odata['operation_name'];
				}
				$joblist[]=$job;
				$jobhtml .= "&nbsp;<a href='editJob.php?id=$job' target='_blank' style='font-weight: bold; background-color: white;' alt='$op $jitem' title='$op $jitem'>$job</a>&nbsp;";
			}
			if (count($joblist)>0) {
				$sql="select distinct job_id from jobs_orders where order_line=? and job_id not in (" . implode(",",$joblist) . ")   order by job_id";
			} else {
				$sql="select distinct job_id from jobs_orders where order_line=?  order by job_id";
			}
			list($jrs,$err)=runIQuery($db,$sql,array("i",$line_id));
			foreach ($jrs as $jdata) {
				$job=$jdata['job_id'];
				$jobhtml .= "<br>&nbsp;<a href='editJob.php?id=$job' target='_blank' style='font-weight: bold; background-color: white;'>$job</a>&nbsp;";
			}

			print "<div onclick='$(\".jobtoggle$line_id\").toggle(); return false;' class='btn " . ($jobhtml != "" ? "blue" : "disabled cursor-na") . "'>Toggle Jobs</div>";
			if ($jobhtml != "") {
				print "<div class='jobtoggle$line_id' style='display: none;'>$jobhtml</div>";
			}

			print "</td>";

			print "<td><input type='text' id='sq$i' name='sq$i' value='$sq' style='width: 50px;'></td>"; //Shipped quantity
			$pitext.="getLevels('$i','$item');\n";
			print "</tr>\n";
			$i++;
		}
		$current=$i;
		while ($i < $current+1) {
			print "<tr>";
			print "<td style='display: flex;'><div class='btn red' onclick='deleteLine($i)'><i class='icon-trash'></i></div><input type='hidden' name='ol$i' id='ol$i'  value='0'><input type='text' id='item$i' name='item$i'  onfocus=\"currentLine='$i';addRow('$i');\" class='ui-widget' style='width: 120px;'></td>"; //Item
			print "<td><input type='text' id='rev$i' name='rev$i' value='' style='width: 24px;  background-color: white;'></td>"; //Revision
			print "<td><input type='text' id='desc$i' name='desc$i'  value='' style=' background-color: white;'></td>"; //Description
			print "<td align='right'><input type='text' id='qty$i' name='qty$i' style='width: 40px; text-align: right; background-color: white;' value='0' "; //Quantity
			print " onchange=\"calculateExtPrice('$i');\" >"	;
			print "<td align='right'><input type='text' id='price$i' name='price$i' style='width: 80px; background-color: white;' value='0' onchange=\"calculateExtPrice('$i');\"></td>"; //Price
			print "<td><input type=text id='pol$i' name='pol$i' style='width: 50px; background-color: white;' value=''></td>"; //PO Line
			print "<td><input type=text class='datepicker' id='due$i' name='due$i' style='width: 80px; background-color: white;' value=''></td>"; //Date due
			print "<td><select name='powder$i' id='powder$i'>"; //Powder type
			print "<option value='0'>No Powder</option>";//Powder type
			$sql="select vc_id, color_code, vendor_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by color_code, vendor_name";
			list($crs,$err)=runIQuery($db,$sql);
			foreach ($crs as $cdata) {
				$c=$cdata['color_code'];
				$vc=$cdata['vc_id'];
				$v=$cdata['vendor_name'];
				print "<option value ='$vc' ";
				print ">$c - $v</option>";
			}
			print "</select>";
			print "</td>";
			print "<td align='right'><input type='text' id='ext$i' readonly name='ext$i' style='border: 0px; width: 60px; text-align: right; background-color: white;' value='' ></td>"; //Extended
			print "<td ><div class='btn disabled cursor-na'>Toggle Jobs</div></td>";

			$i++;
		}
		print "</tbody>";
		print "<tfoot>";
		print "<tr><td class='numeric'>Total: </td><td colspan='6'></td>";
		print "<td class='numeric'><input type=text id='otot' readonly style='border: 0px; width: 60px; text-align: right;  background-color: white;' value=''><h5 id='notice'><b>This price does NOT reflect Order Type markups (Check the SO document for that)</b></h5></td></tr>\n";
	} else {
		## id is zero
		print "<tr><td colspan=6>You must save the order before you can enter lines</td></tr>";
	}
	print "</tfoot>";
	print "</table>\n";


	?>
	<div id='selectShipping' style='border: 1px solid black; background-color: white;'></div>
	</div>
	</div>
	</form>
	</div>
	<div class="clear"></div>
	<div id="confirmDeleteFile" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteFile" aria-hidden="true">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
		<h3 id="cdb">Confirm Delete</h3>
	</div>
	<div class="modal-body">
		<p>Are you sure you want to delete file <span id='delfname'></span>?</p>
	</div>
	<div class="modal-footer">
		<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
		<button data-dismiss="modal" class="btn blue" onclick='processDeleteFile();'>Confirm</button>
	</div>
</div>
</div>
	<form id='emailform' name='emailform' method='GET' target='_blank' action='composeEmail.php' rel='opener' >
	<input type='hidden' name='id' id='id' value='<?=$id?>'>
	<input type='hidden' name='type' id='type' value='SO'>
	</form>
	</div>
	<script>
	linecounter=<?=$i?>;
	<?php
	if (! $creditHold) {
		$creditHold=0;
	}
	?>
	creditHold=<?=$creditHold?>;
	var scheduleSet=0;
	function saveTheForm(scheduleIt) {
		var oktogo=1;
		if ($('#customer_id').val() == 693) {
			if ($('#po_number').val()=='') {
				alert('PO Number (and po line) required for DEMATIC');
				oktogo=0;
			}
		}
		if ($('#order_type').val() == 0) {
			alert('You must select an Order Type');
			document.getElementById('order_type').focus();
			oktogo=0;
		}
		rmaIndex=$('#po_number').val().toUpperCase().indexOf('RMA');
		let rmaReason = $('#rma_reason').val();
		let internalNotes = $('#notes_to_self').val();
		//console.log(internalNotes);
		if (rmaReason=='0') {
			if (rmaIndex > 0) {
				oktogo=0;
				$.gritter.add("You must select RMA Reason");
			}
		}
		if (oktogo > 0) {
			if (rmaReason > 0) {
				let url = 'requireNotes.php?reason='+rmaReason+'&rand='+Math.random();
				$.ajax({url: url, success: function(data){
					if (data == 1) {
						if (!internalNotes) {
							oktogo=0;
							$.gritter.add('Internal Notes must be filled out with more info for this type of RMA');
						}
					}
				}})
			}
		}

		if (oktogo==1) {
			$('#working').show();
			$('#printIcon').hide();
			$('#emailIcon').hide()
			$("#saveButton").hide();
			$('#scheduleButton').hide();
			$('#woButton').hide();
			$('#poButton').hide();
			$('#printButton').hide();
			$('#rfqButton').hide();
			var url = "updateOrder.php"; // the script where you handle the form input.
			formdata="id=" + $('#id').val();
			formdata += "&customer_id=" + $('#customer_id').val();
			formdata += "&date_due=" + $('#date_due').val();
			formdata += "&po_number=" + $('#po_number').val();
			formdata += "&status=" + $('#status').val();
			formdata += "&salesperson_id=" + $("#salesperson_id").val();
			formdata += "&attention=" + $('#attention').val();
			formdata += "&ship_name=" + $('#ship_name').val();
			formdata += "&ship_address=" + $('#ship_address').val();
			formdata += "&ship_address2=" + $('#ship_address2').val();
			formdata += "&ship_city=" + $('#ship_city').val();
			formdata += "&ship_state=" + $('#ship_state').val();
			formdata += "&ship_zip=" + $('#ship_zip').val();
			formdata += "&ship_phone=" + $('#ship_phone').val();
			formdata += "&order_priority=" + $('#order_priority').val();
			formdata += "&order_class=" + $('#order_class').val();
			formdata += "&order_type=" + $("#order_type").val();
			formdata += "&ship_email=" + $('#ship_email').val();
			formdata += "&notes_to_ap=" + $('#notes_to_ap').val();
			formdata += "&shipping_notes=" + $('#shipping_notes').val();
			formdata += "&rma_reason=" + $('#rma_reason').val();
			formdata += "&notes_to_customer=" + $('#notes_to_customer').val();
			formdata += "&notes_to_self=" + $('#notes_to_self').val();
			updmsg='';
            alert(url+'?'+formdata);
            console.log(url+'?'+formdata)
			$.ajax({
				type: "POST",
				url: url,
				data: formdata, // serializes the form's elements.
				complete: function(jqXHR)
				{
					$('#working').hide();
					$('#printIcon').show();
					$('#emailIcon').show()
					$("#saveButton").show();
					$('#scheduleButton').show();
					$('#woButton').show();
					$('#poButton').show();
					$('#printButton').show();
					$('#rfqButton').show();
					scheduleLines(jqXHR.responseText, scheduleIt);
				}
			});
		}
	}

function processLines(updmsg, scheduleIt) {
		scheduleSet=scheduleIt;
		url = 'updateOrderLine.php';
		for (i=0; i < 999; i++) {
			try {
				formdata = "scheduleit=" + scheduleIt;
				formdata += "&id=" + $('#id').val();
				ol = $('#ol' + i).val();
				itm = $('#item' + i).val();
				if ((ol > 0 ) || (itm != '')) {
					rev = $('#rev' + i).val();
					desc = $('#desc' + i).val();
					qty = $('#qty' + i).val();
					price = $('#price' + i).val();
					pol = $('#pol' + i).val();
					due = $('#due' + i).val();
					powder=$('#powder' + i).val();
					sched=0;
					if (document.getElementById('sched'+i).checked) {
						sched = 1;
					}
					qoh = $('#qoh' + i).val();
					qoj = $('#qoj' + i).val();
					formdata += "&ol=" + ol;
					formdata += "&item=" + itm;
					formdata += "&rev=" + rev;
					formdata += "&desc=" + desc;
					formdata += "&qty=" + qty;
					formdata += "&price=" + price;
					formdata += "&pol=" + pol;
					formdata += "&due=" + due;
					formdata += "&sched=" + sched;
					formdata += "&qoh=" + qoh;
					formdata += "&powder=" + powder;
					formdata += "&qoj=" + qoj;
					$.ajax({
						type: "POST",
						url: url,
						data: formdata,
						complete: function(jqXHR)
						{
						}
					});
				}
			}
			catch (err) {
				i=999;
				// errors mean it is undefined
			}
		}
		$(document).ajaxStop(function() {
			$('#working').hide();
			document.getElementById('printIcon').style.display='block';
			document.getElementById('emailIcon').style.display='block';
			document.getElementById('saveButton').style.display='inline';
			showReturnValue(updmsg);
		});
}

function checkAll() {
	$('input[type=checkbox]').each(function() {
		this.click();
	});
}

	//add code for hiding buttons
	function checkCreditHold(customerID) {
		let url = 'checkCreditHold.php?customer='+customerID+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){
			if (data == 1) {
				//hide buttons here and send message
				$.gritter.add('Customer on Credit Hold');
				$('#saveButton').hide();
				$('#woButton').hide();
				$('#printButton').hide();
				$('#poButton').hide();
				$('#powderButton').hide();
				$('#rfqButton').hide();
				//$('#copyButton').hide();
				$('#confirmButton').hide();

			} else {
				$('#saveButton').show();
				$('#woButton').show();
				$('#printButton').show();
				$('#poButton').show();
				$('#powderButton').show();
				$('#rfqButton').show();
				//$('#copyButton').show();
				$('#confirmButton').show();
			}
		}} );
	}

	// bdoss adding functions for automated reminders 10/4/22
	function deleteReminder(reminder) {
		let hideRow = document.getElementById(`hideRow${reminder}`);
		let reminderURL=`updateOrderReminders.php?id=${reminder}&action=delete`;
		$.ajax({url: reminderURL, success: function(){
			$(hideRow).hide();
			$.gritter.add('Deleted Reminder');  }} );
	}
	// adding so reminder functionionality 11/15/22
	function deleteSOReminder(reminder) {
		let hideRow = document.getElementById(`hideRow${reminder}`);
		let reminderURL=`updateSOReminders.php?id=${reminder}&action=delete`;
		$.ajax({url: reminderURL, success: function(){
			$(hideRow).hide();
			$.gritter.add('Deleted SO Reminder');  }} );
	}
	// bdoss this will add an existing repeat reminder to a new order 10/4/22
	function copyReminder(order,customer,status,employees,message) {
		let hideButton = document.getElementById(`hide${message}`);
		let showAdded = document.getElementById(`show${message}`);
		$(hideButton).hide();
		let reminderURL=`updateOrderReminders.php?order=${order}&customer=${customer}&status=${status}&employees=${employees}&message=${message}&action=repeat`;
		console.log(reminderURL);
		$.ajax({url: reminderURL, success: function(){
			$(showAdded).show();
			$.gritter.add('Copied Repeat Reminder');  }} );
	}

	function closeRepeatDialog() {
		$('#repeatReminderDialog').dialog('close');
	}

	// bdoss adding contact dropdown to select email from list of frequent buyers

	function setContactInfo(contactinfo) {
		cinfo=contactinfo.split("|");
		$('#attention').val(cinfo[0]);
		$('#ship_email').val(cinfo[1]);
	}

	function selectContact() {
		$('#selectContact').load('listContacts.php?customer='+$('#customer_id').val()+'&rand='+Math.random());
	}

	function updateCustomer(customerID) {

		//adding code to hide buttons if customer is on credit hold Brittany 6/22
		let churl = 'checkCreditHold.php?customer='+customerID+'&rand='+Math.random();

		$.ajax({url: churl, success: function(data){
			if (data == 1) {
				//hide buttons here and send message
				$.gritter.add('Customer on Credit Hold');
				$('#saveButton').hide();
				$('#woButton').hide();
				$('#printButton').hide();
				$('#poButton').hide();
				$('#powderButton').hide();
				$('#rfqButton').hide();
				//$('#copyButton').hide();
				$('#confirmButton').hide();
				$('#choldmsg').show();

			} else {
				$('#saveButton').show();
				$('#woButton').show();
				$('#printButton').show();
				$('#poButton').show();
				$('#powderButton').show();
				$('#rfqButton').show();
				//$('#copyButton').show();
				$('#confirmButton').show();
				$('#choldmsg').hide();
			}
		}} );

		var url='getCustomerInfo.php?customer='+customerID+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){   setShippingInfo(data); }} );
		selectContact();
	}

	function updatePriority(priority) {
		saveTheForm('1');
	}

	function setShippingInfo(shipinfo) {
		if (shipinfo!='') {
			console.log("shipinfo is " + shipinfo);
			spinfo=shipinfo.split('|');
			$('#customer_info').html(spinfo[0]+'<br>'+spinfo[1]+'<br>'+spinfo[2]+'<br>'+spinfo[3]+'<br>'+spinfo[4]+'<br>'+spinfo[5]);
			$('#ship_phone').val(spinfo[4]);
			emval='';
			if (spinfo.lengtgh > 5) {
				emval=spinfo[5].replace(/(<([^>]+)>)/ig,"");
			}
			$('#ship_email').val(emval);
			if (spinfo.length > 8) {
				$('#ship_name').val(spinfo[6]);
				$('#ship_address').val(spinfo[7]);
				$('#ship_address2').val(spinfo[8]);
				csz=spinfo[9].split(',');
				if (csz[1]) {
					$('#ship_city').val(csz[0]);
					sz=csz[1].trim().split(' ');
					$('#ship_state').val(sz[0].trim());
					$('#ship_zip').val(sz[1]);
				}
				$('#notes').val(spinfo[10]);
				$('#shipping_notes').val(spinfo[11]);
			} else {
				$('#ship_name').val(spinfo[0]);
				$('#ship_address').val(spinfo[1]);
				$('#ship_address2').val(spinfo[2]);
				csz=spinfo[3].split(',');
				if (csz[1]) {
					$('#ship_city').val(csz[0]);
					sz=csz[1].trim().split(' ');
					$('#ship_state').val(sz[0].trim());
					$('#ship_zip').val(sz[1]);
				}
				$('#notes').val(spinfo[6]);
				$('#shipping_notes').val(spinfo[7]);
			}
		} else {
			customerName=$('#customer_name').val();
			updateCustomer(customerName);
		}
	}

	function setShippingInfoDiv(shipinfo) {
		if (shipinfo!='') {
			console.log("shipinfo is " + shipinfo);
			shipinfo=shipinfo.replace('<BR>','<br>');			
			spinfo=shipinfo.split('<br>');
			$('#customer_info').html(spinfo[0]+'<br>'+spinfo[1]+'<br>'+spinfo[2]+'<br>'+spinfo[3]+'<br>'+spinfo[4]+'<br>'+spinfo[5]);
			$('#ship_phone').val(spinfo[4]);
			emval='';
			$('#ship_email').val(emval);
			if (spinfo.length > 6) {
				$('#ship_name').val(spinfo[6]);
				$('#ship_address').val(spinfo[7]);
				$('#ship_address2').val(spinfo[8]);
				csz=spinfo[9].split(',');
				if (csz[1]) {
					$('#ship_city').val(csz[0]);
					sz=csz[1].trim().split(' ');
					$('#ship_state').val(sz[0].trim());
					$('#ship_zip').val(sz[1]);
				}
			} else {
				$('#ship_name').val(spinfo[0]);
				$('#ship_address').val(spinfo[1]);
				$('#ship_address2').val(spinfo[2]);
				csz=spinfo[3].split(',');
				if (csz[1]) {
					$('#ship_city').val(csz[0]);
					sz=csz[1].trim().split(' ');
					$('#ship_state').val(sz[0].trim());
					$('#ship_zip').val(sz[1]);
				}
			}
		} else {
			customerName=$('#customer_name').val();
			updateCustomer(customerName);
		}
	}


	function setShippingDiv(newval) {
		$('#shippingDiv').html(newval);
	}

	function selectShipTo() {
		$('#selectShipping').load('listShiptos.php?customer='+$('#customer_id').val()+'&rand='+Math.random());
		$('#selectShipping').dialog({modal: true, width: 800, height: 600});
	}
	function checkSaveShipping() {
		html=html+'Would you like to save this shipping address for future use?';
		currentID=id;
		if (confirm(html)) {
			processSShip();
		}
		$.prompt(html,{ callback: processSShip, buttons: { 'Yes': true, 'No': false}})
	}

	function processSShip() {
		url='saveShipping.php?customer='+$('#id').val()+'&name='+escape($('#ship_name').val())+'&addr1='+escape($('#ship_address').val())+'&addr2='+escape($('#ship_address2').val())+'&city='+escape($('#ship_city').val())+'&state='+escape($('#ship_state').val())+'&zip='+escape($('#ship_zip').val())+'&phone='+escape($('#phone').val())+'&rand='+Math.random();
		$.ajax(url);
	}
	function sendEmail() {
		if (creditHold == 1 && $('#order_status')!=10) {
			alert('Please see Justin or Aaron, you cannot confirm this SO');
		} else {
			if ($('#id').val()==0) {
				$.gritter.add('You must save the Sales Order first');
			} else {
				composeEmail('SO',$('#id').val());
			}
		}
	}
	function printPage() {
		if (creditHold == 1 && $('#order_status')!=10) {
			alert('Please see Justin or Aaron, you cannot print this SO');
		} else {
			if ($('#id').val()==0) {
				$.gritter.add('You must save the Sales Order first');
			} else {
				//Updated to go directly to renderPDF -Josh 02-25-2022
				if (confirm("Print Prices? OK=Yes, Cancel=No")) {
					url='renderPDF.php?type=SO&id='+$('#id').val()+'&rand='+Math.random();
					window.open(url,'_blank');
					//$.ajax({url: url, success: function(data){window.open('documents/SO'+$('#id').val()+'.pdf?rand='+Math.random(),'_blank');}});
				} else {
					url='renderPDF.php?type=SO&price=no&id='+$('#id').val()+'&rand='+Math.random();
					window.open(url,'_blank');
					//$.ajax({url: url, success: function(data){window.open('documents/SO'+$('#id').val()+'.pdf?rand='+Math.random(),'_blank');}});
				}
			}
		}
	}
function page_init() {

	$("#date_due").on("change", function(e) {
		var date = $(e.target).val();
		var id = $("#id").val();
		if (id == "") {
			return;
		}

		$.ajax({
			type: "POST",
			url: "updateOrderLineNew.php",
			data: "datesonly=1&id=" + id + "&date=" + date,
			complete: function(jqXHR) {
				console.log(jqXHR);
			}
		});
	});

	$.each($("#orderLineList input"), function(i,e) {
		if ($(e).is("[readonly]") && e.id.substr(0,3) != "ext") {
			var linenum = +$(e).prop("id").replace(/[A-z]/g, "");
			$("#uniform-sched"+linenum).hide();
		}

		$(e).data('previousValue', $(e).val());
	});

	$('[id^="item"]').autocomplete({source: itemList, minLength: 4, messages: {
        noResults: '',
        results: function() {}
    }
    , change: function (event, ui) {
    	var ok=1;
    	if ($(this).val().includes("Pending")) {
			ok=0;
		}
    	if ($(this).val().includes("Inactive")) {
			ok=0;
		}
		if (ok==1) {
			lookupItemInfo($(this).val());
		} else {
			$.gritter.add("You must have this part activated by Engineering");
			$(this).val('');
		}
	}
    });
    $('#date_due').change(
    	function() {
			$("[id^='due']").val($('#date_due').val());
	    	if ($('#id').val()!='0') {
		    	url="dateChanged.php?order=" + $('#id').val()+'&date='+$('#date_due').val();
				$.ajax(url);
			}
		}
    )
    $('#po_number').change(
    	function() {
    		url='validatePO.php?rand='+Math.random()+'&customer=' + $('#customer_id').val()+'&id=<?=$id?>&po='+$('#po_number').val();
    		$.ajax({url: url, success: function(data) {if (data!='') {alert(data);}}});
    	});
    if ($('#id').val()=='0') {
	    $('#customer_id').focus();
	    document.getElementById('customer_id').style.backgroundColor='#c0c0c0';
	}
	$('[id^="item"]').autocomplete({ autoFocus: true });
    $('[id^="qty"]').change(function() { lookupFromQuantity($(this).attr('id')); })

    calculateExt();
	<?=$pitext?>
	url='getReceivingInfo.php?id='+$('#id').val();
	$.ajax({url: url, success: function(data) {
		$('#receipt').html(data);
	}});
	checkCreditHold(document.getElementById('customer_id').value);

	resetLineOnChange();

	// bdoss adding automated reminders 10/11/22
	// bdoss getting url and search parameters
	const queryString = window.location.search;
	const urlParams = new URLSearchParams(queryString);
	// bdoss is this an order that was just created and has repeat automated reminders?
	if (urlParams.has('repeat')) {
		$('#repeatReminderDialog').dialog({position: [1000,400], height: 300, width: 500});
		let id = urlParams.get('id');
		let newURL = `editOrders.php?id=${id}`;
		window.history.pushState({}, '', newURL);   // bdoss this will get rid of the repeat parameter so the dialog only shows up once
	}

	// bdoss added ability to autofill email field from list of available contacts 11/22/22 per Nick's request to match machine
	selectContact();
}

//changed 02-11-2022 by Josh- applies notes on change
function notesChanged(type) {
	if (type != 'shipping_notes') {
		type = "notes_to_" + type;
	}
	url='notesChanged.php?id=<?php echo $id; ?>&type=' + type + '&notes=' + $("#" + type).val();
	console.log(url);
	$.get(url, function(data) {
		console.log('retval: ' + data);
	});
}
//end change


function addRow(currentLine) {
	newLine=parseInt(currentLine)+1;
	if (! document.getElementById('item'+newLine)) {
		newRow="<tr><td style='display: flex;'><input type='hidden' name='ol";
		newRow=newRow + newLine + "' id='ol";
		newRow=newRow + newLine + "' value='0'>";
		newRow=newRow + "<div class='btn red' onclick='deleteLine("+newLine+")'><i class='icon-trash'></i></div><input type='text' id='item";
		newRow=newRow +  newLine + "' name='item" + newLine + "' autocomplete='off' class='ui-widget' ";
		newRow=newRow + "  onfocus=\"currentLine='" + newLine + "';addRow('" + newLine + "');\"";
		newRow=newRow + " style='width: 120px;'>";
		newRow=newRow + "</td>";
		newRow=newRow + "<td><input type='text' id='rev" + newLine + "' name='rev" + newLine + "' value='' style='width: 24px;  background-color: white;'></td>";
		newRow=newRow+"<td><input type='text' id='desc" + newLine + "' name='desc" + newLine + "'  value='' style=' background-color: white;'></td>";
		newRow=newRow+"<td align='right'><input type='text' id='qty" + newLine + "' name='qty" + newLine + "' style='width: 40px; text-align: right; background-color: white;' value='0' ";
		newRow=newRow+" onchange=\"calculateExtPrice('" + newLine + "');\" ></td>";
		newRow=newRow+"<td align='right'><input type='text' id='price" + newLine + "' name='price" + newLine + "' style='width: 80px; background-color: white;' value='' onchange=\"calculateExtPrice('" + newLine + "');\"></td>";
		newRow=newRow+"<td><input type=text id='pol" + newLine + "' name='pol" + newLine + "' style='width: 50px; background-color: white;' value=''></td>";
		newRow=newRow+"<td><input type=text class='datepicker' id='due" + newLine + "' name='due" + newLine + "' style='width: 80px; background-color: white;' value=''></td>";
		newRow=newRow+"<td><select name='powder" + newLine + "' id='powder" + newLine + "'>";
		newRow=newRow+"<option value='0'>No Powder</option>";
<?php
		$sql="select vc_id, color_code, vendor_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by color_code, vendor_name";
		list($crs,$err)=runIQuery($db,$sql);
		foreach ($crs as $cdata) {
			$c=$cdata['color_code'];
			$vc=$cdata['vc_id'];
			$v=$cdata['vendor_name'];
			print "		newRow=newRow+\"<option value ='$vc'>$c - $v</option>\";\n ";
		}
?>
		newRow=newRow+"</select>";
		newRow=newRow+"</td>";
		newRow=newRow+"<td align='right'><input type='text' id='ext" + newLine + "' readonly name='ext" + newLine + "' style='border: 0px; width: 60px; text-align: right; background-color: white;' value='' ></td>";
		newRow=newRow+ "<td ><div class='btn disabled cursor-na'>Toggle Jobs</div></td>";

		newRow=newRow+ "</tr>";
		$('#orderLineList tr:last').after(newRow);
		linecounter++;

		$('#item'+newLine).autocomplete({
			source: itemList,
			minLength: 4,
			messages: {
				noResults: '',
				results: function() {}
			},
			change: function (event, ui) {
				lookupItemInfo($(this).val());
			}
		});

		$('#due'+newLine).datepicker();
		resetLineOnChange();
	}
}

function scheduleLines(updmsg, scheduleIt) { // This is not ideal. Currently the system has multiple things that require the lines to be scheduled all at once
	scheduleSet=scheduleIt;
	var url = "scheduleOrderLine.php";
	var formdata = "&id=" + $('#id').val();

		$.ajax({
			type: "POST",
			url: url,
			data: formdata,
			complete: function(jqXHR) {
				showReturnValue(updmsg);
			}
		});

	$(document).ajaxStop(function() {
		$('#working').hide();
		document.getElementById('printIcon').style.display='block';
		document.getElementById('emailIcon').style.display='block';
		document.getElementById('saveButton').style.display='inline';
	});
}

function scheduleLine(linenum, len, i) {
	var url = "scheduleOrderLine.php";
	console.log(linenum);
	var formdata = "&id=" + $('#id').val();
	formdata += "&ol=" + $("#ol"+linenum).val();
	formdata += "&qty=" + $("#qty"+linenum).val();
	formdata += "&desc=" + $("#desc"+linenum).val();
	formdata += "&due=" + $("#due"+linenum).val();
	formdata += "&item=" + $("#item"+linenum).val();

	$.ajax({
		type: "POST",
		url: url,
		data: formdata,
		complete: function(jqXHR) {
			console.log(jqXHR);
			if (i+1 == len) {

			}
		}
	});
}
var skipDeleteCheck = false;
function deleteLine(linenum,confirmed=false) {
	var olelm = $("#ol"+linenum);
	var ol = +(olelm.val());
	var part = $("#item"+linenum);


	var emptycount = 0;
	$.each($("#orderLineList").children(), function(i,x) {
		var item = x.children[0].children[2].value;
		if (item == "") {
			emptycount++;
		}
	});

	if (emptycount == 1 && part.val() == "") {
		// Maybe alert user?
		return;
	}

	if (ol) {
		if (skipDeleteCheck || confirmed) {
			var url = "deleteOrderLine.php";
			var formdata = "id=" + $('#id').val();
			formdata += "&ol=" + ol;
			$.ajax({
				type: "POST",
				url: url,
				data: formdata,
				success: function(resp) {
					if (resp == "success") {
						$.gritter.add("Line Removed and Jobs Closed (if any)");
						olelm.parent().parent().remove();
					} else {
						$.gritter.add(resp);
					}
				}
			});
		} else {
			confirmModal("Delete Line?","Are you sure you want to delete this line?<br>Skip this check for additional line deletes on this page? <input type='checkbox' onclick='skipDeleteCheck=!skipDeleteCheck;'>", function(yes) {
				if (yes) {
					deleteLine(linenum,true);
				}
			});
		}
	} else {
		olelm.parent().parent().remove();
	}
}

function lineOnChange(event) { // used to set and unset onchange for line items for auto-saving lines as you
	var source = $(event.target || event.srcElement);
	var previousValue = $(event.target).data('previousValue');

	var linenum = +source.prop("id").replace(/[A-z]/g, "");
	var part = $("#item"+linenum).val();
	var ol = $("#ol"+linenum).val();
	var qty = $('#qty' + linenum).val();

	var nogo = 0;
	if (part == "") {
		nogo = 1; // 1 means part is empty
	} else {
		/*$("#orderLineList tr").each(function(i,x) {
			if (linenum != i) {
				var item = x.children[0].children[1].value;
				if (item == part) {
					nogo = 2; // 2 means duplicate part found, use other numbers for different messages
				}
			}
		});*/
	}

	if (!(+qty)) {
		nogo = 3;
		if (ol == 0) return;
		confirmModal("Delete Line?","Lines with a quantity of 0 will be deleted if yes is selected. Quantity is required to save a line.", function(conf) {
			$(event.target).val(+previousValue);
			$(event.target).data('previousValue', previousValue);
			if (conf) {
				deleteLine(linenum);
			}
		});
	}

	if (!nogo) { // only save if all required information is supplied

		scheduleSet=scheduleIt;
		url = 'updateOrderLineNew.php';
		formdata = "retval=1&scheduleit=" + scheduleIt;
		formdata += "&id=" + $('#id').val();
		itm = part;
		if ((ol > 0 ) || (itm != '')) {
			var i = linenum;
			rev = $('#rev' + i).val();
			desc = $('#desc' + i).val();
			price = $('#price' + i).val();
			pol = $('#pol' + i).val();
			due = $('#due' + i).val();
			powder=$('#powder' + i).val();
			sched=0;
			qoh = $('#qoh' + i).val();
			qoj = $('#qoj' + i).val();
			formdata += "&ol=" + ol;
			formdata += "&item=" + itm;
			formdata += "&rev=" + rev;
			formdata += "&desc=" + desc;
			formdata += "&qty=" + qty;
			formdata += "&price=" + price;
			formdata += "&pol=" + pol;
			formdata += "&due=" + due;
			formdata += "&qoh=" + qoh;
			formdata += "&powder=" + powder;
			formdata += "&qoj=" + qoj;
			$.ajax({
				type: "POST",
				url: url,
				data: formdata,
				success: function(resp) {
					resp = JSON.parse(resp);
					console.log(resp);
					if (resp.ol == 0) {
						$.gritter.add({
							title: "Line " + (1+linenum) + " Not Saved",
							text: "Order Line did not get saved (something went wrong)"
						});
						return;
					}

					if (qty > 0) $("#ol"+linenum).val(resp.ol);

					$('#working').hide();
					document.getElementById('printIcon').style.display='block';
					document.getElementById('emailIcon').style.display='block';
					document.getElementById('saveButton').style.display='inline';

					$.gritter.add("Line " + (1+linenum) + " Saved");
				}
			});
		}

	} else {
		var message = "";
		if (nogo == 1) {
			message = "Cannot save line without part number";
		}
		if (nogo == 2) {
			// message = "Duplicate parts, must use one line"; // We want to allow duplicate parts, keeping code in case that changes
		}
		if (nogo == 3) {
			// message = "Must enter quantity";
		}

		if (message != "") {
			$.gritter.add({
				title: "Line Not Saved",
				text: message
			});
		}
	}

	$(event.target).data('previousValue', $(event.target).val());
}

function resetLineOnChange() {
	var jqsel = $("#orderLineList :input:not(:checkbox), #orderLineList select");
	jqsel.off("change", lineOnChange); // don't want to save a bunch of times, remove the onchange events
	jqsel.on("change", lineOnChange); // time to re-apply!
}

	function confirmOrder() {
		if ($('#ship_email').val()=='') {
			alert('You must enter the shipping email');
		} else {
			url='updateOrderConfirmation.php?rand='+Math.random()+'&id='+$('#id').val();
			$.ajax(url);
			$('#to_email').val($('#ship_email').val());
			document.emailform.submit();
		}
	}
	function subUpload() {
		document.uploadForm.submit();
	}
	function deleteFile(fname,shortname, fid) {
		currentFile=fname;
		currentFileID=fid;
		$('#delfname').html(shortname);
		$('#confirmDeleteFile').modal('show');
	}
	function processDeleteFile() {
		url='deleteFile.php?file='+currentFile;
		$.ajax({url: url, success: function(data){
			$.gritter.add("Deleted");
			$('#'+currentFileID).hide();
			$('#del'+currentFileID).hide();
		}}
		);
	}

	function deleteDocument(docid) { // legacy/machine delete document
		if (confirm("Really Delete?")) {
			window.open('deleteDocument.php?id='+docid,'_blank');
		}
	}
	function copyOrder() {
		$('#copyButton').hide();
		document.location.href='copyOrder.php?id=<?=$id?>&rand='+Math.random();
	}

	function uploadquote() {
		testlinecount=linecounter -1;
		if (testlinecount > 0) {
			if (confirm('Are you sure you want to upload?  There are already ' + testlinecount + ' line items on this order')) {
				document.uploadform.submit();
			}
		} else {
			document.uploadform.submit();
		}
	}

	function getActivity(which) {
		url='getOrderActivity.php?so=<?=$id?>&which='+which+'&rand='+Math.random();
		function handleData(data) {
			if (which == 'viewed') {
				$('#viewed_activity').html(data);
			} else {
				$('#activity').html(data);
			}
		}
		if ($(which == 'viewed' ? "#viewed_activity" : "#activity").children().length) {
			handleData("");
		} else {
			$.ajax({url: url, success: handleData});
		}
	}
	<?php
	$sql="select * from order_lines l, jobs j, production_results r where order_id=? and l.line_id=j.line_id and j.job_id=r.job_id ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$id));
	$hasPR=count($rs);
?>
	var hasProductionResults=<?=$hasPR?>;
	function checkStatusChanged(newstat) {
		if (hasProductionResults > 0) {
			if (newstat == 5) {
				alert('Are you sure you want to cancel this order?  There are production results.');
			}
		}
	}

	</script>
</div>
</div>
<?php
include('footer.php');
?>