<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
include('security.php');
include('functions.php');
### WST
include('vendor/wstModules/quotes/soQuoteTicketing.php');
### end WST
//adding dialog warning for duplicate po bdoss 7/29/22
print "<div class='box transform'><p class='popp'>Duplicate</p><br><p class='popp'>PO</p><button class='popButton popp' onclick='stopPop()'>OK</button></div>";
include('header.php');
$id=$_GET['id'];
### WST checking for conversation ID in url which means user created SO from a quote request
if(isset($_GET['conversation'])){
	$conversation = $_GET['conversation'];
}
else {
	$conversation = false;
}

if(isset($_GET['tuser']))
{
    $tuser = $_GET['tuser'];
}
else 
{
    $tuser = '';
}
### end WST 
$key="order_id";
$table="orders";
$startDate=Date("m/d/Y H:i");
$sentInitial=0;
$okToReview=0;
if ($id) {
	$sql="select * from order_activity where order_id=? and activity='INITIAL' LIMIT 1";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($rs)>0) {
		$sentInitial=1;
	} else {
		$sql="select count(*) from order_lines where order_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		if ($rs[0][0]>0) {
			$sentInitial=1;
		}
	}
	$sql="select line_id,  sum(quantity * xdimension * ydimension * price_per_square_inch) as material_cost, sum(price * quantity) as ext from order_lines l, materials m where order_id=? and material=material_id group by line_id";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$id));
	$mcost=0;
	$okToReview=1;
	foreach ($lrs as $ldata) {
		$mcost+=$ldata['material_cost'];
	}
	if ($mcost > 4000) {
		$okToReview=0;
		$msg="High Material Cost";
	}
	foreach ($lrs as $ldata) {
		if ($ldata['ext'] > 5000) { # bdoss ext doesn't exist in table, commenting out to prevent errors
		 	$okToReview=0;
		 	$msg="High Value Order";
		 }
	}
	## cma changed from 8k and 10k to 4k and 5k, and also added individual line price >= 500 or qty >= 100
	$sql="select line_id from order_lines where (price  >= 500 or quantity >= 100)  and order_id=? ";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($lrs) > 0) {
			$okToReview=0;
			$msg="Price or Quantity High";
	}
	
	### WST
	$sql= "select * from quotes_have_requests where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$taggedConversations = $rs;
	### end WST
}
?>
<style>
	#repeatReminderDialog {
		background-color: lightblue;
		font-size: 20px;
	}
	.showReminder {
		display: block;
	}

	.hideReminder {
		display: none;
	}

	.box {
  color: red;
  background-color: gray;
  height: 0px;
  min-width: 500px;
  width: fit-content;
  position: fixed;
  bottom: 0px;
  right: 0px;
  display: flex;
  flex-direction: column;
  justify-content: space-around;
  z-index: -1;

}

.transform {
  -webkit-transition: all 10s ease;
  -moz-transition: all 10s ease;
  -o-transition: all 10s ease;
  -ms-transition: all 10s ease;
  transition: all 10s ease;
}

.transform-active {
  background-color: black;
  color: red;
  height: 40%;
  z-index: 1000;
  font-size: 100px;
  font-weight: bolder;
}

.popButton {
	color: white;
	background-color: red;
	width: 200px;
	height: 100px;
	border-radius: 20px;
}

.popp {
	padding: 20px;
	margin: 10px;
}

</style>
<script type="text/javascript">

<?php
// get list of items
## sql statement was commented out and autocomplete removed, adding it back in by a different variable name bdoss 9/7/22
$itemcount=0;
$sql="select item_name, item_description from items order by item_name ";
$itemList=array();
$rs=mysqli_query($db,$sql);
foreach ($rs as $data) {
	$itemList[]=$data['item_name'];
}
$itemcount=count($itemList);



$sql="select * from materials where material_name like '%SS%' or material_name='Custom Material' order by display_sequence, material_name";
list($mrs,$err)=runIQuery($db,$sql);
$sslist="'0'";
foreach ($mrs as $mdata) {
	$sslist.=",'";
	$sslist.=$mdata['material_id'];
	$sslist.="'";
}

$sql="select * from materials where display_sequence > 0  and material_name not like '%-OS' order by display_sequence, material_name";
list($mrs,$err)=runIQuery($db,$sql);

?>
var scheduleIt=0;
var addanother=0;
var currentLine=0;
var linecounter=0;
var itemList=<?=json_encode($itemList)?>

function itemFilter(req,res) {
	res(itemList.filter(x=>x.trim().toLowerCase().startsWith(req.term.trim().toLowerCase())));
}

var sslist = [<?=$sslist?>];

function lookupItemInfo(itemValue) {
	url='getItemInfo.php?item='+itemValue+'&rand='+Math.random();
	url = url + '&customer=' + $('#customer_id').val();
	url = url + '&id=' + $('#id').val();
	console.log(url);
	$.ajax({url: url, success: function(data){ setLineValues(data, currentLine); }})
	$('#qty'+currentLine).select();
}

function setLineValues(data,lineno) {
	console.log(data);
	vals=data.split('|');
	if (vals[0]!='NOTINMASTER') {
		$('#message'+lineno).html("<img src='images/loading.gif'>");
		$('#desc'+lineno).val(vals[0]);
		$('#price'+lineno).val(vals[1]);
		inotes = document.getElementById('notes_to_self').value;
		vals[2]=vals[2].trim();
		$('#rev'+lineno).val(vals[2]);
		if (! inotes.includes(vals[2])) {
			if (vals[2]=='undefined') {
				vals[2]='';
			}
			inotes = inotes + ' ' + vals[2];
			inotes=inotes.trim();
			console.log(inotes);
			$('#notes_to_self').val(inotes);
		}
		if ($('#qty'+lineno).val()=='') {
			$('#qty'+lineno).val('0');
		}
		$('#qty'+lineno).select();
		if ($('#due'+lineno).val()=='') {
			$('#due'+lineno).val($('#date_due').val());
		}
		$('#material'+lineno).val($('#master_material').val());
		$('#materialnew'+lineno).val($('#master_material').val());
		mtl=$('#master_material').val();
		if (vals[3]) {
			var cm = $('#material'+lineno).val();
			if (cm) {
				if (cm != vals[3]) {
					console.log("setting material to "+vals[3]+ " for line " + lineno);
					try {
						document.getElementById("material"+lineno).value=vals[3];
					} catch (e) {
						document.getElementById("materialnew"+lineno).value=vals[3];
					}
				}
			} else {
				console.log("cm is undefined");
				console.log("setting material to "+vals[3]+ " for line " + lineno);
				try {
					document.getElementById("material"+lineno).value=vals[3];
				} catch (e) {
					document.getElementById("materialnew"+lineno).value=vals[3];
				}
			}
			mtl=vals[3];
		}
		if(vals[4]) {
			// this is now the color
			setColor(vals[4],vals[5]);
		}
		if (vals[6])  {
			setOperationsOn(vals[6],lineno);
		}
		url='updateOrderLineFull.php?id='+$('#id').val()+'&ol='+currentOLID+'&rowid='+currentLine+'&desc='+$('#desc'+currentLine).val()+'&price='+$('#price'+currentLine).val()+'&material='+mtl+'&due='+$('#due'+currentLine).val()+'&rev='+vals[2]+'&ops='+vals[6]+'&c1='+vals[4]+'&c2='+vals[5];
		console.log(url);
		$.ajax({url: url, success: function(data) {
						$('#message'+currentLine).html("<img src='images/checkmark.png'>");
				}});
	}
	currentOp=0;
	currentQuestionType='op';
}

function setOperationsOn(oplist,lineno) {
	// force all to unchecked and then check only the ones that you want
	var sel = '[id^="opnew' + lineno + '-"]';
	$(sel).each(function() {
			if (this.checked) {
				this.checked=false;
			}
			co=this.id;
			var btn = 'btn'+co;
			btnobj=document.getElementById(btn);
			$(btnobj).attr('class','btn btn-danger');
		});
	setOperations(oplist,lineno);
}

function setOperations(oplist,lineno) {
	ops=oplist.split(',');
	for (i=0; i<ops.length; i++) {
		lk='opnew'+lineno+'-'+ops[i];
		try {
			document.getElementById(lk).checked=true;
		}
		catch (err) {
			lk='op'+lineno+'-'+ops[i];
			try {
				document.getElementById(lk).checked=true;
			}
			catch (err) {

			}
		}
		btn = 'btn'+lk;
		updateOp(lineno,ops[i],document.getElementById(btn));
	}
}

var currentOp=0;
var currentQuestionType='op';
function askQuestion() {
	// disabling
}

function saveFloorNotes() {
	floornotes=$('#newfloornotes').val();
	if (floornotes=='undefined') {
		floornotes='';
	}
	if ($('#notes_to_self').val() != '') {
		$('#notes_to_self').val($('#notes_to_self').val() + ' ' + floornotes);
	}  else {
		$('#notes_to_self').val(floornotes);
	}
	$('#newfloornotes').val('');
	$('#floorNotesDialog').dialog('close');
}
function checkOption(op,yesno,seq) {
	if (yesno == 'yes') {
		document.getElementById('opnew'+currentLine+'-'+op).checked = true;
	} else {
		document.getElementById('opnew'+currentLine+'-'+op).checked = false;
	}
	currentOp=seq;
	//askQuestions();
}

var stepsDone = 0;

function updateOtherRows(cline,rowid) {
	currentLine=cline;
	currentOLID=rowid;
	if (! $('#message'+cline).html().toLowerCase().includes('checkmark')) {
		stepsDone++;
		if (stepsDone < 100) {
			setTimeout(updateOtherRows(cline,rowid),500);
		} else {
			$stepsDone = 0;
		}
	} else {
		url='updateOrderLine.php?id='+$('#id').val()+'&ol='+rowid+'&field=allothers&desc='+$('#desc'+cline).val()+'&rand='+Math.random()+'&opcount=0&rowid='+cline+'&price='+$('#price'+cline).val()+'&rev='+$('#rev'+cline).val()+'&due='+$('#due'+cline).val()+'&material='+$('#material'+cline).val();
		if ($('#id').val()==112360) {
			alert(url);
		}
		$.ajax({url: url, success:
		function(data) {
			$('#message'+currentLine).html("<img src='images/checkmark.png'>");
			lookupItemInfo($('#item'+cline).val());
		 }});
	}
}


function calculateExt(lineno) {
	if ($('#qty'+lineno).val()!='') {
		if ($('#price'+lineno).val()!='') {
			$('#ext'+lineno).val((Math.round($('#qty'+lineno).val()*$('#price'+lineno).val()*100)/100).toFixed(2));
		}
	}
	tot=0;
	for (i=0; i < linecounter; i++) {
		if ($('#qty'+i)) {
			if ($('#qty'+i).val()!='') {
				if ($('#price'+i).val()!='') {
					tot=tot+(Math.round($('#qty'+i).val()*$('#price'+i).val()*100)/100);
				}
			}
		}
	}
	$('#otot').val(tot.toFixed(2));
}
function removeSpaces(obj)
{
	while (obj.value.indexOf(" ")!=-1)
{
		obj.value=obj.value.replace(" ","-");
	}
	while (obj.value.indexOf(",")!=-1)
	{
		obj.value=obj.value.replace(",","-");
	}
	while (obj.value.indexOf(".")!=-1)
	{
		obj.value=obj.value.replace(".","");
	}
	while (obj.value.indexOf("--")!=-1)
	{
		obj.value=obj.value.replace("--","-");
	}
}

function showReturnValue(responseText)
{
	var d = new Date();
	var datestring = (d.getMonth()+1)  + "/" + d.getDate() + "/" + d.getFullYear() + " " + d.getHours() + ":" + d.getMinutes();
	$('#start_date').val(datestring);
	if (responseText.substring(0,1)!='<') {
		document.location.href='editOrders.php?id='+responseText;
	} else {
		$('#btnSave').show();
		$.gritter.add(responseText);
		// $('#responser').html(responseText);
		if (scheduleSet == '1') {
//			document.location.reload();
		}
		if (scheduleSet == '3') {
			document.location.href='index.php';
		}
	}
}
function reloadPage() {
	scheduleSet='0';
	document.location.href=document.location.href;
}

</script>
<?php
## security check to make sure they can edit this
$sql="select * from admin_access where user_id=$userID and table_name='orders' and allow_edit=1 or allow_view=1";
$rs=mysqli_query($db,$sql);
if (! mysqli_num_rows($rs))
{
#	exit;
}
$data=mysqli_fetch_array($rs);
$allow_edit=$data['allow_edit'];
?>
<div class="row">
<div class="col-md-12">
<div class="panel panel-primary">
            <div class="panel-heading">
              <div class="panel-btns">
                <a href="" class="minimize">&minus;</a>
              </div><!-- panel-btns -->
              <h3 class="panel-title" id="order_title">
<?php
$dlabel="Done";
$function="saveTheForm('3',<?=$conversation?>)";
	if ($id) {
		print "Order " . $id;
	} else {
		print "NEW Order";
		$dlabel="Cancel";
		$function="document.location.href='index.php';";
	}
?>
</h3>
<div id='responser'></div>
			<div style='display: none; float: right;' id='working'>&nbsp;&nbsp;&nbsp;<img src='img/loading.gif'></div>
				<button type='button' class='btn btn-success' id='btnSave' onclick="saveTheForm('0',<?=$conversation?>);" style='margin: 5px;'><i class='icon-ok'></i> Save</button><button type='button' class='btn btn-danger' onclick="<?=$function?>" style='margin: 5px;' id='btnDone'><?=$dlabel?></button>
<?php if ($id) { ?>
<button type='button' class='btn btn-warning' id='btnDem' onclick='dematicLabel();' style='margin: 5px;'>Dematic Label</button>
<button type='button' class='btn btn-danger' onclick='cancelOrder();' style='margin: 5px;'>Cancel Order</button>
<?php } ?>
				<button type='button' class='btn btn-warning' id='btnLabels' onclick='printLabels();' style='margin: 5px;'>Labels</button>
</div>
<!-- ### WST row for these buttons to align them with tables (padding-left:20px;) and organize columns --> 
<div class='row' style='padding-left:22px;'>
				<button type='button' class='btn btn-warning' id='btnPrint' onclick='printOrder();' style='margin: 5px;'>Print Shop Floor</button>
<?php if ($canChangeDate) { ?>
								<button type='button' class='btn btn-primary' onclick='printInvoice();' style='margin: 5px;'>Print Invoice</button>
								Paint Individual: <input type='checkbox' id='individual' name='individual' value='1'>
								<button type='button' class='btn btn-warning' onclick='paintInvoice();' style='margin: 5px;'>PAINT Invoice</button>
<?php
$sql="select po_id from purchase_orders, vendors  where purchase_orders.vendor_id=vendors.vendor_id and sales_order=? and purchase_orders.status <> 2 and coalesce(op_vendor,0)=1 ";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$powderPOStop=false;
if (count($rs)>0) {
	$powderPO=$rs[0][0];
	print "Outsource PO <a href='editPO.php?id=$powderPO' target='_blank' rel='opener'>$powderPO</a>";
} else {
	print renderButton("Outsource PO","primary","powderPO()");
	$sql = "select coalesce(olc.olc_id,0) as olc_id from orders o, vendors v, order_line_operations olo, order_lines ol left outer join order_line_color olc on ol.line_id=olc.order_line where ol.order_id=o.order_id and o.order_vendor=v.vendor_id and v.op_vendor=1 and v.finish_vendor=1 and ol.line_id=olo.line_id and olo.operation_id=59 and o.order_id=?";
	list($rs,$err)=runIQuery($db,$sql,["i",$id]);
	foreach ($rs as $data) {
		if ($data["olc_id"] == 0) {
			$powderPOStop = true;
			break;
		}
	}
}
$sql="select po_id from purchase_orders, vendors  where purchase_orders.vendor_id=vendors.vendor_id and sales_order=? and purchase_orders.status <> 2 and coalesce(op_vendor,0)=0 ";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
if (count($rs)>0) {
	$powderPO=$rs[0][0];
	print "Purchase PO <a href='editPO.php?id=$powderPO' target='_blank' rel='opener'>$powderPO</a>";
}
?>
<?php } ?>
</div>
<div class='row' style="padding-left:20px;">
<?php if ($id) { ?>
<div class='col-md-4'>
<form action='uploadDocument.php' method='POST'  enctype="multipart/form-data" target='_blank' rel='opener' class='form-control'>
	<input type='hidden' name='order' value='<?=$id?>'>
    <div class="form-group">
	    <input type='file' name='doc' class='form-control'>
    </div>
    <div class="form-group">
        <button type='submit' class='btn btn-primary' >Upload Document</button>
    </div>
</form>
</div>
<?php if ($canChangeDate) { ?>
<div class='col-md-4'>
	<?php if ($id == 128539 or $id == 134310) { ?>
		<form action='uploadQuoteTest.php' name='uploadform' method='POST'  enctype="multipart/form-data" target='_blank' rel='opener' class='form-control'>
	<?php } else { ?>
		<form action='uploadQuote.php' name='uploadform' method='POST'  enctype="multipart/form-data" target='_blank' rel='opener' class='form-control'>
	<?php } ?>
	<input type='hidden' name='id' value='<?=$id?>'>
    <div class="form-group">
	    <input type='file' name='quoteinfo' class='form-control'>
    </div>
    <div class="form-group">
        <button type='button' class='btn btn-primary' onclick='uploadquote()'>Upload Consuela File</button>
    </div>
</form>
</div>
<?php } ?>
<!-- ### WST adding tagged conversations --> 		
<div class='col-md-4'>

<?php if($taggedConversations){
    // var_dump($taggedConversations);
		echo "<h4>Linked Quote Requests</h4>";
	foreach ($taggedConversations  as $convoKey => $convoItem){
		
		echo "<li><a style='color:blue'; href='/getQuoteDetails.php?convo=".$convoItem[2]."'>".$convoItem[2]."</a></li>";

	}
}
// ## end WST
?> 
</div>
<!-- ### WST adjusted column with and text size for so file link -->
<div class="col-md-4">
<?php
$sql="select * from documents where order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
foreach ($rs as $data) {
	$fname=$data['file_name'];
	$docid=$data['document_id'];
	print "<a href='showDocument.php?id=$docid' target='_blank' rel='opener' style='font-size: 24px;'>View $fname</a><br>";
	if ($isAdmin or $orderAdmin or $canDeleteAttachments) {
		print "<a href=\"javascript:deleteDocument('$docid');\" style='color: red;' rel='opener'>DELETE $fname</a><br>";
	}
}
logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - after documents",$userID);
?>
</div>
</div>
<!-- ### WST adjusted column width and parent row padding for viewed and activity so they are side by side rather than on top of each other for easier viewing / ux experience -->
<div class='row' style="padding-left:20px;">
<div class='col-md-6'>
<?php
print renderButton("Activity","primary","getActivity('noview')");
?>
<div id='activity'>
</div>
</div>
<div class='col-md-6'>
<?php
print renderButton("Viewed","primary","getActivity('viewed')");
?>
<div id='viewed_activity'>
</div>
</div>
</div>
<?php } ?>
<!-- </div></div>				 -->
	<div class='panel-body' sytle="background-color:white; padding-bottom:55px;">
<form name='editForm' id='editForm' class="form-control"><input type='hidden' name='table' id='table' value='<?=$table?>'><div style='display: none;'><input type='hidden=' name='key' id='key' value='<?=$key?>'><input type=hidden name='id' value='<?=$id?>' id='id'><input type='hidden' name='start_date' value='<?=$startDate?>' id='start_date'></div>
   <!-- ### WST hidden field for ticketing user for associating quote requests -->
   <input type='hidden' name='ticketingUser' id='ticketUser' value='<?=$tuser?>'>
	<?php
	$isOutsource=0;
	$vendorConfirmed=0;
	if ($id > 0) {
		$sql="select  price_per_square_inch from order_lines l inner join  materials m on l.material=m.material_id where order_id=? and m.material_id not in (119 , 141) and price_per_square_inch=0 ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		if (count($rs)> 0) {
			print "\n<script>alert('One or more materials do not have a price');</script>\n";
		}
		logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - before orders",$userID);
		$sql="select * from orders where order_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$data=$rs[0];
		$customer_id=$data['customer_id'];
		$sql="select * from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
		$cdata=$rs[0];
		$customer_name=$cdata['name'];
		$customer_address=$cdata['address'];
		$customer_city=$cdata['city'];
		$customer_state=$cdata['state'];
		$customer_zip=$cdata['zip'];
		$customer_phone=$cdata['phone'];
		$vendorConfirmed=$data['vendor_confirmed'];
		$customer_email=$cdata['email'];
		if ($id) {
			$ship_name=$data['ship_name'];
			$ship_address=$data['ship_address'];
			$ship_city=$data['ship_city'];
			$ship_state=$data['ship_state'];
			$ship_zip=$data['ship_zip'];
			$ship_phone=$data['phone'];
			$ship_email=$data['email'];
		} else {
			$ship_name=$customer_name;
			$ship_address=$customer_address;
			$ship_city=$customer_city;
			$ship_state=$customer_state;
			$ship_zip=$customer_zip;
			$ship_phone=$customer_phone;
			$ship_email=$customer_email;
		}
		$orderType=$data['order_type'];
		if (! $orderType) {
			$orderType=1;
		}
		$date_order=formatDateDBToWeb($data['date_order']);
		$date_due=$data['date_due'];
		if (! $date_due) {
			$date_due=Date("Y-m-d");
		}
		$due_customer=$data['due_customer'];
		if (! $due_customer) {
			$due_customer=$date_due;
		}
		$vendor=$data['order_vendor'];
		$status=$data['status'];

		logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - before olo",$userID);
		$sql="select olo.operation_id from order_lines l, order_line_operations olo where order_id=? and l.line_id=olo.line_id and operation_id=59 LIMIT 1";
		list($ors,$err)=runIQuery($db,$sql,array("i",$id));
		$isOutsource=count($ors);
		logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - after olo",$userID);
		if ($isOutsource and ! $vendor) {
			print "<script>alert('Outsource Selected, Vendor Not');</script>";
		} else {
			if (! $vendor and ($status==1 or $status == 13)) {
				$leadTime=getCustomerLeadTime($db,$id);
				$backDate=SubtractBusinessDays($due_customer,$leadTime,$db);
				if ($backDate < Date("Y-m-d")) {
					print "<script>alert('Standard Customer Lead Time goes into the past. Please confirm that the due customer date can be achieved.  This includes any shipping lead time');</script>";
				}
			}
			if (! $vendorConfirmed and $vendor and ($status == 1 or $status == 13) ) {
				$sql="select lead_time from vendors where vendor_id=?";
				list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
				$leadTime=$vrs[0][0];
				$lead=getCustomerLeadTime($db,$id);
				$leadTime+=$lead;
				$backDate=SubtractBusinessDays($due_customer,$leadTime,$db);
				if ($backDate < Date("Y-m-d")) {
					print "<script>alert('Standard lead time goes into the past. Please confirm with the vendor that the due customer date can be achieved.  This includes any shipping lead time');</script>";
				}
			}
			if (! $vendorConfirmed and $vendor == 36) {
				##  check if any colors used  are not stocked
				$sql="select distinct c.color_id, stocked from order_lines l, order_line_color c, vendor_colors vc where order_id=? and l.line_id=c.order_line and c.color_id=vc.vc_id ";
				list($vrs,$err)=runIQuery($db,$sql,array("i",$id));
				$unstocked=0;
				foreach ($vrs as $vdata) {
					if ($vdata['stocked']==0) {
						$unstocked++;
					}
				}
				## check for primer
				$sql="select distinct c.color_id, stocked from order_lines l, order_line_color c, vendor_colors vc where order_id=? and l.line_id=c.order_line 
				and c.primer_id=vc.vc_id ";
				list($vrs,$err)=runIQuery($db,$sql,array("i",$id));
				foreach ($vrs as $vdata) {
					if ($vdata['stocked']==0) {
						$unstocked++;
					}
				}
				if ($unstocked > 0) {
					print "<script>alert('Order uses unstocked powdercoat or primer. Please confirm with the vendor that this can be achieved.');</script>";
				}
				if (count($vrs)>1) {
					print "<script>alert('Order uses MULTIPLE powdercoat. Please confirm with the vendor that this can be achieved.');</script>";
				}
			}
		}
		logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - after lead time checks",$userID);
		$master_material=$data['master_material'];
		$po_number=$data['po_number'];
		$folder_number=$data['folder_number'];
		$salesperson_id=$data['salesperson_id'];
		$notes_to_customer=$data['notes_to_customer'];
		$shipping_notes=$data['shipping_notes'];
		$notes_to_self=$data['notes_to_self'];
		$floor_notes=$data['floor_notes'];
		$email=$data['email'];
		$phone=$data['phone'];
		$reason_id=$data['rma_reason'];
	} else {
		$date_order=Date('Y-m-d');
		$date_due=$date_order;
		$due_customer=$date_order;
		$status=13;
		$master_material=0;
		$po_number="";
		$salesperson_id=0;
		$notes_to_customer="";
		$notes_to_self="";
		$floor_notes="";
		$email="";
		$phone="";
		$reason_id=0;
		$customer_id=0;
		$customer_name="";
		$customer_address="";
		$customer_city="";
		$customer_state="";
		$customer_zip="";
		$customer_phone="";
		$customer_email="";
		$orderType=1;
		$ship_name=$customer_name;
		$ship_address=$customer_address;
		$ship_city=$customer_city;
		$ship_state=$customer_state;
		$ship_zip=$customer_zip;
		$ship_phone=$customer_phone;
		$ship_email=$customer_email;
		$shipping_notes="";
		$vendor=0;
	}
	$sql="select customer_id, name from customers order by name";
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"customer_id",$customer_id,"Customer","N",$rs,1, "", 'checkCreditHold(this.value)'); // Brittany 6/22 preventing creation of header if customer on credit hold
	print renderStartItem(FALSE,"","");
	print "<div id='customer_info' style='width: 150px; background-color: white;'>";
	$creditHold=0;
	if ($customer_id) {
		print $customer_address;
		print "<BR>";
		print "$customer_city, $customer_state $customer_zip";
		print "<BR>";
		print $customer_phone;
		foreach (explode(",",$customer_email) as $em) {
			print "<BR>";
			print "<a href='mailto:$em'>$em</a>";
		}
		$sql="select credit_hold from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
		$creditHold=$rs[0][0];
		if (! $creditHold) {
			$creditHold=0;
		}
	}
	print "</div>";
	print renderEndItem();
	print renderDateBox(TRUE,"date_due",$date_due,"Date Due");
	print renderDateBox(TRUE,"due_customer",$due_customer,"Due Customer");
	print renderTextBox(TRUE,"po_number",$po_number,"PO #","left","checkPO();");
	//adding dialog warning for duplicate po bdoss 7/29/22
	print "<div id='duplicatePODialog' style='display: none; border: 1px solid black; color: red; font-size: 25px; background-color: black; padding: 20px; min-height: 500px;'><p>This PO number already exists on another order.</p></div>";

	if (! isset($folder_number)) {
		$folder_number="";
	}
	print renderTextBox(TRUE,"folder_number",$folder_number,"Folder #");
	if (! $id) {
		if ($salesperson_id==0) {
			if ($userEmail) {
				$sql="select salesperson_id from salespeople where email=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));
				if (count($rs) > 0) {
					$data=$rs[0];
					$salesperson_id=$data[0];
				}
			}
		}
	}
	$sql="select salesperson_id, full_name from salespeople where (coalesce(obsolete,0) = 0 or salesperson_id=$salesperson_id) order by last_name, first_name";
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"salesperson_id",$salesperson_id,"Salesperson","N",$rs,1);
	## bdoss 9/14/22 specified that rma reasons shown must be included in the rma category, filtering out irma reasons to decrease clutter
	$sql="select reason_id, reason_description from rma_reasons where reason_description <> 'See Internal Notes' and category_rma = 1 order by reason_description";
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"rma_reason",$reason_id,"RMA Reason","N",$rs,1);
	if ($reason_id == 6) {
		print "PICK NEW REASON";
	}
	$sql="select type_id, type_name from order_types where type_id <> 7 order by type_name ";
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"order_type",$orderType,"Order Type","N",$rs,0); // bdoss 10/5/22 this will be hidden by jquery (see script) if customer is not allowed to have order types other than standard (applies to preferred companies and Nate Jobs)
	$sql="select count(*) from order_reviews where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$reviews=$rs[0][0];
	$sql="select status_id, status_name from order_status where status_id in (1,5,10,13,$status) order by status_name='Pending Review' Desc, status_name";
	if ($isOutsource and ! $vendor) {
		$sql="select status_id, status_name from order_status where status_id in (5,10,13,$status) order by status_name='Pending Review' Desc, status_name";
	}
	if ($status == 10 or $status==13) {
		## open, quote and pending review can only cancel, quote, or pending review
		$sql="select status_id, status_name from order_status where status_id in (5,10,13) order by status_name='Pending Review' Desc, status_name";
		if ($reviews) {
			## if reviewed they can also open it
			$sql="select status_id, status_name from order_status where status_id in (1,5,10,13) order by status_name='Pending Review' Desc, status_name";
			if ($isOutsource and ! $vendor) {
				$sql="select status_id, status_name from order_status where status_id in (5,10,13) order by status_name='Pending Review' Desc, status_name";
			}
		}
	}
	if (strtolower($userEmail) == "shipping@preferredmachinellc.com") {
		$sql="select status_id, status_name from order_status where status_id not in (5, 10) order by status_name='Pending Review' Desc, status_name";
	}
	if (strtolower($userEmail) == "jsmith@preferredmachinellc.com") {
		$sql="select status_id, status_name from order_status where status_id not in (5, 10) order by status_name='Pending Review' Desc, status_name";
	}
	if (strtolower($userEmail) == "cmueller@preferredmachinellc.com") {
		$sql="select status_id, status_name from order_status where status_id not in (5, 10) order by status_name='Pending Review' Desc, status_name";
	}
	if (strtolower($userEmail) == "jmcdaniel@preferredmachinellc.com") {
		$sql="select status_id, status_name from order_status where status_id not in (5, 10) order by status_name='Pending Review' Desc, status_name";
	}
	if ($status == 5) {
		$sql="select status_id, status_name from order_status where status_id = 5 ";
	}
	if ($status == 15) {
		$sql="select status_id, status_name from order_status where status_id = 15 ";
	}
	if ($isAdmin or $orderAdmin) {
		$sql="select status_id, status_name from order_status order by status_name";
		if ($isOutsource and ! $vendor) {
			$sql="select status_id, status_name from order_status where status_id != 1 order by status_name";
		}
	}
	if ($orderType==7) {
		$sql="select status_id, status_name from order_status where status_id=10 ";
	}
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"order_status",$status,"Status","N",$rs,0,"","checkStatusChanged(this.value);");
	if ($status == 15) {
		print "<p>Preliminary Quote can only be changed by re-uploading quote inside 30 days.</p>";
	}
	print "<div style='clear: both;'></div>\n";
	$sql="select vendor_id, vendor_name from vendors order by vendor_name";
	list($rs,$err)=runIQuery($db,$sql);
	print renderSelect(TRUE,"order_vendor",$vendor,"Outsource Vendor","N",$rs,1);
	print renderCheckBox(TRUE,"vendor_confirmed",$vendorConfirmed,"Date Confirmed with Vendor");
	# adding checkbox for order hold Brittany 7/15/22
	print "<div style='display: flex; flex-direction:column; width:fit-content'>";
	print "<label for='order_hold'>Order on Hold</label>";
	print "<input name='order_hold' id='order_hold' type='checkbox' value=$id onChange=\"updateOrderHold(this.value);\">";
	print "</div>";
	#End Brittany additions
	print "<div style='clear: both;'></div>\n";
	if (! isset($attention)) {
		$attention="";
	}
	print renderTextBox(TRUE,"attention",$attention,"Attention");
	print "<div class='span3' id='selectShipping'></div>";
	print "<div class='span3' id='selectContact'></div>";
	print "<div style='clear: both;'></div>\n";
	print renderTextBox(TRUE,"ship_name",$ship_name,"Name");
	print renderTextBox(TRUE,"ship_address",$ship_address,"Address");
	print "<div style='clear: both;'></div>";
	print renderTextBox(TRUE,"ship_city",$ship_city,"City");
	print renderTextBox(TRUE,"ship_state",$ship_state,"State");
	print renderTextBox(TRUE,"ship_zip",$ship_zip,"Zip");
	print "<div style='clear: both;'></div>";

	print renderTextBox(TRUE,"ship_phone",$ship_phone,"Phone");
	print renderTextBox(TRUE,"ship_email",$ship_email,"Email");
	print "<button onclick='processSShip();' class='btn btn-warning pull-right' style='margin-top:10px;'>Save New Address</button>";
	print "<div style='display: none;'>";
	print renderStartItem(TRUE,"opslist","Operations");
	print "<BR>";
	logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - before operations",$userID);
	$sql="select * from operations where customer_sequence > 0 order  by customer_sequence ";
	list($ors,$err)=runIQuery($db,$sql);
	$opcount=0;
	print "\n<script>var opCount=0; var opArray=Array();</script>\n";
	$opscript="";
	foreach ($ors as $odata) {
		$opid=$odata['operation_id'];
		$oname=$odata['operation_name'];
		print "<input type='checkbox' id='master-$opid' name='master-$opid' value='$opid' onclick='setMasterOperations(this); '";
		if ($id) {
			$sql="select * from order_operations where order_id=? and operation_id=?";
			list($oprs,$err)=runIQuery($db,$sql,array("ii",$id,$opid));
			if (count($oprs) > 0 ) {
				print " checked ";
			}
		}
		## this is laser always check it.
		if (! $id) {
			if ($opid==35) {
				print " checked ";
			}
		}
		if (in_array($customer_id,array("319","425","704","708","713","726","729","765","766"))) {
			if (! $id) {
				## peel plastic is checked for these guys
				if ($opid == 86) {
					print " checked ";
				}
			}
		}
		print "> $oname<BR>";
		$opscript .= "opArray[$opcount]=$opid;\n";
		$opcount++;
	}

	print renderEndItem();
	print "</div>";
	print "\n<script>\nopCount=$opcount;\n";
	print $opscript;
	print "</script>\n";
    print "<div style='clear: both'></div>\n";
    print "<div class='row'>";
	print "<div style='display: none;'>";
		print "<select name='master_material' id='master_material' onBlur='setMasterMaterial(this);'><option value='0'>Please Select</option>\n";
		foreach ($mrs as $oldata) {
			print "<option value='" . $oldata['material_id'] . "' ";
			if ($oldata['material_id']==$master_material) {
				print " selected ";
			}
			print ">" . $oldata['material_name'] . "</option>\n";
		}
	print "</select>";
	print "</div>";
    print "</form>\n";
	print renderClosePanel();
    print "<div style='clear: both;'></div>\n";

	print renderPanel("Notes","Notes","success","col-md-12","notesPanel");
	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_customer'>Notes To Customer</label>\n";
    print "<div class='controls'>\n";
	print "<textarea rows=4   id='notes_to_customer' name='notes_to_customer' onchange=\"updateOrderNotes('customer',this.value);\" class='form-control' style=' background-color: white; width: 80%'>$notes_to_customer</textarea>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_self'>Internal Notes</label>\n";
    print "<div class='controls'>\n";
	print "<textarea  rows=4 style=' background-color: white; width: 80%' class='form-control' onchange=\"updateOrderNotes('internal',this.value);\"  id='notes_to_self' name='notes_to_self'>$notes_to_self</textarea>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";

	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='shipping_notes'>Shipping Notes</label>\n"; //Shipping notes -Josh 04-28-2022
    print "<div class='controls'>\n";
	print "<textarea  rows=4 style=' background-color: white; width: 80%' class='form-control' onchange=\"updateOrderNotes('shipping',this.value);\"  id='shipping_notes' name='shipping_notes'>$shipping_notes</textarea>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";

	print "<div class='span8 '>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='notes_to_self'>Notes to AP</label>\n";
    print "<div class='controls'>\n";
	print "<textarea  rows=4 style=' background-color: white; width: 80%' class='form-control' onchange=\"updateOrderNotes('floor',this.value);\" id='floor_notes' name='floor_notes'>$floor_notes</textarea>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";

	## bdoss adding notes for automated reminders 9/20/22
	## modal dialog for new orders with customers with existing repeating reminders
	$sql="SELECT repeat_reminders.*, order_status.status_name FROM repeat_reminders
    	INNER JOIN order_status ON repeat_reminders.order_status=order_status.status_id
		WHERE customer=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	if ($rs) {
		$repeatTable= "<table><thead><th>Reminder</th><th>Order Status</th><th>Send To</th><th></th></thead><tbody>";
		foreach($rs as $data) {
			$repeatID=$data['repeat_id'];
			$message=$data['reminder_message'];
			$status=$data['status_name'];
			$statusID=$data['order_status'];
			$reminderRecipients="";
			$reminderID=0;
			## taking most recent reminder to see who it was sent to
			$sql="SELECT reminder_id FROM order_reminders WHERE reminder_message=? AND order_status=? AND customer=? ORDER BY reminder_id DESC LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("sii",$message,$statusID,$customer_id));
			if ($rs) {
			$reminderID=$rs[0][0];
			}
			## get email recipients
			$sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
			list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
			foreach($employee_rs as $employee_data) {
				$reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
			}

			$useRepeatReminder=renderButton("Add","primary","copyReminder($id,$customer_id,$statusID,$reminderID,$repeatID);");
			$repeatTable.="<tr><td>$message</td><td>$status</td><td>$reminderRecipients</td><td><div id='hide$repeatID' >$useRepeatReminder</div><div id='show$repeatID' style='display:none; color: blue'>Added</td></td></tr>";
		}
		$repeatTable.="</tbody></table>";

	}
	print "<div id='repeatReminderDialog' style='display: none; border: 1px solid black;'>";
	print "<p>This customer has an existing repeat reminder.  Would you like to add an automated reminder to this order?</p>";
	print $repeatTable;
	print "</div>";
	## bdoss end of repeat additions on creation of order
	$reminderNotes = "";
	$reminderClass = "hideReminder";
	if ($id > 0) {
		$sql="SELECT reminder_id, status_name, repeat_reminder, reminder_message FROM order_reminders INNER JOIN order_status ON order_status.status_id=order_reminders.order_status WHERE order_id=? AND sent_on IS NULL";
		list($reminder_rs,$err)=runIQuery($db,$sql,array("i",$id));
		if ($reminder_rs) {
			$reminderClass = "showReminder";

			$reminderNotes.= "<table><thead><th>Reminder</th><th>Order Status</th><th>Repeat</th><th>Send To</th></thead><th></th><tbody>";
			foreach($reminder_rs as $reminder_data) {
				$reminderID=$reminder_data['reminder_id'];
				$reminderMessage=$reminder_data['reminder_message'];
				$reminder_data['repeat_reminder'] == 1 ? $reminderRepeat = 'Yes' : $reminderRepeat = 'No';
				$reminderStatus=$reminder_data['status_name'];
				$reminderRecipients = "";
				## buttons
				## bdoss this doesn't actually delete the reminder, it sets the sent_on, and reminders with a IS NOT NULL sent_on will not display
				$deleteReminder = renderButton("Delete","danger","deleteReminder($reminderID);");
				$editReminder = "<a class='btn btn-warning' href='updateOrderReminders.php?id=$reminderID&action=edit' target='_blank' rel='opener'>Edit Reminder</a>";

				$sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
				list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
				foreach($employee_rs as $employee_data) {
					$reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
				}
				$reminderNotes.= "<tr id='hideRow$reminderID'><td>$reminderMessage</td><td>$reminderStatus</td><td>$reminderRepeat</td><td>$reminderRecipients</td><td>$deleteReminder $editReminder</td><tr>";
			}
			$reminderNotes.= "</tbody></table>";

		} else {
			$reminderClass = "hideReminder";
		}
	}
	##bdoss the display area for automated reminders  9/27
	print "<div class='span8 $reminderClass'>\n";
	print "<div class='control-group'>\n";
	print "<label class='control-label' for='reminder_notes'>Automated Reminder(s)</label>\n";
    print "<div class='controls'>\n";
	print "<div  rows=4 style=' background-color: white; width: 80%' id='reminder_notes' name='reminder_notes'>$reminderNotes</div>";
	print "</div>\n";
	print "</div>\n";
	print "</div>\n";
	## bdoss end of automated reminder notes
	print "<div class='buttonContainer' style='margin-top: 10px'>";
	print renderButton("Save Notes","warning");
	## bdoss adding button for generating a new reminder/ updating
	print "<a class='btn btn-primary' href='updateOrderReminders.php?order=$id&customer=$customer_id&action=create' target='_blank' rel='opener'>Create New Reminder</a>";
	print "</div>";
	print renderClosePanel("");

	print renderPanel("Line Items","Line Items","green","col-md-12");
	print "<table class='table-bordered table-striped table-condensed flip-content'>\n<thead class='flip-content'>\n";
	print "<tr><th >Part</th><th>Rev</th><th >Description</th><th class='numeric'>Quantity</th><th>Operations</th><th>Material</th><th class='numeric'>Price</th><th>Due Date</th><th>Color</th></tr></thead><tbody id='orderLineList'>\n";
	$i=0;
	$toggle=1;
	$sql="select line_id from order_lines where order_id=? and item_id='DELETE'";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $ldata) {
		$line=$ldata['line_id'];
		$sql="delete from order_line_operations where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$line));
		$sql="delete from order_lines where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$line));
	}
	$sql="select * from order_lines where order_id=$id order by line_id ";
	$pitext="";
	$rs=mysqli_query($db,$sql);
	$currentLines=0;
	while ($ldata=mysqli_fetch_array($rs)) {
		$currentLines++;
		print "<tr id='tr$i' >";
		$line_id=$ldata['line_id'];
		logTime($db,$startLoadDate,$startLoadTime,$_POST,$_GET,"$scriptid - processing line $line_id",$userID);
		$pol=$ldata['po_line'];
		$item=$ldata['item_id'];
		$desc=$ldata['item_description'];
		$qty=$ldata['quantity'];
		$price=$ldata['price'];
		$rev=$ldata['revision'];
		$material=$ldata['material'];
		$sql="select price_valid_until_date from items where item_name='$item' ";
		list($vrs,$err)=runIQuery($db,$sql);
		if (count($vrs)) {
			$vdata=$vrs[0];
			$valid=$vdata['price_valid_until_date'];
			if ($valid) {
				if ($valid < Date("Y-m-d") and ($status == 1 or $status == 13 or $status == 10)) {
					print "<script>alert('$item price is obsolete');</script>\n";
				}
			}
		}
		$due=formatDateDBToWeb($ldata['due_date']);
		$ext=number_format($qty*$price,2);
		$nextline=$i+1;
		## bdoss adding autocomplete for item names 9/6/22
		print "<td valign='top'><input type='hidden' name='ol$i' id='ol$i' value='$line_id'><input type='text'  style='width: 250px;' id='item$i' name='item$i' value='$item' onfocus=\"currentLine='$i';\" onChange=\"updateRow('$i','item_id',this.value);\">";
		print "<div id='message$i'><img src=\"images/checkmark.png\"></div>";
		print "</td>";
		print "<td valign='top'><input type='text' id='rev$i' onfocus=\"currentLine='$i';\"  name='rev$i' value='$rev' style='width: 240px;  resize: both; background-color: white;'  onChange=\"updateRow('$i','revision',this.value);\" >";
		print "<form action='uploadDocument.php' method='POST'  enctype='multipart/form-data' target='_blank' rel='opener' class='form-control'>";
		print "<input type='hidden' name='order' value='$id'>";
    	print "<div class='form-group'>";
	    print "<input type='file' name='doc' class='form-control'>";
        print "<button type='submit' id='btnUpload' class='btn btn-primary' >Upload Document</button>";
		print "</form>";
		print "</td>";
		print "<td valign='top'><input type='text' id='desc$i' name='desc$i'  value='$desc' onfocus=\"currentLine='$i';\" style=' background-color: white;'  onChange=\"updateRow('$i','item_description',this.value);\"></td>";
		print "<td class='numeric' valign='top'><input type='text' id='qty$i' name='qty$i' onfocus=\"currentLine='$i';\" style='width: 40px; text-align: right;background-color: white;'  value='$qty' onChange=\"calculateExt('$i');updateRow('$i','quantity',this.value);\"></td>";
		print "<td valign='top'>";
		$sql="select * from operations where customer_sequence > 0 order  by customer_sequence ";
		list($ors,$err)=runIQuery($db,$sql);
		$stack=0;
		foreach ($ors as $odata) {
			$opid=$odata['operation_id'];
			$oname=$odata['operation_name'];
			$sql="select * from order_line_operations use index(line_operation) where operation_id=? and line_id=?";
			list($olrs,$err)=runIQuery($db,$sql,array("ii",$opid,$line_id));
			print "<input type='checkbox' style='display: none;' name='opnew$i-$opid' id='opnew$i-$opid' value='$opid' ";
			if (count($olrs) > 0) {
				print " checked ";
			}
			print " >";
			print "<div id='btnopnew$i-$opid' ";
			if ($oname=='Outsource') {
				print "  onclick=\"currentLine='$i';describeOperation(this);updateOp('$i','$opid',this);\" ";
			} else {
				if ($oname == "Class A Finish") {
					print "  onclick=\"alert('You must change this in Consuela');\" ";
				} else {
					print "  onclick=\"currentLine='$i';updateOp('$i','$opid',this);\" ";
				}
			}
			if (count($olrs)>0) {
				print " class='btn btn-success'  style='width: 100px;'";
			} else {
				print " class='btn btn-danger' style='width: 100px;'";
			}
			print "> $oname</div>";
			$stack++;
			if ($stack == 3) {
				$stack=0;
				print "<br><br>";
			} else {
				print "&nbsp;";
			}
		}
		print "</td>";
		print "<td valign='top'>";
		print "<select name='material$i' id='material$i'   onBlur=\"console.log('blur');currentLine='$i';updateRow('$i','material',this.value);\">\n";
		print "<option value='0'>Please Select</option>";
		foreach ($mrs as $oldata) {
			print "<option value='" . $oldata['material_id'] . "' ";
			if ($oldata['material_id']==$material) {
				print " selected ";
			}
			print ">" . $oldata['material_name'] . "</option>\n";
		}
		print "</select>\n";
		print "</td>";
		print "<td class='numeric' valign='top'><input type='text' id='price$i' name='price$i' style='width: 60px; text-align: right; background-color: white;' value='$price' onfocus=\"currentLine='$i';\"  onChange=\"currentLine='$i';updateRow('$i','price',this.value);calculateExt('$i');\"></td>";
		print "<input type=hidden id='pol$i' name='pol$i' value='$pol' >";
		print "<td valign='top'><input type=text class='datepicker' id='due$i' name='due$i' style='width: 80px; background-color: white;' value='$due' onfocus=\"currentLine='$i';\"  onChange=\"currentLine='$i';updateRow('$i','due_date',this.value);\"></td>";
		print "<input type='hidden' id='ext$i' readonly name='ext$i' style='border: 0px; width: 60px; text-align: right; background-color: white;' value='$ext' >";
		$sql="select vendor_name, color_code from order_line_color l, vendor_colors c, vendors v where order_line=? and l.color_id=vc_id and c.vendor_id=v.vendor_id";
		list($crs,$err)=runIQuery($db,$sql,array("i",$line_id));
		$color="";
		if (count($crs) > 0) {
			$cdata=$crs[0];
			$color=$cdata['vendor_name'] . " " . $cdata['color_code'];
		}
		print "<td valign='top'><span id='color$i'>$color</span></td>";
		$sql="select vendor_name, color_code from order_line_color l, vendor_colors c, vendors v where order_line=? and l.primer_id=vc_id and c.vendor_id=v.vendor_id";
		list($crs,$err)=runIQuery($db,$sql,array("i",$line_id));
		$primer="";
		if (count($crs) > 0) {
			$cdata=$crs[0];
			$primer=$cdata['vendor_name'] . " " . $cdata['color_code'];
		}
		print "<td valign='top'><span id='primer$i'>$primer</span></td>";
		print "</tr>\n";
		$i++;
	}
	$current=$i;
	if (! $id) {
		print "<center>Please Save the Header before entering lines.</center>";
	} else {
		$itemplate="<td valign='top'><input type='hidden' name='olINDEX' id='olINDEX' value='0'><input style='width: 250px;' type='text' id='itemINDEX' name='itemINDEX' onfocus=\"currentLine='INDEX';showRow('INDEX');\"  onChange=\"updateRow('INDEX','item_id',this.value);\">";
		$itemplate.="<div id='messageINDEX'></div>";
		$itemplate.= "</td>";
		$itemplate.= "<td valign='top'><input type='text' id='revINDEX' name='revINDEX' value='' style='width: 240px;  resize: both; background-color: white;' onfocus=\"currentLine='INDEX';\" onChange=\"updateRow('INDEX','revision',this.value);\">";
		$itemplate.= "<form action='uploadDocument.php' method='POST'  enctype='multipart/form-data' target='_blank' rel='opener' class='form-control'>";
		$itemplate.= "<input type='hidden' name='order' value='$id'>";
    	$itemplate.= "<div class='form-group'>";
	    $itemplate.= "<input type='file' name='doc' class='form-control'>";
        $itemplate.= "<button type='submit' class='btn btn-primary' >Upload Document</button>";
		$itemplate.= "</form>";
		$itemplate.="</td>";
		$itemplate.= "<td valign='top'><input type='text' id='descINDEX' name='descINDEX'  value='' style=' background-color: white;' onfocus=\"currentLine='INDEX';\" onChange=\"updateRow('INDEX','item_description',this.value);\"></td>";
		$itemplate.= "<td align='right' valign='top'><input type='text' id='qtyINDEX' name='qtyINDEX' style='width: 40px; text-align: right; background-color: white;' value='0' ";
		$itemplate.= " onfocus=\"currentLine='INDEX';\"  onChange=\"updateRow('INDEX','quantity',this.value);calculateExt('INDEX');\"></td>";
		$itemplate.= "<td valign='top'>";
		$sql="select * from operations where customer_sequence > 0 order  by customer_sequence ";
		list($ors,$err)=runIQuery($db,$sql);
		$stack=0;
		foreach ($ors as $odata) {
			$opid=$odata['operation_id'];
			$oname=$odata['operation_name'];
			$sql="select * from order_operations where order_id=? and operation_id=?";
			list($oprs,$err)=runIQuery($db,$sql,array("ii",$id,$opid));
			$itemplate.= "<input type='checkbox' style='display: none;' name='opnewINDEX-$opid' id='opnewINDEX-$opid' value='$opid' ";
			if (count($oprs) > 0) {
				$itemplate.= " checked ";
			}
			if (! $id) {
				if ($opid==35) {
					$itemplate.=" checked ";
				}
			}
			$itemplate.= " >";
			$itemplate.= "<div id='btnopnewINDEX-$opid' ";
			if ($oname=='Outsource') {
				$itemplate.= " onfocus=\"currentLine='INDEX';\" onclick=\"currentLine='INDEX';describeOperation(this);updateOp('INDEX','$opid',this);\" ";
			} else {
				$itemplate.= " onfocus=\"currentLine='INDEX';\" onclick=\"currentLine='INDEX';updateOp('INDEX','$opid',this);\" ";
			}
			if (count($oprs)>0) {
				$itemplate.= " class='btn btn-success'  style='width: 100px;'";
			} else {
				$itemplate.= " class='btn btn-danger' style='width: 100px;'";
			}
			$itemplate.= "> $oname</div>";
			$stack++;
			if ($stack == 3) {
				$stack=0;
				$itemplate.= "<br><br>";
			} else {
				$itemplate.= "&nbsp;";
			}

		}
		$itemplate.="</td>";
		$itemplate.="<td valign='top'>";
		$itemplate.="<select name='materialnewINDEX' id='materialnewINDEX' onChange=\"currentLine='INDEX';updateRow('INDEX','material',this.value);\">\n";
		$itemplate.= "<option value='0'>Please Select</option>";
		foreach ($mrs as $oldata) {
			$itemplate.= "<option value='" . $oldata['material_id'] . "' ";
			if ($oldata['material_id']==$master_material) {
				$itemplate.= " selected ";
			}
			$itemplate.=">" . $oldata['material_name'] . "</option>\n";
		}
		$itemplate.="</select>\n";
		$itemplate.="</td>";
		$itemplate.= "<td align='right' valign='top'><input type='text' id='priceINDEX' name='priceINDEX' style='width: 80px; background-color: white;' value='' onfocus=\"currentLine='INDEX';\" onChange=\"calculateExt('INDEX');updateRow('INDEX','price',this.value);\"></td>";
		$itemplate.= "<input type=hidden id='polINDEX' name='polINDEX'  value=''>";
		$itemplate.= "<td valign='top'><input type=text class='datepicker' id='dueINDEX' name='dueINDEX' onfocus=\"currentLine='INDEX';\"  onChange=\"updateRow('INDEX','due_date',this.value);\"  style='width: 80px; background-color: white;' value=''></td>";
		$itemplate.= "<input type='hidden' id='extINDEX' readonly name='extINDEX'  value='' ><td valign='top'><span id='colorINDEX'></span></td>";
		$itemplate.= "</tr>\n";

		while ($i < $current+100) {
			print "<tr id='tr$i' ";
			if ($i > $current + 1) {
				print " style='display: none;' ";
			}
			print ">";
			print str_replace("INDEX",$i,$itemplate);
			$i++;
		}
	} ## if id
	print "</tbody>";
	print "<tfoot>";
	print "<tr><td class='numeric'>Total: </td><td colspan='5'></td>";
	print "<td class='numeric'><input type=text id='otot' readonly style='border: 0px; width: 60px; text-align: right;  background-color: white;' value=''></td></tr>\n";
	print "</tfoot>";
	print "</table>\n";
	print renderClosePanel("");
    print "<div style='clear: both;'></div>\n";
	?>
<div id='outsourceDialog' style='display: none; border: 1px solid black; background-color: white; padding: 20px; min-height: 500px;'>
Please Describe the Outsourced Operation(s);
<br>
<textarea id='outsource' cols='50' rows='3' ></textarea>
<BR>
	<BR>
	If applicable, please Select the Powder Color:
	<br>
	<?php
	$sql="select vc_id, concat(vendor_name, '-', color_code) as name  from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code ";
	list($vrs,$err)=runIQuery($db,$sql);
	print renderStartItem(FALSE,"color","Color");
	print "<select name='color' id='color' style='width: 400px;'>";
	print renderOptions($vrs,0,1,0);
	print "</select>";
	print renderEndItem();
	print "Also Primer if applicable:<BR>";
	$sql="select vc_id, concat(vendor_name, '-', color_code) as name  from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code ";
	list($vrs,$err)=runIQuery($db,$sql);
	print renderStartItem(FALSE,"primer","Primer");
	print "<select name='primer' id='primer' style='width: 400px;'>";
	print renderOptions($vrs,0,1,0);
	print "</select>";
	print renderEndItem();

	?>
	<BR>
	<BR>
	<BR>
	<BR>
	<input type='button' class='btn btn-success' value='Save' onclick='hideOSDialog();'>
</div>
<div id='questionDialog' class='modal fade' role='dialog'>
<div class='modal-dialog'>
<div class='modal-content'>
<div class='modal-header'>
<button data-dismiss='modal' class='close' type='button'></button>
<h3>Operations Wizard</h3>
</div>
<div class='modal-body' id='questionContents'>
</div>
</div>
</div>
</div>
<div id='floorNotesDialog'style='display: none; border: 1px solid black; background-color: white; padding: 20px; min-width: 400px; min-height: 400px;'>
Enter Notes for Reason Change:<br>
<textarea id='newfloornotes' style='width: 300px;'></textarea><br>
<button type='button' class='btn btn-success' id='btnFloor' onclick="saveFloorNotes();" style='margin: 5px;'><i class='icon-ok'></i> Stash Notes (still click Save)</button>
</div>
	<script>
	linecounter=<?=$i?>;
	var current_line_count=<?=$currentLines?>;
	<?php
	if (! $creditHold) {
		$creditHold=0;
	}
	?>
	var creditHold=<?=$creditHold?>;
	var scheduleSet=0;
	function checkForZeroQty() {
		i=0;
		bfound=0;
		nozero=true;
		if (scheduleSet!='4') {
			while (( i < linecounter ) && (bfound ==0)) {						var itm = $('#item'+i).val().toUpperCase();
				if (($('#item'+i).val()!='') && (itm != 'DELETE')) {
					if ($('#qty'+i).val()=='0') {
						bfound=1;
						alert('You cannot have zero Quantity Line ' + i+1 + " Part " + $('#item'+i).val());
						nozero=false;
					}
					if ($('#due'+i).val()=='') {
						alert('You must select due date for line ' + i + ' part ' + $('#item'+i).val());
						nozero=false;
					}
				} else {
					bfound=1;
				}
				i++;
			}
		}
		if ($('#customer_id').val()=='0') {
			nozero=false;
			alert('You must select a customer');
		}
//		if ($('#folder_number').val()=='') {
//			nozero=false;
//			alert('You must enter the Folder Number');
//		}
		if ($('#po_number').val()=='') {
			nozero=false;
			alert('You must enter the PO Number');
		}
		if ($('#po_number').val()==$('#folder_number').val()) {
			nozero=false;
			alert('PO Number and Folder Number cannot be the same.');
		}
		if ($('#date_due').val()=='') {
			nozero=false;
			alert('You must enter the header due date');
		}
		return nozero;
	}

function continueSave(conversation='') {
	if (checkForZeroQty()) {
		$('#btnSave').hide();
		$('#working').show();
		var url = "updateOrder.php"; // the script where you handle the form input.
		formdata=formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('[id^="master-"]').each(function() {
			if (!this.checked) {
				formdata += '&'+this.name+'=0';
			} else {
				formdata += '&'+this.name+'=1';
			}
		});
		console.log("processing...");
		formdata+="&vendor_confirmed=";
		if (document.getElementById('vendor_confirmed').checked) {
			formdata+="1";
		} else {
			formdata+="0";
		}
		formdata+='&scheduleit='+scheduleIt;
		formdata+='&notes_to_customer='+$('#notes_to_customer').val();
		formdata+='&notes_to_self='+$('#notes_to_self').val();
		formdata+='&floor_notes='+$('#floor_notes').val();
		formdata+='&shipping_notes='+$('#shipping_notes').val();
		//### WST adding conversation id to formdata
		if (conversation != ''){
			formdata+='&conversation='+conversation;
			formdata+='&tuser=1';
		}
		console.log(url+'?'+formdata);
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				$('#working').hide();
				showReturnValue(data);
			}
			});
	}
}

	function saveTheForm(scheduleIt,conversation='') {
		//### WST ticketing user
		let tuser = $("#ticketUser").val();

		// bdoss put the bottom section that does the saving into a separate function so that, if ajax is used, ajax has a chance to finish, also added variables for below rma additions
		scheduleSet=scheduleIt;
		oktosave=1;
		rmaIndex=$('#folder_number').val().toUpperCase().indexOf('RMA');
		let rmaReason = $('#rma_reason').val();
		let internalNotes = $('#notes_to_self').val();
		console.log(internalNotes);
		if (rmaReason=='0') {
			if (rmaIndex > 0) {
				oktosave=0;
				$.gritter.add("You must select RMA Reason");
			}
		}
		if (oktosave > 0) {
			// bdoss 9/14/22 if certain rma reasons are selected, internal notes section is required to be filled out, restructured so that form couldn't save before ajax finished
			if (rmaReason > 0) {
				let url = 'requireNotes.php?reason='+rmaReason+'&rand='+Math.random();
				$.ajax({url: url, success: function(data){
					if (data == 1) {
						if (!internalNotes) {
							oktosave=0;
							$.gritter.add('Internal Notes must be filled out with more info for this type of RMA');
						} else {
							continueSave(<?=$conversation?>);
						}
					} else {
						continueSave(<?=$conversation?>);
					}
				}})
			} else {
				continueSave(<?+$conversation?>);
			}
		}
	}

	// Brittany 6/22 preventing creation of header if customer on credit hold
	// bdoss 10/5/22 as long as we're looking to see if the customer is on credit hold whenever customer is updated, we'll also check to see if the customer has restricted shipping options
	// per Justin, only allow standard shipping for certain customers (namely ourselves)
	function checkCreditHold(customerID) {
		let url = 'checkCreditHold.php?customer='+customerID+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){
			if (data == 1) {
				//hide buttons here and send message
				$.gritter.add('Customer on Credit Hold');
				$('#order_type').parent().show();
				$('#btnSave').hide();
				$('#btnDem').hide();
				$('#btnLabels').hide();
				$('#btnPrint').hide();
				$('#btnDone').html("CUSTOMER ON CREDIT HOLD");
			} else if (data == 2) { // this is for customers who may only have standard order type selected
				$('#order_type').val(1);
				$('#btnSave').show();
				$('#btnDem').show();
				$('#btnLabels').show();
				$('#btnPrint').show();
				$('#btnDone').html("Done");
				$('#order_type').parent().hide();
			} else {
				$('#btnSave').show();
				$('#btnDem').show();
				$('#btnLabels').show();
				$('#btnPrint').show();
				$('#btnDone').html("Done");
				$('#order_type').parent().show();
			}
		}} );
	}




	// bdoss adding functions for automated reminders 9/27
	function deleteReminder(reminder) {
		let hideRow = document.getElementById(`hideRow${reminder}`);
		let reminderURL=`updateOrderReminders.php?id=${reminder}&action=delete`;
		$.ajax({url: reminderURL, success: function(){
			$(hideRow).hide();
			$.gritter.add('Deleted Reminder');  }} );
	}
	// bdoss this will add an existing repeat reminder to a new order 9/27
	function copyReminder(order,customer,status,employees,message) {
		let hideButton = document.getElementById(`hide${message}`);
		let showAdded = document.getElementById(`show${message}`);
		$(hideButton).hide();
		let reminderURL=`updateOrderReminders.php?order=${order}&customer=${customer}&status=${status}&employees=${employees}&message=${message}&action=repeat`;
		console.log(reminderURL);
		$.ajax({url: reminderURL, success: function(){
			$(showAdded).show();
			$.gritter.add('Copied Repeat Reminder');  }} );
	}

	function updateCustomer(customerID) {
		var url='getCustomerInfo.php?customer='+customerID+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){  setShippingInfo(data);  }} );
		// Customers that always get operations
<?php
$sql="select customer_id, operation_id from customer_operations where coalesce(always_use,0) = 1 ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$cust=$data['customer_id'];
	$op=$data['operation_id'];
	print "		if (customerID == $cust) { \n";
	print "			obj=document.getElementById('master-$op');\n";
	print "			obj.checked=true;\n";
	print "			setMasterOperations(obj);\n";
	print "		}\n";
}
?>
		selectShipTo();
	}
	function setShippingInfo(shipinfo) {
		spinfo=shipinfo.split('|');
		$('#ship_name').val(spinfo[0]);
		$('#ship_address').val(spinfo[1]);
		$('#ship_city').val(spinfo[2]);
		$('#ship_state').val(spinfo[3].trim());
		$('#ship_zip').val(spinfo[4]);
		if 	($('#ship_phone').val()!='') {
			$('#ship_phone').val(spinfo[5]);
		}
		$('#ship_email').val(spinfo[6]);
		notes=spinfo[7];
		if (notes =='undefined') {
			notes='';
		}
		if (typeof notes == 'undefined') {
			notes='';
		}
		if ($('#notes_to_self') == '') {
			$("#notes_to_self").val(notes);
		} else {
			oldnotes=$("#notes_to_self").val();
			if (oldnotes.indexOf(notes)==-1) {
				$('#notes_to_self').val(oldnotes + ' ' + notes);
			}
		}

		shipnotes=spinfo[8]; //Shipping notes -Josh 04-28-2022
		if (shipnotes =='undefined') {
			shipnotes='';
		}
		if (typeof shipnotes == 'undefined') {
			shipnotes='';
		}
		if ($('#shipping_notes') == '') {
			$("#shipping_notes").val(shipnotes);
		} else {
			oldnotes=$("#shipping_notes").val();
			if (oldnotes.indexOf(shipnotes)==-1) {
				$('#shipping_notes').val(oldnotes + ' ' + shipnotes);
			}
		}
	}

	function setContactInfo(contactinfo) {
		cinfo=contactinfo.split("|");
		$('#attention').val(cinfo[0]);
		$('#ship_email').val(cinfo[1]);
	}

	function selectShipTo() {
		$('#selectShipping').load('listShiptos.php?customer='+$('#customer_id').val()+'&rand='+Math.random());
		$('#selectContact').load('listContacts.php?customer='+$('#customer_id').val()+'&rand='+Math.random());
	}

	function processSShip() {
		url='saveShipping.php?customer='+$('#customer_id').val()+'&ship='+escape($('#shipping_info').val())+'&rand='+Math.random();
		$.ajax(url);
	}
	function sendEmail() {
		if (creditHold == 1 && $('#order_status')!=10) {
			alert('Please see Cory Wind or Aaron Fisher, you cannot confirm this SO');
		} else {
			if ($('#id').val()==0) {
				$.gritter.add('You must save the Sales Order first');
			} else {
				if ('<?=$sentInitial?>' == '1') {
					if ($('#item0').val()=='') {
						$.gritter.add('You must have at least one line item');
					} else {
						composeEmail('SO',$('#id').val());
					}
				} else {
					composeEmail('INITIAL',$('#id').val());
				}
			}
		}
	}
	var originalpo='';
function page_init() {
	reasonChanged();
	$('#floorNotesDialog').dialog('close');
	$('#outsourceDialog').dialog();
	$('#outsourceDialog').dialog({position: [500,100],width: '600', height: '600'});
	$('#outsourceDialog').dialog('close');
	window.scrollTo(0, 0);
	// bdoss getting url and search parameters
	const queryString = window.location.search;
	const urlParams = new URLSearchParams(queryString);

	//look for if order is on hold Brittany 7/15/22
	let order = document.getElementById('order_hold').value;
	url=`updateOrderHold.php?update=check_for_hold&order=${order}&rand=${Math.random()}`;
	$.ajax({url: url, success: function(data){
		if (data == 1) {
			document.getElementById('order_hold').checked = true;
		} else {
			document.getElementById('order_hold').checked = false;
		}
	}});

	jQuery('.datepicker').datepicker();
  	jQuery(".chosen-select").chosen({'width':'100%','white-space':'nowrap'});
 	jQuery('#customer_id').change(function() { customerChanged(); });
  	jQuery('#rma_reason').change(function() { reasonChanged(); });
  	jQuery('#date_due').change(function() { alert('Be sure of this you are manipulating internal due date');dateChanged(); });
  	jQuery('#due_customer').change(function() { dueChanged(); });
  	jQuery('#order_vendor').change(function() { vendorChanged(); });
  	jQuery('#po_number').focus(function() { originalpo=$(this).val(); } );
	// bdoss autocomplete stopped working because itemlist was changed, making it work again 9/7/22
	// callen reverted back to itemfilter
	jQuery('[id^="item"]').autocomplete({source: itemFilter, minLength: 4, messages: {
        noResults: '',
        results: function() {}
    }
    });
    jQuery("[id^=qty]").ForceNumericOnly();
    jQuery("[id^=price]").ForceNumericOnly();
  	jQuery('#folder_number').change(function() { folderChanged(); });
	jQuery('#date_due').attr('tabindex',9999);
  	selectShipTo();
	checkCreditHold(document.getElementById('customer_id').value);
	// bdoss is this an order that was just created and has repeat automated reminders?
	if (urlParams.has('repeat')) {
		$('#repeatReminderDialog').dialog({position: [1000,400], height: 300, width: 500});
		let id = urlParams.get('id');
		let newURL = `editOrders.php?id=${id}`;
		window.history.pushState({}, '', newURL);   // bdoss this will get rid of the repeat parameter so the dialog only shows up once
	}
}

function reasonChanged() {
	$('#floorNotesDialog').dialog();
	$('#floorNotesDialog').dialog({position: [500, 100], height: 500, width: 500});
}
function dateChanged() {
	dc=$('#due_customer').val();
    jQuery("[id^=due]").val($('#date_due').val());
    $('#due_customer').val(dc);
    if ($('#id').val()!='0') {
		overlay();
		console.log('overlay');
	    url="dateChanged.php?order=" + $('#id').val()+'&date='+$('#date_due').val();
	    $.ajax({url: url, complete:
			function(data) {
				unoverlay();
				saveTheForm('0');
			}
		});
	}
}
function dueChanged() {
	console.log('due changed id is '+$('#id').val());
	    if ($('#id').val()!='0') {
			overlay();
		    url="dateChanged.php?vendor=" + $('#order_vendor').val()+ "&dt=dc&order=" + $('#id').val()+'&date='+$('#due_customer').val();
		   	$.ajax({url: url, success: function(data) {
		   		$('#date_due').val(data);
				   unoverlay();
				   saveTheForm('0');
		   	}} );
		} else {
			$('#date_due').val($('#due_customer').val());
			dateChanged();
		}
}

// 7/15/22 Brittany adding order hold check box functionality
function updateOrderHold(order) {
	console.log(order);
	if (document.getElementById('order_hold').checked) {
		console.log('Checked!');
		url=`updateOrderHold.php?update=put_on_hold&order=${order}&rand=${Math.random()}`;
		$.ajax({url: url, success: function(data){ }});
	} else {
		console.log('Not Checked!');
		url=`updateOrderHold.php?update=take_off_hold&order=${order}&rand=${Math.random()}`;
		$.ajax({url: url, success: function(data){ }});
	}
}

function vendorChanged() {
	    if ($('#id').val()!='0') {
			url='vendorChanged.php?vendor=' + $('#order_vendor').val() + '&order=' + $('#id').val() + '&date=' + $('#due_customer').val();
		    $.ajax({url: url, success: function(data){
				$('#date_due').val(data);
			 }});
		} else {
			alert('Check Internal Due Date after save');
		}
}

function showRow(lineno) {
	newLine=parseInt(lineno)+1;
	jQuery('#tr'+newLine).show();
}


	function customerChanged() {
		updateCustomer(jQuery('#customer_id').val());
	}

	function folderChanged() {
		url='validateFolder.php?folder='+$('#folder_number').val();
		$.ajax({url: url, success: function(data){ processValidateFolder(data); }});
	}

	function checkPO() {
		url='validatePO.php?id=' + $('#id').val() + '&po=' + $('#po_number').val()+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){ processValidatePO(data); }});
	}

	function processValidateFolder(data) {
		if 	(data != '') {
			alert(data);
		}
	}

	//creating interval variable for blinking title bdoss 7/29/2
	let intv;
	function processValidatePO(data) {
		let title = document.title;
		// call this to stop the blinking
		function startBlink() {
			if (!intv) {
				intv = setInterval(blink, 1000);
			}
		}

		function blink() {
			document.title = document.title === 'Duplicate PO' ? title : 'Duplicate PO';
		}

		function stopBlink() {
			clearInterval(intv);
			intv = null;
			document.title=title;
		}

		if 	(data != '') {
			alert(data);
			startBlink();
			$('#duplicatePODialog').dialog({position: [1000,400], height: 300, width: 500});
			$('.transform').toggleClass('transform-active');
		} else {
			stopBlink();
		}
	}

	function stopPop() {
		$('.transform').removeClass('transform-active');
	}


	function setMasterOperations(obj) {
		var seekid=obj.id.replace('master','');
		var inputs = document.getElementsByTagName("input");
  		for (x = 0 ; x < inputs.length ; x++){
    		myname = inputs[x].getAttribute("id");
    		if (myname) {
	    		if(myname.indexOf("opnew")==0){
	      			if (myname.indexOf(seekid)> 0) {
						inputs[x].checked=obj.checked;
					}
	       		}
			}
    	}
	}
	function setMasterMaterial(obj) {
		$("select[id^='materialnew']").val(obj.value);
	}
	function printLabels() {
		window.open('renderTCPDF.php?type=TAG&id=<?=$id?>','labels');
	}
	function dematicLabel() {
		window.open('renderTCPDF.php?type=DEMATIC&id=<?=$id?>','labels');
	}
	function printOrder() {
		window.open('renderTCPDF.php?type=WO&id=<?=$id?>','wo');
	}
	function printPage() {
		if (creditHold == 1 && $('#order_status')!=10) {
			alert('Please see Justin or Matt, you cannot print this SO');
		} else {
<?php
	if (! $okToReview) {
		$sql="select distinct full_name from site_admins where coalesce(can_review_high_dollar,0) = 1 ";
		list($rs,$err)=runIQuery($db,$sql);
		$msg= "Please contact one of the people below to Send the Confirmation: ";
		foreach ($rs as $data) {
			$msg.= $data['full_name'];
			$msg.= ", ";
		}
		print "		alert('$msg');\n";
	} else {
		print "window.open('renderTCPDF.php?type=SO&id=$id','wo');\n";
	}
?>
		}
	}
	function printInvoice() {
		window.open('printInvoice.php?id=<?=$id?>','_blank');
	}
	function paintInvoice() {
		if (document.getElementById('individual').checked) {
			window.open('paintInvoice.php?id=<?=$id?>&individual=1','_blank');
		} else {
			window.open('paintInvoice.php?id=<?=$id?>','_blank');
		}
	}

	function powderPO() {
		var powderPOStop = <?php print ($powderPOStop ? 1 : 0); ?>;
		if (!powderPOStop) {
			window.open('powderPO.php?id=<?=$id?>','powderpo');
			return;
		}

		$.gritter.add("There must be a powder color on all outsourced items requiring powder!");
	}

	function copyOrder() {
		window.open('copyOrder.php?id=<?=$id?>','_blank');
	}
	function describeOperation(btnobj) {
		ck=0;
		btnclass=$(btnobj).attr('class');
		if (btnclass == 'btn btn-danger') {
			// because we are toggling
			ck=1;
		}
		if (ck) {
			openOutsourceDialog();
		}
	}
	function hideOSDialog() {
		newinfo=$('#outsource').val();
		if (newinfo=='undefined') {
			newinfo='';
		}
		if ($('#notes_to_self').val()!='') {
			$('#notes_to_self').val($('#notes_to_self').val()+', ');
		}
		newcode=$("#color option:selected" ).text();
		if (newcode=='undefined') {
			newcode='';
		}
		if ($('#color').val() != '0') {
			$('#color'+currentLine).html(newcode);
		} else {
			$('#color'+currentLine).html('');
		}
		$('#notes_to_self').val($('#notes_to_self').val()+newinfo+' '+newcode);
		$('#outsourceDialog').dialog('close');
		url='updateLineColor.php?line='+$('#ol'+currentLine).val()+'&primer='+$('#primer').val()+'&color='+$('#color').val()+'&rand='+Math.random();
		$.ajax(url);
	}

	function setColor(newid,newcode) {
		if (newcode=='undefined') {
			newcode='';
		}
		if (newid != '0') {
			$('#color'+currentLine).html(newcode);
		} else {
			$('#color'+currentLine).html('');
		}
		url='updateLineColor.php?line='+$('#ol'+currentLine).val()+'&color='+newid+'&rand='+Math.random();
		$.ajax(url);
	}

	function cancelOrder() {
		alert('You must manually do this if you truly want to cancel it.')
		//$('#order_status').val(5);
		//var url = "updateOrder.php"; // the script where you handle the form input.
		//formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		//$('input[type=checkbox]').each(function() {
		//    if (!this.checked) {
		 //       formdata += '&'+this.name+'=0';
		   // } else {
		     //   formdata += '&'+this.name+'=1';
		//	}
		//});
		//$.ajax({
		//	type: "POST",
		//	url: url,
		//	data: formdata, // serializes the form's elements.
		///	success: function(data)
		//	{
		///		backToTable();
		//	}
		//	});
	}
	var currentField='';
	var currentOLID='0';
	var trycount=0;
	function updateRow(rowid,fieldname,newvalue) {
		currentField=fieldname;
		oktoupdate=1;
		console.log('in update row');
		olid=$('#ol'+currentLine).val();
		if (fieldname != 'item_id') {
			if (fieldname != 'revision') {
				if (! $('#message'+rowid).html().toLowerCase().includes('checkmark'))   {
					oktoupdate=0;
					console.log('not ok beause ' + $('#message'+rowid).html());
			  	}
			}
		}
		if (oktoupdate > 0) {
			$('#message'+currentLine).html("<img src='images/loading.gif'>");
			if ($('#id').val()=='0') {
				saveTheForm('4');
			} else {
				continueUpdateRow(rowid,olid,fieldname,newvalue);
			}
		} else {
			if (oktoupdate == 0 )  {
				if (isDuplicate == 0) {
					setTimeout(
						function() {
							console.log('try again');
							updateRow(rowid,fieldname,newvalue);
						}
						,400);
				} else {
					console.log('isDuplicate');
				}
			}
		}
	}
	function continueUpdateRow(rowid,olid,fieldname,newvalue) {
		currentField=fieldname;
		url='updateOrderLine.php?id='+$('#id').val()+'&ol='+olid+'&field='+fieldname+'&value='+newvalue+'&rand='+Math.random()+'&opcount='+opCount+'&rowid='+rowid;
		currentLine = rowid;
		console.log(url);
		for (i=0; i < opCount; i++) {
			url=url+'&op'+i+'='+opArray[i] + '&opval'+i+'=';
			opid='opnew'+rowid+'-'+opArray[i];
			if (document.getElementById(opid).checked) {
				url=url + '1';
			} else {
				url=url + '0';
			}
		}
		$.ajax({url: url, success:
		function(data) {
			$('#message'+currentLine).html("<img src='images/checkmark.png'>");
			if (olid=='0') {
				// to make it synchronous
				if (setOLID(data,currentLine)) {
					lookupItemInfo($('#item'+currentLine).val());
				}
			} else  {
				console.log(currentField);
				if (currentField=='item_id') {
					lookupItemInfo($('#item'+currentLine).val());
				}
			}
		 }});
	}

	var isDuplicate=0;
	function setOLID(newolresponse,rowid) {
		updates=newolresponse.split("|");
		newol=updates[0];
		isDuplicate=0;
		if (newol=='DUPE') {
			isDuplicate=1;
			alert('Duplicate Part - not added');
		} else {
			if (newol == 'NOPE') {
				alert('Entry not updated - update item name first');
			} else {
				$('#ol'+rowid).val(newol);
				currentOLID=newol;
				if (currentField == 'item_id') {
					updateOtherRows(rowid,newol);
				}
			}
		}
		return true;
	}
	function updateOp(rowid,operation,btnobj) {
		url='updateOrderLineOperation.php?rand='+Math.random();
		currentLine=rowid;
		currentOLID=$('#ol'+rowid).val();
		url=url+'&op='+operation;
		url=url+'&ol='+currentOLID;
		btnclass=$(btnobj).attr('class');
		btnid=$(btnobj).attr('id');
		ckid=btnid.replace('btn','');
		document.getElementById(ckid).click();
		ischecked=0;
		if (btnclass == 'btn btn-danger') {
			// because we are toggling
			ischecked=1;
		}
		if (ischecked) {
			url=url+'&value=1';
			$(btnobj).attr('class','btn btn-success');
		} else {
			url=url+'&value=0';
			$(btnobj).attr('class','btn btn-danger');
		}
		$.ajax(url);
		if (operation == 95) {
			// Class A Finish
			rev = $('#rev'+rowid).val();
			crev = $('#rev'+rowid).val();
			if (ischecked) {
				if (crev != '') {
					if (! crev.includes('CLASS A FINISH')) {
						rev='CLASS A FINISH ' + crev;
					}
				} else {
					rev='CLASS A FINISH';
				}
			} else {
				rev = rev.replace(/CLASS A FINISH/g,'').replace(' ','');
			}
			$('#rev'+rowid).val(rev);
			updateRow(rowid,'revision',rev);
		}
		if (operation == 86) {
			// Peel Plastic
			mtl=$('#material'+rowid).val();
			rev = $('#rev'+rowid).val();
			if (sslist.includes(mtl)) {
				crev = $('#rev'+rowid).val();
				if (ischecked) {
					if (crev != '') {
						if (! crev.includes('PEEL PLASTIC')) {
							rev='PEEL PLASTIC ' + crev;
						}
					} else {
						rev='PEEL PLASTIC';
					}
				} else {
					rev = rev.replace(/PEEL PLASTIC/g,'').replace(' ','');
				}
				$('#rev'+rowid).val(rev);
				updateRow(rowid,'revision',rev);
			} else {
				$(btnobj).attr('class','btn btn-danger');
			}
		}
		if (operation == 77) {
			// PEM NUT
			crev = $('#rev'+rowid).val();
			if (ischecked) {
				if (crev != '') {
					if (! crev.includes('CRITICAL TOLERANCE')) {
						rev='CRITICAL TOLERANCE ' + crev;
					}
				} else {
					rev='CRITICAL TOLERANCE';
				}
			} else {
				rev = rev.replace(/CRITICAL TOLERANCE/g,'').replace(' ','');
			}
			$('#rev'+rowid).val(rev);
			updateRow(rowid,'revision',rev);
		}
		if (operation == 59) {
			// OUTSOURCE
			console.log("detected outsource");
			if (ischecked) {
				console.log("trying to open");
				openOutsourceDialog();
			}
		}
	}
	function openOutsourceDialog() {
		itemid='#item'+currentLine;
		itemval=$(itemid).val();
		itemqty=$('#qty'+currentLine).val();
		itemval=itemval + ' - ' + itemqty;
		itemdesc=$('#desc'+currentLine).val();
		itemval=itemval + ' - ' +itemdesc;
		itemval=itemval.trim();
		getColors=0;
		if ('<?=$userID?>' == '4') {
			// me
			if ($('#vendor_id')=='36') {
				// Preferred Coatings
				getColors=1;
			}
		}
		if (getColors == 1) {
			$('#outsource').val(itemval);
		} else {
			$('#outsource').val(itemval);
			$('#outsourceDialog').dialog();
			$('#outsourceDialog').dialog({position: [500,100],width: '600', height: '600'});
		}
	}
	function deleteDocument(docid) {
		if (confirm("Really Delete?")) {
			window.open('deleteDocument.php?id='+docid,'_blank');
		}
	}
	function uploadquote() {
		if (current_line_count > 0) {
			if (confirm('Are you sure you want to upload?  There are already ' + current_line_count + ' line items on this order')) {
				document.uploadform.submit();
			}
		} else {
			document.uploadform.submit();
		}
	}
	function updateOrderNotes(notetype,newnotes) {
		var url='updateOrderNotes.php';
		var formdata="order=<?=$id?>&type=" + notetype + "&notes=" + newnotes + "&rand=" + Math.random();
		$.ajax({
			type: "POST",
			url: url,
			data: formdata,
			success: function(data)
			{
				$.gritter.add("Updated");
			}
		});
	}

	var whichActivity='';
	function getActivity(which) {
		whichActivity=which;
		url='getOrderActivity.php?so=<?=$id?>&which='+which+'&rand='+Math.random();
		$.ajax({url: url, success: function(data) {
			if (which == 'viewed') {
				$('#viewed_activity').html(data);
			} else {
				$('#activity').html(data);
			}
		}});
	}
<?php
	$sql="select * from production_results where job_id=? and item_name <> 'ALL' ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$folder_number));
	$hasPR=count($rs);
?>
	var hasProductionResults=<?=$hasPR?>;
	function checkStatusChanged(newstat) {
		if (hasProductionResults > 0) {
			if (newstat == 5) {
				alert('Are you sure you want to cancel this order?  There are production results.');
			}
		}
	}
	</script>
</div>
</div>
<?php
include('footer.php');
?>