<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$table="jobs";
if ($id == 0) {
	print "<script>alert('Create Jobs from Orders Please');</script>\n";
	exit;
}
?>
<script type="text/javascript">
<?php
// get list of items

$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id where coalesce(under_review,0)=0 order by item_name ";
$rs=mysqli_query($db,$sql);
$itemlist=array();
$itemcount=0;
while ($data=mysqli_fetch_array($rs)) {
	if ($data['status_name'] != 'Active') {
		$itemlist[]=$data['item_name'] . "-" . $data['status_name'];
	} else {
		$itemlist[]=$data['item_name'];
	}
	$itemcount++;
}
$itemcount=count($itemlist);
#print "var fullItemList= " .json_encode($itemlist) . "\n";
?>
var addanother=0;
var currentLine=0;


function lookupItemInfo(itemValue) {
	url='getItemInfo.php?item='+itemValue+'&rand='+Math.random();
	$.ajax({url: url, success: function(data){ setLineValues(data); }})
}

function setLineValues(data) {
	vals=data.split('|');
	$('#desc'+currentLine).val(vals[0]);
}

function removeSpaces(obj)
{
	while (obj.value.indexOf(" ")!=-1)
	{
		obj.value=obj.value.replace(" ","-");
	}
	while (obj.value.indexOf(",")!=-1)
	{
		obj.value=obj.value.replace(",","-");
	}
	while (obj.value.indexOf(".")!=-1)
	{
		obj.value=obj.value.replace(".","");
	}
	while (obj.value.indexOf("--")!=-1)
	{
		obj.value=obj.value.replace("--","-");
	}
}

function showReturnValue(responseText)
{
	if (responseText.substring(0,1)!='<') {
		document.location.href='editJob.php?table=jobs&id='+responseText+'&rand='+Math.random();
	} else {
		$.gritter.add(responseText);
		document.location.href='editJob.php?table=jobs&id='+<?=$id?>+'&rand='+Math.random();

	}
}

</script>
<?php
$allow_edit=1;
$part="";
$qty="";
if (isset($_GET['part'])) {
	$part=$_GET['part'];
}
if (isset($_GET['qty'])) {
	$qty=$_GET['qty'];
}
	if ($id) {
		$title= "Job " . $id;
	} else {
		$title="NEW Job";
	}
	print renderPanel($title,"","green","span11","star");
	print renderButton("<i class='icon-ok'></i> Save","blue","saveTheForm();");
	print renderButton("<i class='icon-print'></i> Print","blue","printJob();");
	print renderButton("Done","","backToSchedule();");
	print renderButton("<i class='icon-cogs'></i> BOM View ","blue","bomView()");

?>
<form name='editForm' id='editForm' ><input type='hidden' name='table' id='table' value='<?=$table?>'><div style='display: none;'><input type='hidden=' name='key' id='key' value='<?=$key?>'><input type=hidden name='id' value='<?=$id?>' id='id'></div>
	<?php
	$sql="select * from jobs where job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$itemName=$data['item_id'];
	$customer_id=$data['customer_id'];
	$qbid=$data['quickbooks_job_number'];
	if (! $customer_id) {
		if ($part) {
			$sql="select customer_id from items where item_name=?";
			list($crs,$err)=runIQuery($db,$sql,array("s",$part));
			$cdata=$crs[0];
			$customer_id=$cdata['customer_id'];
		}
	}
	if (! $customer_id) {
		$customer_id=0;
	}
	$sql="select * from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	$cdata=$rs[0];
	$customer_name=$cdata['name'];
	$date_due=formatDateDBToWeb($data['start_date']);
	$description=$data['description'];
	if (! $date_due) {
		$date_due=Date("m/d/Y");
	}
	$quantity=$data['quantity_scheduled'];
	$good=$data['quantity_good'];
	$duration=$data['duration'];
	if (! $duration) {
		## calculate duration
		$duration=calculateDuration($db,$id);
	}
	$seq=$data['sequence'];
	$shift=$data['shift'];
	$who=$data['who'];
	$line_id=$data['line_id'];
	if (! $line_id) {
		$line_id=0;
	}
	$item_id=$data['item_id'];
	if (! $item_id) {
		if (! $id ) {
			$item_id=$part;
			#$quantity=$qty;
		}
	}
	$sql="select order_id from order_lines where line_id=? ";
	list($ors,$err)=runIQuery($db,$sql,array("i",$line_id));
	$odata=$ors[0];
	$order=$odata['order_id'];
	$status=$data['status'];
	print renderTextList("item_id",$item_id,"Part",$itemlist);
	if (! $line_id or ! $customer_id) {
		// add inactive customers code -Josh 02/20/2023
		$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
    	list($crs,$err)=runIQuery($db,$sql,["i",$customer_id]);
		print renderSelect(TRUE,"customer_id",$customer_id,"Customer","N",$crs,true);
	} else {
		print "<input type='hidden' name='customer_id' id='customer_id' value='$customer_id'>";
		print $customer_name; ## have to change on order if this job is for an order
	}
	print "<div class='span3 '>\n";
	if ($order) {
		print "<a href='editOrders.php?id=$order' target='_blank'>Order $order</a><br>";
	}
	$sql="select distinct order_id from jobs_orders, order_lines where job_id=? and order_line=line_id and order_id <> ?";
	list($jrs,$err)=runIQuery($db,$sql,array("ii",$id,$order));
	foreach ($jrs as $jdata) {
		$so=$jdata['order_id'];
		print "<a href='editOrders.php?id=$so' target='_blank'>Order $so</a><br>";
	}
	print "</div>";

	print renderDateBox(TRUE,"start_date",$date_due,"Date");
	print renderTextBox(TRUE,"sequence",$seq,"Sequence");
	print renderTextBox(TRUE,"duration",$duration,"Duration");
	$sql="select shift_id, shift_name from shifts order by shift_id";
	$srs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"shift",$shift,"Shift","N",$srs);
	print renderStartItem(FALSE,"","");
	print "<a href='allocationReport.php?part_prefix=$item_id' target='_blank'>Allocation Report</a>";
	print renderEndItem();
	$sql="select salesperson_id, concat(last_name,', ', first_name) as name from salespeople where inactive=0 order by last_name, first_name";
	$srs=mysqli_query($db,$sql);
	if (! $who) {
		$who=$userSalesPersonID;
		if (! $who) {
			if ($customer_id) {
				$sql="select salesperson_id from customers where customer_id=?";
				list($sprs,$err)=runIQuery($db,$sql,array("i",$customer_id));
				if (count($sprs)>0) {
					$who=$sprs[0][0];
				}
			}

		}
	}
	print renderSelect(TRUE,"who",$who,"Who","N",$srs);
	print renderTextBox(TRUE,"quantity_scheduled",$quantity,"Scheduled Quantity");
	print renderStartItem(TRUE,"good","Good So Far:");
	if ($good) {
		print "<b>$good</b>";
	}
	print renderEndItem();
	## calculate how much they can build based on available inventory
	$sql="select item_name, coalesce(sum(quantity),0)/quantity_per as maxb from billofmaterial, items, item_locations where billofmaterial.parent_item=? and child_item=item_name and items.item_id=item_locations.item_id and coalesce(available,0)=1 group by item_name";
	list($irs,$err)=runIQuery($db,$sql,array("s",$item_id));
	$maxbuild=99999;
	foreach ($irs as $idata) {
		$testItem=$idata['item_name'];
		if ($idata['maxb'] < $maxbuild) {
			$maxbuild=$idata['maxb'];
		}
	}
	if ($maxbuild==99999) {
		$maxbuild=0;
	}
	$maxbuild=round($maxbuild);
	print renderTextBox(TRUE,"make_qty",0,"Make You can make $maxbuild parts.");
	print renderButton("Build","green","buildQuantity();");

	$sql="select status_id, status_name from job_status order by status_id ";
	$srs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"status",$status,"Status","N",$srs);
	print "</select>";
	print "</form>\n";
	print "<div style='clear: both;'></div>";
	print "<div style='border: 1px solid black;'>LABELS";
	print "<form id=labelform action='renderPDFLabel.php' target='_blank' method='GET'>";
	print "<input type='hidden' name='job' value='$id'>";
	print "<input type='hidden' name='so' value='$order'>";
	print "<input type='hidden' name='due' value='$date_due'>";
	print "<input type='hidden' name='part' value='$item_id'>";
	print renderTextBox(TRUE,"qty",$quantity,"Qty");
	print renderTextBox(TRUE,"copies",1,"Copies");
	print "<input type='submit' text='Label' value='Make Label(s)'>";
	print "<form>\n";
	print "</div>";
	$sql="select po_id from purchase_orders where job_id > 0 and job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$writtenHeader=0;
	foreach ($rs as $data) {
		if (! $writtenHeader) {
			print "<BR><div>Purchase Order(s)</div>";
			$writtenHeader=1;
		}
		print "<div>PO <a href='editPO.php?id=" . $data['po_id'] . "' target='_blank'>" . $data['po_id'] . "</a></div>";
	}
	if ($writtenHeader) {
		print "<br>";
	}
	print "<div style='clear: both;'></div>";
	print "<div class='span11' style='border: 1px dashed black;'>";
	print "<h4>Production Results</h4>";
	print "<div id='results'>";
	$sql="select production_results.*, display_sequence, operation_name, workcenter_name from production_results, routing, operations, workcenters  
		where job_id=? and production_results.routing_id=routing.routing_id and routing.operation_id=operations.operation_id 
		and routing.workcenter_id=workcenters.workcenter_id order by results_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($rs) > 0) {
		print "<table><Tr><td>Operation</td><td>Date</td><td align='right'>Qty Good</td></tr>";
	}
	foreach ($rs as $data) {
		print "<tr>";
		if ($data['operation_name']=='Laser') {
			if ($data['notes'] =='SORT') {
				print "<td>15 ";;
			} else {
				print "<td>" . $data['display_sequence'] . " ";				
			}
			print $data['notes'];
		} else {
			print "<td>" . $data['display_sequence'] . " ";
			print $data['workcenter_name'];

		}
		print "</td>";
		print "<td>" . formatDateDBToWeb($data['result_date']) . "</td>";
		print "<td align='right'>" . $data['quantity_good'] . "</td>";
		print "</tr>";
	}
	if (count($rs) > 0) {
		print "</table>\n";
	}
	print "</div>\n";

	print "<input class='btn btn-green green' type='button' text='Enter Results' value='Enter Results' onclick=\"window.open('enterResults.php?job=$id','_blank');\">";
	print "</form>\n";
	print "</div>";
	print "<div style='clear: both;'></div>";
	print "<div id='bom'></div>";
	print "<div id='ops'></div>";
	print "</div>";
	print renderClosePanel();
	?>
	<div class="clear"></div>
	<div style='display: none' id='goodqty'><?=$good?></div>
	<script>
	function buildQuantity() {
		mqty=parseInt($('#make_qty').val());
		var oktogo=1;
		if (mqty > <?=$maxbuild?>) {
			oktogo=0;
			if (confirm('You can only build <?=$maxbuid?>. OK=Build Anyway, Cancel=Do Not Build')) {
				oktogo=1;
			}
		} else {
			sqty=parseInt($("#quantity_scheduled").val());
			if ($('#goodqty').html()!='') {
				gqty=parseInt($('#goodqty').html());
			} else {
				gqty=0;
			}
			if (gqty+mqty > sqty) {
				oktogo=0;
				if (confirm('That would make more than is scheduled. OK=OverBuild, Cancel=Do Not Build')) {
					oktogo=1;
				}
			}
		}
		if (oktogo==1) {
			url='makeQuantity.php';
			formdata='job=<?=$id?>&qty='+mqty;
			$.ajax({
				type: "POST",
				url: url,
				data: formdata, // serializes the form's elements.
				success: function(data)
				{
					document.getElementById('working').style.display='none';
					$('#make_qty').val('0');
					$('#buildresult').html(data);
					showReturnValue(data);
				}
			});
		}
	}
	function saveTheForm() {
		$('#working').show();
		var url = "updateJob.php"; // the script where you handle the form input.
		formdata=$("#editForm").serialize();
		// because serialize ignores unchecked checkboxes
		$('input[type=checkbox]').each(function() {
		    if (!this.checked) {
		        formdata += '&'+this.name+'=0';
		    } else {
		        formdata += '&'+this.name+'=1';
			}
		});
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				$('#working').hide();
				showReturnValue(data);
			}
			});
	}

	function editBillofmaterial(bomid) {
		url='editSubTable.php?section=billofmaterial&masterfield=parent_item&id='+bomid+'&masterkey='+$('#id').val();
		window.open(url,'edits');
	}

	function continueRouting() {
		renderOperations();
	}

	function continuebillofmaterial() {
		renderBOM();
	}
	var currentID=0;
	function deleteRouting(id) {
		html='<table><tr><td colspan=2><h3>Confirm Delete</h3></td></tr>';
		html=html+'<tr><td colspan=2>Are you sure you want to delete this record?</td></tr>';
		html=html+'</table>';
		currentID=id;
		$.prompt(html,{ callback: processRDEL, buttons: { 'Confirm Delete': true, 'Cancel': false}})
	}
	function processRDEL() {
		var url = "deleteRecord.php"; // the script where you handle the form input.
			$.ajax({
			type: "GET",
			url: url,
			data: "key=routing_id&table=routing&id="+currentID, // serializes the form's elements.
			success: function(data)
			{
				renderOperations();
			}
		});
	}
	function updateCustomer(customerID) {
		var url='getCustomerInfo.php?customer='+customerID+'&rand='+Math.random();
		$.ajax({url: url, success: function(data){ $('#customer_info').html(data); $('#shipping_info').val(''); }} );
	}
	function selectShipTo() {
		$('#selectShipping').load('listShiptos.php?customer='+$('#customer_id').val()+'&rand='+Math.random());
		$('#selectShipping').dialog({modal: true, width: 800});
	}
	function checkSaveShipping() {
		html='<table><tr><td colspan=2><h3>Save Shipping</h3></td></tr>';
		html=html+'<tr><td colspan=2>Would you like to save this shipping address for future use?</td></tr>';
		html=html+'</table>';
		currentID=id;
		$.prompt(html,{ callback: processSShip, buttons: { 'Yes': true, 'No': false}})
	}

	function processSShip() {
		url='saveShipping.php?customer='+$('#customer_id').val()+'&ship='+escape($('#shipping_info').val())+'&rand='+Math.random();
		$.ajax(url);
	}
	function validatePart(item) {
		var ok=1;
		if (item.includes('Inactive')) {
			ok=0;
		}
		if (item.includes('Pending')) {
			ok=0;
		}
		if (ok==1) {
			selectCustomer(item);
			renderOps(item);
			renderBOM(item);
		} else {
			$.gritter.add("You must have this part activated by Engineering");
			$('#item_id').val('');
		}
	}
	function selectCustomer(item) {
		url='getItemCustomer.php?item='+item;
		$.ajax({url: url, success: function(data) { $('#customer_id').val(data); }} )
	}
	function renderOps(item) {
		url='renderJobOps.php?item_id='+item+'&job=<?=$id?>&rand='+Math.random();
		$.ajax({url: url, success: function(data) { $('#ops').html(data); }} )
	}
	function renderBOM(item) {
		url='renderJobBom.php?item_id='+item;
		url=url+'&qty='+$('#quantity_scheduled').val();
		url=url+'&job='+$('#id').val();
		$.ajax({url: url, success: function(data) { $('#bom').html(data); }} )
	}
	function printJob() {
		if ($('#id').val()=='0') {
			$.gritter.add('After Order Saved, click print again');
			saveTheForm();
		} else {
			url='printJob.php?id='+$('#id').val();
			window.open(url,'pj');
		}
	}
function page_init() {
	$("#saveButton").click(function()
	{
		saveTheForm();
		return false; // avoid to execute the actual submit of the form.
	});
	$('#start_date').datepicker();
    if ($('#id').val()=='0') {
	    $('#item_id').focus();
	}
	$("#quantity_scheduled").change(function()
	{
		if ($(this).val() == 0) {
			alert('If you save with zero quantity, it will delete the job.');
		}
		return false; // avoid to execute the actual submit of the form.
	});
	renderOps('<?=$item_id?>');
	renderBOM('<?=$item_id?>');
}
var originalQuantity='$quantity';
function quantityChanged(newq) {
	url='updatePOQuantity.php?job=<?=$job?>&original='+originalQuantity+'&new='+newq;
	originalQuantity=newq;
	$.ajax(url);
}
function backToSchedule() {
	document.location.href='schedule.php';
}

function createJob(itemName,lc) {
	if (($('#id').val()=='') || ($('#id').val()=='0')) {
		$.gritter.add("You must Save the job first.");
	} else {
		url='createComponentJob.php';
		formdata='parentjob='+$('#id').val()+'&qty='+$('#bqty'+lc).val()+'&item_id='+itemName+'&id=0&rand='+Math.random();
		window.open(url+'?'+formdata,'_blank');
	}
}

function bomView() {
	window.open('bomReport.php?item_id=<?=$itemName?>&job=<?=$id?>','bom');
}

function createPO(job,itemName) {
	if (($('#id').val()=='') || ($('#id').val()=='0')) {
		$.gritter.add("You must Save the job first.");
	} else {
		url='createComponentPO.php';
		formdata='job='+job+'&qty='+$('#bqty'+lc).val()+'&item_id='+itemName+'&id=0&rand='+Math.random();
		window.open(url+'?'+formdata,'_blank');
	}
}

</script>
<?php
include('footer.php');
?>