<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$id=$_GET['id'];
if (! $id) {
	print "<script>document.location.href='createCycleCount.php';</script>\n";
	exit;
}
print renderPanel("Cycle Count","","Green","span11", "cogs");
$sql="select c.*, full_name from cycle_counts c left outer join site_admins on c.who = user_id where cc_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$data=$rs[0];
$dtlist=explode(" ",$data['count_date']);
$dt=formatDateDBToWeb($dtlist[0]);
print renderTextBox(TRUE,"count_date",$dt,"Count Date");
print renderCheckBox(TRUE,"posted",$data['posted'],"Posted");
$posted=$data['posted'];
print renderStartItem(TRUE,"who","Assigned To");
print $data['full_name'];
print renderEndItem();
print "<div style='clear: both;'></div>\n";
if ($data['posted'] == 0) {
	print "<div id='btnPost' class='btn green hidden-print' style='float: right; display: none;' onclick='postCycleCount();'>Post</div>";
	print "<div style='float: right'>&nbsp;</div>";
	print "<div id='btnPrint' class='btn blue hidden-print' style='float: right;' onclick='printCycle();'>Print without QOH</div>";
	print "<div style='float: right'>&nbsp;</div>";
}
print "<div class='btn yellow hidden-print'  style='float: right;' onclick='self.print();'>Print with QOH</div>";
print "<form autocomplete='off'>";
print "<div style='clear: both;'></div>\n";
print "<table class='table table-striped'>\n";
print "<thead>";
print "<tr><th>Item</th><th>Description</th><th>UOM</th><th class='qoh'>On Hand</th><th>Counted</th><th class='qoh'>Differential</th>";
if (! $posted) {
	if ($isAdmin) {
		print "<th>Remove</th>";
	}
}
print "</tr>";
print "</thead>\n";
print "<tbody>";
$sql="select item_name, item_description, c.cci_id, c.quantity, counted_quantity, uom_name from items, cycle_count_items c, units_of_measure m where cc_id=? and c.item_id=items.item_id and unit_of_measure=m.uom_id order by default_location ";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
foreach ($rs as $data) {
	$cid=$data['cci_id'];
	print "<tr id='row$cid'><td>" . $data['item_name'] . "</td>";
	print "<td>" . $data['item_description'] . "</td>";
	print "<td>" . $data['uom_name'] . "</td>";
	$qty=$data['quantity'];
	$cqty=$data['counted_quantity'];
	$diff=$cqty - $qty;
	print "<td align='right' class='qoh'>$qty<input type='hidden' id='qty$cid' value='$qty'></td>";
	print "<td align='right'><input id='newq$cid' type='number' value='$cqty' onchange=\"updateQuantity('$cid',this.value);\" style='width: 100px;'></td>";
	print "<td align='right' class='qoh'><span id='diff$cid'>$diff</span></td>";
	if (! $posted and $isAdmin) {
		print "<td>";
		print "<button type='button' class='btn red' onclick=\"deleteCycleCount('$cid');\"><i class='icon-trash'></i> Remove</button>";	
		print "</td>";
	}
	print "</tr>";
} 
print "</tbody>\n";
print "</table>\n";
print "</form>";
print renderClosePanel("");
?>
<div class="modal fade" id="blankEntriesDialog" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document"  >
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" >Blank Entries</h4>
      </div>
      <div class="modal-body">
      There are blank entries for some of the parts.  If you counted and there were zero, put a 0 in the field.  If you did not count that part, then please delete it from the list, then you will be able to post.
     </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-default" onclick="removeBlanks();" >Please Remove All Blanks For Me</button>
      </div>
   </div>
  </div>
</div>

<script>
	function postCycleCount() {
		msg='';
		$('[id^="newq"').each(
			function() {
				if ($(this).val() == '') {
					msg='Empty'
				}
			}
		);
		if (msg != '') {
			$('#blankEntriesDialog').modal('show');		
		} else {
			$.gritter.add("Processing");
			$('#btnPost').hide();
			url='postCycleCount.php?id=<?=$id?>';
			$.ajax({url: url, success: function(data) {
				$.gritter.add("Posted.");
				setTimeout(function() {
						document.location.reload();
					 }, 1500);
			}});			
		}
	}
	function removeBlanks() {
		url='deleteRecord.php?table=cycle_count_items&key=cci_id&id=0';
		$('[id^="newq"').each(
			function() {
				if ($(this).val() == '') {
					currentCID=$(this).attr('id').replace('newq','');
					$('#row'+currentCID).hide();				
					url=url+','+currentCID;
				}
			}
		);
		$.ajax({url: url, success: function(data) {
			$.gritter.add("Removed All Blanks");
		}})
	}
	var currentCID=0;
	function deleteCycleCount(cid) {
		currentCID=cid;
		url='deleteRecord.php?table=cycle_count_items&key=cci_id&id='+cid;
		$.ajax({url: url, success: function(data) {
			$.gritter.add("Removed");
			$('#row'+currentCID).hide();
		}})
		
	}
	function print_page() {
		printCycle();
	}
	function printCycle() {
		$('.qoh').hide();
		self.print();
		$('.qoh').show();
	}
	var newQuantity = 0;
	var currentCID=0;
	function updateQuantity(cid,value) {
		newQuantity=value;
		currentCID=cid;
		url='ajax/updateRecord.php?table=cycle_count_items&key=cci_id&id='+cid+'&counted_quantity='+value;
		$.ajax({url: url, success: function(data) {
			newdiff = parseInt(newQuantity) - parseInt($('#qty'+currentCID).val());
			$('#diff' + currentCID).html(newdiff);
			$.gritter.add('Updated');
			var oktoshow='yes';
			checkgroup="[id^=\'newq\']";
			$(checkgroup).each(function(index) {
				if ($(this).val() == '') {
					oktoshow='no';
				}
			});
			if (oktoshow=='yes') {
				$('#btnPost').show();				
			}
		}})
	}
</script>
<?	
include('footer.php');
?>