<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Select BOL/Packing Slip");
## 715 is dematic
$bolList=array();

## make sure everything is in the route for BOL
if (strtolower($userEmail)!="bol") {
	$sql="select distinct bol.bol_id ";
	$sql.=" from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id inner join skids on bol_skids.skid_id=skids.skid_id  
		inner join active_bol_route r on bol.bol_id=r.bol_id  
		 left outer join packing_slip p on skids.packing_slip_id=p.packing_slip_id and p.ship_address=r.ship_address  and p.ship_name=r.ship_name  
		 left outer join transfers t on skids.packing_slip_id=t.packing_slip_id and t.ship_address=r.ship_address and t.ship_name=r.ship_name 
		 where coalesce(assigned_to,0) =? and if(skid_type='TRANSFER',t.ship_name is not null,p.ship_name is not null) 
		 and if(skid_type='TRANSFER',t.signed_by is null,p.signed_by is null)  order by bol.bol_id, r.display_sequence ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	foreach ($rs as $bdata) {
		$bol=$bdata['bol_id'];
		$bolList[]=$bol;
		$max=0;
		$max+=10;
		$sql="select  distinct coalesce(t.ship_name, p.ship_name) as ship_name, coalesce(t.ship_address,p.ship_address) as ship_address, 
			coalesce (t.ship_city, p.ship_city) as ship_city, coalesce(t.ship_state, p.ship_state) as ship_state, coalesce(t.ship_zip, p.ship_zip) as ship_zip 
			from active_bol_skids b inner join skids s on b.skid_id=s.skid_id inner join  packing_slip p on s.packing_slip_id = p.packing_slip_id 
			left outer join transfers t on p.packing_slip_id=t.packing_slip_id and t.signed_by is null 
			where b.skid_id=s.skid_id and b.bol_id=? and s.packing_slip_id=p.packing_slip_id order by bs_id";
		list($xrs,$err)=runIQuery($db,$sql,array("i",$bol));
		foreach ($xrs as $data) {
			$name=$data['ship_name'];
			$address=$data['ship_address'];
			$city=$data['ship_city'];
			$state=$data['ship_state'];
			$zip=$data['ship_zip'];	
			$sql="select * from actve_bol_route where bol_id=? and ship_name=? and ship_address=? and ship_city=? and ship_state=? and ship_zip = ?";
			list($brs,$err)=runIQuery($db,$sql,array("isssss",$bol,$name,$address,$city,$state,$zip));
			if (count($brs)==0) {
				$sql="insert into active_bol_route (bol_id, ship_name, ship_address, ship_city, ship_state, ship_zip, display_sequence) ";
				$sql.=" values (?, ?, ?, ?, ?, ?, ?) ";
				list($brs,$err)=runIQuery($db,$sql,array("isssssi",$bol,$name,$address,$city,$state,$zip,$max));
				$max+=10;
			}
		}
	}

}

$validate=0;
## get where packing slip or transfer is not signed but is on the route
if (strtolower($userEmail) == "bol") {
	if (isset($_GET['validate'])) {
		$validate=1;
		$sql="select distinct bol.bol_id, skids.packing_slip_id, r.ship_name, r.ship_address, r.ship_city, r.ship_state, r.ship_zip 
			from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id 
			inner join skids on bol_skids.skid_id=skids.skid_id 
			inner join packing_slip p on skids.packing_slip_id=p.packing_slip_id and p.signed_by is null 
			left outer join active_bol_route r on bol.bol_id=r.bol_id and p.ship_name = r.ship_name and p.ship_address=r.ship_address 
			where coalesce(assigned_to,0) = 0  and r.display_sequence is not null order by bol.bol_id, r.display_sequence, skids.packing_slip_id ";		
	} else {
		$sql="select distinct bol.bol_id, coalesce(p.packing_slip_id, t.packing_slip_id) as packing_slip_id,  r.ship_name, r.ship_address, r.ship_city, r.ship_state,
		 r.ship_zip  from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id inner join skids
		  on bol_skids.skid_id=skids.skid_id  
		 inner join active_bol_route r on bol.bol_id=r.bol_id  left outer join packing_slip p on skids.packing_slip_id=p.packing_slip_id 
		 and p.ship_address=r.ship_address  
		 and p.ship_name=r.ship_name  left outer join transfers t on skids.packing_slip_id=t.packing_slip_id and t.ship_address=r.ship_address 
		 and t.ship_name=r.ship_name  where coalesce(assigned_to,0) =0 and if(skid_type='TRANSFER',t.ship_name is not null,p.ship_name is not null) 
		 and if(skid_type='TRANSFER',t.signed_by is null,p.signed_by is null)  order by bol.bol_id, r.display_sequence ";
	}
	list($rs,$err)=runIQuery($db,$sql);
} else {
	if (isset($_GET['validate'])) {
		$validate=1;
		$sql="select distinct bol.bol_id, skids.packing_slip_id, r.ship_name, r.ship_address, r.ship_city, r.ship_state, r.ship_zip 
			from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id inner join skids skid on bol_skids.skid_id=skids.skid_id 
			inner join packing_slip p on skids.packing_slip_id=p.packing_slip_id and p.signed_by is null 
			left outer join active_bol_route r on bol.bol_id=r.bol_id and p.ship_name = r.ship_name and p.ship_address=r.ship_address 
			where coalesce(assigned_to,0) = ? and  r.display_sequence is not null order by bol.bol_id, r.display_sequence, skids.packing_slip_id ";
	} else {
			$sql="select distinct bol.bol_id, coalesce(p.packing_slip_id, t.packing_slip_id) as packing_slip_id,  r.ship_name, r.ship_address, r.ship_city, r.ship_state, r.ship_zip 
				from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id inner join skids on bol_skids.skid_id=skids.skid_id  
				inner join active_bol_route r on bol.bol_id=r.bol_id  
				left outer join packing_slip p on skids.packing_slip_id=p.packing_slip_id and p.ship_address=r.ship_address  and p.ship_name=r.ship_name  
				left outer join transfers t on skids.packing_slip_id=t.packing_slip_id and t.ship_address=r.ship_address and t.ship_name=r.ship_name 
				where coalesce(assigned_to,0) =? and if(skid_type='TRANSFER',t.ship_name is not null,p.ship_name is not null) 
				and if(skid_type='TRANSFER',t.signed_by is null,p.signed_by is null)  order by bol.bol_id, r.display_sequence ";
	}
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	if ($debug) {
		print renderQuery($sql,array("i",$userID));
	}
}
print renderButton("Compare","blue","window.open('driver.php?validate=1','_blank');");
print "<table class='table table-striped'><thead><tr><th>BOL</th><th>Packing Slip</th><th>Name</th><th>Address</th><th># Skids</th><th># Boxes</th></tr></thead><tbody>";
processResults($db,$rs);

## now get the list of packing slips and transfers that are not signed 
if (isset($_GET['validate'])) {
	$validate=1;
	if (strtolower($userEmail) == "bol") {
		$sql="select distinct bol.bol_id, skids.packing_slip_id, r.ship_name, r.ship_address, r.ship_city, r.ship_state, r.ship_zip 
			from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id 
			inner join skids on bol_skids.skid_id=skids.skid_id 
			inner join transfers p on skids.packing_slip_id=p.packing_slip_id and p.signed_by is null 
			left outer join active_bol_route r on bol.bol_id=r.bol_id and p.ship_name = r.ship_name and p.ship_address=r.ship_address 
			 where coalesce(assigned_to,0) = 0  and r.display_sequence is not null order by bol.bol_id, r.display_sequence, skids.packing_slip_id ";		
		list($rs,$err)=runIQuery($db,$sql);
	} else {
		$sql="select distinct bol.bol_id, skids.packing_slip_id, r.ship_name, r.ship_address, r.ship_city, r.ship_state, r.ship_zip 
			from active_bol bol inner join active_bol_skids bol_skids on bol.bol_id=bol_skids.bol_id inner join skids on bol_skids.skid_id=skids.skid_id 
			inner join transfers p on skids.packing_slip_id=p.packing_slip_id and p.signed_by is null 
			left outer join active_bol_route r on bol.bol_id=r.bol_id and p.ship_name = r.ship_name and p.ship_address=r.ship_address 
			where coalesce(assigned_to,0) = ? and  r.display_sequence is not null order by bol.bol_id, r.display_sequence, skids.packing_slip_id ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	}
	processResults($db,$rs);
}




print "</tbody></table>\n";
print renderClosePanel();

function processResults($db,$rs) {
	global $userEmail;
	$bolList=array();
	foreach($rs as $data)  {
		$name=$data['ship_name'];
		$address=$data['ship_address'];
		$city=$data['ship_city'];
		$state=$data['ship_state'];
		$zip=$data['ship_zip'];
		$bol=$data['bol_id'];
		$bolList[]=$bol;
		$pack=$data['packing_slip_id'];
		$sql="select * from transfers where packing_slip_id=? and signed_by is null";
		list($trs,$err)=runIQuery($db,$sql,array("i",$pack));
		$transfer=0;
		if (count($trs)) {
			$tdata=$trs[0];
			if (count($tdata)) { 
					$transfer=1;
			}
		}
		$sql="select count(*) from skids where packing_slip_id=? and scanned != '0000-00-00 00:00:00' and unload_by is null and coalesce(box,0) = 0 ";
		list($srs,$err)=runIQuery($db,$sql,array("i",$pack));
		$sdata=$srs[0];
		$skids=$sdata[0];	
		$sql="select count(*) from skids where packing_slip_id=? and scanned != '0000-00-00 00:00:00' and unload_by is null and coalesce(box,0) = 1 ";
		list($srs,$err)=runIQuery($db,$sql,array("i",$pack));
		$sdata=$srs[0];
		$boxes=$sdata[0];
		$google="https://www.google.com/maps/place/";
		$google.=str_replace(" ","+",str_replace("Plant 2","", $address));
		$google.=",+";
		$google.=str_replace(" ","+",$city);
		$google.=",+";
		$google.=$state;
		$google.="+";
		$google.=$zip;
		$url="<a href='$google' target='_blank'>";	
		print "<tr><td>";
		if (strtolower($userEmail)=="bol") {
			print "<a href='editActiveBOL.php?id=$bol' target='_blank'>";
			print $bol;
			print "</a>";
		} else {
			print $bol;
		}
		print "</td><td><a href='unload.php?pack=$pack&transfer=$transfer' target='_blank'>$pack</td></td><td>$url$name</a></td><td>$url$address</a></td><td>$skids</td><td>$boxes</td></tr>\n";	
	}
}

include('footer.php');
