<?php


#error_reporting(E_ALL);

#ini_set('display_errors','1');

date_default_timezone_set("America/Detroit");


include('dbConnection.php');
## session start is now in dbconnection.php;
$itemID=$_GET['id'];

include('functions.php');

include('security.php');

$id=$_GET['id'];

$type=$_GET['type'];





function multiLine($string,$max) {

	$lines=array();

	$words=explode(" ",$string);

	$widx=0;

	$string="";

	while ($widx < count($words)) {

		$retstring="";

		$tooLong=0;

		while ($widx < count($words) and $tooLong==0 ) {

			if ($retstring) {

				$retstring.=" ";

			}						

			$oldstring=$retstring;

			$retstring.=$words[$widx];

			if (strlen($words[$widx])>$max) {

				$retstring=substr($words[$widx],0,$max);

				$words[$widx]=substr($words[$widx],$max);

				$tooLong=1;

			} else {

				if ( strlen($retstring)>$max) {

					$retstring=$oldstring;

					$tooLong=1;

				} else {

					$widx++;

				}

			}

		}

		if (trim($retstring)) {

			$lines[]=$retstring;

		}

	}	

	$string=implode("\r\n",$lines);

	$numberLines=count($lines);

	return array($numberLines,$string);

}





?>

<!DOCTYPE html>

<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->

<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->

<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->

<head>

	<meta charset="utf-8">

	<title>Render PDF</title>

</head>

<body>

<?php

include('tcpdf.php');

include('tcpdf_barcodes_1d.php');

$pdf = new TCPDF("P","pt","LETTER");

$pdf->SetAutoPageBreak(false, 0);

$pdf->setCellPaddings(0,0,0,0);

$pdf->setFontSubsetting(false);

$pdf->SetLeftMargin(.25);

$pdf->SetRightMargin(.25);

$pdf->SetTextColor(0,0,0,100); ## 100% black

$pdf->SetDrawColor(0,0,0,100);

$pdf->SetLineWidth(1);







function printWOHeader($db,$id,$pdf,$routing) {

	$sql="select items.*, customers.name as customer_name  from items left outer join  customers on items.customer_id=customers.customer_id  where item_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));

	$data=$rs[0];

	$part=$data['item_name'];

	$description=$data['item_description'];

	$quantity=1;

	$customer=$data['customer_name'];

	$itemInfo=getItemData($db,$part);

	$drawing=$itemInfo['drawing'];

	$revision=$itemInfo['revision'];

	$opid=$routing['operation_id'];

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$data=$rs[0];

		$pdf->AddPage();

		$pdf->Image("logoblank.jpg",5,5,600,100,'','','',true);

		$pdf->Image("images/logoblack.png",5,5,150, 60,'','','',true);

		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(300,10);

		$pdf->Write(16,"Operation Notes");

		$pdf->SetXY(300,26);

		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));

		// rectangle

		$pdf->Rect(20,60,540,100);

		$pdf->SetXY(30,62);

		$pdf->Write(16,"Production Order");		

		$pdf->SetXY(30,86);

		$pdf->Write(16,"Drawing/Rev:");		

		$pdf->SetXY(150,86);

		$pdf->Write(16,$drawing . " / ".$revision);		

		$pdf->SetXY(30,102);

		$pdf->Write(16,"Description");		

		$pdf->SetXY(150,102);

		$pdf->Write(16,$description);		

		$pdf->SetXY(30,118);

		$pdf->Write(16,"Customer:");		

		$pdf->SetFont("times","B",16,'',false);

		$pdf->SetXY(150,118);

		$pdf->Write(16,$customer);		

		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(30,134);

		$pdf->Write(16,"Purchase Order(s)");		

		$pdf->SetXY(340,62);

		$pdf->Write(16,"Part");		

		$pdf->SetXY(340,86);

		$pdf->Write(16,"Due");		

		$pdf->SetXY(320,134);

		$pdf->Write(16,"Quantity");		

		$pdf->SetFont("times","B",24,'',false);

		$pdf->SetXY(150,62);

		$pdf->Write(16,$id);

		$pdf->SetXY(400,62);

		$pdf->Write(16,$part);

		$pdf->SetXY(400,86);

		$pdf->Write(16,$datedue);

		$pdf->SetXY(400,134);

		$pdf->Write(16,$quantity);



		// operation dependent information		

		

		$operationSequence=$routing['display_sequence'];

		

		$style = array(

		    'position' => '',

		    'align' => 'C',

		    'stretch' => false,

		    'fitwidth' => true,

		    'cellfitalign' => '',

		    'border' => false,

		    'hpadding' => 'auto',

		    'vpadding' => 'auto',

		    'fgcolor' => array(0,0,0),

		    'bgcolor' => false, //array(255,255,255),

		    'text' => true,

		    'font' => 'helvetica',

		    'fontsize' => 6,

		    'stretchtext' => 4

		);

		$pdf->SetXY(170,15);

		$pdf->write1DBarcode($id."-".$operationSequence, 'C39', '', '', '', 36, 0.6, $style, 'N');

		$pdf->SetXY(460,524);

		$pdf->write1DBarcode($id."-".$operationSequence, 'C39', '', '', '', 36, 0.6, $style, 'N');

		$pdf->SetFont("times","",16,'',false);

		$routingID=$routing['routing_id'];

		$opid=$routing['operation_id'];

		

		$sql="select distinct po_id from po_lines where job_id=? and operation_id=?";

		list($prs,$err)=runIQuery($db,$sql,array("ii",$id, $opid));

		$polist="";

		$comma="";

		foreach ($prs as $data) {

			$polist.=$comma;

			$polist.= $data['po_id'];

			$comma=", ";

		}

		$pdf->SetXY(150,134);

		$pdf->Write(16,$polist);		

		

		$pdf->SetFont("times","",12,'',false);

		$pdf->SetXY(30,162);

		$pdf->Write(16,"SEQ");

		$pdf->SetXY(60,162);

		$pdf->Write(16,"Operation");

		$pdf->SetXY(220,162);

		$pdf->Write(16,"Workcenter");

		$pdf->SetXY(320,162);

		$pdf->Write(16,"Machine");

		$pdf->SetXY(450,162);

		$pdf->Write(16,"Parts/Hour");

		$mname=$routing['machine_name'];

		$mname=$routing['machine_name'];

		$opname=$routing['operation_name'];

		$wname=$routing['workcenter_name'];

		$pph=$routing['pph'];

		$units=$routing['units'];



		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(30,178);

		$pdf->Write(16,$operationSequence);

		$pdf->SetFont("times","B",16,'',false);

		$pdf->SetXY(60,178);

		$pdf->Write(16,$opname);

		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(220,178);

		$pdf->Write(16,$wname);

		$pdf->SetXY(320,178);

		$pdf->Write(16,$mname);

		$pdf->SetXY(450,178);

		$pdf->Write(16,$pph);

}





	$sql="select items.*, customers.name as customer_name  from items left outer join  customers on items.customer_id=customers.customer_id  where item_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));

	$data=$rs[0];

	$part=$data['item_name'];

	$description=$data['item_description'];

	$quantity=1;

	$customer=$data['customer_name'];

	$itemInfo=getItemData($db,$part);

	$drawing=$itemInfo['drawing'];

	$revision=$itemInfo['revision'];

	$opid=$routing['operation_id'];





	$datedue=formatDateDBToWeb($data['start_date']);

	$sql="select operations.operation_id, operation_name, machine_name, workcenter_name, pph, units, routing.routing_id, routing.display_sequence, notes from routing left outer join operations on routing.operation_id=operations.operation_id left outer join machines on routing.machine_id=machines.machine_id left outer join workcenters on routing.workcenter_id=workcenters.workcenter_id left outer join routing_text on routing.routing_id=routing_text.routing_id where routing.parent_part=? order by routing.display_sequence";

	list($ors,$err)=runIQuery($db,$sql,array("s",$part));

	$numPages=count($ors);

	$page=0;

	foreach ($ors as $routing) {

		printWOHeader($db,$id,$pdf,$routing);

		$page++;



		// operation dependent information		

		

		$operationSequence=$routing['display_sequence'];

		

		$pdf->SetFont("times","",16,'',false);

		$routingID=$routing['routing_id'];

		$opid=$routing['operation_id'];

		

		$polist="PO HERE";

		$pdf->SetXY(150,134);

		$pdf->Write(16,$polist);		

		

		$pdf->SetFont("times","",12,'',false);

		$pdf->SetXY(30,162);

		$pdf->Write(16,"SEQ");

		$pdf->SetXY(60,162);

		$pdf->Write(16,"Operation");

		$pdf->SetXY(220,162);

		$pdf->Write(16,"Workcenter");

		$pdf->SetXY(320,162);

		$pdf->Write(16,"Machine");

		$pdf->SetXY(450,162);

		$pdf->Write(16,"Parts/Hour");

		$mname=$routing['machine_name'];

		$mname=$routing['machine_name'];

		$opname=$routing['operation_name'];

		$wname=$routing['workcenter_name'];

		$pph=$routing['pph'];

		$units=$routing['units'];



		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(30,178);

		$pdf->Write(16,$operationSequence);

		$pdf->SetFont("times","B",16,'',false);

		$pdf->SetXY(60,178);

		$pdf->Write(16,$opname);

		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(220,178);

		$pdf->Write(16,$wname);

		$pdf->SetXY(320,178);

		$pdf->Write(16,$mname);

		$pdf->SetXY(450,178);

		$pdf->Write(16,$pph);



		$retval=$routing['notes'];

		$retval=str_replace("size='1'","size='0'",$retval);

		$retval=str_replace("size='2'","size='1'",$retval);

		$retval=str_replace("size='3'","size='2'",$retval);

		$pdf->WriteHTMLCell(430,520,10,210,$retval);

		$pdf->SetFont("times","",10,'',false);

		$pdf->SetXY(450,210);

		$pdf->Write(16,"Date/Time              Qty            Who");

		$base=226;

		while ($base < 354) {

			$pdf->SetXY(450,$base);

			$pdf->Write(16,"_______________ ________ _______");

			$base+=16;

		}

		$pdf->SetXY(450,370);

		$pdf->Write(16,"Defect                  Qty            Who");

		$pdf->SetXY(450,386);

		$pdf->Write(16,"_______________ ________ _______");

		$pdf->SetXY(450,402);

		$pdf->Write(16,"_______________ ________ _______");

		$pdf->SetXY(450,418);

		$pdf->Write(16,"_______________ ________ _______");

		$sql="select * from billofmaterial where parent_item=? and routing_id=? ";

		if ($operationSequence==10) {

			$sql="select * from billofmaterial where parent_item=? and (routing_id=? or routing_id=0)  ";

		}

		$sql.=" order by child_item ";

		list($rs,$err)=runIQuery($db,$sql,array("si",$part,$routingID));

		if (count($rs)>0 ) {

			$base=617;

			$pdf->SetXY(30,601);

			$pdf->Write(16,"Qty Per");

			$pdf->SetXY(72,601);

			$pdf->Write(16,"Qty");

			$pdf->SetXY(120,601);

			$pdf->Write(16,"Component");

			$pdf->SetXY(200,601);

			$pdf->Write(16,"Description");

			$pdf->SetXY(450,601);

			$pdf->Write(16,"Drawing");

			$pdf->SetXY(540,601);

			$pdf->Write(16,"Rev");

		}

		$pdf->SetLineWidth(.5);

		foreach ($rs as $data) {

			if ($base > 760 ) {

				printWOHeader($db,$id,$pdf,$routing);

				$pdf->SetXY(100,210);

				$pdf->Write(16,"Component Parts Continued");

				$base=234;

				$pdf->SetFont("times","",10,'',false);

				$pdf->Line(20,249,566,249);

				$base=250;

				$pdf->SetXY(30,234);

				$pdf->Write(16,"Qty Per");

				$pdf->SetXY(62,234);

				$pdf->Write(72,"Qty");

				$pdf->SetXY(100,234);

				$pdf->Write(16,"Component");

				$pdf->SetXY(200,234);

				$pdf->Write(16,"Description");

				$pdf->SetXY(450,234);

				$pdf->Write(16,"Drawing");

				$pdf->SetXY(540,234);

				$pdf->Write(16,"Rev");

			}

			$pdf->Line(20,$base-1,566,$base-1);

			$childItem=$data['child_item'];

			$qtyper=$data['quantity_per'];

			$childInfo=getItemData($db,$childItem);

			$cdesc=$childInfo['item_description'];

			$tq=$quantity * $qtyper;

			$dwg=$childInfo['drawing'];

			$rev=$childInfo['revision'];





			$pdf->SetXY(30,$base);

			$pdf->Write(16,$qtyper);

			$pdf->SetXY(90,$base);

			$pdf->Write(16,$tq);

			$pdf->SetXY(120,$base);

			$pdf->Write(16,$childItem);

			$pdf->SetXY(450,$base);

			$pdf->Write(16,$dwg);

			$pdf->SetXY(540,$base);

			$pdf->Write(16,$rev);

			list($nbrLines,$text)=multiLine($cdesc,50);

			if ($nbrLines==0) {

				$base+=16;

			} else {

				foreach (explode("\r\n",$text) as $l) {

					$pdf->SetXY(200,$base);

					$pdf->Write(14,$l);

					$base+=14;		

				}

				$base+=2;

			}

		}

		#$pdf->Line(20,$base,600,$base);

		#$pdf->Line(20,600,20,$base);

		#$pdf->Line(600,600,600,$base);

	}

$fname="/home/prefwelderp/public_html/documents/DEMOWO$itemID.pdf";	

if (file_exists($fname)) {

	unlink($fname);

}

$pdf->Output($fname, "F");

print "\n<script>document.location.href='/documents/DEMOWO$itemID.pdf';</script>\n";

?>

</body></html>