<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Dematic EDI History","","red","span11","star");
print "<p>The Entries below show the history of Dematic EDI orders.  Click on the order to view the details</p>";
print "<form name='findform' action='dematicEDIHistory.php' method='POST'>";
print renderButton("Refresh","green","document.findform.submit();");
print "</form>";
print "<table class='table table-striped'>";
print "<thead>";
print "<tr><th>EDI Order Number</th><th>Date Sent</th><th>Date Due</th><th>Document Type</th><th>PO Number</th><th>Date Ack Sent</th>";
print "</thead>";
print "<tbody>";
$sql="select order_id, date_order, date_due, document_type, po_number, date_ack_sent from edi_orders where order_id in (select order_id from edi_order_lines where ack_ready=1) order by date_due desc, po_number, document_type";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$order=$data['order_id'];
	$dt=formatDateDBToWeb($data['date_order']);
	$due=formatDateDBToWeb($data['date_due']);
	$docType=$data['document_type'];
	if ($docType == "850") {
		$docType="NEW PO";
	}
	if ($docType == "860") {
		$docType="PO Change";
    }
    $sent=formatDateDBToWeb($data['date_ack_sent']);
	$po=$data['po_number'];
	print "<tr>";
	print "<td>";
	print "<a href='viewDematicEDI.php?id=$order' target='_blank'>";
	print $order;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='viewDematicEDI.php?id=$order' target='_blank'>";
	print $dt;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='viewDematicEDI.php?id=$order' target='_blank'>";
	print $due;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='viewDematicEDI.php?id=$order' target='_blank'>";
	print $docType;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='viewDematicEDI.php?id=$order' target='_blank'>";
	print $po;
	print "</a>";
    print "</td>";
    print "<td>$sent</td>";
	print "</tr>\n";
}

print "</tbody>";
print "</table>";
print renderClosePanel();
include('footer.php');
?>