<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Engineering Dashboard History";

if (empty($_POST)) {
	$_POST = $_GET;
}
$export=0;
if (isset($_POST["export"])) {
	$export = $_POST["export"];
}

if (!$export) {
	include('header.php');
}

$start_date=Date("m/d/Y");
$end_date=$start_date;
if (isset($_POST['start_date'])) {
	$start_date=$_POST['start_date'];
} else {
	if (isset($_SESSION['start_date'])) {
		$start_date=$_SESSION['start_date'];
	}
}
if (isset($_POST['end_date'])) {
	$end_date=$_POST['end_date'];
} else {
	if (isset($_SESSION['end_date'])) {
		$end_date=$_SESSION['end_date'];
	}
}
$hour=11;
if (isset($_POST['hour'])) {
	$hour=$_POST['hour'];
}
$target=3;
if (isset($_POST['target'])) {
	$target=$_POST['target'];
}
$calculation="avg";
if (isset($_POST['calculation'])) {
	$calculation=$_POST['calculation'];
}

if (!$export) {
	print renderPanel("Engineering Dashboard History","","primary");
	print "<p>The dashboard was implemented 4/21/2020, so you can go as far back as that.  Pick a Date Range  and the hour you want to see the snapshot of.</p>";
	print "<p>Also check whether you want averages or totals.</p>";
	print "<form name='listform' method='POST' action='dashboard.php'>\n";
	print renderDateBox(TRUE,"start_date",$start_date,"Start Date");
	print renderDateBox(TRUE,"end_date",$end_date,"End Date");
	print "<div style='clear: both;'></div>";
	print renderStartItem(TRUE,"hour","Hour");
	print "<select name='hour' id='hour'>";
	print "<option value='8' ";
	if ($hour == 8) {
		print " selected ";
	}
	print ">8am</option>";
	print "<option value='12' ";
	if ($hour == 12) {
		print " selected ";
	}
	print ">Noon</option>";
	print "<option value='5' ";
	if ($hour == 5) {
		print " selected ";
	}
	print ">5pm</option>";
	print "<option value='11' ";
	if ($hour == 11) {
		print " selected ";
	}
	print ">11pm</option>";
	print "</select>";
	print renderEndItem();
	print renderStartItem(TRUE,"calculation","View");
	print "<select name='calculation' id='calculation'>";
	print "<option value='avg'>Average</option>";
	print "<option value='sum' ";
	if ($calculation == "sum") {
		print " selected ";
	}
	print ">Total</option>";
	print "</select>";
	print renderEndItem();
	print renderButton("Chart","success","document.listform.submit();");
	print "<div style='clear: both;'></div>\n";
}

print "<table style='padding: 6px;'><thead><tr><th>Salesperson</th><th>Lines</th><th>Percent</th><th>Bar</th></tr>\n";
print "</thead><tbody>";

$colors=array();
$colors[0]="Black";
$colors[1]="Aquamarine";
$colors[2]="Brown";
$colors[3]="Blue";
$colors[4]="BlueViolet";
$colors[5]="Coral";
$colors[6]="Green";
$colors[7]="Crimson";
$colors[8]="DarkOrange";
$colors[9]="DarkSlateGray";
$colors[10]="Gold";
$colors[11]="Fuchsia";
$colors[12]="LightBlue";
$colors[13]="Yellow";
$colors[14]="Maroon";
$colors[15]="MidnightBlue";
$colors[16]="Olive";
$colors[17]="PaleVioletRed";

$sd=formatDateWebtoDB($start_date);
$ed=formatDateWebtoDB($end_date);
$sql="select DATE(date_snapshot), gap, count(*), sum(lines_entered) from dashboard_snapshot_engineers where date_snapshot >= ? and DATE(date_snapshot) <= ? and hour_snapshot=? group by DATE(date_snapshot), gap order by date_snapshot";
if ($hour > 8) {
	$sql="select DATE(date_snapshot), gap, count(*), sum(lines_entered) from dashboard_snapshot_engineers where date_snapshot >= ? and DATE(date_snapshot) <= ? and hour_snapshot=? and lines_entered > 5  group by DATE(date_snapshot), gap order by date_snapshot";
}
$totalGap=0;
$totalDays=0;
$holdDate="";
list($rs,$err)=runIQuery($db,$sql,array("ssi",$sd,$ed,$hour));
foreach ($rs as $data) {
	if ($holdDate != $data[0]) {
		$gap=round($data[1]);
		$engineers=$data[2];
		$lines=$data[3];
		## they are expected to do 125 a day - but cannot do more tha is in pending processing
		if (($engineers*125)-$lines < $gap) {
			$gap=$engineers*125;
			$gap -= $lines;
		}
		$totalGap+=$gap;
		$totalDays++;
		$holdDate=$data[0];
	}
}
if ($calculation=="avg" and $totalDays > 0) {
	$totalGap = round($totalGap / $totalDays);
}
$sql="select salesperson, $calculation(lines_entered) as datalines, last_name, first_name from dashboard_snapshot_engineers ";
$sql.=" left outer join salespeople on salesperson = salesperson_id ";
$sql.=" where date_snapshot >= ? and DATE(date_snapshot) <= ? and hour_snapshot=? group by salesperson ";
$sql.=" order by last_name, first_name ";
list($rs,$err)=runIQuery($db,$sql,array("ssi",$sd,$ed,$hour));


$bottomScript="data =[";
$totalLines=0;

foreach ($rs as $data) {
	$lines=round($data[1]);
	$totalLines+=$lines;
}


reset($rs);
$i=0;
foreach ($rs as $data) {
	$salesperson=$data[0];
	$lines=round($data[1]);
	$name=trim($data['first_name'] . " " . $data['last_name']);

	if (! $name) {
		$name=$salesperson;
	}
	$pct=0;
	if ($totalLines > 0) {
		$pct=round($lines / $totalLines * 100,1);
	}
	$col=$colors[$i];
	print "<tr><td >$name</td><td>$lines</td><td>$pct</td><td>";
	$length=$lines * 2;
	if ($export) { // length tends to be very very long, using lines instead
		print "<div style='height: 40px; width: ".$lines."px; background: $col; margin-bottom: 7px;'></div>";
	} else {
		print "<svg width='$length' height='40'><rect fill='$col' width='$length' height='40'	></rect></svg>";
	}
	print "</td></tr>\n";
	$i++;
}


if ($totalGap>0) {
	$col=$colors[$i];
	print "<tr><td>To Go</td><td>$totalGap</td>";
	$pct=0;
	if ($totalLines > 0) {
		$pct=round($totalGap / $totalLines * 100,1);
	}
	$length=$totalGap * 2;
	print "<td>$pct</td><td>";
	if ($export) { // length tends to be very very long, using totalGap instead
		print "<div style='height: 40px; width: ".$totalGap."px; background: $col; margin-bottom: 7px;'></div>";
	} else {
		print "<svg width='$length' height='40'><rect fill='$col' width='$length' height='40'	></rect></svg>";
	}

	print "</td></tr>\n";
}

print "</tbody></table>";

## now lets see how many emails are in there
print "<H4>Order Queue</h4>\n";
$sql="select $calculation(inbox) as inbox, $calculation(unseen) as unseen, $calculation(orders) as orders, $calculation(quotes) as quotes from dashboard_snapshot_loaded where date_snapshot >= ? and DATE(date_snapshot) <= ? and hour_snapshot=? ";
list($rs,$err)=runIQuery($db,$sql,array("ssi",$sd,$ed,$hour));
$data=$rs[0];
$inbox=round($data['inbox']);
$unseen=round($data['unseen']);
$ordersLoaded=round($data['orders']);
$quotesLoaded=round($data['quotes']);
print "<table><thead><tr><th>Email Status</th><th>Count</th><th></th></tr></thead><tbody>";
print "<tr><td>Inbox</td><td>$inbox</td><td>";
$col=$colors[0];
if ($export) {
	print "<div style='height: 40px; width: ".$inbox."px; background: $col; margin-bottom: 7px;'></div>";
} else {
	print "<svg width='$inbox' height='40'><rect fill='$col' width='$inbox' height='40'	></rect></svg>";
}

print "</td></tr>";
print "<tr><td>Unseen</td><td>$unseen</td><td>";
$col=$colors[1];
if ($export) {
	print "<div style='height: 40px; width: ".$unseen."px; background: $col; margin-bottom: 7px;'></div>";
} else {
	print "<svg width='$unseen' height='40'><rect fill='$col' width='$unseen' height='40'	></rect></svg>";
}

print "</td></tr>";
print "<tr><td>Orders Loaded</td><td>$ordersLoaded</td><td>";
$col=$colors[2];
if ($export) {
	print "<div style='height: 40px; width: ".$ordersLoaded."px; background: $col; margin-bottom: 7px;'></div>";
} else {
	print "<svg width='$ordersLoaded' height='40'><rect fill='$col' width='$ordersLoaded' height='40'	></rect></svg>";
}

print "</td></tr>";
print "<tr><td>Quotes Loaded</td><td>$quotesLoaded";
$col=$colors[3];
if ($export) {
	print "<div style='height: 40px; width: ".$quotesLoaded."px; background: $col; margin-bottom: 7px;'></div>";
} else {
	print "<svg width='$quotesLoaded' height='40'><rect fill='$col' width='$quotesLoaded' height='40'	></rect></svg>";
}
print "</td></tr>";
print "</tbody></table>";
if (!$export) {
	print renderClosePanel();
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}
</script>
<?php
include('footer.php');
}