<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Engineering Dashboard";
include('header.php');
$start_date=Date("m/d/Y");
$end_date=$start_date;
$target=3;
if (isset($_GET['target'])) {
	$target=$_GET['target'];
}
print renderPanel("Engineering Dashboard","","primary");
print "<p>This is the daily Engineering Dashboard.</p>";
print "<form name='listform' method='GET' action='dailyDashboard.php'>\n";
print renderTextBox(TRUE,"target",$target,"# Engineers");
print renderButton("Chart","success","document.listform.submit();");
print "<div style='clear: both;'></div>\n";
print "<div id='linesUploaded' class='chart' style='position: relative; width: 600px; height: 600px; font-size: 32px; text-align: center; margin-top: 20px;'>Lines Processed</div>\n";
$sd=formatDateWebtoDB($start_date);
$ed=formatDateWebtoDB($end_date);
$sql="select salesperson_id, count(*) from orders o, order_lines l where o.order_id=l.order_id and o.status <> 5 and date_uploaded >= ? and DATE(date_uploaded)  <= ? group by salesperson_id having count(*) > 10 order by count(*) desc LIMIT $target";
list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
$days=BusinessDaysDifferent($ed,$sd,$db)+1;
$target=125*$target*$days;

$bottomScript="data =[";
$i=0;
$totalLines=0;
foreach ($rs as $data) {
	$i++;
	if ($i >1) {
		$bottomScript.=", ";
	}
	$salesperson=$data[0];
	$lines=$data[1];
	$totalLines+=$lines;
	$bottomScript.="{ label: '[$salesperson] $lines', data: $lines}";
}

$gap=$target - $totalLines;
$sql="select coalesce(sum(line_count),0) as gap from pending_processing p left outer join order_lines l on p.order_id=l.order_id where l.order_id is null";
list($rs,$err)=runIQuery($db,$sql);
$newgap=$rs[0][0];
if ($newgap < $gap and $newgap > 0) {
	$gap=$newgap;
}

$today=Date("Y-m-d");
if ($ed < $today) {
	$gap=0;
}	

if ($gap>0) {
	if ($i >0) {
		$bottomScript.=", ";
	}
	$bottomScript.="{ label: 'To Go: $gap', data: $gap}";
	$i++;
}
$bottomScript.="];\n";
$bottomScript.= " $.plot('#linesUploaded', data, { series: {pie: {innerRadius: 0.5, show: true, label: { show: true, formatter: labelFormatter}}}, legend: {show: false} } );\n";

## now lets see how many emails are in there
print "<div id='activity' class='chart' style='position: absolute; width: 600px; height: 600px; font-size: 32px; text-align: left; margin-top: 20px;'>Order Queue</div>\n";
$ordersInbox=0;
$ordersUnseen=0;
$quotesInbox=0;
$quotesUnseen=0;
	$mbox = imap_open("{imap.secureserver.net}", "laser@preferredmachinellc.com", "Laser@Beam22#", OP_HALFOPEN)
	      or die("can't connect: " . imap_last_error());
	$status = imap_status($mbox, "{imap.secureserver.net}Inbox", SA_ALL);
	if ($status) {
		$ordersInbox=$status->messages;
		$ordersUnseen=$status->unseen;
		$ordersInbox-=$ordersUnseen;
	}
	$ordersInbox-=$ordersUnseen;
	$mbox = imap_open("{imap.secureserver.net}", "quote@preferredmachinellc.com", "Quote@Team22#", OP_HALFOPEN);
	$status = imap_status($mbox, "{imap.secureserver.net}Inbox", SA_ALL);
	if ($status) {
		$quotesInbox=$status->messages;
		$quotesUnseen=$status->unseen;
		$quotesInbox-=$quotesUnseen;
	}
$inbox=$ordersInbox+$quotesInbox;
if ($inbox < 0) {
	$inbox=0;
}
$unseen=$ordersUnseen+$quotesUnseen;

$sql="select count(*) from orders where date_order >= '$sd' and date(date_order) <= '$ed' and status <> 10 ";
list($rs,$err)=runIQuery($db,$sql);
$ordersLoaded=$rs[0][0];
$sql="select count(*) from orders where date_order >= '$sd' and date(date_order) <= '$ed' and status = 10 ";
list($rs,$err)=runIQuery($db,$sql);
$quotesLoaded=$rs[0][0];
#$bottomScript.="adata=[{label: 'Quotes Entered ($quotesLoaded)', data: $quotesLoaded},  {label: 'Orders Entered ($ordersLoaded)', data: $ordersLoaded}];\n";
$bottomScript.="adata=[{label: 'Inbox ($inbox)', data: $inbox}, {label: 'Unseen ($unseen)', data: $unseen}, {label: 'Orders Entered ($ordersLoaded)', data: $ordersLoaded}, {label: 'Quotes Entered ($quotesLoaded)', data:$quotesLoaded}];\n";
$bottomScript.="$.plot('#activity', adata, {series: {pie: {innerRadius: 0.5, show: true, label: { show: true, formatter: labelFormatter}}}, legend: {show: false} } );\n";

## irma by department
print "<div style='clear: both;'></div>\n";
print "<div id='irma' class='chart' style='position: relative; width: 600px; height: 600px; font-size: 32px; text-align: center; margin-top: 20px;'>IRMA by Department</div>\n";

$sql="select department_name, sum(quantity) from irma, rma_reasons, departments where reason=reason_description and reason_department=department_id and irma_date >= '$sd' and DATE(irma_date) <= '$ed' group by department_name ";
list($rs,$err)=runIQuery($db,$sql);
$comma="";
if(count($rs)>0) {
	$bottomScript.="idata=[";
	foreach ($rs as $data) {
		$department=$data['department_name'];
		$quantity=$data[1];
		$bottomScript.=$comma;
		$bottomScript.="{label: '$department ($quantity)', data: $quantity}";
		$comma=", ";
	}
	$bottomScript.="];\n";
	$bottomScript.="$.plot('#irma', idata, {series: {pie: {innerRadius: 0.5, show: true, label: { show: true, formatter: labelFormatter}}}, legend: {show: false} } );\n";
} else {
	$bottomScript.="$('#irma').html('IRMA by Department<br><br>No IRMA today');\n";
}


## rma by customer
## rma by customer
print "<div id='rmawrapper' style='position: absolute;font-size: 32px; margin-top: 20px;'>RMA by Department<br>";
print "<div id='rma' class='chart' style='width: 600px; height: 600px; font-size: 32px; text-align: left; margin-top: 20px;'></div>\n";
print "</div>";
$sql="select department_name, sum(quantity) from orders o, order_lines l, rma_reasons r, departments where o.order_id=l.order_id and o.rma_reason=r.reason_id and reason_department=department_id  and date_due >= '$sd' and date_due <= '$ed' group by department_name";
list($rmars,$err)=runIQuery($db,$sql);
if (count($rmars)>0) {
	$bottomScript.="cdata=[";
	$comma="";
	foreach($rmars as $data) {
		$name=$data['department_name'];
		$quantity=$data[1];
		$bottomScript.=$comma;
		$bottomScript.="{label: '$name ($quantity)', data: $quantity}";
		$comma=", ";
	}
	$bottomScript.="];\n";
	$bottomScript.="$.plot('#rma', cdata, {series: {pie: {innerRadius: .5, show: true, label: { show: true, formatter: labelFormatter}}}, legend: {show: false} } );\n";
} else {
	$bottomScript.="$('#rma').html('No RMA today');\n";
}

print renderClosePanel();
?>
<script>
function page_init() {
	lpos=$('#linesUploaded').offset();	
	xpos=lpos['left'];
	ypos=lpos['top'];
	lpos={left: xpos+500, top: ypos - 150};
	$('#activity').css(lpos);
	lpos=$('#irma').offset();	
	xpos=lpos['left'];
	ypos=lpos['top'];
	lpos={left: xpos+500, top: ypos - 150};
	$('#rmawrapper').css(lpos);
	<?=$bottomScript?>
	// refresh every 10 minutes
	setTimeout(function() { document.listform.submit(); }, 6000000);
}
function labelFormatter(label, series) {
	return "<div style='padding-top: 20px; font-size: 24px; color: " + series.color + "'>" + label + "<br>" + Math.round(series.percent) + "%</div>";
}
</script>
<?php
include('footer.php');
?>