<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Sales Order Progess";
include('header.php');
$order='';

if ($isCustomer) {
    $customer=$isCustomer;
} else {
    $customer=$_GET['customer'];
}
$detail=$_GET['detail'];
$order=$_GET['order'];
$so=$_GET['so'];

print renderPanel("Order Progress","Order Progress","blue","span11");
print "<form name='findform' action='$scriptid' method=GET>\n";
// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print renderTextBox(TRUE,"order",$order,"Customer Purchase Order");
print renderTextBox(TRUE,"so",$so,"Our Sales Order");
print renderCheckBox(TRUE,"detail",$detail,"Show Line Items");
print renderButton("Find","blue","document.findform.submit()");
print "</form>\n";


$ops=array();
$prog=array();
if (isset($_GET['order']) or isset($_GET['so'])) {
    if ($order) {
        $sql="select order_id, name from orders o, customers c where po_number=? and o.customer_id=c.customer_id ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        $data=$rs[0];
        $so=$data[0];
        $customer=$data[1];
    } else {
        $sql="select po_number, name from orders o, customers c where order_id=?  and o.customer_id=c.customer_id ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$so));
        $data=$rs[0];
        $order=$data[0];
        $customer=$data[1];
        $so=$_GET['so'];
    }
    if ($so) {
        $sql="select j.line_id, sum(quantity_scheduled/if(pph=0,quantity_scheduled,pph)) from order_lines l, jobs j, routing r where l.order_id=? ";
        $sql.=" and l.line_id=j.line_id  and j.item_id=r.parent_part ";
        $sql.=" group by j.line_id ";
        list($irs,$err)=runIQuery($db,$sql,array('i',$so));
        foreach($irs as $data) {
            $line=$data['line_id'];
            $ops[$line]=$data[1];
        }
        $sql="select j.line_id, sum(pr.quantity_good/if(pph=0,pr.quantity_good,pph)) from  order_lines l, jobs j, routing r, production_results pr ";
        $sql.=" where l.order_id=? and l.line_id=j.line_id and j.item_id=r.parent_part and r.routing_id=pr.routing_id and j.job_id=pr.job_id  ";
        $sql.=" and pr.quantity_good > 0 ";
        $sql.=" group by j.line_id ";
        list($irs,$err)=runIQuery($db,$sql,array('i',$so));
        foreach($irs as $data) {
            $line=$data['line_id'];
            $prog[$line]=$data[1];
        }
        print "<h4>Results for Sales $so, Customer $customer PO $order</h4>";
        $sql= "SELECT orders.ship_name, orders.date_due, order_lines.line_id, order_lines.item_id, order_lines.item_description, status_name, quantity, po_number
        FROM orders
        INNER JOIN order_lines ON orders.order_id = order_lines.order_id
        INNER JOIN order_status ON order_status.status_id = orders.status
        WHERE orders.order_id=? ";
        $sql.=" order by line_id ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$so));
        if (count($rs)) {
            print "<div style='clear: both;'></div>";
            #print "<p>Click on the Order Number for Job Detail</p>";
            print "<table class='table table-striped'>";
            print "<thead><tr>";
            print "<th>Sales Order</th>";
            print "<th>Purchase Order</th>";
            if ($detail) {
                print "<th>Part</th>";
                print "<th>Quantity</th>";
                print "<th>Description</th>";
            }
            print "<th>Ship To</th>";
            print "<th>Due Date</th>";
            print "<th>Order Status</th>";
            print "<th>Progress</th>";
            print "</tr></thead><tbody>";
            $lpct=0;
            $lc=0;
            foreach ($rs as $data) {
                $so=$data['order_id'];
                $po=$data['po_number'];
                $ship=$data['ship_name'];
                $due=formatDateDBToWeb($data['date_due']);
                $line=$data['line_id'];
                $part=$data['item_id'];
                $description=$data['item_description'];
                $status=$data['status_name'];
                $quantity=$data['quantity'];
                $totalOperations=$ops[$line];
                $progress=$prog[$line];
                $pct="";
                if ($totalOperations > 0) {
                    $pct=number_format($progress / $totalOperations * 100);
                    if ($pct > 99) {
                        $pct=99;
                    }
                }
                if ($detail) {
                    print "<tr>";
                    print "<td>$so</td>";
                    print "<td>$po</td>";
                    print "<td>$part</td>";
                    print "<td>$quantity</td>";
                    print "<td>$description</td>";
                    print "<td>$ship</td>";
                    print "<td>$due</td>";
                    print "<td>$status</td>";
                    $factor=$pct*2;
                    print "<td><svg width='$factor' height='40'><rect fill='blue' width='$factor' height='40'></rect></svg> $pct %</td>";
                    print "</tr>";
                }
                $lc++;
                $lpct+=$pct;
        }
            $pct=number_format($lpct/$lc,0);
            print "<tr>";
            print "<td>$so</td>";
            print "<td>$po</td>";
            if ($detail) {
                print "<td colspan='3'></td>";
            }
            print "<td>$ship</td>";
            print "<td>$due</td>";
            print "<td>$status</td>";
            print "<td><svg width='$pct' height='40'><rect fill='blue' width='$pct' height='40'></rect></svg> $pct %</td>";
            print "</tr>";
            print "</tbody></table>";
        } else {
            print "<h2>Order Not Found</h2>";
        }
    }
}

print renderClosePanel();
include('footer.php');
?>
