<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

print renderPanel("Custom Material");
$start_date=$_GET['start_date'];
if (! $start_date) {
    $start_date=Date("m/d/Y");
}
$end_date=$_GET['end_date'];
if (! $end_date) {
    $end_date=Date("m/d/Y");
}
$salesOrder="";
if (isset($_GET['sales_order'])) {
    $salesOrder=$_GET['sales_order'];
}
print "<form name='listform' method='GET' action='customMaterialReport.php'>\n";
print renderDateBox(TRUE,"start_date",$start_date,"Start");
print renderDateBox(TRUE,"end_date",$end_date,"End");
print renderTextBox(TRUE,"sales_order",$salesOrder,"Folder");
print renderButton("FIND","success","document.listform.submit();");
print renderButton("EXPORT","primary","exportReport();");
print "</form>\n";
print "<table class='table table-bordered table-striped table-condensed flip-content'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Folder";
print "</th>";
print "<th valign='top'>";
print "Part";
print "</th>";
print "<th valign='top'>";
print "Date Expected";
print "</th>";
print "<th valign='top'>";
print "Quantity";
print "</th>";
print "<th valign='top'>";
print "Price";
print "</th>";
print "<th valign='top'>";
print "Extended";
print "</th>";
print "</tr>\n";
print "</thead>";
print "<tbody>";
$sql="select  distinct pl.item_id, pl.description, pl.quantity, pl.price, pl.date_expected, pl.folder_number from order_lines l, orders o, po_lines pl where l.material=141 and l.order_id=o.order_id and o.folder_number=pl.folder_number";
$sd=formatDateWebToDB($start_date);
$ed=formatDateWebToDB($end_date);
if ($salesOrder) {
    $sql.=" and pl.folder_number=? ";
    list($rs,$err)=runIQuery($db,$sql,array("s",$salesOrder));
} else {
    $sql.=" and date(pl.date_expected) >= ? and date(pl.date_expected) <= ? ";
    list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
}
$total=0;
foreach ($rs as $data) {
    set_time_limit(100);
	$item=$data['item_id'];
    $description=$data['description'];
    $folder=$data['folder_number'];
    $dt=formatDateDBToWeb($data['date_expected']);
    $qty=$data['quantity'];
    $price=$data['price'];
    $ext=$qty*$price;
    $total+=$ext;
    print "<tr><td>$folder</td><td>$part $description</td><td>$dt</td><td>$qty</td><td>$price</td><td>" . number_format($ext,2) . "</td></tr>\n";
}
print "<tr>K<td>Total</td><td colspan='4'></td><td>";
print number_format($total,2);
print "</td></tr>\n";
print "</tbody>";
print "</table>";
?>
<script>

	function exportReport() {
		url='customMaterialExport.php?start_date='+document.getElementById('start_date').value+'&end_date='+document.getElementById('end_date').value;
        url=url+'&customer='+document.getElementById('customer').value+'&rand='+Math.random();
        url=url+'&byso=<?=$byso?>';
		window.open(url,'exporter');
	}
    function page_init() {
        $('.datepicker').datepicker();
    }
</script>
</div>
</div>
<?php
include('footer.php');
?>