<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

date_default_timezone_set('America/Detroit');

print renderPanel("Create Items and Orders from Preferred Machine - with Routing and BOM","","green");

if (isset($_POST['quote'])) {
	$quote=strtoupper($_POST['quote']);
	$quote=str_replace("Q","",$quote);
	$customer=$_POST['customer'];
	$category=$_POST['category'];
	$url="http://preferrederp1.com/importSalesOrderAll.php?code=8383&so=$quote&rand=" . rand();
	$itemString=file_get_contents($url);
	$items=explode("\n",$itemString);
	$orderCreated=0;
	print "<table class='table table-striped'><thead><tr><th>Item from Preferred</th><th>Results</th></thead><tbody>";
	foreach ($items as $item) {
		$fields=explode("|",$item);
		if (count($fields)>5) {
			list($customerSent,$po,$due,$order,$vendor,$status,$item,$desc,$qty,$price,$poline,$folder,$class,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$notes_to_customer,$material,$rev,$x,$y,$color_vendor,$color_code,$color_description,$gloss,$texture,$laserSeconds,$bendSeconds,$color_part,$cure_minutes,$plugs,$masking,$usePM)=explode("|",$item);
			if ($x == 0 or $y == 0) {
				$sql="select width, length from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$item));
				if (count($rs)>0) {
					$data=$rs[0];
					$x=$data['width'];
					$y=$data['width'];
				}
			}
			if (trim($item) != "") {
				$sql="select * from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$item));
				print "<tr>";
				if (count($rs)>0) {
					$data=$rs[0];
					$id=$data['item_id'];
					print "<td>";
					print "<a href='editRecipe.php?id=$id' target='_blank'>$item</a>";
					print "Part already in system.<BR>";
				} else {
					## 19 is components
					## 7 is Eaches
					## 4 is active
					## 2172 is Preferred Machine
					## 36 is PC as vendor
					$desc=trim($desc) . " " . $material;
					$desc=trim($desc);
					if ($status == 10) {
						$desc.=" QT: $order";
					}
					if (! $category) {
						$category=20;
						## finished goods
					}
					$cost=$price/1.2;
					// add default cycle count if exists -Josh 02-16-2023
					$sql = "select default_cycle_count from item_categories where category_id=? and default_cycle_count<>0 and not default_cycle_count is null";
					list($crs,$err)=runIQuery($db,$sql,["i",$category]);
					$defaultCCount=0;
					if (count($crs)) {
						$defaultCCount=$crs[0]["default_cycle_count"];
					}

					$sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id, customer_id, width, length, plugs, masking,markup" . ($defaultCCount ? ", cycle_count" : "") . ") ";
					$sql.=" values (?, ?, ?, 7, ?, ?, 4, 0, 0,?,?,?,?,?,20" . ($defaultCCount ? ", ?" : "") . ") ";

					$vars=["sisddiddii",$item,$category,$desc,$price,$cost,$customer,$x,$y,$plugs,$masking];
					if ($defaultCCount) {
						$vars[0].="i";
						$vars[]=$defaultCCount;
					}
					list($rs,$err)=runIQuery($db,$sql,$vars);
					$data=$rs[0];
					$id=$data[0];
					if ($laserSeconds) {
						## create routing for Laser - operation 3123
						$hpp=$laserSeconds/3600;
						$pph=1/$hpp;
						if ($pph > 1000) {
							$pph=1000;
						}
						$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
						$sql.=" values ('Laser', ?, 3123, 181, 181, ?, 1, 1, 'Laser Cut', 10) ";
						list($rrs,$err)=runIQuery($db,$sql,array("sd",$item,$pph));
						$routing=$rrs[0]['id'];
						$sql="select * from items where item_name=?";
						list($mrs,$err)=runIQuery($db,$sql,array("s",$material));
						$mdata=$mrs[0];
						$sheetArea=$mdata['width'] * $mdata['length'];
						$extra=$mdata['laser_part_space'];
						if (count($mrs)> 0) {
							$qtyper=1;
							if ($sheetArea > 0) {
								$x+=$extra;
								$y+=$extra;
								$qtyper=($x*$y)/$sheetArea;
							}
							$sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) ";
							$sql.=" values (?, ?, ?, ?, 10) ";
							list($brs,$err)=runIQuery($db,$sql,array("ssdi",$item,$material,$qtyper,$routing));
						}
					}
					if ($bendSeconds) {
						## add routing for bend - operation 3122
						$seq=10;
						if ($laserSeconds) {
							$seq=20;
						}
						$hpp=$bendSeconds/3600;
						$pph=1/$hpp;
						if ($pph > 1000) {
							$pph=1000;
						}
						$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
						$sql.=" values ('Bend', ?, 3122, 180, 180, ?, 1, 1, 'Bend To Print', $seq) ";
						list($rrs,$err)=runIQuery($db,$sql,array("sd",$item,$pph));
					}

					print "<td>";
					print "<a href='editRecipe.php?id=$id' target='_blank'>$item</a>";
					print "</td><td>";
					print "Item Created in system.";
				}
				print "</td></tr>\n";
			}
			$newStatus=1;
			if ($status == 10) {
				## if quote in PM, make it a quote in PC
				$newStatus=6;
			}
			## create the sales order now
			if (! $orderCreated) {
				$orderCreated=1;
				$sql="select order_id from orders where po_number=? and customer_id=706";
				list($rs,$err)=runIQuery($db,$sql,array("s",$order));
				if (count($rs)>0) {
					$data=$rs[0];
					$newOrder=$data[0];
					print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$newOrder</td><td>ALREADY in the system</td></tr>\n";
				} else {
					if (substr($customerSent,0,7) == "JR Auto" or substr($customerSent,0,6) == "HS Die" or ! $usePM) {
						$attention="";
						$sql="insert into orders (customer_id, order_class, date_due, status, po_number, quickbooks_order_number, salesperson_id, email, phone, notes_to_customer, notes_to_self, ship_name, ship_address, ship_city, ship_state, ship_zip, attention, ship_address2, date_order) ";
						$sql.=" values (706, 2, ?, ?, ?, ?, ?, 'laser@preferredmachinellc.com', '616.272.6334', '', '', ?, ?, ?, ?, ?, ?, '', now()) ";
						## customer is 706 - Preferred Machine
						list($updrs,$err)=runIQuery($db,$sql,array("sisiissssss",$due,$newStatus,$folder,$quote,$userSalesPersonID,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$attention));
					} else {
						$sql="insert into orders (customer_id, order_class, date_due, status, po_number, quickbooks_order_number, salesperson_id, email, phone, notes_to_customer, notes_to_self, ship_name, ship_address, ship_city, ship_state, ship_zip, attention, ship_address2, date_order) ";
						$sql.=" values (706, 2, ?, ?, ?, 0, 0, 'laser@preferredmachinellc.com', '616.272.6334', '', ?, 'Preferred Machine LLC', '6673 Pine Ridge Ct', 'Jenison', 'MI', '49428', 'Matt Huizenga', '', now()) ";
						## customer is 706 - Preferred Machine
						list($updrs,$err)=runIQuery($db,$sql,array("siss",$due,$newStatus,$order,$quote));
					}
					$newOrder=$updrs[0][0];
					print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$newOrder</td><td>Created in the system</td></tr>\n";
				}
			}
			$sql="select * from order_lines where order_id=? and item_id=? and line_status <> 5 ";
			list($rs,$err)=runIQuery($db,$sql,array("is",$newOrder,$item));
			if (count($rs)>0) {
					print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$item</td><td>ALREADY ON Sales Order $newOrder.</td></tr>\n";
			} else {
					$sql="insert into order_lines (order_id, item_id, item_description, quantity, price, po_line, cost, due_date,revision, powder_color, xdimension, ydimension,plugs,masking, line_status) ";
					$sql.=" values (?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?) ";
					list($updrs,$err)=runIQuery($db,$sql,array("issddsdssiddiii",$newOrder,$item,$desc,$qty,$price,$poline,$cost,$due,$rev,$color,$x,$y,$plugs,$masking,$newStatus));
					print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$item</td><td>Added to Sales Order $newOrder</td></tr>\n";
					createJobsForOrder($db,$newOrder);
			}
		}
	}
	print "</tbody></table>";
	if ($newOrder) {
		$fname="SO".$newOrder;
		$fname.="-";
		$fname.=$_FILES['upload1']['name'];
		if (isset($_FILES['upload1']['name'])) {
			if (trim($_FILES['upload1']['name'] != "")) {
				require_once('s3.php');
				$tmpname = $_FILES['upload1']['tmp_name'];

				if (!uploadFile($tmpname, $fname)) {
					print "move error";
				}
			}
		}
		$id=$newOrder;
		include('paintCalculation.php');
	}
}

print "<form name='updform' action='createPCItemsOrders.php' method='POST' enctype='multipart/form-data'>";
print "<p>Enter the FOLDER NUMBER from Preferred Machine, and click Create, the system will go get them and load the items into the database if necessary, then create the Sales Order if it is not a Quote.<p>";
if (! isset($quote)) {
	$quote="";
}
print renderTextBox(TRUE,"quote",$quote,"Machine FOLDER");
if (! isset($customer)) {
	$customer=0;
}
$sql="select customer_id, name from customers order by name='Preferred Machine LLC' desc, name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,0);
$sql="select category_id, category_name from item_categories order by category_name='Finished Good' desc, category_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"category",0,"Category","N",$rs,0);
print renderCheckBox(TRUE,"gray",0,"Paint RAL 7035 if no color sent");
print "Upload PO PDF: <input type='file' name='upload1'>";
print renderButton("Create","green","document.updform.submit();");
print "</form>";
print renderClosePanel();
include('footer.php');