<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

date_default_timezone_set('America/Detroit');

print renderPanel("Create Items and Orders from Preferred Machine Purchase Order","","green");
if (isset($_POST['quote'])) {
	$quote=strtoupper($_POST['quote']);
	$quote=str_replace("Q","",$quote);
	$customer=$_POST['customer'];
	$category=$_POST['category'];
	$url="http://preferrederp1.com/importPurchaseOrder.php?code=8383&so=$quote&rand=" . rand();
	$itemString=file_get_contents($url);
	$items=explode("\n",$itemString);
	$orderCreated=0;
	print "<table class='table table-striped'><thead><tr><th>Item from Preferred</th><th>Results</th></thead><tbody>";
	foreach ($items as $itemfromlist) {
		set_time_limit(100);
		$fields=explode("|",$itemfromlist);
		if (count($fields)>5) {
			list($customerSent,$po,$due,$order,$vendor,$status,$item,$desc,$qty,$cost,$poline,$folder,$class,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$notes_to_customer,$dateOrder,$x,$y,$material,$laserSeconds,$bendSeconds)=explode("|",$itemfromlist);
			$usePM=0;
			$color_code="";
			$plugs=0;
			$masking=0;
			if ($x == 0 or $y == 0) {
				$sql="select width, length from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$item));
				if (count($rs)>0) {
					$data=$rs[0];
					$x=$data['width'];
					$y=$data['width'];
				}
			}
			if (trim($item) != "") {
				if ($item != "PPF") {
					$item=str_replace(" ","",$item);
					$item=str_replace(",","",$item);
					$sql="delete from billofmaterial where parent_item=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$item));
					$sql="delete from routing where parent_part=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$item));
					$sql="delete from items where item_name=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$item));
					print "<tr>";
					## 20 is FG
					## 7 is Eaches
					## 4 is active
					## 2172 is Preferred Machine
					## 36 is PC as vendor
					$price=$cost;
					$desc=trim($desc) . " " . $material;
					$desc=trim($desc);
					#$category=20;
					## figure out the paint price now
					$cost=$price/1.2;
					$sql="select * from items where item_name=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$item));
					if (count($rs)==0) {
						print renderQuery($sql,array("s",$item));

						// add default cycle count if exists -Josh 02-16-2023
						$sql = "select default_cycle_count from item_categories where category_id=? and default_cycle_count<>0 and not default_cycle_count is null";
						list($crs,$err)=runIQuery($db,$sql,["i",$category]);
						$defaultCCount=0;
						if (count($crs)) {
							$defaultCCount=$crs[0]["default_cycle_count"];
						}

						$sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id, customer_id, width, length, plugs, masking,vendor_part_number,markup" . ($defaultCCount ? ", cycle_count" : "") . ") ";
						$sql.=" values (?, ?, ?, 7, ?, ?, 4, 0, 0,?,?,?,?,?,'',20" . ($defaultCCount ? ", ?" : "") . ") ";

						$vars=["sisddiddii",$item,$category,$desc,$price,$cost,$customer,$x,$y,$plugs,$masking];
						if ($defaultCCount) {
							$vars[0].="i";
							$vars[]=$defaultCCount;
						}
						list($rs,$err)=runIQuery($db,$sql,$vars);
						$data=$rs[0];
						$id=$rs[0]['id'];
						print "<td>";
						print "<a href='editRecipe.php?id=$id' target='_blank'>$item</a>";
						print "</td><td>";
						print "Item Created in system.";
					} else {
						$data=$rs[0];
						$id=$data['item_id'];
						$desc=$data['item_description'];
						print "<td>";
						print "<a href='editRecipe.php?id=$id' target='_blank'>$item</a>";
						print "</td><td>";
						print "Item Exists in system.";
					}
					if ($laserSeconds) {
						## create routing for Laser - operation 3123
						$hpp=$laserSeconds/3600;
						if ($hpp > 0) {
							$pph=1/$hpp;
						}
						if ($pph > 1000) {
							$pph=1000;
						}
						$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
						$sql.=" values ('Laser', ?, 3123, 181, 181, ?, 1, 1, 'Laser Cut', 10) ";
						list($rrs,$err)=runIQuery($db,$sql,array("sd",$item,$pph));
						$routing=$rrs[0]['id'];
						$sql="select * from items where item_name=?";
						list($mrs,$err)=runIQuery($db,$sql,array("s",$material));
						if (count($mrs)> 0) {
							$mdata=$mrs[0];
							$sheetArea=$mdata['width'] * $mdata['length'];
							$extra=$mdata['laser_part_space'];
							$qtyper=1;
							if ($sheetArea > 0) {
								$x+=$extra;
								$y+=$extra;
								$qtyper=($x*$y)/$sheetArea;
							}
							$sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) ";
							$sql.=" values (?, ?, ?, ?, 10) ";
							list($brs,$err)=runIQuery($db,$sql,array("ssdi",$item,$material,$qtyper,$routing));
						}
					}
					if ($bendSeconds) {
						## add routing for bend - operation 3122
						$seq=10;
						if ($laserSeconds) {
							$seq=20;
						}
						$hpp=$bendSeconds/3600;
						if ($hpp > 0) {
							$pph=1/$hpp;
						}
						if ($pph > 1000) {
							$pph=1000;
						}
						$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
						$sql.=" values ('Bend', ?, 3122, 180, 180, ?, 1, 1, 'Bend To Print', $seq) ";
						list($rrs,$err)=runIQuery($db,$sql,array("sd",$item,$pph));
					}
				} else {
					print "PPF Noted";
				}
				print "</td></tr>\n";
				$newStatus=1;
				## create the sales order now
				if (! $orderCreated) {
					$orderCreated=1;
					$sql="select order_id from orders where po_number=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$order));
					if (count($rs)>0) {
						$data=$rs[0];
						$newOrder=$data[0];
						print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$newOrder</td><td>ALREADY in the system</td></tr>\n";
					} else {
						$attention="";
						$newStatus=1;
						$sql="insert into orders (customer_id, order_class, date_due, status, po_number, quickbooks_order_number, salesperson_id, email, phone, notes_to_customer, notes_to_self, ship_name, ship_address, ship_city, ship_state, ship_zip, attention, ship_address2, date_order) ";
						$sql.=" values (706, 3, ?, ?, ?, ?, ?, 'laser@preferredmachinellc.com', '616.272.6334', '', ?, ?, ?, ?, ?, ?, ?, '', now()) ";
						## customer is 706 - Preferred Machine
						$notes_to_self=str_replace("[n]","\n",str_replace("[b]"," ",$data['notes_to_customer']));
						list($updrs,$err)=runIQuery($db,$sql,array("siiiisssssss",$due,$newStatus,$po,$quote,$userSalesPersonID,$notes_to_self,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$attention));
						$newOrder=$updrs[0][0];
						print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$newOrder</td><td>Created in the system</td></tr>\n";
					}
				}
				$rev="";
				$price=$cost;
				$cost=calculateCost($db,$item);
				$plugs=0;
				$masking=0;
				$color=0;
				$sql="select * from order_lines where order_id=? and item_id=? and line_status <> 5 ";
				list($rs,$err)=runIQuery($db,$sql,array("is",$newOrder,$item));
				if (count($rs)>0) {
						print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$item</td><td>ALREADY ON Sales Order $newOrder.</td></tr>\n";
				} else {
						$sql="insert into order_lines (order_id, item_id, item_description, quantity, price, po_line, cost, due_date,revision, powder_color, xdimension, ydimension,plugs,masking, line_status) ";
						$sql.=" values (?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?) ";
						list($updrs,$err)=runIQuery($db,$sql,array("issddsdssiddiii",$newOrder,$item,$desc,$qty,$price,$poline,$cost,$due,$rev,$color,$x,$y,$plugs,$masking,$newStatus));
						print "<tr><td><a href='editOrders.php?id=$newOrder' target='_blank'>$item</td><td>Added to Sales Order $newOrder</td></tr>\n";
				}
				CreateJobsForOrder($db,$newOrder);
			}
		}
	}
	print "</tbody></table>";
	if ($newOrder) {
		$fname="SO".$newOrder;
		$fname.="-";
		$fname.=$_FILES['upload1']['name'];
		if (isset($_FILES['upload1']['name'])) {
			if (trim($_FILES['upload1']['name'] != "")) {
				require_once('s3.php');
				$tmpname = $_FILES['upload1']['tmp_name'];

				if (!uploadFile($tmpname, $fname)) {
					print "move error";
				}
			}
		}
		$id=$newOrder;
	}
}

print "<form name='updform' action='createPWItemsOrders.php' method='POST' enctype='multipart/form-data'>";
print "<p>Enter the Purchase Order number from Preferred Machine, and click Create, the system will go get them and load the items into the database if necessary, then create the Sales Order.<p>";
if (! isset($quote)) {
	$quote="";
}
print renderTextBox(TRUE,"quote",$quote,"Purchase Order");
if (! isset($customer)) {
	$customer=0;
}
// add inactive customers code -Josh 02/20/2023
$sql="select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name='Preferred Machine LLC' desc, name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,0);
$sql="select category_id, category_name from item_categories where category_name in ('Components','Finished Good','Laser Cut') order by category_name='Laser Cut' desc, category_name='Finished Good' desc,  category_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"category",0,"Category","N",$rs,0);
print "Upload PO PDF: <input type='file' name='upload1'>";
print renderButton("Create","green","document.updform.submit();");
print "</form>";
print renderClosePanel();
include('footer.php');