<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$reminderMessage="";
$reminderStatus=1;
$remindThisPerson=0;
$reminderRecipients=[];

## 1. get order id and customer id from editOrders
## 2. user fills out form
## 3. collect post data and insert into order_reminders, employee_reminders, repeat_reminders


## bdoss get the order id
if (isset($_POST['order'])) {
    $order=$_POST['order'];
} elseif (isset($_GET['order'])) {
    $order=$_GET['order'];
} else {
    $order=0;
}
## bdoss get the customer id
if (isset($_POST['customer'])) {
    $customer=$_POST['customer'];
} elseif (isset($_GET['customer'])) {
    $customer=$_GET['customer'];
} else {
    $customer=0;
}

## after form has been submitted, look for form data
if (isset($_POST['reminder_message'])) {
    $reminderMessage=$_POST['reminder_message'];
    $reminderStatus=$_POST['reminder_status'];
    $reminderRecipients=$_POST['employees'];
    if (isset($_POST['repeat_reminder'])) {
        $repeat = 1;
    } else {
        $repeat = 0;
    }

    ## bdoss handle insert into order_reminders table
    $sql="INSERT INTO order_reminders (order_id,order_status,customer,repeat_reminder,reminder_message,created_on)
            VALUES (?,?,?,?,?,now())";
    list($rs,$err)=runIQuery($db,$sql,array("iiiis",$order,$reminderStatus,$customer,$repeat,$reminderMessage));
    
    ## get the id of last query
    $sql="SELECT LAST_INSERT_ID()";
    list($rs,$err)=runIQuery($db,$sql);
    $reminderID=$rs[0][0];
    ## insert employees into employee_reminders table
    foreach($reminderRecipients as $recipient) {
       $sql="INSERT INTO employee_reminders (reminder_id, employee_id)
                VALUES (?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
    }

    ## if it's being added as repeat reminder, add it to the repeat_reminders table too
    if ($repeat) {
        $sql="INSERT INTO repeat_reminders (customer,order_status,reminder_message)
            VALUES (?,?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("iis",$customer,$reminderStatus,$reminderMessage));
    }
}

print renderPanel("Create New Order Reminder","Create New Order Reminder","primary","span11");

print "<h3>Create a new reminder for order $order and customer $customer.</h3>";

print "<form name='order_reminder' action='createOrderReminders.php' method='POST'>"; ## Beginning of Form
print "<input type='hidden' id='order' name='order' value=$order>";
print "<input type='hidden' id='customer' name='customer' value=$customer>";
print renderTextArea(TRUE, "reminder_message", $reminderMessage, "Reminder Message");
## bdoss I only want statuses that appear in the order_status_update table as a new_status, otherwise the message may never be sent if it's not a status the updateOrderStatus() touches
$sql="SELECT DISTINCT new_status, status_name FROM order_status_update INNER JOIN order_status ON order_status.status_id=order_status_update.new_status ORDER BY new_status";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"reminder_status",$reminderStatus,"Reminder Status","N",$rs);
## CHECKBOXES
print "<br><div id='checkbox_container'>";
$sql="SELECT employee_id, CONCAT(first_name, ' ', last_name) AS employee_name FROM employees WHERE inactive!=1 AND employee_email IS NOT NULL ORDER BY employee_name";
list($rs,$err)=runIQuery($db,$sql);
foreach($rs as $data) {
    $employeeID=$data['employee_id'];
    $employeeName=$data['employee_name'];
    print "<input type='checkbox' value='$employeeID' name='employees[]' id='$employeeID'>$employeeName <br />";
}
print "</div>";
print "<input type='checkbox' name='repeat_reminder' id='repeat_reminder' value='1' > Check for repeat reminders <br />";
print renderButton("Submit","success","document.order_reminder.submit();");
print "</form>"; # #End of Form


print renderClosePanel();
include('footer.php');
?>

<style>
    #checkbox_container {
        border:2px solid #ccc; 
        width:300px; 
        height: 150px; 
        overflow-y: scroll; 
    }

    
</style>

<script>

  
</script> 