<?php
#error_reporting(E_ALL);
#ini_set('display errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');
function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='pipe') {
		$fields=explode("|",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}
date_default_timezone_set('America/Detroit');
$customer=693;
$salesPerson=4; ## Joe Espinoza
$category=17; ## Laser Cut
if (isset($_POST['uploaded'])) {
	$fileType="tab";
    $fname=$_FILES['leads']['tmp_name'];
	$fp=fopen($fname,"r");
	$header=fgets($fp); // actual header
	$nextPart=0;
	$soNumber = 0;
    $weldments=array();
    list($rs,$err)=runIQuery($db,$sql);
    if ($fname) {
        while (!feof($fp)) {
            set_time_limit(100);
            $line=trim(fgets($fp));
            if ($line) {
                if (substr($line,0,4) != "Item") {
                    $cntr++;
                    $fields=array();
                    $fields=parseRecord($line,$fileType);
                    $itemName=strtoupper($fields[0]);
                    $qoh=$fields[1];
                    $description=$fields[2];
                    $drawing=$fields[3];
                    $hasBend=$fields[4];
                    $location=1;
                    $uom=1;
                    $price=0;
                    $cost=0;
                    $width=$fields[31];
                    $height=0;
                    $material=$fields[33];
                    $thickness=$fields[34];
                    $length=$fields[35];
                    $sql="select * from items where item_name=?";
                    list($rs,$err)=runIQuery($db,$sql,array("s",$material));
                    $data=$rs[0];
                    $mlength=$data['length'];
                    $mwidth=$data['width'];
                    $partArea=$length * $width;
                    $materialArea=$mlength * $mwidth;
					$qtyper=1;
					if ($materialArea > 0) {
                    $qtyper=round($partArea/$materialArea,4);
					}

                    // add default cycle count if exists -Josh 02-16-2023
                    $sql = "select default_cycle_count from item_categories where category_id=17 and default_cycle_count<>0 and not default_cycle_count is null";
                    list($crs,$err)=runIQuery($db,$sql);
                    $defaultCCount=0;
                    if (count($crs)) {
                        $defaultCCount=$crs[0]["default_cycle_count"];
                    }
                    ## 7 is ea
                    $sql="insert into items (item_name, item_category, item_description, unit_of_measure, cost, status, quantity_on_hand,salesperson_id, length, width, customer_id" . ($defaultCCount ? ", cycle_count" : "") . ") ";
                    $sql.=" values (?, 17, ?, 7, 0, 4, 0, 4, ?, ?, 693" . ($defaultCCount ? ", ?" : "") . ") ";

                    $vars=["ssdd",$itemName,$description,$length,$width];
                    if ($defaultCCount) {
                        $vars[0].="i";
                        $vars[]=$defaultCCount;
                    }
                    list($rs,$err)=runIQuery($db,$sql,$vars);
                    print renderQuery($sql,$vars);
                    print "<hr>";
                    ## 3122 is bend, 3123 is laser, etc.
                    ## always add laser
                    $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                    $sql.=" values ('Laser',?,3123, 181, 316, 0, 1, 1, 'Laser Cut', 10) ";
                    list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
                    $data=$rs[0];
                    $laserRouting=$data['id'];
                    if ($hasBend) {
                        $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                        $sql.=" values ('Bend',?,3122, 180, 315, 0, 1, 1, 'Bend To Print', 20) ";
                        list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
                    }
                    if ($material) {
                        $sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) values (?, ?, ?, ?, 10) ";
                        list($rs,$err)=runIQuery($db,$sql,array('ssdi',$itemName,$material,$qtyper,$laserRouting));
                    }
                }
            }
        }
        print "<center><h3>$cntr Record(s) Processed</h3></center>";
        fclose($fp);
    } else {
        print "<h3>No File Browsed</h3>";
    }
	include('footer.php');
	exit;
}
if (! $uploaded) {
?>
<center>
<form name='updform' action='createLaserItems.php' method='POST' enctype="multipart/form-data">
<input type='hidden' name='uploaded' value='1'>
<h3>Upload Text Tab File to create Laser Items</h3>
<p>DO NOT USE THIS PROGRAM IF YOU DO NOT KNOW WHAT IT DOES</p>
<input type='file' name='leads'>
<br>
<input type='submit' class='btn blue' value='Upload'>
</form>
</center>
<?php
} ## if not uploaded yet uploaded
include('footer.php');
?>