<?php
#error_reporting(E_ERROR);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

$id='';
if (isset($_POST['count_date'])) {
	$dt=formatDateWebtoDB($_POST['count_date']);
	$who=$_POST['assigned_to'];
	$sql="insert into cycle_counts (count_date, posted, who)  values (?, 0, ?)";
	list($rs,$err)=runIQuery($db,$sql,array("si",$dt, $who));
	$id=$rs[0]['id'];
	$stamped=0;
	$category=0;
	if (isset($_POST['stamped'])) {
		$stamped=$_POST['stamped'];
	}	
	if (isset($_POST['category'])) {
		$category=$_POST['category'];
	}	
	## establish baselines
	$categories=array();
	$caps=array();
	$dates=array();
	$freq=array();
	$sql="select ccc_id, frequency, count(*) from cycle_count_categories c, items i where ccc_id=cycle_count  and i.status=4 ";
	if ($stamped) {
		$sql.=" and item_name in (select part_number from stamped_inventory)  ";
	} else {
		$sql.=" and item_name NOT in (select part_number from stamped_inventory)  ";
	}
	if ($category) {
		$sql.=" and item_category = ? ";
		$sql.=" group by ccc_id, frequency";	
		list($rs,$err)=runIQuery($db,$sql,array("i",$category));
	} else {
		$sql.=" and item_category not in (16, 20, 22, 23, 24, 26) ";
		$sql.=" group by ccc_id, frequency";	
		list($rs,$err)=runIQuery($db,$sql);
	}
	foreach ($rs as $data) {
		$cid=$data['ccc_id'];
		$categories[]=$cid;
		$frequency=$data['frequency'];
		// This is Daily
		$factor=1;
		$datediff=0;
		if ($frequency == 'Monthly') {
			$factor=20; // we count some every day
			$datediff=28;
		}
		if ($frequency == 'Weekly') {
			$factor=5;
			$datediff=7;
		}
		if ($frequency == 'Bi-Weekly') {
			$factor=10;
			$datediff=14;
		}
		if ($frequency == 'Quarterly') {
			$factor=65;
			$datediff=90;
		}
		if ($frequency == 'Bi-Annual') {
			$factor=125;
			$datediff=180;
		}
		if ($frequency == 'Annual') {
			$factor=250;
			$datediff=360;
		}
		$caps[$cid] = round($data[2] / $factor);
		if ($caps[$cid] < 1) {
			$caps[$cid] = 1;
		}
		$dates[$cid] = $datediff;
		$freq[$cid] = $frequency;
	}	
	## find the parts and insert them
	foreach ($categories as $cat) {
		$sql="select item_id, quantity_on_hand from items i, cycle_count_categories c where ccc_id=cycle_count  and ccc_id=? and i.status=4 ";
		if ($stamped) {
			$sql.=" and item_name in (select part_number from stamped_inventory)  ";
		} else {
			$sql.=" and item_name NOT in (select part_number from stamped_inventory)  ";
		}
		if ($category) {
			$sql.=" and item_category = ? ";
		} else {
			$sql.=" and item_category not in (16, 20, 22, 23, 24, 26) ";
		}	
		$dtdiff=$dates[$cat] * -1;
		$sql.=" and item_id not in (select item_id from cycle_count_items ci, cycle_counts n where ci.cc_id=n.cc_id and count_date > DATE_ADD(?, INTERVAL $dtdiff DAY)) ";			
		$limit=$caps[$cat];
		if ($limit <= 1) {
			$limit=2;
		}
		$sql.=" LIMIT $limit";
		if ($category) {
			list($rs,$err)=runIQuery($db,$sql,array("iis",$cat,$category,$dt));
		} else {
			list($rs,$err)=runIQuery($db,$sql,array("is",$cat,$dt));
		}	
		$frequency=$freq[$cat];
		foreach ($rs as $data) {
			$item=$data['item_id'];
			$qty=$data['quantity_on_hand'];
			$sql="insert into cycle_count_items (cc_id, item_id, quantity) values (?, ?, ?) ";
			list($updrs,$err)=runIQuery($db,$sql,array("iii", $id, $item, $qty));
		}
	}
}
?>
<script type="text/javascript">

if(!Array.prototype.indexOf) {
    Array.prototype.indexOf = function(needle) {
        for(var i = 0; i < this.length; i++) {
            if(this[i] === needle) {
                return i;
            }
        }
        return -1;
    };
}

</script>
<?
print renderPanel("Create Cycle Count","","yellow","span11","check-square");
print "<form name='updform' id='updform' action='createCycleCount.php' method='post'>";
print renderDateBox(TRUE,"count_date",Date("m/d/Y"),"Count Date");
$stamped=0;
if (strtolower($userEmail)=="clangeland@preferredmachinellc.com") {
	$stamped=1;
}
print renderCheckBox(TRUE,"stamped",$stamped,"Stamped Inventory");
$sql="select category_id, category_name from item_categories where category_id in (20, 22, 24, 26) order by category_name ";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"category",$category,"Only This Category","N",$rs,1);
$sql="select user_id, full_name from site_admins where email not like 'laser%' order by full_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"assigned_to",$userID,"Assigned To","N",$rs);
print "<div class='btn btn-success' onclick='createCount();'>Create Cycle Count</div>";
print "</form>";
print renderClosePanel();
?>
<script>
	function createCount() {
		document.updform.submit();
	}
	
	function redirect() {
		//document.location.href='editCycleCount.php?id=<?=$id?>';
	}
	function countCreated() {
		setTimeout(function() { redirect(); }, 3000);
		$.gritter.add("Cycle Count Created");
	}
	if ('<?=$id?>' != '' ) {
		countCreated();
	}
</script>	
<?	
include('footer.php');
?>