<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

if (! isset($_POST['id'])) {
    $_POST=$_GET;
}
$parent=$_POST['id'];
$customer=$_POST['customer'];
$sql="select item_name from items where item_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$parent));
$data=$rs[0];
$parentName=$data['item_name'];

date_default_timezone_set('America/Detroit');

print renderPanel("Create Weld BOM from Preferred Machine","","green");

$sql="select routing_id, operation_name from routing r, operations o where parent_part=? and r.operation_id=o.operation_id order by operation_name";
list($oprs,$err)=runIQuery($db,$sql,array("s",$parentName));
$oplist=array();
foreach ($oprs as $opdata) {
    $r=$opdata['routing_id'];
    $op=$opdata['operation_name'];
    $oplist[$r]=$op;
}
if (isset($_POST['create'])) {
    ## create the BOM
    $rowCount=$_POST['rowcount'];
    $i=0;
    print "<table class='table table-striped'><thead><tr><th>Part</th><th>Quantity Per</th><th>Operation</th></tr>\n</thead><tbody>";
    while ($i < $rowCount) {
        $i++;
        $child=$_POST['part'.$i];
        $qtyper=$_POST['qty'.$i];
        $routing=$_POST['op'.$i];
        $markup=$_POST['markup'.$i];
        $pct=1 + ($markup /100);
        $sql="update items set price = cost * $pct where item_name=?";
        list($rs,$err)=runIQuery($db,$sql,array("s",$child));
        if ($qtyper > 0) {
            $seq=$i*10;
            $sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) values (?, ?, ?, ?, ?) ";
            list($rs,$err)=runIQuery($db,$sql,array("ssdii",$parentName,$child,$qtyper,$routing,$seq));
            print "<tr><td>$child</td><td>$qtyper</td><td>" . $oplist[$routing] . "</td></tr>\n";
        }
    }
    print "</tbody></table>\n";
}
if (isset($_POST['quote'])) {
	$quote=strtoupper($_POST['quote']);
	$quote=str_replace("Q","",$quote);
    print "<h3>Creating BOM Under $parentName</h3>";
	$url="http://preferredmachineproduction-env.eba-msgmf3n9.us-east-1.elasticbeanstalk.com/listSalesOrder.php?code=8383&so=$quote&rand=" . rand();
	$itemString=file_get_contents($url);
	$items=explode("\n",$itemString);
	$orderCreated=0;
    print "<form name='updform' action='createBOM.php' method='POST'>";
    print "<input type='hidden' name='id' value='$parent'>";
	print "<table class='table table-striped'><thead><tr><th>Item from Preferred</th><th>QTY Per</th><th>Markup %</th><th>Operation</th></thead><tbody>";
    $i=0;
	foreach ($items as $item) {
		$fields=explode("|",$item);
		if (count($fields) > 19) {
			list($customerSent,$po,$due,$order,$item,$desc,$qty,$cost,$poline,$folder,$class,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$notes_to_customer,$material,$orderDate,$color_vendor,$color_code,$color_description,$gloss,$texture,$color_part,$cure_minutes,$x,$y)=explode("|",$item);
		} else {
			list($customerSent,$po,$due,$order,$item,$desc,$qty,$cost,$poline,$folder,$class,$ship_name,$ship_address,$ship_city,$ship_state,$ship_zip,$notes_to_customer,$material,$orderDate,$x,$y)=explode("|",$item);
			$color_code="";
		}
		if (trim($item) != "") {
            $i++;
			print "<tr>";
            print "<td>";
            print $item;
            print "<input type='hidden' name='part$i' id='part$i' value='$item'>";
            print "</td>";
            print "<td>";
            print "<input type='text' name='qty$i' id='qty$i' value='1'>";
            print "</td>";
            print "<td>";
            print "<input type='text' name='markup$i' id='markup$i' value='20'>";
            print "</td>";
            print "<td>";
            reset($oprs);
            print "<select name='op$i' id='op$i'>";
            foreach ($oprs as $opdata) {
                print "<option value='" . $opdata['routing_id'] . "' ";
                if ($opdata['operation_name']=="Assembly") {
                    print " selected ";
                }
                print ">"  . $opdata['operation_name'] . "</option>";
            }
            print "</select>";
            print "</td>";
            print "</tr>\n";
			$sql="select * from items where item_name=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$item));
            if (count($rs)==0) {
				## 19 is components
				## 7 is Eaches
				## 4 is active
				## 2172 is Preferred Machine
                ## default margin is set in security.php at the bottom
				$factor=$defaultMargin/100;
				$factor+=1;
				$price=round($cost * $factor *10000)/10000;
				$desc=trim($desc) . " " . $material;
				$desc=trim($desc);
				$desc.=" QT: $quote";

                // add default cycle count if exists -Josh 02-16-2023
                $sql = "select default_cycle_count from item_categories where category_id=19 and default_cycle_count<>0 and not default_cycle_count is null";
                list($crs,$err)=runIQuery($db,$sql);
                $defaultCCount=0;
                if (count($crs)) {
                    $defaultCCount=$crs[0]["default_cycle_count"];
                }

				$sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id, customer_id,width,length" . ($defaultCCount ? ", cycle_count" : "") . ") ";
				$sql.=" values (?, 19, ?, 7, ?, ?, 4, 0, 2172,?,?,?" . ($defaultCCount ? ", ?" : "") . ") ";
                $vars = ["ssddidd",$item,$desc,$price,$cost,$customer,$x,$y];
                if ($defaultCCount) {
                    $vars[0].="i";
                    $vars[]=$defaultCCount;
                }
				list($rs,$err)=runIQuery($db,$sql,$vars);
				$data=$rs[0];
				$id=$data[0];
			}
		}
	}
    print "<tr><td><input type='hidden' name='create' id='create' value='1'><input type='hidden' name='rowcount' id='rowcount' value='$i'><input type='hidden' name='customer' id='customer' value='$customer'>";
    print renderButton("Create BOM","green","document.updform.submit();");
    print "</td></tr>\n";
    print "</tbody></table>";
    print "</form>";
} else {
    print "<p>If you do not want a given part in the BOM, put 0 in the quantity per.</p>";
    print "<form name='updform' action='createBOM.php' method='POST'>";
    print "<input type='hidden' name='id' value='$parent'>";
    print "<p>Enter the Quote number (less the Q) from Preferred Machine, and click Manage BOM, the system will go get them and present a screen for you to set the BOM.<p>";
    print renderTextBox(TRUE,"quote",$quote,"Quote");
    $sql="select customer_id, name from customers order by name";
    $rs=mysqli_query($db,$sql);
    print renderSelect(TRUE,"customer",0,"Customer","N",$rs,0);
    print renderButton("Manage BOM","green","document.updform.submit();");
    print "</form>";
}
print renderClosePanel();
include('footer.php');