<?php
include('dbConnection.php');
include('security.php');
include('functions.php');

if (isset($_POST['bay'])) {
    $bayID = $_POST['bay'];
}

if (isset($_POST['order'])) {
    $order = $_POST['order'];
}

if (isset($_POST['type'])) {
    $bayType = $_POST['type'];
}

// use bay type to determine how to update the order

// update order status

// reset the staging bay
$sql = "UPDATE staging_bays 
SET order_id=0,full=0,date_loaded=NULL
WHERE bay_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$bayID));

// insert into staging_bay_history
$sql = "SELECT item_id, (SUM(quantity) * -1) AS qty, line_id, pallet_id, job_id FROM staging_bay_contents WHERE bay_id=? GROUP BY item_id";
list($staging_rs,$staging_data)=runIQuery($db,$sql,array("i",$bayID));
foreach($staging_rs AS $staging_data) {
    $item=$staging_data['item_id'];
    $qty=$staging_data['qty'];
    $line=$staging_data['line_id'];
    $pallet=$staging_data['pallet_id'];
    $job=$staging_data['job_id'];

    $sql = "INSERT INTO staging_bay_history (bay_id,date_history,item_id,quantity,order_number,line_id,`action`,pallet_id,`user_id`,job_id)
    VALUES (?,now(),?,?,?,?,'CLEAR',?,?,?)";
    list($rs,$err)=runIQuery($db,$sql,array("isiiiiii",$bayID,$item,$qty,$order,$line,$pallet,$userID,$job));
}

// delete from staging bay contents
$sql="DELETE FROM staging_bay_contents WHERE bay_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$bayID));

// update pallets table
$sql = "SELECT pallet_id FROM pallets WHERE assigned_bay=? AND order_id=? AND cleared_from_bay IS NULL";
list($pallets_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));
foreach($pallets_rs AS $pallets_data) {
    $palletID=$pallets_data['pallet_id'];

    if ($bayType == 2 || $bayType == 4 || $bayType == 3) { ## weldments wouldn't go to shipping
        $sql = "UPDATE pallets SET complete=1, cleared_from_bay=1, last_touched_by_user=?, updated_at=now() WHERE pallet_id=?";
    } else {
        $sql = "UPDATE pallets SET current_location='shipping', complete=1, cleared_from_bay=1, last_touched_by_user=?, updated_at=now() WHERE pallet_id=?";
    }
    list($rs,$err)=runIQuery($db,$sql,array("ii",$userID,$palletID));

    // update pallets_have_parts
    $sql="UPDATE pallets_have_parts SET cleared=1,updated_at=now(), cleared_by=? WHERE pallet_id=? AND order_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("iii",$userID,$palletID,$order));
    
}

?>