<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$start = date("m/d/Y", strtotime('-1 month'));
$end = date("m/d/Y");
if (isset($_GET["start"])) {
    $start = $_GET["start"];
}
if (isset($_GET["end"])) {
    $end = $_GET["end"];
}

$wvars = [];
$wadsql = "";
$wscript = "0";
if (isset($_GET["script"])) {
    $wscript = $_GET["script"];
    if ($wscript != "0") {
        $wadsql = " where change_script=? ";
        $wvars = ["s",$wscript];
    }
}

$emp = 0;
if (isset($_GET["emp"]))  {
    $emp = $_GET["emp"];
}

print renderPanel("Changes Seen","","blue");

//script, date
print "<form name='seenform' id='seenform' action='changeSeen.php' method='GET'>";

    print "<div class='span3'><div class='control-group span11'><label class='control-label' for='script'>Which Page</label><div class='controls'>
        <select name='script' id='script'>";

        print "<option value='0'>All</option>";
        $sql = "select change_script from change_log cl, change_seen cs where cl.change_id=cs.change_id and date_changed >=? and date_changed <= ? group by change_script order by change_script";
        list($rs,$err)=runIQuery($db,$sql,["ss",date("Y-m-d", strtotime($start)),date("Y-m-d", strtotime($end))]);
        foreach ($rs as $scr) {
            $scr = $scr["change_script"];
            print "<option value='$scr' " . ($wscript == $scr ? "selected" : "")  . ">$scr</option>";
        }

        print "</select></div></div></div>";

        print "<div class='span3'><div class='control-group span11'><label class='control-label' for='emp'>Which Employee</label><div class='controls'>
        <select name='emp' id='emp'>";

        print "<option value='0'>All</option>";
        $sql = "select employee_id, first_name, last_name from employees where inactive=0 order by first_name, last_name";
        list($rs,$err)=runIQuery($db,$sql);
        foreach ($rs as $data) {
            $name = $data["first_name"] . " " . $data["last_name"];
            $id = $data["employee_id"];
            print "<option value='$id' " . ($emp == $id ? "selected" : "")  . ">$name</option>";
        }

        print "</select></div></div></div>";

        print renderDateBox("From", "start", $start, "From");
        print renderDateBox("To", "end", $end, "To");

        print "<button type='button' class='btn blue' onclick='document.seenform.submit();'><i class='icon-filter'></i> Filter</button>";

print "</form><br>";

$sql = "select concat(e.first_name, ' ', e.last_name) as full_name, cl.change_description, cl.change_script, cs.seen_date from employees e, change_seen cs, change_log cl where cs.change_id=cl.change_id and cs.employee_id=e.employee_id and date_changed >=? and date_changed <= ?";
$vars = ["ss",date("Y-m-d", strtotime($start)),date("Y-m-d", strtotime($end))];

if ($wscript) {
    $sql .= " and cl.change_script=?";
    $vars[0] .= "s";
    $vars[] = $wscript;
}

if ($emp) {
    $sql .= " and e.employee_id=?";
    $vars[0] .= "i";
    $vars[] = $emp;
}

print "<table class='table table-bordered table-striped' id='changes'>";

print "<thead>";
    print "<tr>";
        print "<th>Which Page</th>";
        print "<th>Description</th>";
        print "<th>Who</th>";
        print "<th>When</th>";
    print "</tr>";
print "</thead>";

$i = 0;
list($rs,$err) = runIQuery($db,$sql,$vars);
foreach ($rs as $change) {
    $script = $change["change_script"];
    $desc = $change["change_description"];
    $who = $change["full_name"];
    $when = date("m/d/Y h:i A", strtotime($change["seen_date"]));

    $color = $i%2 == 1 ? "white" : "#f9f9f9";
    print "<tr>";
        print "<td>$script</td>";
        print "<td>$desc</td>";
        print "<td>$who</td>";
        print "<td>$when</td>";
    print "</tr>";
    $i++;
}

print "</table>";

print renderClosePanel();

include('footer.php');