<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
?>
<style>
.invalid {
    background: #ff9a9a !important;
}
</style>
<?php
if (!$isAdmin) {
    print "<h3>You must be an Admin to create a changelog!</h3>";
}

//TODO: editing existing changes?

if (isset($_POST["change_script"])) { // form cannot be submitted with empty results so we can rely on just checking one thing
    $script = $_POST["change_script"];
    $elms = $_POST["change_elements"];
    $by = $_POST["changed_by"];
    $until = $_POST["show_until"];
    $times = $_POST["show_times"];
    $desc = $_POST["change_description"];

    $sql = "insert into change_log (change_script, change_elements, show_until, show_times, change_description, changed_by) values (?, ?, ?, ?, ?, ?)";
    list($rs,$err) = runIQuery($db,$sql,["sssiss",$script,$elms,formatDateWebToDB($until),$times,$desc,$by]);
    $cid=0;
    if (count($rs)) {
        $cid = $rs[0][0];
    }

    if ($cid) {
        $bottomScript .= "window.open('changeLog.php?id=$cid', '_blank');"; // We're going here to verify that the change was pushed
    } else {
        print_r($err);
    }
}

print renderPanel("Create new Change Log", "", "red");

print "<form name='changeform' id='changeform' action='changeLogNew.php' method='POST'>";

    print "<h5>If you want to just add to the change log without alerting users on the page, either set the date to before today OR set 'Show How Many Times' to 0</h5>";
    print "<br>";

    print renderTextBox(TRUE,"change_script","","Which Script");
    print renderTextBox(TRUE,"change_elements","","Elements Changed<div style='font-size: 11px;'>jQuery selectors (separated by commas)</div>");
    print renderTextBox(TRUE,"changed_by",$userEmail,"Changed By");
    print renderDateBox(TRUE,"show_until",date("m/d/Y", strtotime("+1 week")),"Show Until");
    print renderTextBox(TRUE,"show_times","3","Show How Many Times");
    print renderTextArea(TRUE,"change_description","","Description");
    print "<div class='control-group span1'>
        <label class='control-label' for=''>‎</label>
        <div class='controls'>
            <button type='button' class='btn green' onclick='SubmitTheForm(); return false;'><i class='icon-star'></i> Create</button>
        </div>
    </div>";

print "</form>";

print renderClosePanel();
?>
<script>
    function SubmitTheForm() {
        var noGo = 0;
        var elms = [$("#change_script"),$("#change_description"),$("#changed_by")];
        for (var i = 0; elms.length > i; i++) {
            var elm = $(elms[i]);
            if (elm.val() == "") {
                noGo = 1;
                elm.addClass("invalid").effect("shake");
            } else {
                elm.removeClass("invalid");
            }
        }

        var script = $("#change_script").val();
        if (script != "" && (!script.endsWith(".php") || script == ".php")) {
            noGo = 1;
            $("label[for=change_script]").addClass("invalid").text("Which Script (Must end with .php!)");
        } else {
            $("label[for=change_script]").removeClass("invalid").text("Which Script");
        }

        if (noGo == 1) {
            $.gritter.add("Please fill out missing or invalid values");
            return;
        }

        document.changeform.submit();
    }
</script>
<?php
include("footer.php");
?>