<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
?>
<style>
    .no-bullets {
        list-style-type: none;
    }
    .indent {
        padding-left: 25px;
    }
</style>
<?php
print renderPanel("Change Log");
$wchange = 0;

if (isset($_GET["change"])) {
    $wchange = $_GET["change"];
}

$count = 0;
if ($wchange) {
    $sql = "select * from change_log where change_id=?";
    list($rs,$err) = runIQuery($db,$sql,["i",$wchange]);
        $count = count($rs);
    if (!count($rs)) {
        print "<h3>Invalid Change ID</h3>";
    }
}

if (!$wchange) {
    $page_size = 30;

    $page = 1;
    if (isset($_GET["page"])) {
        $page = $_GET["page"];
    }

    if ($page == 0 || !is_numeric($page)) {
        $page = 1;
    }



    $wscript = "0";
    $adsql = "";
    $vars = [];
    if (isset($_GET["script"])) {
        $wscript = $_GET["script"];
        if ($wscript != "0") {
            $adsql = " where change_script=? ";
            $vars = ["s",$wscript];
        }

    }

    print "<form name='scriptform' id='scriptform' action='changeLog.php' method='GET'>";

        print "<div class='span3'><div class='control-group span11'><label class='control-label' for='script'>Which Page</label><div class='controls'>
            <select name='script' id='script'>";

            print "<option value='0'>All</option>";
            $sql = "select change_script from change_log group by change_script order by change_script";
            list($rs,$err)=runIQuery($db,$sql);
            foreach ($rs as $scr) {
                print "<option value='" . $scr["change_script"] . "' " . ($wscript == $scr["change_script"] ? "selected" : "")  . ">" . $scr["change_script"] . "</option>";
            }

            print "</select></div></div></div>";

            print "<div class='control-group span1'>
            <label class='control-label' for=''>‎</label>
            <div class='controls'>
                <button type='button' class='btn blue' onclick='document.scriptform.submit();'><i class='icon-filter'></i> Filter</button>
            </div>
        </div>";

    print "</form><br><br><br><br><br>";

    $sql = "select count(*) as count from change_log $adsql";
    list($rs,$err) = runIQuery($db,$sql,$vars);
    $count = 0;
    if (count($rs)) {
        $count = (int) $rs[0]["count"];
    }
}

if ($count != 0) {
    if (!$wchange) {
        $max_page = ceil($count/$page_size);
        $sql = "select * from change_log $adsql order by date_changed desc limit $page_size offset " . ($page_size * ($page-1));
        list($rs,$err) = runIQuery($db,$sql,$vars);
    }

    $days = [];
    foreach ($rs as $change) {
        if (!isset($days[$change["date_changed"]])) {
            $days[$change["date_changed"]] = [$change["change_script"] => []];
        }

        $days[$change["date_changed"]][$change["change_script"]][] = $change["change_description"];
    }

    print "<ul style='margin: 0px;' class='no-bullets'>";
        foreach ($days as $day => $scripts) {
            print "<li><ul class='no-bullets'>";
            print "<h4><b>$day:</b></h4>";
                foreach ($scripts as $script => $changes) {
                    print "<li><ul class='no-bullets'>";
                        print "<h5><b>$script</b></h5>";
                        foreach ($changes as $change) {
                            print "<li class='indent'>$change</li>";
                        }
                    print "</ul></li>";
                }
            print "</ul></li>";
            print "<li></li>";
        }
    print "</ul><br>";

    if (!$wchange) {
        $paginator = "";
        if ($page == 1) {
            $paginator .= "<a class='prev btn grey' onclick=''>Prev Page</a>";
        } else {
            $paginator .= "<a class='prev btn blue' href='changeLog.php?page=" . ($page-1) . "&script=$wscript'>Prev Page</a>";
        }
        if ($page >= $max_page) {
            $paginator .= "<a class='next btn gray' onclick=''>Next Page</a>";
        } else {
            $paginator .= "<a class='next btn blue' href='changeLog.php?page=" . ($page+1) . "&script=$wscript'>Next Page</a>";
        }

        print $paginator;
    }
}


print renderClosePanel();
include("footer.php");
?>