<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Capacity";
include('header.php');
$start = date("U");

$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id where coalesce(under_review,0)=0 and customer_id=693 order by item_name ";
list($rs)=runIQuery($db,$sql);
$itemlist=[];
foreach ($rs as $data) {
    if ($data['status_name'] != 'Active') {
        $itemlist[]=$data['item_name'] . "-" . $data['status_name'];
	} else {
		$itemlist[]=$data['item_name'];
	}
}
$itemcount=count($itemlist);
## close out jobs for orders that have been closed, shipped, or cancelled
$sql="select job_id, o.status from jobs j, order_lines l, orders o where j.status=1 and j.line_id=l.line_id and l.order_id=o.order_id and o.status in (3,4,5) ";
list($rs)=runIQuery($db,$sql);
foreach ($rs as $data) {
    $job=$data['job_id'];
    $status=$data['status'];
    if ($status == 3 or $status == 4) {
        $sql="update jobs set status=2 where job_id=?";
        list($updrs,$err)=runIQuery($db<$sql,array("i",$job));
    } else {
        if ($status == 5) {
            $sql="update jobs set status=3 where job_id=?";
            list($updrs,$err)=runIQuery($db<$sql,array("i",$job));
        }
    }
}
?>
<script>
var itemList=<?=json_encode($itemlist)?>;
</script>

<style>
	.day {
		border: 1px solid black;
		min-width: 100px;
		min-height: 100px;
		width: 100px;
		height: 100px;
	}

/* Tooltip container */
.mytooltip {
  position: relative;
  display: inline-block;
  cursor: pointer;
  border-bottom: 1px dotted black; /* If you want dots under the hoverable text */
}

/* Tooltip text */
.mytooltip .mytooltiptext {
  visibility: hidden;
  width: 300px;
  background-color: black;
  color: #fff;
  text-align: center;
  border-radius: 6px;

  /* Position the tooltip text - see examples below! */
  position: absolute;
  z-index: 1;
}

/* Show the tooltip text when you mouse over the tooltip container */
.mytooltip:hover .mytooltiptext {
  visibility: visible;
}


	ul.ui-autocomplete {
    list-style: none;
    border: 1px solid black;
    background-color: white;
    width: 200px;
}

</style>


<?php
function build_tooltip($item,$qty,$pph,$jobHours,$tooltip) {
	if (! $tooltip) {
		$tooltip="<table style='min-width: 200px;'><tr><td>Part</td><td align='right'>Quantity</td><td align='right'>PPH</td><td align='right'>Hours</td></tr>";
	}
	$qty=round($qty,0);
	$pph=round($pph,0);
	$jobHours=round($jobHours,2);
	$tooltip.="<tr><td>$item</td><td align='right'>$qty</td><td></td><td align='right'>$pph</td><td align='right'>$jobHours</td></tr>";
	return $tooltip;
}

function build_calendar($month,$year) {
    global $db;

    // Create array containing abbreviations of days of week.
	$daysOfWeek = array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
	// What is the first day of the month in question?
	$firstDayOfMonth = mktime(0,0,0,$month,1,$year);
	// How many days does this month contain?
	$numberDays = date('t',$firstDayOfMonth);
	// Retrieve some information about the first day of the
	// month in question.
	$dateComponents = getdate($firstDayOfMonth);
	// What is the name of the month in question?
	$monthName = $dateComponents['month'];
	// What is the index value (0-6) of the first day of the
	// month in question.
	$dayOfWeek = $dateComponents['wday'];
	// Create the table tag opener and day headers
	$calendar = "<table class='table calendar'>";
	$calendar .= "<caption>$monthName $year</caption>";
	$calendar .= "<tr>";

	$backlogHours=[];

    $sql="select item_id, workcenter_id, pph, people, quantity_scheduled, coalesce(quantity_good,0) as good from jobs, routing ";
    $sql.=" where start_date < curdate() and jobs.item_id=routing.parent_part ";
    $sql.=" and workcenter_id in (select workcenter_id from workcenters where capacity_hours > 0 and coalesce(use_in_capacity,0) = 1) ";
    $sql.=" and jobs.status=1 ";
    list($wrs)=runIQuery($db,$sql);
    foreach ($wrs as $wdata) {
        $wc = $wdata["workcenter_id"];
        if (empty($backlogHours[$wc])) {
            $backlogHours[$wc] = 0;
        }

        $pph=$wdata['pph'];
        if ($pph == 0) {
            $pph=5;
        }
        $qty=$wdata['quantity_scheduled'] - $wdata['good'];
        if ($qty < 0) {
            $qty=0;
        }
        $people=$wdata['people'];
        $cap=$pph * $people;
        if ($cap > 0) {
            $jobHours = $qty / $cap;
        } else {
            $jobHours=0;
            error_log("$scriptid something wrong pph or people 0 for $wc " . $wdata['item_id']);
        }
        $jobHours += .5;
        $jobHours=round($jobHours,2);
        $backlogHours[$wc]+=$jobHours;
    }

    print "Applicable Adjustments<BR>";
    $sql="select workcenter_name, t.* from workcenter_down_time t, workcenters w where t.workcenter_id =w.workcenter_id  ";
    $sql.=" and MONTH(down_date) = ? and YEAR(down_date) = ? ";
    $sql.=" and coalesce(use_in_capacity,0) = 1 ";
    $sql.=" order by workcenter_name, down_date ";
    list($rs,$err)=runIQuery($db,$sql,array("ii",$month,$year));
    $headerWritten=0;
    foreach ($rs as $data) {
        $wcname=$data['workcenter_name'];
        $hours=$data['down_hours'];
        $dt=formatDateDBToWeb($data['down_date']);
        $why=$data['down_description'];
        if (! $headerWritten) {
            print "<table><tr><td>Workcenter</td><td>Date</td><td>Description</td><td>Hours</td></tr>\n";
            $headerWritten=1;				
        }
        print "<tr><td>$wcname</td><td>$dt</td><td>$why</td><td>$hours</td></tr>\n";
    }
    if ($headerWritten) {
        print "</table>";
    }

    // DATA START -Josh

    $sql = "select * from workcenters where capacity_hours > 0 and coalesce(use_in_capacity,0) = 1 ";
    list($rs)=runIQuery($db,$sql);
    $workcenters = [];
    foreach ($rs as $wc) {
        $workcenters[$wc["workcenter_id"]] = $wc;
    }

    ## jobs
    $sql = "select start_date, workcenter_id, item_id, pph, people, quantity_scheduled, coalesce(quantity_good,0) as good from jobs, routing  ";
    $sql.="  where (start_date between ? and ?) and jobs.item_id=routing.parent_part ";
    $sql.=" and workcenter_id in (select workcenter_id from workcenters where capacity_hours > 0 and coalesce(use_in_capacity,0) = 1 ) ";
    list($jrs)=runIQuery($db,$sql,["ss","$year-$month-01",date("Y-m-t", strtotime("$year-$month-01"))],0);

    $jobs = [];
    foreach ($jrs as $jdata) {
        if (empty($jobs[$jdata["workcenter_id"]])) {
            $jobs[$jdata["workcenter_id"]] = [];
        }
        if (empty($jobs[$jdata["workcenter_id"]][$jdata["start_date"]])) {
            $jobs[$jdata["workcenter_id"]][$jdata["start_date"]] = [];
        }
        $jobs[$jdata["workcenter_id"]][$jdata["start_date"]][] = $jdata;
    }

    ## orders
    $sql = "select due_date, workcenter_id, order_lines.item_id, pph, people, quantity, coalesce(shipped_quantity,0) as shipped ";
    $sql.=" from orders inner join order_lines on orders.order_id=order_lines.order_id and orders.status=1 inner join routing on order_lines.item_id=parent_part ";
    $sql.="  left outer join jobs on order_lines.line_id=jobs.line_id ";
    $sql=" where workcenter_id in (select workcenter_id from workcenters where capacity_hours > 0 and coalesce(use_in_capacity,0) = 1 ) ";
    $sql.=" and (due_date between ? and ?) and job_id is null ";
    list($ors)=runIQuery($db,$sql,["ss", AddBusinessDays("$year-$month-01",9), AddBusinessDays(date("Y-m-t", strtotime("$year-$month-01")),9)],0);

    $orders = [];
    foreach ($ors as $odata) {
        if (empty($orders[$odata["workcenter_id"]])) {
            $orders[$odata["workcenter_id"]] = [];
        }
        if (empty($orders[$odata["workcenter_id"]][$odata["due_date"]])) {
            $orders[$odata["workcenter_id"]][$odata["due_date"]] = [];
        }
        $orders[$odata["workcenter_id"]][$odata["due_date"]][] = $odata;
    }

    ## proposed
    $sql = "select proposed_date, workcenter_id, part_number, pph, people, quantity from proposed_jobs, routing where (proposed_date between ? and ?) and part_number=parent_part and workcenter_id in (select workcenter_id from workcenters where capacity_hours > 0 and coalesce(use_in_capacity,0) = 1 )";
    list($prs)=runIQuery($db,$sql,["ss","$year-$month-01",date("Y-m-t", strtotime("$year-$month-01"))],0);

    $proposed = [];
    foreach ($prs as $pdata) {
        if (empty($proposed[$pdata["workcenter_id"]])) {
            $proposed[$pdata["workcenter_id"]] = [];
        }
        if (empty($proposed[$pdata["workcenter_id"]][$pdata["proposed_date"]])) {
            $proposed[$pdata["workcenter_id"]][$pdata["proposed_date"]] = [];
        }
        $proposed[$pdata["workcenter_id"]][$pdata["proposed_date"]][] = $pdata;
    }

    // DATA END -Josh

    ## - cma - added down time
    $down = [];
    $sql-="select down_date, workcenter_id, sum(down_hours) as hours from workcenter_down_time where down_date between ? and ?) group by workcenter_id, down_date ";
    list($drs,$err)=runIQuery($db,$sql,array("ss","$year-$month-01",date("Y-m-t",strtotime("$year-$month-01"))));

    foreach ($drs as $ddata) {
        if (empty($down[$ddata['workcenter_id']])) {
            $down[$ddata['workcenter_id']] = [];
        }
        if (empty($down[$ddata['workcenter_id']][$ddata['down_date']])) {
            $down[$ddata['workcenter_id']][$ddata['down_date']]=0;
        }
        $down[$ddata['workcenter_id']][$ddata['down_date']]+=$ddata['hours'];
    }
    // Create the calendar headers
    foreach($daysOfWeek as $day) {
        $calendar .= "<th class='header' style='text-align: center;'>$day</th>";
    }
    // Create the rest of the calendar
    // Initiate the day counter, starting with the 1st.
    $currentDay = 1;
    $calendar .= "</tr><tr>";
    // The variable $dayOfWeek is used to
    // ensure that the calendar
    // display consists of exactly 7 columns.

    if ($dayOfWeek > 0) {
        $calendar .= "<td colspan='$dayOfWeek'>&nbsp;</td>";
    }

    $month = str_pad($month, 2, "0", STR_PAD_LEFT);

    while ($currentDay <= $numberDays) {

        // Seventh column (Saturday) reached. Start a new row.

        if ($dayOfWeek == 7) {

            $dayOfWeek = 0;
            $calendar .= "</tr><tr>";

        }

        $currentDayRel = str_pad($currentDay, 2, "0", STR_PAD_LEFT);

        $date = "$year-$month-$currentDayRel";
        $available=100;
        if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
            $tooltip="";
            $hours = 0;
            foreach ($workcenters as $data) {
                $wc=$data['workcenter_id'];
                $hours=$data['capacity_hours'];
                $availableHours = $hours;

                ## jobs
                foreach ($jobs[$wc][$date] as $wdata) {
                    $pph=$wdata['pph'];
					if ($pph == 0) {
						$pph=5;
					}
					$qty=$wdata['quantity_scheduled'] - $wdata['good'];
					if ($qty < 0) {
						$qty=0;
					}
					$people=$wdata['people'];
					$item=$wdata['item_id'];
					if (! $tooltip) {
						$tooltip.="<table><tr><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
					}
					$jobHours = $qty / $pph * $people;
					$jobHours += .5;
					$jobHours=round($jobHours,2);
					$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$tooltip);
					$hours -= $jobHours;
                }

                ## orders
                $schdate=AddBusinessDays($date,9);
                foreach ($orders[$wc][$schdate] as $odata) {
                    $pph=$odata['pph'];
					if ($pph == 0) {
						$pph=40;
					}
					$qty=$odata['quantity'];
					$sqty=$odata['shipped'];
					if ($sqty >= $qty) {
						$qty=0;
					}
					$item=$odata['item_id'];
					$people=$odata['people'];
					$jobHours = $qty / $pph * $people;
					$jobHours += .5;
					$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$tooltip);

					$hours -= $jobHours;
                }

                ## proposed
                foreach ($proposed[$wc][$date] as $wdata) {
                    $pph=$wdata['pph'];
					if ($pph == 0) {
						$pph=40;
					}
					$qty=$wdata['quantity'];
					$people=$wdata['people'];
					$item=$wdata['part_number'];
					if (! $tooltip) {
						$tooltip.="<table><tr><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
					}
					$jobHours = $qty / $pph * $people;
					$jobHours=round($jobHours,2);
					$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$tooltip);
					$hours -= $jobHours;
                }

                if (isset($down[$wc][$date])) {
                    $hours -= $down[$wc][$date];
                }
                $addon=10;
				if (Date('m',strtotime($date)) == Date('m')) {
					$trytooltip="";
					if ($backlogHours[$wc] > 0) {
						$addon=0;
						if ($hours > $backlogHours[$wc]) {
							$hours -= $backlogHours[$wc];
							if (! $tooltip) {
								$tooltip.="<table><tr><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
							}
							$trytooltip="<tr><td>Backlog:</td><td></td><td></td><td></td><td align='right'>" . $backlogHours[$wc] . "</td></tr>";
							foreach ($backlogHours as $key => $value ) {
								$backlogHours[$key]=0;
							}
						} else 
							$margin=1;
							if ($backlogHours[$wc] > 0 {
								$margin=$hours/$backlogHours[$wc];
							}
							$backlogHours[$wc]-=$hours;
							foreach ($backlogHours as $key => $value ) {
								if ($key != $wc) {
									$deduct=$margin * $backlogHours[$key];
									$backlogHours[$key] -= $deduct;
								}
							}
							if (! $tooltip) {
								$tooltip.="<table><tr><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
							}
							$trytooltip="<tr><td>Backlog:</td><td></td><td></td><td></td><td align='right'>" . $hours . "</td></tr>";
							$hours=0;
						}
					}
				}
				if ($hours < 0) {
					$hours=0;
				}
				$hours=round($hours,2);
				$pct = $hours / $availableHours * 100;
				if ($pct < $available)  {
					$available=$pct;
					$tooltip.=$trytooltip;
				}
            }

            $available=round($available,0);
            $available+=$addon;
            if ($available > 100) {
                $available=100;
            }
        }

        $calendar .= "<td class='day' rel='$date' ";
        if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
            if ($available > 30) {
                $calendar .= " style='background-color: #99ffbb;' ";
            } else {
                if ($available > 10) {
                    $calendar .= " style='background-color: #ffff99;' ";
                } else {
                    $calendar .= " style='background-color: #ff9999;' ";
                }
            }
        }

        $calendar .="><div style='float: right; font-size: 16px;'>$currentDay</div>";
        if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
        if ($tooltip) {
            $tooltip.="</table>";
        }
        $st=str_replace("'","\'",$tooltip);
        $sd = "<center>" . formatDateDBToWeb($date) . "</center>";
        $used=100-$available;
            $calendar.="<br><br><center><div class='mytooltip' onclick=\"showTip('$st','$sd');\">";
            $calendar .= $used . "%";
            $calendar.="<span class='mytooltiptext'>$tooltip</span>";
            $calendar .="</div>";
            $calendar .="</center>";

        }
        $calendar .= "</td>";

        // Increment counters

        $currentDay++;
        $dayOfWeek++;

    }

         // Complete the row of the last week in month, if necessary

        if ($dayOfWeek != 7) {

        $remainingDays = 7 - $dayOfWeek;
        $calendar .= "<td colspan='$remainingDays'>&nbsp;</td>";

    }

    $calendar .= "</tr>";

    $calendar .= "</table>";

    return $calendar;

}

$month=Date("m");
if (isset($_POST['month'])) {
    $month=$_POST['month'];
}
$year=Date("Y");
if (isset($_POST['year'])) {
    $year=$_POST['year'];
}

if (isset($_POST['new_part'])) {
    $newpart=trim($_POST['new_part']);
    if ($newpart) {
        $qty=trim($_POST['new_quantity']);
        $dt=formatDateWebtoDB($_POST['new_date']);
        $cmpdt=AddBusinessDays(Date("Y-m-d"),9);
        if ($dt < $cmpdt) {
            $dt=$cmpdt;
        }
        $schdate=SubtractBusinessDays($dt,9);
        $sql="insert into proposed_jobs (part_number, proposed_date, due_date, quantity) values (?, ?, ?,?) ";
        list($rs,$err)=runIQuery($db,$sql,array("sssi",$newpart,$schdate,$dt,$qty));
    }
}
if ($isCustomer) {
    $customer=$isCustomer;
    $_SESSION['customer']=$customer;
}


print renderPanel("Capacity","Capacity","green","span11","green");
print "<div class='span7'>";
print build_calendar($month,$year);
print "</div>";
print "<div class='span5'>";
print "<form name='listform' method='POST' action='capacity.php'>\n";
print renderStartItem(TRUE,"month","Month");
print "<select name='month' id='month' class='form-control chosen-select' onchange='document.listform.submit();'>";
print "<option value='01'";
if ($month == 1) {
    print " selected";
}
print ">January</option>";
print "<option value='02'";
if ($month == 2) {
    print " selected";
}
print ">February</option>";
print "<option value='03'";
if ($month == 3) {
    print " selected";
}
print ">March</option>";
print "<option value='04'";
if ($month == 4) {
    print " selected";
}
print ">April</option>";
print "<option value='05'";
if ($month == 5) {
    print " selected";
}
print ">May</option>";
print "<option value='06'";
if ($month == 6) {
    print " selected";
}
print ">June</option>";
print "<option value='07'";
if ($month == 7) {
    print " selected";
}
print ">July</option>";
print "<option value='08'";
if ($month == 8) {
    print " selected";
}
print ">August</option>";
print "<option value='09'";
if ($month == 9) {
    print " selected";
}
print ">September</option>";
print "<option value='10'";
if ($month == 10) {
    print " selected";
}
print ">October</option>";
print "<option value='11'";
if ($month == 11) {
    print " selected";
}
print ">November</option>";
print "<option value='12'";
if ($month == 12) {
    print " selected";
}
print ">December</option>";
print "</select>";
print renderEndItem();
print renderStartItem(TRUE,"year","Year");
print "<select name='year' id='year' class='form-control chosen-select' onchange='document.listform.submit();'>";
$y=Date("Y");
print "<option value='$y' ";
if ($year == $y) {
    print " selected ";
}
print ">$y</option>";
$y++;
print "<option value='$y' ";
if ($year == $y) {
    print " selected ";
}
print ">$y</option>";
print "</select>";
print renderEndItem();
print "<div style='clear: both;'></div>";
print renderTextBox(TRUE,"new_part","","New Part");
print renderTextBox(TRUE,"new_quantity","0","New Quantity");
print renderDateBox(TRUE,"new_date","","New Due Date");
print "<div style='clear: both;'></div>";
print renderButton("Add","green","document.listform.submit();","addbtn");
print "<hr>";
print "<center>Current Pending Entries</center>";
$dt=AddBusinessDays(Date("m/d/Y"),9);

$dt=formatDateDBToWeb($dt);
print "<center>Nearest Due Date Available is $dt</center>";
print "<table class='table table-striped'><thead><tr><th>Part</th><th>Quantity</th><th>Due Date</th><th>Weld Date</th><th>Remove<th></tr></thead><tbody>";
$sql="select * from proposed_jobs order by proposed_date ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    $part=$data['part_number'];
    $pjid=$data['pj_id'];
    $qty=$data['quantity'];
    $dt=formatDateDBToWeb($data['due_date']);
    print "<tr><td>$part</td><td align='right'>$qty</td><td>$dt</td>";
    print "<td>";
    $dt=formatDateDBToWeb($data['proposed_date']);
    print $dt;
    print "</td>";
    print "<td>";
    print renderButton("Remove","red","deleteJob('$pjid');","dj$pjid");
    print "</td>";
    print "</tr>\n";
}
print "</tbody></table>";
print "<div style='border: 1px solid black; padding: 5px;' id='detail'>";
print "</div>";
print "</form>";
print "</div>";
print renderClosePanel();

?>
<script>
    function deleteJob(jobid) {
        url='deleteRecord.php?key=pj_id&table=proposed_jobs&id='+jobid;
        $.ajax({url: url, success: function(data) {document.listform.submit();}});
    }
    function sortby(byval) {
        if ('<?=$seq?>' == byval) {
            document.listform.seq.value=byval + ' desc';
        } else {
            document.listform.seq.value=byval;
        }
        document.listform.submit();
    }
    function showTip(data, dt) {
        $('#detail').html(dt+data);
    }
    function page_init() {
        $('#new_part').autocomplete({source: itemList, minLength: 4, messages: {
        noResults: '',
        results: function() {}}});
    }
</script>
<?php
include('footer.php');

?>