<?php
include("dbConnection.php");
## session start is now in dbconnection.php; //This must be removed for Machine due to session_start being called elsewhere (headers.php? security.php?), required for Weld
include("security.php");
if (!$isAdmin && !$isManager && !$calendarAdmin) {
    header("Location: index.php");
    die();
}

include("functions.php");
include("header.php");
?>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <script src="calendar/js/fullcalendar.min.js"></script>
        <link rel="stylesheet" href="calendar/css/fullcalendar.min.css">

        <script src="calendar/js/jquery-1.10.2.min.js"></script>


        <style>
            #calendar { /* fix when adding to system */
                width: 100%;
                height: 90vh;
            }

            .fc-event {
                border: initial !important;
                background-color: initial !important;
                color: #0d638f !important;
            }

            input[type=date] {
                line-height: normal !important;
            }

            .modal-backdrop {
                z-index: 500 !important;
            }

            .fitContent {
                width: -moz-fit-content;
                width: fit-content;
                display: initial;
            }

            #location {
                font-size: 15pt;
            }

            .tpicker {
                width: 100px;
            }

            #alerts {
                position: fixed;
                top: 50px;
                z-index: 2000;
                display: flex;
                justify-content: center;
                align-items: center;
                flex-direction: column;
                width: 100vw;
            }

            @media print {
                .fc-button{display :none !important;} .fc-scroller.fc-scroller-liquid{overflow:visible !important;} .fc-view-harness.fc-view-harness-active{height:auto !important;}
                #calendar {width: 100vw; height: 100vh; position: fixed; z-index: 9000;}
            }
        </style>
        <div id="header"></div>
        <div id="content" style="background-color: #fff;">
            <div id="calendar"></div>
            <div id="alerts"></div>
            <div id="editmodal" class="modal fade" style="display: none;" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"></button>
                            <h4 id="editor-title" class="modal-title">
                                Edit Event
                            </h4>
                        </div>

                        <div class="modal-body">
                            <div id="scheduler">
                                <form onsubmit="submitForm(event)" method="post">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label>Title: <input class="form-control fitContent" type="text" id="title" placeholder="optional"></label>
                                        </div>

                                        <div class="form-group">
                                            <label>Summary: <input class="form-control" style="min-width: 70%;" type="text" id="desc" placeholder="optional"></label>
                                        </div>

                                        <label>Start: <input class="form-control fitContent" type="date" id="start-day" oninput="updateDate(this.value, this.oldvalue)">
                                        <input class="form-control fitContent tpicker text-center" type="text" id="start-time" onchange="updateTime()" jt-timepicker="" time="model.time" time-string="model.timeString" default-time="model.options.defaultTime" time-format="model.options.timeFormat" start-time="model.options.startTime" min-time="model.options.minTime" max-time="model.options.maxTime" interval="model.options.interval" dynamic="model.options.dynamic" scrollbar="model.options.scrollbar" dropdown="model.options.dropdown"></label>
                                        <label>End:   <input class="form-control fitContent tpicker text-center" type="text" id="end" onchange="updateTime()" jt-timepicker="" time="model.time" time-string="model.timeString" default-time="model.options.defaultTime" time-format="model.options.timeFormat" start-time="model.options.startTime" min-time="model.options.minTime" max-time="model.options.maxTime" interval="model.options.interval" dynamic="model.options.dynamic" scrollbar="model.options.scrollbar" dropdown="model.options.dropdown"></label>

                                    </div>

                                    <div id="repeatSelect" class="form-group">
                                        <label for="repeat">Repeat: <input name="repeat" id="repeat" onchange="toggleRepeat()" type="checkbox"></label>
                                    </div>

                                    <div class="form-group repeat">
                                        <label>Every: <input class="form-control fitContent" id="interval" onchange="updateDWMY(this.value)" type="number" min="1" max="2" value="1">
                                        <select onchange="updateMax()" class="form-control fitContent" id="duration">
                                            <option id="day">Day</option>
                                            <option id="week">Week on the 1st Tuesday</option>
                                            <option id="month"></option>
                                            <option id="year"></option>
                                        </select></label>

                                    </div>

                                    <div class="form-group repeat" style="display: grid !important;">
                                        <label><input type="radio" onchange="updateRadio()" name="repeattype" value="ftn">For the next: <input class="form-control fitContent" id="repeatTimes" type="number" min="2" max="14" value="2"> occurrences</label>
                                        <label><input type="radio" onchange="updateRadio()" name="repeattype" value="unt">Until: <input class="form-control fitContent" type="date" id="untdate"></label>
                                        <label><input type="radio" onchange="updateRadio()" name="repeattype" value="ye">Until Year End</label>
                                    </div>

                                    <div class="form-group">
                                        <label>For: <input value="<?php echo $userEmail; ?>" class="form-control" id="for" type="text" placeholder="Who this is for"></label>

                                    </div>

                                    <div class="form-group recurring" style="display: none;">
                                        <select class="form-control fitContent" onchange="toggleWhich()" id="which">
                                            <option>All Repeating Events</option>
                                            <option>This Event</option>
                                        </select>
                                    </div>
                                </form>
                            </div>

                        </div>

                        <div class="modal-footer">
                            <button style="display: none;" id="deleteBtn" class="pull-left btn red" onclick="submitEvent(submitType = 'delete')">Delete</button>
                            <button class="btn green" onclick="submitEvent()">Submit</button>
                            <button class="btn btn-default" data-dismiss="modal">Cancel</button>
                        </div>

                    </div>

                </div>
            </div>
        </div>

    <?php
include("footer.php");
?>
    <script src="calendar/js/jquery.timepicker.min.js"></script>
    <link rel="stylesheet" href="calendar/css/jquery.timepicker.min.css">
    <script>
        var userEmail = "<?php echo $userEmail; ?>"; //self explanatory
        var userName = "<?php echo $userName; ?>"; //users full name
        var isAdmin = <?php echo $isAdmin; ?>;
        var calendarAdmin = <?php if (!isset($calendarAdmin)) $calendarAdmin  = 0; echo $calendarAdmin; ?>;
        var isManager = <?php if (!isset($isManager)) $isManager  = 0; echo $isManager; ?>;
    </script>
    <script src="calendar/js/calendarscript.js"></script>