<?php

## get routing (used to get BOM children that are consumed at this step)
## get operation name, # people, parts per hour, operation cost, quantity good, hours, minutes
function calculateWIP($db,$line,$part,$jobGood,$qtyper) {
    global $due,$totalMaterial,$job,$order,$scheduled,$partlist,$costlist,$_GET;
    global $scriptid;
    $sql="select  j.job_id, operation_name, display_sequence, sum(pr.quantity_good) as good  ";
    $sql.=" from jobs j inner join routing r on j.item_id=r.parent_part  ";
    $sql.=" inner join operations op on r.operation_id=op.operation_id ";
    $sql.=" inner join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id and pr.quantity_good < 25000 ";
    $sql.=" where j.line_id=? and j.item_id=? ";
    $sql.=" and pr.employee_id > 0 ";
    $sql.=" group by  j.job_id, display_sequence, operation_name ";
    $sql.=" order by display_sequence DESC ";
    list($rrs,$err)=runIQuery($db,$sql,array("is",$line,$part));
    if  ($_GET['order']) {
        print "Processing Part $part, $jobGood, $qtyper<BR>";
        print renderQuery($sql,array("is",$line,$part));
    }
    foreach ($rrs as $rdata) {
        if  ($_GET['order']) {
            print_r($rdata);
            print "<hr>";
        }
        $operation=$rdata['operation_name'];
        $sequence=$rdata['display_sequence'];
        $cost=calculateCost($db,$part,$line,$sequence);
        $cost=round($cost,2);
        $partlist[]=$part;
        $costlist[$part]=$cost;
        $good=$rdata['good'];
        $thisjob=$rdata['job_id'];
        $sql="select quantity_scheduled from jobs where job_id=?";
        list($jrs,$err)=runIQuery($db,$sql,array("i",$thisjob));
        $thisScheduled=$jrs[0][0];        
        ## you need to compare against prior job to see if you made more than what was consumed at the level up
        ## can only count as  many good as there is the cap        
        $good -= ($jobGood * $qtyper);
        if ($good < 0) {
            $good=0;
        }
        if  ($_GET['order']) {
            print " in cw:good now $good<br>";
        }
    
        $jobGood+=($good * $qtyper);
        if ($good > 0) {
            $wip=$cost*$good;
            $totalMaterial+=$wip;
            if ($scriptid == "calculatedWIPNew.php") {
                print "<tr><td>$thisjob</td><td>$due</td><td>$part</td><td>$order</td><td>$operation</td><td>$thisScheduled</td><td>$good</td><td>$cost</td><td>$wip</td></tr>\n";
            } else {
                print "$thisjob\t$due\t$part\t$order\t$operation\t$thisScheduled\t$good\t$cost\t$wip\n";
            }
        }
    }
    return $jobGood;
}

$partlist=array();
$costlist=array();

$totalLabor=0;
$totalMaterial=0;

## get all jobs for finished goods where order status is not cancelled or quote
## get all jobs that are open for the finished good - get job#, item, quantity scheduled for the job,  SO Line #, SO#, SO Due Date, Shipped Quantity if any
## walk through each job
$sql="SELECT j.job_id, j.item_id, quantity_scheduled, quantity_good, j.line_id, l.order_id, l.due_date, coalesce(l.shipped_quantity,0) as shipped_quantity ";
$sql.=" FROM jobs j inner join order_lines l on j.line_id=l.line_id and j.item_id=l.item_id ";
$sql.=" inner join orders o on l.order_id=o.order_id ";
$sql.=" where j.status in (1,2)  and coalesce(o.status,1) not in (3,4,5,6) and quantity_scheduled < 25000 ";
$sql.=" and j.item_id not like 'INDIRECT LABOR%' ";
$sql.=" and coalesce(shipped_quantity,0) < l.quantity  ";
if (isset($_GET['order'])) {
    $sql.=" and l.order_id=" . $_GET['order'];
}
list($rs,$err)=runIQuery($db,$sql);

foreach ($rs as $data) {
    $job=$data['job_id'];
    $item=$data['item_id'];
    $jobGood=$data['quantity_good'];
    $originalJobGood=$jobGood;
    $line=$data['line_id'];
    $order=$data['order_id'];
    $scheduled=$data['quantity_scheduled'];
    $shipped=$data['shipped_quantity'];    
    $due=formatDateDBToWeb($data['due_date']);
    ## pass the quantity good at this level, to deduct from the next level
    $jobGood=calculateWIP($db,$line,$item,$shipped,1);
    ## go as many as 4 levels down to find any children that are on a job
    ## if the quantity good for a job meets the needs of the assembly job, then do not continue any further down the BOM, 
    ## as anything beneath it in the BOM have all been consumed into this child component
    ## remember you have to multiply the cap times the quantity per at that level of the BOM
    $sql="select child_item, quantity_per from billofmaterial where parent_item=? ";    
    list($brs,$err)=runIQuery($db,$sql,array("s",$item));
    foreach ($brs as $bdata) {
        $jobGood=$originalJobGood;
        $qtyper=$bdata['quantity_per'];
        $child=$bdata['child_item'];
        $jobGood=calculateWIP($db,$line,$child,$jobGood,$qtyper);
        $originalJobGood2=$jobGood;
        $sql="select child_item, quantity_per from billofmaterial where parent_item=?";
        list($brs2,$err)=runIQuery($db,$sql,array("s",$child));
        foreach ($brs2 as $bdata2) {
            $jobGood=$originalJobGood2;
            $qtyper2=$bdata2['quantity_per']*$qtyper;
            $child=$bdata2['child_item'];
            $jobGood=calculateWIP($db,$line,$child,$jobGood,$qtyper2);
            $originalJobGood3=$jobGood;
            $sql="select child_item, quantity_per from billofmaterial where parent_item=?";
            list($brs3,$err)=runIQuery($db,$sql,array("s",$child));
            foreach ($brs3 as $bdata3) {
                $jobGood=$originalJobGood3;
                $qtyper3=$bdata3['quantity_per']*$qtyper2;
                $child=$bdata3['child_item'];
                $jobGood=calculateWIP($db,$line,$child,$jobGood,$qtyper3);
                $originalJobGood4=$jobGood;
                $sql="select child_item, quantity_per from billofmaterial where parent_item=?";
                list($brs4,$err)=runIQuery($db,$sql,array("s",$child));
                foreach ($brs4 as $bdata4) {
                    $jobGood=$originalJobGood4;
                    $qtyper4=$bdata4['quantity_per']*$qtyper3;
                    $child=$bdata4['child_item'];
                    $jobGood=calculateWIP($db,$line,$child,$jobGood,$qtyper4);
                }
            }
        }
    }
}
