<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

if (! $isAdmin) {
    exit;
}
print renderPanel("WIP Calculation");
print renderButton("Export","blue","window.open('exportCalculatedWIP.php','_blank');");
## get all jobs that are open - get job#, item,  quantity good, SO Line #, SO#
## walk through each job
## check for production results for that job - get the quantity_good and the routing number
## cap the quantity good for the step at the quantity scheduled for the job
## subtract the job quantity good from the step
## get PPH and people from the routing number, and get operation cost from operation table
## get consumed parts from the routing number/BOM - add those costs in based on step quantity
## I think we also need to take inventory of all components, subassemblies, and painted parts
## maybe not components 19 subassy 18 painted is 21
$sql="SELECT j.job_id, j.item_id, quantity_scheduled, quantity_good, j.line_id, l.order_id, l.due_date, j.start_date FROM jobs j left outer join order_lines l on j.line_id=l.line_id ";
$sql.=" left outer join orders o on l.order_id=o.order_id ";
$sql.=" where j.status in (1,2)  and coalesce(o.status,1) not in (3,4,5,6) and quantity_scheduled < 10000 and ";
$sql.=" coalesce(shipped_quantity,0) < quantity_scheduled ";
list($rs,$err)=runIQuery($db,$sql);
print "<center>WIP From Production Results</center>";
print "<table class='table table-striped'>";
print "<thead><tr><th>WO</th><th>Order Due</th><th>Part</th><th>SO</th><th>Step</th><th>PPH</th><th>Reported PPH</th><th>Qty On Job</th><th>Qty Completed at Step</th><th>Labor</th><th>Material</th><th>Total Value</th></tr>\n</thead>\n";
print "<tbody>";
$totalLabor=0;
$totalMaterial=0;
foreach ($rs as $data) {
    $job=$data['job_id'];
    $item=$data['item_id'];
    $jobGood=$data['quantity_good'];
    $line=$data['line_id'];
    $order=$data['order_id'];
    $scheduled=$data['quantity_scheduled'];
    $due=formatDateDBToWeb($data['due_date']);
    ## exclude Outside Process, material handling, and quality inspection from this
    $sql="select r.routing_id, operation_name, r.people, r.pph, operation_cost, sum(pr.quantity_good) as good, sum(duration_hours) as hours, sum(duration_minutes) as minutes ";
    $sql.=" from jobs j inner join routing r on j.item_id=r.parent_part ";
    $sql.=" inner join operations op on r.operation_id=op.operation_id ";
    $sql.=" inner join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
    $sql.=" where j.job_id=? and r.operation_id <> 3106 and r.operation_id <> 3090 and r.operation_id <> 3107  ";
    $sql.=" and j.line_id=? ";
    $sql.=" group by pr.routing_id, operation_name, r.people, r.pph, operation_cost ";
    list($rrs,$err)=runIQuery($db,$sql,array("ii",$job,$line));
    foreach ($rrs as $rdata) {
        $routing=$rdata['routing_id'];
        $operation=$rdata['operation_name'];
        $people=$rdata['people'];
        if ($people == 0) {
            $people=1;
        }
        $pph=$rdata['pph'];
        $cost=$rdata['operation_cost'];
        $good=$rdata['good'];
        $hours=$rdata['hours'];
        $minutes=$rdata['minutes'];
        $hours += ($minutes/60);
        if ($hours > 0) {
            $actualPPH=$good / $hours;
        } else {
            $actualPPH=$pph;
        }
        ## cap quantity good at quantity scheduled because people hit buttons too many times
        if ($good > $scheduled) {
            $good=$scheduled;
        }
        ## they are not WIP if they are finished Assembly - remainder is how many you can count
        if ($operation=="Assembly") {
            $remainder=$good - $jobGood;
        } else {
            $remainder=$good;
        }
        if ($operation == "Laser") {
            $nestGood=0;
            $sql=" select distinct nest_id from production_results pr, nest_contents nc  where job_id=? and pr.results_id=nc.result_id";
            list($nrs,$err)=runIQuery($db,$sql,array("i",$job));
            foreach ($nrs as $ndata) {
                $nest=$ndata['nest_id'];
                $sql="select sum(quantity_good) from nest_contents nc, production_results pr where nest_id=? and nc.result_id=pr.results_id ";
                list($qrs,$err)=runIQuery($db,$sql,array("i",$nest));
                $nestGood+=$qrs[0][0];
            }
            if ($good > 0)  {
                if ($nestGood > $good and $good > 0) {
                    $actualPPH=$actualPPH/$good*$nestGood;
                    if ($actualPPH > 5000) {
                        $actualPPH=5000;
                    }
                }
            }
        }
        if ($remainder > 0) {
            if ($cost == 0) {
                print "Operation Cost Zero $operation<br>";
            }
            if ($pph == 0) {
                print "PPH zero for item $item, operation $operation<br>";
                print renderQuery($sql,array("i",$job));
                print "<br>";
                $labor=0;
            } else {
                if ($pph < $actualPPH) {
                    $labor=$remainder / $actualPPH * $cost;
                } else {
                    $labor=$remainder / $pph * $cost;
                }
            }
            $material=0;
            $sql="select  quantity_per, cost from billofmaterial b, items i where (b.parent_item=? or b.parent_item=?) and routing_id=? and child_item=i.item_name ";
            list($mrs,$err)=runIQuery($db,$sql,array("ssi",$item,$item,$routing));
            foreach($mrs as $mdata) {
                $thisMaterial=$mdata['quantity_per'] * $mdata['cost'] * $remainder;
                $material+=$thisMaterial;
            }
            $labor=round($labor,2);
            $material=round($material,2);
            $totalLabor+=$labor;
            $totalMaterial+=$material;
            $wip=$labor+$material;
            $labor=number_format($labor,2);
            $material=number_format($material,2);
            $wip=number_format($wip,2);
            $actualPPH=number_format($actualPPH,3);
            print "<tr><td>$job</td><td>$due</td><td>$item</td><td>$order</td><td>$operation</td><td>$pph</td><td>$actualPPH</td><td>$scheduled</td><td>$remainder</td><td>$labor</td><td>$material</td><td>$wip</td></tr>\n";
        }
    }
}
$total=$totalLabor+$totalMaterial;
print "<tr><td colspan='9' align='right'>Total WIP</td><td>";
print number_format($totalLabor,2);
print "</td><td>";
print number_format($totalMaterial,2);
print "</td><td>";
print number_format($total,2);
print "</td></tr>\n";
print "</tbody>";
print "</table>";
print renderClosePanel();
include('footer.php');
