<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');
$item_id=$_GET['item_id'];
print renderPanel("Bill of Material Audit","","green","span11","cogs");
print "<form name='updform' actin='bomAudit.php' method='GET'>";
print renderTextBox(TRUE,"item_id",$item_id,"Raw Part");
print renderButton("Run Audit","blue","document.updform.submit();");
print "<div style='clear: both;'></div>";
print "</form>";
print "<p>Part Numbers, Quantity Per, PPH, Operations, and Work Centers are audited versus the Raw part.  The first mis-match is reported, so once corrected, the audit should be reprocessed.</p>";
print "<table class='table table-striped'><thead><tr><th>Parent</th><th>Component</th><th>Results</th><th>Message</th></tr></thead><tbody>";
$baseinfo=array();
if ($item_id) {
  $sql="select item_name from items where item_name like '$item_id%' and length(item_name) < 12";
  list($irs,$err)=runIQuery($db,$sql);
  foreach ($irs as $idata) {
  	$masterPart=$idata['item_name'];
	$level=1;
	unset($baseinfo);
	$baseinfo=array();
	$baseinfo=getInfo($db,$baseinfo,1,$masterPart);
	foreach ($baseinfo as $info) {
		$baseinfo=getInfo($db,$baseinfo,1,$info['child_item']);
	}
	$i=2;
	while ($i < 6) {
		reset($baseinfo);
		foreach ($baseinfo as $info) {
			$level=$info['level'];
			$child=$info['child_item'];
			if ($level == $i) {
				$baseinfo=getInfo($db,$baseinfo,$i,$child);
			}
		}
		$i++;
	}
	reset($baseinfo);
	$baseroute=array();
	$paintRoute = array();
	$baseroute=getRouting($db,$baseroute,$masterPart);


	$sql="select * from billofmaterial where parent_item like '$masterPart%' and parent_item != ?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$masterPart));
	$paintInfo=array();
	$processedParentsList=array();
	foreach ($rs as $data) {
		$message="";
		$anyError=0;
		unset($paintInfo);
		$paintInfo=array();
		$parent=trim($data['parent_item']);
		unset($paintInfo);
		$paintInfo=array();
		$routemessage="";
		if ($masterPart != substr($parent,0,strlen($masterPart))) {
			print "<tr><td><a href='goRecipe.php?part=$masterPart' target='_blank'>$masterPart</a></td><td><a href='goRecipe.php?part=$parent' target='_blank'>$parent</a></td><td><font color='red'>FAIL</font></td><td>Parents Do not Match</td></tr>";
		}
		if (! in_array($parent,$processedParentsList)) {
			unset($paintRoute);
			$paintRoute=array();
			$paintRoute=getRouting($db,$paintRoute,$parent);
			$routeMessage=compareRouting($baseroute,$paintRoute);
			if ($routeMessage) {
				$routemessage="<tr><td><a href='goRecipe.php?part=$masterPart' target='_blank'>$masterPart</a></td><td><a href='goRecipe.php?part=$parent' target='_blank'>$parent</a></td><td><font color='red'>FAIL</font></td><td>Parent Routings do not Match</td></tr>";
			}
			$processedParentsList[]=$parent;
		}
		$child=$data['child_item'];
		print "<tr><Td><a href='goRecipe.php?part=$parent' target='_blank'>$parent</a></td><td><a href='goRecipe.php?part=$child' target='_blank'>$child</a></td>";
		$paintInfo=getInfo($db,$paintInfo,1,$parent);
		foreach ($paintInfo as $info) {
			$paintInfo=getInfo($db,$paintInfo,1,$info['child_item']);
		}
		$i=2;
		while ($i < 6) {
			reset($paintInfo);
			foreach ($paintInfo as $info) {
				$level=$info['level'];
				$child=$info['child_item'];
				if ($level == $i) {
					$paintInfo=getInfo($db,$paintInfo,$i,$child);
				}
			}
			$i++;
		}
		reset($paintInfo);
		foreach ($paintInfo as $paint) {
			reset($baseinfo);
			$found=0;
			foreach ($baseinfo as $info) {
				$info['parent_item']=str_replace("-PAINTED","",$info['parent_item']);
				$info['child_item']=str_replace("-PAINTED","",$info['child_item']);
				if (! $found) {
					if ($info['parent_item'] == substr($paint['parent_item'],0,strlen($info['parent_item'])))	 {
						if ($info['child_item'] == substr($paint['child_item'],0,strlen($info['child_item']))) {
							if ($info['level']==$paint['level']) {
								if ($info['quantity_per']==$paint['quantity_per']) {
									if ($info['pph'] == $paint['pph']) {
										if ($info['op'] == $paint['op']) {
											if ($info['wc'] == $paint['wc']) {
												$found=1;
											} else {
												$message="Workcenter did not match";
											}											
										} else {
											$message="Operation did not match";
										}
									} else {
										$message="pph did not match";
									}
								} else {
									$message="qtyper did not match";
								}
							} else {
								$message="Level did not match";
							}
						} else {
						}
					} else {
					}
				}
			}
			if (! $found) {
				if ($message) {
					$message="Painted to Raw: " . $message;
					$anyError=1;
				}
			}
		}
		if (! $anyError) {
			reset($baseinfo);
			$basecompare=array();
			foreach ($baseinfo as $info) {
				reset($paintInfo);
				$p=str_replace("-PAINTED","",$info['parent_item']);
				$c=str_replace("-PAINTED","",$info['child_item']);
				$found=0;
				foreach ($paintInfo as $paint) {
					if (! $found) {
						if ($p == substr($paint['parent_item'],0,strlen($p)))	 {
							if ($c == substr($paint['child_item'],0,strlen($c))) {
								$found=1;
								$basecompare=getInfo($db,$basecompare,1,$p);
								if ($routemessage=="") {
									unset($routecompare);
									$routecompare=array();
									$routecompare=getRouting($db,$routecompare,$info['parent_item']);
									unset($paintCompare);
									$paintCompare=array();
									$paintCompare=getRouting($db,$paintCompare,$paint['parent_item']);
									$routeMessage=compareRouting($routecompare,$paintCompare);
									if ($routeMessage) {
										$routemessage="<tr><td><a href='goRecipe.php?part=" . $info['parent_item'] . "' target='_blank'>" . $info['parent_item'] . "</a></td><td><a href='goRecipe.php?part=" . $paint['parent_item'] . "' target='_blank'>" . $paint['parent_item'] . "</a></td><td><font color='red'>FAIL</font></td><td>Routings do not Match</td></tr>";
									}
								}
							}
						}
					}
				}
			}
			foreach ($basecompare as $info) {
				reset($paintInfo);
				$info['parent_item']=str_replace("-PAINTED","",$info['parent_item']);
				$info['child_item']=str_replace("-PAINTED","",$info['child_item']);
				$found=0;
				foreach ($paintInfo as $paint) {
					if (! $found) {
						if ($info['parent_item'] == substr($paint['parent_item'],0,strlen($info['parent_item'])))	 {
							if ($info['child_item'] == substr($paint['child_item'],0,strlen($info['child_item']))) {
								if ($info['quantity_per']==$paint['quantity_per']) {
									if ($info['pph'] == $paint['pph']) {
										if ($info['op'] == $paint['op']) {
											if ($info['wc'] == $paint['wc']) {
												$found=1;
											} else {
												$message="Workcenter did not match";
											}												
										} else {
											$message="Operation did not match";
										}
									} else {
										$message="pph did not match";
									}
								} else {
									$message="qty per did not match";
								}
							} else {
							}
						}	 else {
						}
					}
				}
				if (! $found) {
					$anyError=1;
					$message="Painted Part Missing Record" . $message;
				}
			}
		}
		print "<td>";
		if (! $anyError) {
			if (count($baseinfo) <> count($paintInfo)) {
				$anyError=1;
				$message="BOM Count is different";				
			}
		}
	  	if (! $anyError) {
			print "PASS";
		} else {
			print "<font color='red'>FAIL</font>";
		}
		print "</td>";
		print "<td>$message</td>";
		print "</td></tr>\n";
		if ($routeMessage) {
			print $routemessage;
		}
	}
  }
}

print "</tbody></table>";
print renderClosePanel();

function getInfo($db,$baseinfo,$level,$part) {
	$sql="select * from billofmaterial where parent_item=? order by runseq";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		$parent=$data['parent_item'];
		$child=$data['child_item'];
		$qty=$data['quantity_per'];
		$seq=$data['runseq'];
		$routing=$data['routing'];
		$op=0;
		$pph=0;
		$wc=0;
		if ($routing) {
			$sql="select operation_id, pph, workcenter_id from routing where routing_id=?";
			list($rdata,$err)=runIQuery($db,$sql,array("i",$routing)); 
			$op=$rdata['operation_id'];
			$wc=$rdata['workcenter_id'];
			$pph=$rdata['pph'];
		}
		$data['level']=$level+1;
		$data['operation']=$op;
		$data['pph']=$pph;
		$data['wc']=$wc;
		$baseinfo[]=$data;
	}
	return $baseinfo;
}

function getRouting($db,$baseinfo,$part) {
	$sql="select * from routing where parent_part=? order by display_sequence ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		$baseinfo[]=$data;
	}
	return $baseinfo;
}
function compareRouting($routing1,$routing2) {
	$anyRouteError=0;
	foreach ($routing1[0] as $info) {
		$found=0;
		if (isset($info['operation_id'])) {
			foreach ($routing2[0] as $paint) {
				if (! $found) {
					if (isset($paint['operation_id'])) {
						if ($info['operation_id'] == $paint['operation_id']) {
							if ($info['workcenter_id'] == $paint['workcenter_id']) {
								if ($info['pph'] == $paint['pph']) {
									if ($info['vendor_id'] == $paint['vendor_id']) {
										if ($info['display_sequence'] == $paint['display_sequence']) {
											$found=1;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		if (! $found) {
			$anyError=1;
		}
	}
	foreach ($routing2 as $paint) {
		$found=0;
		foreach ($routing1 as $info) {
			if (! $found) {
				if ($info['operation_id'] == $paint['operation_id']) {
					if ($info['workcenter_id'] == $paint['workcenter_id']) {
						if ($info['pph'] == $paint['pph']) {
							if ($info['vendor_id'] == $paint['vendor_id']) {
								if ($info['display_sequence'] == $paint['display_sequence']) {
									$found=1;
								}
							}
						}
					}
				}
			}
		}
		if (! $found) {
			$anyRouteError=1;
		}
	}
	if (count($routing1) <> count($routing2)) {
		$anyRouteError=1;
	}
	return $anyRouteError;
}
include('footer.php');
?>