<?php
### LOAD BAY MANAGEMENT (unload cart) ADDITION MW ### 
			// 1. User scans a bay
			//1a) bay operations window opens
			// 2. User clicks load pallet on open pallet (or can print a manifest for existing closed pallets in the bay)
			// 3. User is prompted to scan item and confirm quantity
			// 4. heck quantity is correct with number on pallet AND number in order.
			//4a. if incorrect quantity from order or planned to pallet, alert user 
			// 5. ELSE user notifed wrong bay
			// 6. If a pallet is full after last product added user clicks "Pallet Full" manifest prints, new pallet opens and allocates any items planned for that pallet to new pallet
			// 7. This opens the next pallet
            // 8. Empty bay starts the pallet operations over 

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
include('views/modals/loadPallet.php');
include('views/modals/palletItems.php');
$postvariables=json_encode($_POST);
$getvariables=json_encode($_GET);
$bay="";
$pallet="";
$bayId="";
if (isset($_POST['part'])) {
	$part=$_POST['part'];
}	
if (isset($_POST['folder'])) {
	$folder=$_POST['folder'];
}	
if (isset($_POST['defect_type'])) {
	$defectType=$_POST['defect_type'];
}	
if (isset($_POST['defects'])) {
	$defects=$_POST['defects'];
}	
if (isset($_POST['bay'])) {
	$bay=$_POST['bay'];
}	
if (isset($_POST['quantity'])) {
	$qty=$_POST['quantity'];
}	
$inserted=0;
print renderPanel("Bay Operations","Bay","primary","span11");
if ( $_SESSION['notice'] ) {
    print $_SESSION['notice'];
    unset( $_SESSION['notice']);
}
print "<form name='updform' class='form-horizontal form-bordered' method='POST' action='bayOps.php' autocomplete='off'>\n";
print "<input type='hidden' name='bay' id='bay' value=''>";
print "<label class='control-label' for='bay'>Bay</label>";
print "<br><input type='text'  name='bay' id='bay'  value='$bay'>";
print "<div style='margin: 5px;' class='btn btn-success' onclick='document.updform.submit();'>Bay Options</div>";
print "</form>\n";

if($bay){
    // show bay and pallet contents for that bay
    $sql = "SELECT pallets_have_parts.item_id, pallets_have_parts.pallet_id,staging_bays.bay_name,pallets.bay_sequence,pallets.assigned_bay,pallets.pallet_id,pallets.complete,pallets.order_id,pallets.folder_number,
    pallets_have_parts.confirmed_by,pallets_have_parts.cleared_by, sum(pallets_have_parts.quantity) as quanOnPallet,sum(pallets_have_parts.confirmed_quantity) as confirmed_quantity FROM staging_bays 
    LEFT join pallets ON staging_bays.bay_id =pallets.assigned_bay 
    LEFT JOIN pallets_have_parts on pallets.pallet_id = pallets_have_parts.pallet_id WHERE staging_bays.bay_name=$bay
GROUP BY pallets_have_parts.pallet_id
ORDER BY pallets_have_parts.pallet_id";
    // for any pallets that are full, show mark full options
    // for removing a particular pallet from a bay (partially clearing the bay)
        //1. mark that pallet cleared 
    // when a bay is cleared mark all pallets cleared 
    list($palletsInBay,$err)=runIQuery($db,$sql);
					if($err){
						handleError($err,$_SERVER['PHP_SELF'],$userID,__LINE__);
					}
						
					else {
                    //currnetly based on only one bay being in use per folder, if there will be multiple bays in use (Justin H says no for now) then we would need to send key value pair
                     $bayId = $palletsInBay[0]['assigned_bay'];
                        // var_dump($palletsInBay);

                        // print a panel here with options to
                            //1. Load bay 
                            //2. prompt to scan item and enter quantity
                            //3. insert into confirmed columns
                    
                        print "<h3>Bay and Pallet Ops for Bay $bay</h3>";
                        print "<table class='table table-striped table-hover'>";
                        print "<thead>";
                        print "<tr>";
                        print "<th valign='top'>";
                        print "Pallet Sequence";
                        print "</th>";
                        print "<th valign='top'>";
                        print "Order ID";
                        print "</th>";
                        print "<th>Planned # of Items on On Pallet</th>";
                        print "</th>";
                        print "<th>Confirmed # of Items on On Pallet</th>";
                        print "</th>";
                        print "<th valign='top' align='center'>";
                        print "<div align='center'>Pallet Actions</div>";
                        print "</th>";
                        print "</tr>\n";
                        print "</thead>";
                        print "<tbody>";
                    }
                    // var_dump($palletsInBay);
                    if($palletsInBay[0]['bay_sequence']) {
                        foreach ($palletsInBay as $palletKey => $pallet){ 

                            print "<tr>";
                            print "<td>";
                            print $pallet['bay_sequence'];
                            print"</td>";
                            print "<td>";
                            print $pallet['order_id'];
                            print"</td>";
                            print "<td>";
                            print "<a href='#' id='plannedQuanModal' onClick=plannedQuan(".$pallet['pallet_id'].")>".$pallet['quanOnPallet']."</a>";
                            print"</td>";
                            print"<td>";
                            print $pallet['confirmed_quantity'];
                            print"</td>";
                            print "<td align='center'>";
                            if($pallet['complete']!=1){
                                print " <button class='btn btn-primary' onClick=\"loadPallet('" . $pallet['pallet_id'] . ",". $pallet['bay_sequence'] .",". $bay .",".$pallet['quanOnPallet'].",".$pallet['order_id'].",".$bayId."');\">Load Pallet</button> ";
                                print " <button class='btn btn-danger fullPallet' onClick=\"palletFull('" . $pallet['pallet_id'] . ",". $pallet['bay_sequence'] .",". $bay .",".$pallet['quanOnPallet'].",".$pallet['confirmed_quantity'].",".$pallet['order_id']."');\">Pallet Full</button> ";
                            }
                            else {
                                print " <a class='btn btn-success' href='/printPalletManifest.php?pallet=".$pallet['pallet_id']."&bay=".$bay."&seq=".$pallet['bay_sequence']."&o=".$pallet['order_id']."'>Print Manifest</a> ";
                                // print " <button class='btn btn-warning'>Move Pallet</button> ";
                            }
                        
                            print "</td>";
                            print"</tr>";
                        }
                    }
                }
?>
<script>
function loadPallet(input){
console.log(input);
let inputs = input.split(',');

    $("#load_pallet_modal").modal();
    $("#bayAndPallet").text(inputs[2]+"-"+inputs[1]);
    $("#pallet_id").val(inputs[0]);
    $("#bay_name").val(inputs[2]);
   
    $("#order_id").val(inputs[4]);
    // $("#quantityRequired").text(inputs[3]);
    // $("#quantity_planned").val(inputs[3])
    $("#pallet_sequence").val(inputs[1]);
    $("#bay_id").val(inputs[5]);
    
}

function plannedQuan(palletId){
    $.ajax({
            method: "POST",
            url: "ajax/getPalletItems.php",
            data: {pallet:palletId}
            }).done(function(palletContentResults) {
                let decodedResults = JSON.parse(palletContentResults);
                if (decodedResults.success == "true"){
                    $("#plannedItems tr").remove();
                    for (x in decodedResults.results){
                        console.log(decodedResults.results[x].item_id);
                        $("#plannedItems").append('<tr><td>'+decodedResults.results[x].item_id+'</td><td>'+decodedResults.results[x].quantity+'</td></tr>')
                    }
                    $('#palletItemsModal').modal();
                }
                else {
                    alert(palletContentResults);
                    console.log(palletContentResults);
                }

            })
    
}

function closePallet(palletId,bayName,missingParts){
   
        $.ajax({
            method: "POST",
            url: "ajax/closePallet.php",
            data: {pallet:palletId,bay_name:bayName,missing:missingParts}
            }).done(function(palletClosedResult) {
                console.log(palletClosedResult);
                let decodedResults = JSON.parse(palletClosedResult);
                if (decodedResults.success =="true") {
                    let bayId = decodedResults.bay;
                    let sequence = decodedResults.sequence;
                    let order = decodedResults.order;
                    let url = "/printPalletManifest.php?pallet="+palletId+"&bay="+bayId+"&seq="+sequence+"&o="+order;
                    window.open(url,"_blank");
                    window.location.href = "bayOps.php";
                    // window.location.href = "printPalletManifest.php?pallet="+palletId+"&bay="+bayId+"&seq="+sequence+"&o="+order;
                }
                else {
                    alert(decodedResults.error);
                    console.log(decodedResults.error);
                    //there was an error, set to flash and redirect back to bayops - instruct user to contact support.
                    window.location.href = "bayOps.php";
                }
               // if the pallet is closed successfully set print manifest to true and open popup on page refresh with manifest to print.
            
            })
}

function palletFull(input){

    $(".fullPallet").prop("disabled",true);
   
    let inputs=input.split(',');
    let palletId = inputs[0];
    let baySequence = inputs[1];
    let bayName = inputs[2];
    let orderId =inputs[5];
   
    console.log(inputs[5]);
    //1. check to see that all items that are planned for that pallet are on that pallet
    $.ajax({
        method: "POST",
        url: "ajax/checkPalletsForMissingItems.php",
        data: {pallet:palletId,sequence:baySequence,order:orderId,bay:bayName}
        }).done(function(palletMissingItemsResult) {

            let decodedResults = JSON.parse(palletMissingItemsResult);
            if (decodedResults.success =="true")
            {
                //2. if pallet is missing planned parts prompt - 'this pallet has the following parts which are missing, if you mark this pallet full any missing parts should go on the next open pallet'
                if (decodedResults.shortage =="true" && decodedResults.proceed >=1){
                    //nice to have
                    var note = prompt("Pallet has missing parts which will be allocated to the next open pallet. Please confirm/add notes as necessary or cancel and then load pallet with parts until full");
                    // FUTURE FUNCTION NICE TO HAVE NOT WITHIN CURRENT TIME BLOCK / NOT NEED TO HAVE // 
                    // if (note !=null){
                    //     .ajax({
                    //         method: "POST",
                    //         url: "ajax/addNoteToPallet.php", *** (to be created) ***
                    //         data: {pallet:palletId,sequence:baySequence,order:orderId,bay:bayId}
                    //         }).done(function(noteAddedResult) {
                    //         }

                    // }
                    // console.log(decodedResults);
                   
                    closePallet(palletId,bayName,decodedResults.response);
                }
                else if(decodedResults.shortage =="true" && decodedResults.proceed <1){
                    alert('You must confirm at least one item to this pallet before closing it');
                }
                else 
                {
                    //no part shortage just close the pallet
                    closePallet(palletId,bayName,0);
                }
            }
            else {
                // thre is an error show the error.
                alert(decodedResuls.response);
            }
            
        })
    
    
}

</script>
<?php 
print renderClosePanel();
include('footer.php');
exit;
?>
