<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Job Batches";
include('header.php');

$wc=$primaryWC;
if (! isset($_GET['batch'])) {
    $_GET=$_POST;
}
$batch=$_GET['batch'];
$batch=str_replace("B","",$batch);
$batch=str_replace("b","",$batch);

$part=$_GET['part'];

print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<p>Enter either a batch number or part number, then click find.</p>";
print "<form action='batchView.php' name='selform' method='GET'>";
print renderTextBox(TRUE,"batch",$batch,"Batch");
print renderTextBox(TRUE,"part",$part,"Part");
print renderButton("Find","green","document.selform.submit();");
print "</form>";
if ($isAdmin or strtolower($userEmail)=="sdowery@preferredmachinellc.com"  or strtolower($userEmail)=="sdowery@preferredmachinellc.com") {
    print "<p>You can complete it by clicking the button below.</p>";
    print "<form action='batchEdit.php'method='GET' name='updform'>";
    print "<input type='hidden' name='batch' value='$batch'>";
    print "<input type='hidden' name='a' value='complete'>";
    print renderButton("Complete Batch $batch","red","document.updform.submit()");
    print "</form>";
}

if ($batch or $part) {
    if ($part) {
        $sql="select distinct jb.* from jobs_batch jb, jobs_batch_orders jbo, jobs j where jb.batch_id=jbo.batch_id and jbo.job_id=j.job_id and item_id like ?";
        $lp="%" . $part . "%";
        list($batchrs,$err)=runIQuery($db,$sql,array("s",$lp));
    } else {
        $sql="select * from jobs_batch where batch_id=?";
        list($batchrs,$err)=runIQuery($db,$sql,array("i",$batch));
    }
    print "<table id='avj' class='table table-striped'>";
    print "<thead>";	
    print "<tr id='header'><th>Batch</th><th>Workcenter</th><th>Machine</th><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th><th>Labels</th><th>Job Status</th></tr>\n";
    print "</thead><tbody>";
    $anyOpen=0;
    foreach ($batchrs as $batchdata) {
        $batch=$batchdata['batch_id'];
        $machine=$batchdata['machine_id'];
        $wc=$batchdata['workcenter_id'];
        $complete=$batchdata['batch_complete'];
        $ready=$batchdata['batch_ready'];
        $sql="select workcenter_name from workcenters where workcenter_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
        $wcName=$rs[0]['workcenter_name'];
        $sql="select machine_name from machines where machine_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$machine));
        $machineName=$rs[0]['machine_name'];
        $sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, b.batch_id, l.order_id, status_name from jobs ";
        $sql.=" inner join order_lines l on jobs.line_id=l.line_id ";
        $sql.="inner join jobs_batch_orders jbo on jobs.job_id=jbo.job_id  inner join jobs_batch b on jbo.batch_id=b.batch_id and b.batch_id=?  ";
        $sql.=" inner join job_status js on jobs.status=status_id ";
        $sql.=" left outer join routing r on jobs.item_id=r.parent_part and r.workcenter_id=? ";
        $sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
        $sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";        
        //$sql.= " and jobs.status=1 ";
        $sql.=" order by coalesce(schedule_date, start_date) ";
        list($rs,$err)=runIQuery($db,$sql,array("iii",$batch,$wc,$wc));
        foreach ($rs as $data) {
            $job=$data['job_id'];
            $item=$data['item_id'];
            $so=$data['order_id'];
            $startDate = $data['start_date'];
            $cmpQty=$data['quantity_scheduled'];
            $goodQty=$data['quantity_good'];
            $status=$data['status_name'];
            $sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
            list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
            $ds=$wrs[0][0];
            $op=$wrs[0][1];
            $sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
            list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
            $tqty=0;
            foreach ($wrs as $wdata) {
                $tqty+= $wdata["good"];
            }
            $due=$cmpQty - $tqty;
            if ($due <= 0) {
                $due=0;
            }
            $wcStart=$startDate;
            $sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
            list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
            if (count($srs)>0) {
                $sdata=$srs[0];
                $wcStart=$sdata['schedule_date'];
            }
            print "<tr><td>$batch</td><td>$wcName</td><td>$machineName</td><td>$job</td><td>$so</td><td>$item</td><td>";
            print formatDateDBToWeb($wcStart);
            print "</td><td>";
            print formatDateDBToWeb($startDate);
            print "</td>";
            print "<td align='right'>$availableQty</td>";
            $goodsofar=$cmpQty-$due;
            print "<td align='right'>$goodsofar</td>";
            print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
            print "<td>";
            print renderButton("Labels","blue","makeBatchLabels('$batch');");
            print "</td>";
            print "<td>$status</td>";
            print "</tr>\n";
            if ($status == "Open") {
                $anyOpen=1;
            }
        }
    }
    print "</tbody>";
    print "</table>\n";
    if (! $anyOpen) {
        $sql="update jobs_batch set batch_complete=1 where batch_id=?";
        list($updrs,$err)=runIQuery($db,$sql,array("i",$batch));
    }
}

print renderClosePanel();
?>
<script>
	function page_init() {
	}
    function makeBatchLabels(batchid) {
        window.open('makeBatchLabels.php?batch='+batchid+'&rand='+Math.random());
    }
</script>
<?php
include('footer.php');
?>