<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$employee=0;
$noGo = 0;
function createResults($db,$card,$job,$routing,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch) {
	$complete=0;
	$sql="select employee_id from employees where card_number=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$card));
	$employee=0;
	if (count($rs)>0) {
		$data=$rs[0];
		$employee=$data[0];
	}
	date_default_timezone_set('America/Detroit');
	$sql="SET time_zone = '" .date('P') . "'";
	list($rs,$err)=runIQuery($db,$sql);

	$sql="insert into production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete) values (?, ?, ?, now(), ?, ?, ?, 1, ?, ?, ?, ?) ";
	list($rs,$err)=runIQuery($db,$sql,array("iiiiiisssi",$job,$routing,$employee,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch,$complete));
	$rid=$rs[0][0];
	return $rid;
}
print renderPanel("Batch Time Entry");
print "<form name='teform' id='teform' action='batchTimeEntry.php' method='POST'>";
if (isset($_POST['stop'])) {
	$i=0;
	$wc=$_POST['wc'];
    $batch=$_POST['batch'];
	$rows=$_POST['totalrows'];
	$notes=$_POST['notes'];
	$lastPunch=$_POST['start'];
	$newPunch=Date("Y-m-d H:i:s");

	//Switch over to new time calculation -Josh 04-25-2022
	$diff = strtotime($newPunch) - strtotime($lastPunch); //total seconds taken

    $minutes = round($diff/60)%60;
    $hours = floor($diff/60/60);

	$joblist=array();
	print "<table class='table table-striped'><thead><tr id='header'><th>Work Order</th><th>Part</th><th>Description</th><th>Qty Processed</th><th>Qty Scrap</th></tr></thead><tbody>\n";
	print "<p>Below are the results.  To Select more work orders, click the Next button.</p>";
	while ($i < $rows) {
		$i++;
		$job=$_POST['job'.$i];
		$part=$_POST['part'.$i];
		$description=$_POST['description'.$i];
		$cut=$_POST['good'.$i];
		$qtylost=$_POST['scrap'.$i];
		$dt=$_POST['due'.$i];
		print "<tr><td>$job</td><td>$part</td><td>$description</td><td>$cut</td><td>$qtylost</td></tr>\n";
		## figure out routing for the part
		$sql="select max(r.display_sequence) from routing r, jobs j where parent_part = item_id and job_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$max=$rs[0][0];
		$sql="select routing_id, display_sequence from routing where parent_part='$part' and workcenter_id=? ";
		list($rrs,$err)=runIQuery($db,$sql,array("i",$wc));
		$routing=0;
		if (count($rrs)>0) {
			$routing=$rrs[0][0];
			$seq=$rrs[0][1];
		}
		$lastStep=0;
		if ($seq == $max) {
			$lastStep=1;
		}
    	if ($cut > 0) {
			$employee=$_POST['employee1'];
			$result_id=createResults($db,$employee,$job,$routing,$hours,$minutes,$cut,$notes,$lastPunch,$newPunch);
			$sql="select coalesce(quantity_scheduled - sum(coalesce(p.quantity_good,0)),0) as tomake, item_id from jobs j ";
			$sql.=" left outer join production_results p on j.job_id=p.job_id  left outer join routing r on p.routing_id=r.routing_id and r.routing_id=?  where j.job_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$routing,$job));
			$data=$rs[0];
			if ($data['tomake'] <= 0)  {
				$sql="update production_results set complete=1 where results_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$result_id));
				$joblist[]=$job;
			}
			$employee=$_POST['employee2'];
			if ($employee) {
				$result_id=createResults($db,$employee,$job,$routing,$hours,$minutes,0,$notes,$lastPunch,$newPunch);
			}
			$employee=$_POST['employee3'];
			if ($employee) {
				$result_id=createResults($db,$employee,$job,$routing,$hours,$minutes,0,$notes,$lastPunch,$newPunch);
			}
			if ($lastStep) {
				$sql="select item_id,  default_location from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$part));
				$data=$rs[0];
				$item_id=$data['item_id'];
				$loc=$data['default_location'];
				if (! $loc) {
					$loc=1;
				}
				$sql="update jobs set quantity_good=quantity_good+$cut where job_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				# close the job if quantity is enough
				$sql="update jobs set status=2 where quantity_good >= quantity_scheduled and job_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				inventoryUpdate($db,$item_id,$cut,"batchTimeEntry.php","Job $job created",$userID,$loc);
			}
		}
		if ( $qtylost) {
			$defect="Defective";
			$jobDate=Date("Y-m-d h:i:s");
			$sql="insert into job_defects (job_id, defect_id, date_reported, quantity, routing_id) values (?, ?, ?, ?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("iisii",$job,$defect,$jobDate,$qtylost,$routing));
		}
	}
	$sql="select p.job_id, sum(p.quantity_good) as good, j.quantity_scheduled from jobs_batch_orders jbo inner join jobs_batch jb on jbo.batch_id=jb.batch_id ";
	$sql.=" left outer join jobs j on jbo.job_id=j.job_id ";
	$sql.=" left outer join routing r on j.item_id=parent_part and r.workcenter_id=jb.workcenter_id ";
	$sql.=" left outer join production_results p on jbo.job_id=p.job_id and r.routing_id=p.routing_id  ";
	$sql.="  where jbo.batch_id=? group by p.job_id having sum(p.quantity_good) < quantity_scheduled  ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
	if (count($rs)==0) {
		$sql="update jobs_batch set batch_complete=1 where batch_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
	}
	if (count($joblist)>0) {
		$jl=implode(",",$joblist);
		print "\n<script>window.open('renderTCPDF.php?type=WO&id=$jl&so=&due=$dt&part=$part&qty=$qty&copies=1','_blank');</script>\n";
	}
	print "\n<script>window.open('renderTCPDFBatch.php?id=$$batch','_blank');</script>\n";
	print renderButton("Next","green","document.location.href='machineJobs.php?wc=$wc';");
} else {
	if (isset($_GET['batch'])) {
		$batch=$_GET['batch'];
		$employee1=$_GET['e1'];
		$employee2=$_GET['e2'];
		if (! $employee2) {
			$employee2=0;
		}
		$employee3=$_GET['e3'];
		if (! $employee3) {
			$employee3=0;
		}
		$sql="select jobs_batch.workcenter_id, workcenter_name from jobs_batch, workcenters where batch_id=? and jobs_batch.workcenter_id=workcenters.workcenter_id";
		list($wrs,$er)=runIQuery($db,$sql,array("i",$batch));
		$wdata=$wrs[0];
		$wc=$wdata['workcenter_id'];
		$wcName=$wdata['workcenter_name'];
		$newPunch=Date("Y-m-d H:i:s");
		$sql="select * from jobs_batch_orders jbo, production_results p, routing r  where jbo.job_id=p.job_id and p.routing_id=r.routing_id and workcenter_id=? and jbo.batch_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$wc,$batch));
		if (count($rs)>0) {
			print "Resuming Batch $batch for $userName";
		} else {
			print "Starting Batch $batch for $userName";
		}
		print "<center><h4>";
		print "</h4></center>";
		print "<input type='hidden' name='stop' id='stop' value='1'>";
		print "<input type='hidden' name='start' id='start' value='$newPunch'>";
		print "<input type='hidden' name='wc' id='wc' value='$wc'>";
		print "<input type='hidden' name='batch' id='batch' value='$batch'>";
		print "<input type='hidden' name='employee1' id='employee1' value='$employee1'>";
		print "<input type='hidden' name='employee2' id='employee2' value='$employee2'>";
		print "<input type='hidden' name='employee3' id='employee3' value='$employee3'>";
		print "<p>After completion, enter the specific quantities for each job and press the Stop button.</p>";
		print "<p>Alternatively, you can fill out total quantity and click apply and the system will fill them in for you.</p>";
		print "<p>Please fill out any notes.</p>";
		print "<p>If you are taking a break, just fill out the quantities you have finsihed and press Stop.  You will be able to get back to this batch later.</p>";
		$sql="select last_name, first_name from employees where card_number in (?, ?, ?) order by last_name, first_name";
		list($rs,$err)=runIQuery($db,$sql,array("iii",$employee1,$employee2,$employee3));
		print "<div class='floatright right'>Employee(s) clocked in:</div>";
		foreach ($rs as $data) {
			print "<div class='floatright right'>" . $data['first_name'] . " " . $data['last_name'] . "</div>";
		}
		print "<div style='clear: both;'></div>";
		print renderTextBox(TRUE,"total","0","Total Qty");
		print renderButton("Apply","blue","applyTotal()");
		print renderButton("Stop","red","document.teform.submit();");
		print renderTextArea(TRUE,"notes","","Notes");
		print "<table class='table table-striped'><thead><tr id='header'><th>Work Order</th><th>Part</th><th>Description</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Good</th><th>Qty Scrap</th></tr></thead><tbody>\n";
		$sql="select job_id from jobs_batch_orders where batch_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
		foreach ($rs as $data) {
			$job=$data['job_id'];
			print renderJobLine($db,$batch,$job,$wc,FALSE);
		}
		print "</table>";
		print "<input type='hidden' name='totalrows' value='$j'>";
	}	 else {
		if (isset($_POST['start'])) {
			$i=0;
			$j=0;
			$rows=$_POST['totalrows'];
			$start=$_POST['start'];
			$wc=$_POST['wc'];
			$newPunch=Date("Y-m-d H:i:s");
			$sql="insert into jobs_batch (batch_date, batch_user, workcenter_id) values (now(), ?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$userID,$wc));
			$batch=$rs[0]['id'];
			$sql="select workcenter_name from workcenters where workcenter_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
			$wcName=$rs[0][0];
			print "<center><h4>Batch $batch created for $wcName</h4></center>";
			print "<input type='hidden' name='stop' id='stop' value='1'>";
			print "<input type='hidden' name='start' id='start' value='$newPunch'>";
			print "<input type='hidden' name='wc' id='wc' value='$wc'>";
			print "<input type='hidden' name='batch' id='batch' value='$batch'>";
			print "<p>After completion, enter the specific quantities for each job and press the Stop button.</p>";
			print "<p>Alternatively, you can fill out total quantity and click apply and the system will fill them in for you.</p>";
				print "<p>Please fill out your Employee Number and any notes.</p>";
			print "<p>If you are taking a break, just fill out the quantities you have finsihed and press Stop.  You will be able to get back to this batch later.</p>";
			print renderTextBox(TRUE,"total","0","Total Qty");
			print renderButton("Apply","blue","applyTotal()");
			print renderTextBox(TRUE,"employee","","Employee");
			print renderTextArea(TRUE,"notes","","Notes");
			print "<table class='table table-striped'><thead><tr id='header'><th>Work Order</th><th>Part</th><th>Description</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Good</th><th>Qty Scrap</th></tr></thead><tbody>\n";
			while ($i < $rows) {
				$i++;
				if (isset($_POST['sel'.$i])) {
					if ($_POST['sel'.$i]) {
						$job=$_POST['sel'.$i];
						print renderJobLine($db,$batch,$job,$wc,TRUE);
					}
				}
			}

		}
		print "</tbody></table>\n";
		print renderButton("Stop","red","document.teform.submit();");
		print "<input type='hidden' name='totalrows' value='$j'>";
    }
}
print "</form>";
print renderClosePanel();
function renderJobLine($db,$batch,$job,$workcenterID,$new=TRUE) {
	global $j;
	$sql="select * from jobs where job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$data=$rs[0];
	$part=$data['item_id'];
	$description=$data['description'];
	$qty=$data['quantity_scheduled'];
	$good=$data['quantity_good'];
	$lineID=$data['line_id'];
	$dt=formatDateDBToWeb($data['start_date']);
	$togo=$qty-$good;
	if ($togo < 0) {
		$togo=1;
	}
	$j++;
	if ($new) {
		$sql="insert into jobs_batch_orders (batch_id, job_id) values (?, ?) ";
		list($updrs,$err)=runIQuery($db,$sql,array("ii",$batch,$job));
	}
	$retval= "<tr><td>$job</td><td>$part</td><td>$description</td><td>$qty</td><td>$good</td><td>";
	$retval.="<input type='text' name='good$j' id='good$j' value='$togo'>";
	$retval.="<input type='hidden' name='togo$j' id='togo$j' value='$togo'>";
	$retval.="<input type='hidden' name='job$j' id='job$j' value='$job'>";
	$retval.="<input type='hidden' name='part$j' id='part$j' value='$part'>";
	$retval.="<input type='hidden' name='description$j' id='description$j' value=\"$description\">";
	$retval.="<input type='hidden' name='qty$j' id='qty$j' value='$qty'>";
	$retval.="<input type='hidden' name='due$j' id='due$j' value='$dt'>";
	$retval.="</td><td>";
	$retval.="<input type='text' name='scrap$j' id='scrap$j'  value='0'>";
	$retval.="</td></tr>\n";
			## Status 7 is At Weld
	if (in_array($workcenterID,array(157,158,159,161,162,168))) {
		$sql="update orders set status=7 where order_id in (select order_id from order_lines where line_id=?) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
		$sql="update order_lines set line_status=7 where line_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
	}
	## 169 assembly
	## status 10 is At Assembly
	if ($workcenterID == 169) {
		$sql="update orders set status=10 where order_id in (select order_id from order_lines where line_id=?) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
		$sql="update order_lines set line_status=10 where line_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
	}
	## 180 Bend
	## this can have jobs for multiple sales orders
	## 15 is At Bend
	if ($workcenterID == 180) {
		$sql="update orders set status=15 where order_id in (select order_id from order_lines where line_id=?) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
		$sql="update order_lines set line_status=15 where line_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
		$sql="update orders set status=15 where order_id in (select order_id from order_lines, jobs_orders where job_id=? and jobs_orders.order_line=order_lines.line_id) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$sql="update order_lines set line_status=15 where line_id in (select order_line from jobs_orders where job_id=?)  ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	}
	return $retval;
}
?>
<script>
function applyTotal() {
	checkgroup="[id^=\'good\']";
	toapply=parseInt($('#total').val());
	$(checkgroup).each(function(index) {
		togo='#'+$(this).attr('id').replace('good','togo');
		cmp=parseInt($(togo).val());
		if (toapply >= cmp) {
			$(this).val(cmp);
			toapply = toapply - cmp;
		} else {
			$(this).val(toapply);
			toapply=0;
		}
    });
	$('#total').val(toapply);
}
</script>
<?php
include('footer.php');
