<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Job Batches";
include('header.php');

$wc=$primaryWC;
if (! isset($_GET['batch'])) {
    $_GET=$_POST;
}
$batch=$_GET['batch'];
if (isset($_GET['a'])) {
    if ($_GET['a']=='complete') {
        $sql="update jobs_batch set batch_complete=1 where batch_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
    }
}

$sql="select * from jobs_batch where batch_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
$data=$rs[0];
$machine=$data['machine_id'];
$wc=$data['workcenter_id'];
$complete=$data['batch_complete'];
$ready=$data['batch_ready'];
if ($complete) {
    print "This batch is  complete and cannot be modified.";
    include('footer.php');
    exit;
}
$sql="select * from jobs_batch_orders jbo, production_results pr, routing r where jbo.batch_id=? and jbo.job_id=pr.job_id and pr.routing_id=r.routing_id and r.workcenter_id=168";
list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
if (count($rs)>0) {
    print "<p>This batch has production results and cannot be modified.</p>";
    if ($isAdmin or strtolower($userEmail)=="sdowery@preferredmachinellc.com") {
        print "<p>However, you can complete it by clicking the button below.</p>";
        print "<form action='batchEdit.php'method='GET' name='updform'>";
        print "<input type='hidden' name='batch' value'$batch'>";
        print "<input type='hidden' name='a' value='complete'>";
        print renderButton("Complete Batch $batch","success","document.batchEdit.submit()");
        print "</form>";
    }
    include('footer.php');
    exit;
}
print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<h4>Batch $batch</h4>";

if (isset($_POST['update'])) {
    $machine=$_POST['machine'];
    $wc=$_POST['wc'];
    $ready=$_POST['ready'];
    if (! $ready) {
        $ready=0;
    }
    $sql="update jobs_batch set machine_id=?, workcenter_id=?, batch_ready=? where batch_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("iiii",$machine,$wc,$ready,$batch));
    $rows=$_POST['totalrows'];
    $i=0;
    while ($i < $rows) {
        $i++;
        if (isset($_POST['sel'.$i])) {            
            $job=$_POST['job'.$i];
            if ($job)  {
                $sql="select * from jobs_batch_orders where  job_id=?";
                list($rs,$err)=runIQuery($db,$sql,array("i",$job));
                if (count($rs)==0) {
                    $sql="insert into jobs_batch_orders (batch_id, job_id, jbo_quantity) values (?, ?,0) ";
                    list($rs,$err)=runIQuery($db,$sql,array("ii",$batch,$job));
                }
            }
        } else {
            $job=$_POST['job'.$i];
            $sql="delete from jobs_batch_orders where job_id=? and batch_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$batch));
        }
    }
    print "<h4>Batch $batch has been updated</h4>";    
}
print "<form autocomplete='off' action='batchEdit.php' name='ajform' id='ajform' method='POST'>\n";

print "<input type='hidden' name='update' value='1'>";
print "<input type='hidden' name='batch' value='$batch'>";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,true);
$sql="select machine_id, machine_name from machines ";
if ($wc) {
    $sql.=" where workcenter_id=$wc ";
}
$sql.=" order by machine_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"machine",$machine,"Machine","N",$rs,true);
print renderCheckBox(TRUE,"ready",$ready,"Batch Ready");
print "<div style='clear: both;'></div>\n";
print "<div id='btnSubmit' class='btn green hidden-print ' style='float: right;' onclick='document.ajform.submit();'>Update</div>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='btnContinue' class='btn green hidden-print ' style='float: right;' onclick=\"document.location.href='availableJobsWeld.php?wc=168';\">Back to Available Jobs</div>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='components'></div>";
print "<table id='avj' class='table table-striped'>";
print "<thead >";	
print "<tr id='header'><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th></tr>\n";
print "</thead><tbody>";

$i=0;
$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, b.batch_id from jobs ";
$sql.="inner join jobs_batch_orders jbo on jobs.job_id=jbo.job_id  inner join jobs_batch b on jbo.batch_id=b.batch_id and b.batch_id=? and batch_complete=0 ";
$sql.=" left outer join routing r on jobs.item_id=r.parent_part and r.workcenter_id=? ";
$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
$sql.= " and jobs.status=1 ";
$sql.=" order by coalesce(schedule_date, start_date) ";
list($rs,$err)=runIQuery($db,$sql,array("iii",$batch,$wc,$wc));
foreach ($rs as $data) {
    $job=$data['job_id'];
    $item=$data['item_id'];
    $startDate = $data['start_date'];
    $cmpQty=$data['quantity_scheduled'];
    $goodQty=$data['quantity_good'];
    $sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
    list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
    $ds=$wrs[0][0];
    $op=$wrs[0][1];
    $showJob=0;
    $sql="select min(display_sequence) from routing where parent_part=? ";
    list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
    if ($wrs[0][0]==$ds) {
        $showJob=1;
        $availableQty=$cmpQty;
        if (isset($_GET['debug'])) {
            print "showjob=1 because this is first step in routing<BR>";
        }
    } else {
        $sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
        list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
        $ckroute=$wrs[0][0];
        $priorWCName=$wrs[0][1];
        $sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from production_results r where job_id=? and routing_id=? group by coalesce(complete,0) ";
        list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
        $tqty=0;
        ## check this prior step and see if it is complete
        foreach ($wrs as $wdata) {
            if ($wdata['complete']) {
                $showJob=1;
            }
            $tqty+= $wdata["good"];
        }
        $availableQty=$tqty;
        $showJob=1;			
    }
    if ($showJob) {
        $sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
        list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
        $tqty=0;
        foreach ($wrs as $wdata) {
            if ($wdata['complete']) {
                $showJob=0;
            }
            $tqty+= $wdata["good"];
        }
        if ($tqty >= $cmpQty) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because $tqty >= $cmpQty<BR>";
            }
        }
        $due=$cmpQty - $tqty;
    }
    if ($showJob) {
        if ($goodQty >= $cmpQty) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because qty good >= qty scheduled<br>";
            }
        }
    }
    if ($showJob) {
        $sql="select * from jobs j, order_lines l where j.line_id=l.line_id and j.job_id=? and line_status in (3,4,5,6)";
        list($wrs,$err)=runIQuery($db,$sql,array("i",$job));
        if (count($wrs)>0) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because of line status<br>";
            }
        }
    }
    if ($showJob) {
        $wcStart=$startDate;
        $sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
        list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
        if (count($srs)>0) {
            $sdata=$srs[0];
            $wcStart=$sdata['schedule_date'];
        }
        if ($availableQty > 0) {
            $i++;
            print "<tr><td>$job</td><td>BATCH</td><td>$item</td><td>";
            print formatDateDBToWeb($wcStart);
            print "</td><td>";
            print formatDateDBToWeb($startDate);
            print "</td>";
            print "<td align='right'>$availableQty</td>";
            $goodsofar=$cmpQty-$due;
            print "<td align='right'>$goodsofar</td>";
            print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
            print "<td align='center'>";
            print "<input type='hidden' name='job$i' value='$job'>";
            print "<input type='checkbox' name='sel$i' checked>";
            print "</td>";
            print "</tr>\n";
        }			
    }
}
$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, l.order_id, priority_color from jobs ";
$sql.=" left outer join routing r on jobs.item_id=r.parent_part and workcenter_id=? ";
$sql.=" left outer join order_lines l on jobs.line_id=l.line_id ";
$sql.=" left outer join orders o on l.order_id=o.order_id ";
$sql.=" left outer join order_priorities op on o.priority=op.priority_id ";
$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
$sql.=" and jobs.job_id not in (select job_id from production_results p, routing r where coalesce(complete,0)=1 and r.workcenter_id=? and r.routing_id=p.routing_id ) ";
$sql.= " and jobs.status=1 ";
$sql.=" and jobs.job_id not in (select job_id from jobs_batch_orders) ";
$sql.=" and jobs.item_id=? ";
$sql.=" order by priority desc, start_date, job_id ";  
list($rs,$err)=runIQuery($db,$sql,array("iiis",$wc,$wc,$wc,$item));
foreach ($rs as $data) {
    $job=$data['job_id'];
    if (isset($_GET['debug'])) {
        print "<hr>";
        print "checking job $job<BR>";
    }
    $priority=$data['priority_color'];
    $item=$data['item_id'];
    $order=$data['order_id'];
    $startDate = $data['start_date'];
    $cmpQty=$data['quantity_scheduled'];
    $goodQty=$data['quantity_good'];
    $sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
    list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
    $ds=$wrs[0][0];
    $op=$wrs[0][1];
    $showJob=0;
    $sql="select min(display_sequence) from routing where parent_part=? ";
    list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
    if ($wrs[0][0]==$ds) {
        $showJob=1;
        $availableQty=$cmpQty;
        if (isset($_GET['debug'])) {
            print "showjob=1 because this is first step in routing<BR>";
        }
    } else {
        $sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
        list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
        $ckroute=$wrs[0][0];
        $priorWCName=$wrs[0][1];
        $sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results where job_id=? and routing_id=? group by coalesce(complete,0) ";
        list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
        $tqty=0;
        ## check this prior step and see if it is complete
        foreach ($wrs as $wdata) {
            if ($wdata['complete']) {
                $showJob=1;
            }
            $tqty+= $wdata["good"];
        }
        $availableQty=$tqty;
        $showJob=1;			
    }
    if ($showJob) {
        $sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
        list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
        $tqty=0;
        foreach ($wrs as $wdata) {
            if ($wdata['complete']) {
                $showJob=0;
            }
            $tqty+= $wdata["good"];
        }
        if ($tqty >= $cmpQty) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because $tqty >= $cmpQty<BR>";
            }
        }
        $due=$cmpQty - $tqty;
    }
    if ($showJob) {
        if ($goodQty >= $cmpQty) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because qty good >= qty scheduled<br>";
            }
        }
    }
    if ($showJob) {
        $sql="select * from jobs j, order_lines l where j.line_id=l.line_id and j.job_id=? and line_status in (3,4,5,6)";
        list($wrs,$err)=runIQuery($db,$sql,array("i",$job));
        if (count($wrs)>0) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because of line status<br>";
            }
        }
    }
    if ($showJob) {
        $sql="select packing_slip from jobs j, order_lines l, transfer_lines tl where j.line_id=l.line_id and j.job_id=? and l.order_id=so_number and tl.part_number=? ";
        list($trs,$err)=runIQuery($db,$sql,array("is",$job,$item));			
        if (count($trs)>0) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because on transfer " . $trs[0][0] . "<BR>";
            }
        }
    }
    if ($showJob) {
        $sql="select sum(pl.quantity) from jobs j,  packing_slip_lines pl where j.job_id=? and j.line_id=pl.order_line ";
        list($prs,$err)=runIQuery($db,$sql,array("i",$job));
        $pdata=$prs[0];
        if ($pdata[0]>= $cmpQty) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because we have alread shipped " . $pdata[0] . "<BR>";
            }
        } else {
            if (isset($_GET['debug'])) {
                print "still showing becuase we only shipped " . $pdata[0] . "<BR>";
            }
        }
    }
    if ($showJob) {
        $sql="select * from production_results p, routing r where job_id=? and p.routing_id=r.routing_id and operation_id=3116";
        list($rs,$err)=runIQuery($db,$sql,array("i",$job));
        if (count($rs)>0) {
            $showJob=0;
            if (isset($_GET['debug'])) {
                print "not available because results for powder application<br>";
            }
        }
    }
    if ($showJob) {
        $wcStart=$startDate;
        $sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
        list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
        if (count($srs)>0) {
            $sdata=$srs[0];
            $wcStart=$sdata['schedule_date'];
        }
        if ($availableQty > 0) {
            $i++;
            print  "<tr class='$item' style='color: $priority;' id='row$i'>";
            print "<td>$job</td><td>$order</td><td>$item</td><td>";
            print formatDateDBToWeb($wcStart);
            print "</td><td>";
            print formatDateDBToWeb($startDate);
            print "</td>";
            print "<td align='right'>$availableQty</td>";
            $goodsofar=$cmpQty-$due;
            print "<td align='right'>$goodsofar</td>";
            print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
            print "<td align='center'><input type='hidden' name='job$i' value='$job'><input type='checkbox' name='sel$i' id='sel$i' value='$job' \"></td>";
            print "</tr>\n";
        }			
    }
}
print "</tbody>";
print "</table>\n";
print "<input type='hidden' name='totalrows' id='totalrows' value='$i'>";
print "</form>";

print renderClosePanel();
?>
<script>
	function page_init() {
	}
</script>
<?php
include('footer.php');
?>