<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Available Jobs";
include('header.php');

$wc=$primaryWC;
if (isset($_GET['wc'])) {
	$wc=$_GET['wc'];
}
$start=Date("01/01/Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
} else {
	$end=Date("m/d/Y");
}
$searchpart="";
if (isset($_GET['part'])) {
	$searchpart=$_GET['part'];
}
if ($wc == 169) {
	print "<script>document.location.href='availableJobsAssembly.php?wc=169&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}
if ($wc == 170) {
	print "<script>document.location.href='availableJobsOP.php?wc=170&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}
if ($wc != 168) {
	print "<script>document.location.href='availableJobs.php?wc=$wc&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}

print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<form autocomplete='off' action='availableJobs.php' name='ajform' id='ajform' method='GET'>\n";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,true);
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderTextBox(TRUE,"part",$searchpart,"Part Prefix");
print "<div style='clear: both;'></div>\n";
print "<div id='btnSubmit' class='btn green hidden-print ' style='float: right;' onclick='document.ajform.submit();'>Find</div>\n";
print "<div style='clear: both;'></div>\n";
print "</form>\n";
print "<div id='btnBatch' class='btn red hidden-print' style='float: right;' onclick=\"this.style.display='none';document.selform.submit();\">Create Batch</div>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='components' style='min-height: 120px;'>&nbsp;</div>";
if ($wc) {
	$sql="select j.job_id, j.item_id, r.routing_id, j.quantity_scheduled, sum(p.quantity_good) as good, r.display_sequence from jobs j ";
	$sql.=" inner join production_results p on j.job_id=p.job_id inner join routing r on p.routing_id=r.routing_id and r.workcenter_id=? ";
	$sql.=" where 1> 0 ";
	$sql.=" and j.status = 1 and j.start_date >= '2020-01-01' ";
	if ($searchpart) {
		$sql.=" and j.item_id like '%" . $searchpart . "%' ";
	}
	$sql.=" group by j.job_id, r.routing_id, r.display_sequence, j.quantity_scheduled having sum(p.quantity_good) > 0 ";	
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach ($rs as $data) {
		$qs=$data['quantity_scheduled'];
		$good=$data['good'];
		$j=$data['job_id'];
		$r=$data['routing_id'];
		
		$ds=$data['display_sequence'];
		$part=$data['item_id'];
		$sql="select max(display_sequence) as max from routing where parent_part=?";
		list($mrs,$err)=runIQuery($db,$sql,array("s",$part));
		$mdata=$mrs[0];
		$max=$mdata[0];		
		if ($good >= $qs) {
			$sql="update production_results set complete=1 where job_id=? and routing_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("ii",$j,$r));
			if ($max == $ds) {
				$sql="update jobs set status=2 where job_id=?";
				list($updrs,$err)=runIQuery($db,$sql,array("i",$j));
			}
		}	
	}
	print "<form name='selform' action='batchCreation.php' method='POST'>";
	print "<input type='hidden' name='start' value='1'>";
	print "<input type='hidden' name='wc' value='$wc'>";
	print "<table id='avj' class='table table-striped'>";
	print "<thead >";	
	print "<tr id='header' qty='0'><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th><th>Scheduled?</th></tr>\n";
	print "</thead><tbody>";
	$s=formatDateWebtoDB($start);
	$e=formatDateWebtoDB($end);

	$sql="select o.order_id, l.item_id, coalesce(j.start_date,l.due_date) as start_date, 0 as quantity_good, l.quantity as quantity_scheduled ";
	$sql.=" from orders o inner join order_lines l on o.order_id=l.order_id  left outer join routing r on l.item_id=r.parent_part and workcenter_id=? ";
	$sql.=" left outer join jobs j on l.line_id=j.line_id and  j.item_id not in (select part_number from stamped_inventory)  where o.status not in (3,4,5,6) ";
	$sql.=" and coalesce(j.start_date,l.due_date) >= '$s' and coalesce(j.start_date,l.due_date) <= '$e' ";
	$sql.=" and j.line_id is null  ";
	if ($searchpart) {
		$sql.=" and l.item_id like '%" . $searchpart . "%' ";
	}
	$sql.=" order by l.due_date ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach($rs as $data) {
		$item=$data['item_id'];
		$job=$data['order_id'];
		if (shouldIShowWC($db,$item,$wc,$job)) {
			$startDate = $data['start_date'];
			#CreateJobsForOrder($db,$job);				
		}
	}
	$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, l.order_id, l.line_id, priority_color, l.item_description from jobs ";
	$sql.=" left outer join routing r on jobs.item_id=r.parent_part and workcenter_id=? ";
	$sql.=" left outer join order_lines l on jobs.line_id=l.line_id ";
	$sql.=" left outer join orders o on l.order_id=o.order_id ";
	$sql.=" left outer join order_priorities op on o.priority=op.priority_id ";
	$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
	$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
	$sql.=" and jobs.job_id not in (select job_id from production_results p, routing r where coalesce(complete,0)=1 and r.workcenter_id=? and r.routing_id=p.routing_id ) ";
	$sql.=" and jobs.job_id not in (select job_id from jobs_batch jb, jobs_batch_orders jbo where workcenter_id=? and jb.batch_id=jbo.batch_id ) ";
	$sql.= " and jobs.status=1 ";
	if ($searchpart) {
		$sql.=" and jobs.item_id like '%" . $searchpart . "%' ";
	}
	$today=Date('Y-m-d');
	if ($s > $today) {
		$sql.=" and start_date >= '$s' and start_date <= '$e' ";
	}	else {
		$sql.=" and start_date >= '2021-01-01' and start_date <= '$e' ";
	}
	$sql.=" order by priority desc, l.due_date, job_id ";  
	list($rs,$err)=runIQuery($db,$sql,array("iiii",$wc,$wc,$wc,$wc));
	$i=0;

	if (isset($_GET['debug'])) {
		print "<hr>";
		print renderQuery($sql,array("iii",$wc,$wc,$wc));
	}
	#print "$sql<br>";
	foreach ($rs as $data) {
		$job=$data['job_id'];
		$line=$data['line_id'];
		$description=strtoupper($data['item_description']);
		$fastenerType="";
		if (strstr($description,"BOOT") or strstr($description,"BRACKET")) {
			$sql="select description from  order_lines l, items i where  line_id=? and  l.item_id=i.item_name and item_category=20 ";
			list($jrs,$err)=runIQuery($db,$sql,array("i",$line));
			if (count($jrs)>0) {
				$fgDescription=$jrs[0][0];
				if (strstr(strtoupper($fgDescription),"METRIC")) {
					$fastenerType="METRIC";
				} else {
					$fastenerType="STANDARD";
				}
			}
		}
		$associated="";
		$sql="select b.batch_id, b.batch_complete, b.batch_ready from jobs ";
		$sql.="inner join jobs_batch_orders jbo on jobs.job_id=jbo.job_id  inner join jobs_batch b on jbo.batch_id=b.batch_id and b.workcenter_id=?  ";
		$sql.=" left outer join routing r on jobs.item_id=r.parent_part and r.workcenter_id=? ";
		$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
		$sql.=" where  jobs.line_id=? ";
		$sql.= " and jobs.status=1 ";
		$sql.=" order by b.batch_id, coalesce(schedule_date, start_date) ";
		list($jrs,$err)=runIQuery($db,$sql,array("iii",$wc,$wc,$line));
		if (count($jrs)>0) {
			$jdata=$jrs[0];
			$batch=$jdata['batch_id'];
			$complete=$jdata['batch_complete'];
			$ready=$jdata['batch_ready'];
			$associated="<i class='icon-bug' title='";
			$associated.="Associated Batch $batch ";
			if ($complete) {
				$associated.=" Complete!";				
			} else {
				if ($ready) {
					$associated.=" Scheduled!";
				}
			}
			$associated.="'></i>";
		}

		if (isset($_GET['debug'])) {
			print "<hr>";
			print "checking job $job<BR>";
		}
		$priority=$data['priority_color'];
		$item=$data['item_id'];
		$order=$data['order_id'];
		$startDate = $data['start_date'];
		$cmpQty=$data['quantity_scheduled'];
		$goodQty=$data['quantity_good'];
		$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
		list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
		$ds=$wrs[0][0];
		$op=$wrs[0][1];
		$showJob=0;
		$sql="select min(display_sequence) from routing where parent_part=? ";
		list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
		if ($wrs[0][0]==$ds) {
			$showJob=1;
			$availableQty=$cmpQty;
			if (isset($_GET['debug'])) {
				print "showjob=1 because this is first step in routing<BR>";
			}
		} else {
			$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
			list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
			$ckroute=$wrs[0][0];
			$priorWCName=$wrs[0][1];
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results where job_id=? and routing_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
			$tqty=0;
			## check this prior step and see if it is complete
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=1;
				}
				$tqty+= $wdata["good"];
			}
			$availableQty=$tqty;
			$showJob=1;			
		}
		if ($showJob) {
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
			$tqty=0;
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=0;
				}
				$tqty+= $wdata["good"];
			}
			if ($tqty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because $tqty >= $cmpQty<BR>";
				}
			}
			$due=$cmpQty - $tqty;
		}
		if ($showJob) {
			if ($goodQty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because qty good >= qty scheduled<br>";
				}
			}
		}
		if ($showJob) {
			$sql="select * from jobs j, order_lines l where j.line_id=l.line_id and j.job_id=? and line_status in (3,4,5,6)";
			list($wrs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($wrs)>0) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because of line status<br>";
				}
			}
		}
		if ($showJob) {
			$sql="select packing_slip from jobs j, order_lines l, transfer_lines tl where j.line_id=l.line_id and j.job_id=? and l.order_id=so_number and tl.part_number=? ";
			list($trs,$err)=runIQuery($db,$sql,array("is",$job,$item));			
			if (count($trs)>0) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because on transfer " . $trs[0][0] . "<BR>";
				}
			}
		}
		if ($showJob) {
			$sql="select sum(pl.quantity) from jobs j,  packing_slip_lines pl where j.job_id=? and j.line_id=pl.order_line ";
			list($prs,$err)=runIQuery($db,$sql,array("i",$job));
			$pdata=$prs[0];
			if ($pdata[0]>= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because we have alread shipped " . $pdata[0] . "<BR>";
				}
			} else {
				if (isset($_GET['debug'])) {
					print "still showing because we only shipped " . $pdata[0] . "<BR>";
				}
			}
		}
		if ($showJob) {
			$sql="select * from production_results p, routing r where job_id=? and p.routing_id=r.routing_id and operation_id=3116";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($rs)>0) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because results for powder application<br>";
				}
			}
		}
		if ($showJob) {
			## check for laser job make sure it is done
			$sql="select j.* from billofmaterial b, jobs j, routing r  where parent_item=? and child_item=j.item_id and j.line_id=? ";
			$sql.=" and j.item_id=r.parent_part or j.item_id=parent_part)  and r.operation_id=3123 and j.quantity_good < ? * quantity_per ";
			list($jrs,$err)=runIQuery($db,$sql,array("sii",$item,$line,$cmpQty));
			if (isset($_GET['debug'])) {
				print renderQuery($sql,array("sii",$item,$line,$cmpQty));
				print "<br>";
			}
			if (count($jrs)>0) {
				$testPart=$jrs[0]['item_id'];
				$sql="select * from stamped_inventory where part_number=?";
				list($jrs,$err)=runIQuery($db,$sql,array("s",$testPart));
				if (count($jrs)==0) {
					$showJob=0;
					if (isset($_GET['debug'])) {
						print "not available because laser job not done<br>";
					}
				}
			}
		}
		if ($showJob) {
			$wcStart=$startDate;
			$sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
			list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
			if (count($srs)>0) {
				$sdata=$srs[0];
				$wcStart=$sdata['schedule_date'];
			}
			if ($availableQty > 0) {
				$showitem=$item;
				if ($fastenerType) {
					$showitem.="-" . $fastenerType;
				}
				$i++;
				print  "<tr class='$item' style='color: $priority;' id='row$i' data-qty='$cmpQty'>";
				print "<td>$job $associated</td><td>$order</td><td>$showitem</td><td>";
				print formatDateDBToWeb($wcStart);
				print "</td><td>";
				print formatDateDBToWeb($startDate);
				print "</td>";
				print "<td align='right'>$availableQty</td>";
				$goodsofar=$cmpQty-$due;
				print "<td align='right'>$goodsofar</td>";
				print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
				print "<td align='center'><input type='checkbox' name='sel$i' id='sel$i' value='$job' onclick=\"selectOnly('$item',this);\"></td>";
				print "<td align='right'>&nbsp;</td>";
				print "</tr>\n";
			}			
		}
	}
	print "</tbody>";
	print "</table>\n";

	print "<table id='avjb' class='table table-striped'>";
	print "<thead >";	
	print "<tr id='header' qty='0'><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th><th>Scheduled?</th></tr>\n";
	print "</thead><tbody>";

	$batchShown=array();
	$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, b.batch_id, b.batch_ready from jobs ";
	$sql.="inner join jobs_batch_orders jbo on jobs.job_id=jbo.job_id  inner join jobs_batch b on jbo.batch_id=b.batch_id and b.workcenter_id=? and batch_complete=0 ";
	$sql.=" left outer join routing r on jobs.item_id=r.parent_part and r.workcenter_id=? ";
	$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
	$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
	$today=Date('Y-m-d');
	if ($s > $today) {
		$sql.=" and coalesce(schedule_date,start_date) >= '$s' and coalesce(schedule_date,start_date) <= '$e' ";
	}	else {
		$sql.=" and coalesce(schedule_date,start_date) >= '2021-01-01' and coalesce(schedule_date,start_date) <= '$e' ";
	}
	$sql.= " and jobs.status=1 ";
	$sql.=" and jobs.item_id like'%$searchpart%' ";
	$sql.=" order by b.batch_id, coalesce(schedule_date, start_date) ";
	list($rs,$err)=runIQuery($db,$sql,array("iii",$wc,$wc,$wc));
	foreach ($rs as $data) {
		$job=$data['job_id'];
		$batch=$data['batch_id'];
		$ready=$data['batch_ready'];
		if (isset($_GET['debug'])) {
			print "<hr>";
			print "checking job $job<BR>";
		}
		$item=$data['item_id'];
		$startDate = $data['start_date'];
		$cmpQty=$data['quantity_scheduled'];
		$goodQty=$data['quantity_good'];
		$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
		list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
		$ds=$wrs[0][0];
		$op=$wrs[0][1];
		$showJob=0;
		$sql="select min(display_sequence) from routing where parent_part=? ";
		list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
		if ($wrs[0][0]==$ds) {
			$showJob=1;
			$availableQty=$cmpQty;
			if (isset($_GET['debug'])) {
				print "showjob=1 because this is first step in routing<BR>";
			}
		} else {
			$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
			list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
			$ckroute=$wrs[0][0];
			$priorWCName=$wrs[0][1];
			$sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from production_results r where job_id=? and routing_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
			$tqty=0;
			## check this prior step and see if it is complete
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=1;
				}
				$tqty+= $wdata["good"];
			}
			$availableQty=$tqty;
			$showJob=1;			
		}
		if ($showJob) {
			$sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
			$tqty=0;
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=0;
				}
				$tqty+= $wdata["good"];
			}
			if ($tqty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because $tqty >= $cmpQty<BR>";
				}
			}
			$due=$cmpQty - $tqty;
		}
		if ($showJob) {
			if ($goodQty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because qty good >= qty scheduled<br>";
				}
			}
		}
		if ($showJob) {
			$sql="select * from jobs j, order_lines l where j.line_id=l.line_id and j.job_id=? and line_status in (3,4,5,6)";
			list($wrs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($wrs)>0) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because of line status<br>";
				}
			}
		}
		if ($showJob) {
			$wcStart=$startDate;
			$sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
			list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
			if (count($srs)>0) {
				$sdata=$srs[0];
				$wcStart=$sdata['schedule_date'];
			}
			if ($availableQty > 0) {
				print "<tr><td>$job</td><td>BATCH</td><td>$item</td><td>";
				print formatDateDBToWeb($wcStart);
				print "</td><td>";
				print formatDateDBToWeb($startDate);
				print "</td>";
				print "<td align='right'>$availableQty</td>";
				$goodsofar=$cmpQty-$due;
				print "<td align='right'>$goodsofar</td>";
				print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
				print "<td>";
				if (!$ready) {
					print "Not Scheduled";
				} else {
					print "Yes";
				}
				print "</td>";
				print "<td align='center'>";
				if (! in_array($batch,$batchShown)) {
					$sql="select * from jobs_batch_orders jbo, production_results pr, routing r where jbo.batch_id=? and jbo.job_id=pr.job_id and pr.routing_id=r.routing_id and r.workcenter_id=168 and pr.quantity_good > 0";
					list($rs,$err)=runIQuery($db,$sql,array("i",$batch));
					if (count($rs)>0) {
						print "Results Posted";
					} else {
						print renderButton("Edit Batch $batch","green","openBatch('$batch');");
					}
					$batchShown[]=$batch;
				} else {
					print "On Batch $batch";
				}
				print "</td>";
				print "</tr>\n";
			}			
		}
	}
	print "</tbody>";
	print "</table>\n";
	print "<input type='hidden' name='totalrows' id='totalrows' value='$i'>";
	print "</form>";
}
print renderClosePanel();
?>
<script>
	function printPage() {
		url='availableJobsPDF.php?wc=<?=$wc?>&start=<?=$start?>&end=<?=$end?>&rand=' + Math.random();
		window.open(url,'printav','opener');
	}
	function page_init() {
		$('.datepicker').datepicker();
		$('#avj').dataTable();
		$('#avjb').dataTable();
	}
	function openBatch(batchid) {
		document.location.href='batchEdit.php?batch='+batchid+'&rand='+Math.random();
	}


	function selectOnly(part_to_select,obj) {
		if (obj.checked) {
			var totalQuantity = 0;
			$('tr').each(
			function(index) {
				tclass=$(this).attr('class');
				if (tclass!=part_to_select) {
					tid=$(this).attr('id');
					if (tid != 'header') {
						$(this).hide();
					}
				} else {
					var ck = $(this).attr('id');
					var cb=document.getElementById(ck.replace('row','sel'));
					if (cb.checked) {
						qty=parseInt($(this).data('qty'));
						totalQuantity = totalQuantity + qty;
					}
				}
			});

			url='listComponents.php?id='+part_to_select+'&qty='+parseInt(totalQuantity)+'&rand='+Math.random();
			$.ajax({url: url, success: function(data){ 
				$('#components').html(data);
			}});
		} else {
			var allCleared=1;
			var totalQuantity = 0;
			$('tr').each(
			function(index) {
				tclass=$(this).attr('class');
				var ck = $(this).attr('id');
				if (tclass==part_to_select) {
					var cb=document.getElementById(ck.replace('row','sel'));
					if (cb.checked) {
						qty=parseInt($(this).data('qty'));
						totalQuantity = totalQuantity + qty;
						allCleared=0;
					}
				}
			});
			if (allCleared == 1) {
				$('tr').each(
				function(index) {
					$(this).show();
				});
				$('#components').html(''); 			
			} else {
				url='listComponents.php?id='+part_to_select+'&qty='+parseInt(totalQuantity)+'&rand='+Math.random();
				$.ajax({url: url, success: function(data){ 
					$('#components').html(data);
				}});
			}
		}
	}
</script>
<?php
include('footer.php');
?>