<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Available Orders";
include('header.php');

$wc="";
if (isset($_POST['wc'])) {
	$wc=$_POST['wc'];
}
$start=Date("01/01/Y");
if (isset($_POST['start'])) {
	$start=$_POST['start'];
}
if (isset($_POST['end'])) {
	$end=$_POST['end'];
} else {
	$end=formatDateDBToWeb(AddBusinessDays(formatDateWebToDB($start),1));
}
$searchpart="";
if (isset($_POST['part'])) {
	$searchpart=$_POST['part'];
}
print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<form autocomplete='off' action='availableOrders.php' name='ajform' id='ajform' method='POST'>\n";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,true);
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderTextBox(TRUE,"part",$searchpart,"Part Prefix");
print "<div style='clear: both;'></div>\n";
print "<div id='btnSubmit' class='btn green hidden-print ' style='float: right;' onclick='document.ajform.submit();'>Find</div>\n";
print "<div style='clear: both;'></div>\n";
print "</form>\n";
if ($wc) {
	print "<table class='table table-striped'>";
	print "<tr><td><b>SO</b></td><td>Part</td><th>Due Date</td><td>Quantity</td><td>Shipped</td></tr>\n";
	$sql="select  l.* from orders o inner join order_lines l on o.order_id=l.order_id inner join routing r on l.item_id=r.parent_part and workcenter_id=? where o.status not in (3,4,5,6)";
	$s=formatDateWebtoDB($start);
    $e=formatDateWebtoDB($end);
    $sql.=" and  due_date >= '$s' and DATE(due_date) <= '$e' ";
	if ($searchpart) {
		$sql.=" and l.item_id like '%" . $searchpart . "%' ";
	}
	$sql.=" order by l.due_date, item_id ";	
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach ($rs as $data) {
        $so=$data['order_id'];
        $qty=$data['quantity'];
        $shipped=$data['shipped_quantity'];
        if (! $shipped) {
            $shipped=0;
        }
        $item=$data['item_id'];
        $due=formatDateDBToWeb($data['due_date']);
        print "<tr><td>$so</td><td>$item</td><td>$due</td><td>$qty</td><td>$shipped</td></tr>\n";
	}
	print "</table>\n";
}
print renderClosePanel();
?>
<script>
	function printPage() {
		url='availableJobsPDF.php?wc=<?=$wc?>&start=<?=$start?>&end=<?=$end?>&rand=' + Math.random();
		window.open(url,'printav');
	}
	function page_init() {
		$('.datepicker').datepicker();
	}
</script>
<?
include('footer.php');
?>