<?php
#error_reporting(E_ERROR);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
date_default_timezone_set("America/Detroit");
$id=$_GET['id'];
include('functions.php');
include('security.php');
$id=$_GET['id'];
$type=$_GET['type'];

?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->
<head>
	<meta charset="utf-8">
	<title>Render PDF</title>
</head>
<body>
<?php
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
#$pdf->setFontSubsetting(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

function printHeader($pdf,$wcname,$start,$end) {
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
		$pdf->Image("images/logoblack.png",1,1,125, 50,'','','',true);
		$pdf->SetFont("times","I",8,'',false);
		$pdf->SetXY(520,10);
        $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
		$pdf->SetFont("times","",14,'',false);
		$pdf->SetXY(150,10);
		$pdf->Write(16,"Available Jobs $wcname $start - $end");

		$pdf->SetXY(300,26);
		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));	
		$pdf->SetXY(20,50);
		$pdf->Write(16,"Job");		
		$pdf->SetXY(80,50);
		$pdf->Write(16,"Part");		
		$pdf->SetXY(180,50);
		$pdf->Write(16,"Start Date");		
		$pdf->SetXY(250,50);
		$pdf->Write(16,"Due");		
		$pdf->SetXY(320,50);
		$pdf->Write(16,"Available");		
		$pdf->SetXY(390,50);
		$pdf->Write(16,"Good Now");		
		$pdf->SetXY(460,50);
		$pdf->Write(16,"Still Due");		
		$pdf->SetXY(530,50);
		$pdf->Write(16,"Job Qty");		
		// enclosing box
		$pdf->Rect(18,50,565,1);
}
$lc=99;
$wc=$_GET['wc'];
$sql="select workcenter_name from workcenters where workcenter_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
$wcname=$rs[0][0];
$start=$_GET['start'];
$end=$_GET['end'];
$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled from jobs left outer join routing r on jobs.item_id=r.parent_part and workcenter_id=? left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id  where status=1 and item_id in (select parent_part from routing where workcenter_id=? ) and jobs.job_id not in (select job_id from production_results p, routing r where coalesce(complete,0)=1 and r.workcenter_id=? and r.routing_id=p.routing_id ) and jobs.status=1 ";
$s=formatDateWebtoDB($start);
$e=formatDateWebtoDB($end);
$today=Date('Y-m-d');
if ($s > $today) {
	$sql.=" and start_date >= '$s' and start_date <= '$e' ";
}	else {
	$sql.=" and start_date <= '$e' ";
}
$sql.=" order by start_date, job_id ";  
print renderQuery($sql,array("iii",$wc,$wc,$wc));
list($rs,$err)=runIQuery($db,$sql,array("iii",$wc,$wc,$wc));

foreach ($rs as $data) {
	if ($lc > 40) {
		printHeader($pdf,$wcname,$start,$end);
		$lc=0;
	}
	$job=$data['job_id'];
	$item=$data['item_id'];
	$startDate = $data['start_date'];
	$cmpQty=$data['quantity_scheduled'];
	$goodQty=$data['quantity_good'];
	$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
	list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
	$ds=$wrs[0][0];
	$op=$wrs[0][1];
	$showJob=0;
	$sql="select min(display_sequence) from routing where parent_part=? ";
	list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
	if ($wrs[0][0]==$ds) {
		$showJob=1;
		$availableQty=$cmpQty;
	} else {
		$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
		list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
		$ckroute=$wrs[0][0];
		$priorWCName=$wrs[0][1];
		$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results where job_id=? and routing_id=? group by coalesce(complete,0) ";
		list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
		$tqty=0;
		## check this prior step and see if it is complete
		foreach ($wrs as $wdata) {
			if ($wdata['complete']) {
				$showJob=1;
			}
			$tqty+= $wdata["good"];
		}
		$availableQty=$tqty;
		$showJob=1;			
	}
	if ($showJob) {
		$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
		list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
		$tqty=0;
		foreach ($wrs as $wdata) {
			if ($wdata['complete']) {
				$showJob=0;
			}
			$tqty+= $wdata["good"];
		}
		if ($tqty >= $cmpQty) {
			$showJob=0;
			if (isset($_GET['debug'])) {
				print "not available because $tqty >= $cmpQty<BR>";
			}
		}
		$due=$cmpQty - $tqty;
	}
	if ($showJob) {
		if ($goodQty >= $cmpQty) {
			$showJob=0;
		}
	}
	if ($showJob) {
		$wcStart=$startDate;
		$sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
		list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
		if (count($srs)>0) {
			$sdata=$srs[0];
			$wcStart=$sdata['schedule_date'];
		}
		$goodsofar=$cmpQty-$due;
		$lc++;
		$pdf->SetFont("times","",12,'',false);
		$ypos=50 + ($lc * 19);	
		$pdf->SetXY(20,$ypos);
		$pdf->Write(16,$job);		
		$pdf->SetXY(80,$ypos);
		$pdf->SetFont("times","",9,'',false);
		$pdf->Write(16,$item);		
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(180,$ypos);
		$pdf->Write(16,formatDateDBToWeb($wcStart));		
		$pdf->SetXY(250,$ypos);
		$pdf->Write(16,formatDateDBToWeb($startDate));		
		$q=number_format($availableQty);
		$xpos=380 - $pdf->GetStringWidth($q);
		$pdf->SetXY($xpos,$ypos);
		$pdf->Write(16,$q);		
		$q=number_format($goodsofar);
		$xpos=450 - $pdf->GetStringWidth($q);
		$pdf->SetXY($xpos,$ypos);
		$pdf->Write(16,$q);		
		$q=number_format($due);
		$xpos=520 - $pdf->GetStringWidth($q);
		$pdf->SetXY($xpos,$ypos);
		$pdf->Write(16,$q);		
		$q=number_format($cmpQty);
		$xpos=570 - $pdf->GetStringWidth($q);
		$pdf->SetXY($xpos,$ypos);
		$pdf->Write(16,$q);		
	}
}

$f=uniqid();
$fname="/var/www/vhosts/ip-50-63-152-47.ip.secureserver.net/httpdocs/documents/".$f . ".pdf";	
print "created $fname<br>";
if (file_exists($fname)) {
	unlink($fname);
}
$pdf->Output($fname, "F");
print "\n<script>window.opener.close();document.location.href='/documents/$f.pdf';</script>\n";
?>
</body></html>