<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Available Jobs";
include('header.php');

$wc=$primaryWC;
if (isset($_GET['wc'])) {
	$wc=$_GET['wc'];
}
$start=Date("01/01/Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
} else {
	$end=Date("m/d/Y");
}
$searchpart="";
if (isset($_GET['part'])) {
	$searchpart=$_GET['part'];
}
$sql="select job_id from orders o, order_lines l, jobs j where o.status in (3,4,5,6) and o.order_id=l.line_id and l.line_id=j.line_id and j.status = 1 ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$job=$data['job_id'];
	$sql="update jobs set status=9 where job_id=?";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$job));
}
if ($wc == 168) {
	print "<script>document.location.href='availableJobsWeld.php?wc=168&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}
if ($wc == 169) {
	print "<script>document.location.href='availableJobsAssembly.php?wc=169&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}
if ($wc != 170) {
	print "<script>document.location.href='availableJobs.php?wc=$wc&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}

print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<h4>Notice this program has changed  - it will now show you jobs that are not quite ready for you, but instead of a checkbox, it will tell you why it is not ready.</h4>";
print "<form autocomplete='off' action='availableJobsOP.php' name='ajform' id='ajform' method='GET'>\n";
print "<div class='hidden-print'>";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,true);
print renderDateBox(TRUE,"start",$start,"From Date");
print renderDateBox(TRUE,"end",$end,"To Date");
print renderTextBox(TRUE,"part",$searchpart,"Part Prefix");
print "<div style='clear: both;'></div>\n";
print "<div id='btnSubmit' class='btn green hidden-print ' style='float: right;' onclick='document.ajform.submit();'>Find</div>\n";
print "<div style='clear: both;'></div>\n";
print "</div>";
print "</form>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='components' class='hidden-print' style='min-height: 120px;'>&nbsp;</div>";
if ($wc) {
	$sql="select j.job_id, j.item_id, r.routing_id, j.quantity_scheduled, sum(p.quantity_good) as good, r.display_sequence from jobs j ";
	$sql.=" inner join production_results p on j.job_id=p.job_id inner join routing r on p.routing_id=r.routing_id and r.workcenter_id=? ";
	$sql.=" where 1> 0 ";
	$sql.=" and j.status = 1 and j.start_date >= '2022-01-01' ";
	if ($searchpart) {
		$sql.=" and j.item_id like '%" . $searchpart . "%' ";
	}
	$sd=formatDateWebToDB($start);
	$ed=formatDateWebToDB($end);
	$sql.=" and j.start_date >= ? and j.start_date <= ? ";
	$sql.=" group by j.job_id, r.routing_id, r.display_sequence, j.quantity_scheduled having sum(p.quantity_good) > 0 ";	
	list($rs,$err)=runIQuery($db,$sql,array("iss",$wc,$sd,$ed));
	foreach ($rs as $data) {
		$qs=$data['quantity_scheduled'];
		$good=$data['good'];
		$j=$data['job_id'];
		$r=$data['routing_id'];
		
		$ds=$data['display_sequence'];
		$part=$data['item_id'];
		$sql="select max(display_sequence) as max from routing where parent_part=?";
		list($mrs,$err)=runIQuery($db,$sql,array("s",$part));
		$mdata=$mrs[0];
		$max=$mdata[0];		
		if ($good >= $qs) {
			$sql="update production_results set complete=1 where job_id=? and routing_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("ii",$j,$r));
			if ($max == $ds) {
				$sql="update jobs set status=2 where job_id=?";
				list($updrs,$err)=runIQuery($db,$sql,array("i",$j));
			}
		}	
	}
	print "<form name='selform' action='batchCreation.php' method='POST'>";
	print "<input type='hidden' name='start' value='1'>";
	print "<input type='hidden' name='wc' value='$wc'>";
	print "<table id='avj' class='table table-striped'>";
	print "<thead >";	
	print "<tr id='header' qty='0'><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty On PO</th><th>Qty Still Due</th><th>Total Job Qty</th></tr>\n";
	print "</thead><tbody>";
	$s=formatDateWebtoDB($start);
	$e=formatDateWebtoDB($end);
	$sql="select jobs.job_id, jobs.item_id, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, l.order_id, priority_color, l.item_description, l.due_date, jobs.line_id from jobs ";
	$sql.=" left outer join routing r on jobs.item_id=r.parent_part and workcenter_id=? ";
	$sql.=" left outer join order_lines l on jobs.line_id=l.line_id ";
	$sql.=" left outer join orders o on l.order_id=o.order_id ";
	$sql.=" left outer join order_priorities op on o.priority=op.priority_id ";
	$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
	$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
	$sql.=" and jobs.job_id not in (select job_id from production_results p, routing r where coalesce(complete,0)=1 and r.workcenter_id=? and r.routing_id=p.routing_id ) ";
	$sql.=" and jobs.job_id not in (select job_id from jobs_batch jb, jobs_batch_orders jbo where workcenter_id=? and jb.batch_id=jbo.batch_id ) ";
	$sql.= " and jobs.status=1 ";
    $sql.=" and jobs.item_id not like 'C20470001%' ";
    $sql.=" and o.status not in  (3,4,5,6) ";
	if ($searchpart) {
		$sql.=" and jobs.item_id like '%" . $searchpart . "%' ";
	}
	$today=Date('Y-m-d');
	if ($s > $today) {
		$sql.=" and coalesce(schedule_date,start_date) >= '$s' and  coalesce(schedule_date,start_date) <= '$e' ";
	}	else {
		$sql.=" and  coalesce(schedule_date,start_date) >= '2021-01-01' and  coalesce(schedule_date,start_date) <= '$e' ";
	}
	$sql.=" order by priority desc, coalesce(schedule_date,start_date), job_id ";  
	list($rs,$err)=runIQuery($db,$sql,array("iiii",$wc,$wc,$wc,$wc));
	$i=0;

	if (isset($_GET['debug'])) {
		print "<hr>";
		print renderQuery($sql,array("iii",$wc,$wc,$wc));
	}
	foreach ($rs as $data) {
		$job=$data['job_id'];
		if (isset($_GET['debug'])) {
			print "<hr>";
			print "checking job $job<BR>";
		}
		$priority=$data['priority_color'];
		$item=$data['item_id'];
		$description=$data['item_description'];
		$order=$data['order_id'];
		$dueDate=$data['due_date'];
		$ol=$data['line_id'];
		$olead=getOrderLeadTime($db,$ol);
		$vlead=getVendorLeadTime($db,$ol);
		#$startDate = $data['start_date'];
		$lead=$olead+$vlead;
		$startDate=SubtractBusinessDays($dueDate,$lead);
		$cmpQty=$data['quantity_scheduled'];
		$goodQty=$data['quantity_good'];
		$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
		list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
		$ds=$wrs[0][0];
		$op=$wrs[0][1];
		$showJob=0;

		$sql="select min(display_sequence) from routing where parent_part=? ";
		list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
		if ($wrs[0][0]==$ds) {
			$showJob=1;
			$availableQty=$cmpQty;
			if (isset($_GET['debug'])) {
				print "showjob=1 because this is first step in routing<BR>";
			}
		} else {
			$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
			list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
			$ckroute=$wrs[0][0];
			$priorWCName=$wrs[0][1];
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results where job_id=? and routing_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
			$tqty=0;
			## check this prior step and see if it is complete
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=1;
				}
				$tqty+= $wdata["good"];
			}
			$availableQty=$tqty;
			$showJob=1;			
		}
		if ($showJob) {
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
			$tqty=0;
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=0;
					$noCheckBoxMessage="Step Marked Complete";
				}
				$tqty+= $wdata["good"];
			}
			if ($tqty >= $cmpQty) {
				$showJob=0;
				$noCheckBoxMessage="$tqty >= $cmpQty";
				if (isset($_GET['debug'])) {
					print "not available because $tqty >= $cmpQty<BR>";
				}
			}
			$due=$cmpQty - $tqty;
		}
		if ($showJob) {
			if ($goodQty >= $cmpQty) {
				$showJob=0;
				$noCheckBoxMessage="Qty Good >= Qty Scheduled";
				if (isset($_GET['debug'])) {
					print "not available because qty good >= qty scheduled<br>";
				}
			}
		}
		if ($startDate > $ed) {
			$showJob=0;
			$noCheckBoxMessage="Start > End Date";
			if (isset($_GET['debug'])) {
				print "not available because start > end date<br>";
			}
	}
		if ($showJob) {
			$sql="select sum(pl.quantity) from jobs j,  packing_slip_lines pl where j.job_id=? and j.line_id=pl.order_line ";
			list($prs,$err)=runIQuery($db,$sql,array("i",$job));
			$pdata=$prs[0];
			if ($pdata[0]>= $cmpQty) {
				$showJob=0;
				$noCheckBoxMessage="Already Shipped " . $pdata[0];
				if (isset($_GET['debug'])) {
					print "not available because we have alread shipped " . $pdata[0] . "<BR>";
				}
			} else {
				if (isset($_GET['debug'])) {
					print "still showing because we only shipped " . $pdata[0] . "<BR>";
				}
			}
		}
		if ($showJob) {
			$sql="select * from production_results p, routing r where job_id=? and p.routing_id=r.routing_id and operation_id=3116";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($rs)>0) {
				$showJob=0;
				$noCheckBoxMessage="Powder Application Results";
				if (isset($_GET['debug'])) {
					print "not available because results for powder application<br>";
				}
			}
		}
        $wcStart=$startDate;
		if ($showJob or ! $showJob) {
			if ($availableQty > 0 or $availableQty == 0) {
                $sql="select parent_part from routing r where parent_part=? and operation_id in (3106,3113) LIMIT 1";
                list($crs2,$err)=runIQuery($db,$sql,array("s",$item));
                if (isset($_GET['debug'])) {
                    print renderQuery($sql,array("s",$item));
                }    
                foreach ($crs2 as $cdata2) {
                    $qtycheck=$cmpQty;
                    $sql="select sum(pl.quantity) as qr from order_lines ol, jobs j, po_lines pl, items i where ol.order_id=? and ol.line_id=j.line_id and j.job_id=pl.job_id and pl.item_id=i.item_id  and i.item_name=?";
                    list($prs,$err)=runIQuery($db,$sql,array("is",$order,$item));
                    if (isset($_GET['debug'])) {
                        print renderQuery($sql,array("is",$order,$item));
                    }    
                    $rcvqty=$prs[0][0];
                    if ($rcvqty < $qtycheck) {
                        $i++;
                        $qtyshow=$qtycheck - $rcvqty;
                        print  "<tr class='$item' style='color: $priority;' id='row$i' data-qty='$cmpQty'>";
                        print "<td><a href='editJob.php?id=$job' target='_blank'>$job</a></td><td>$order</td><td>$item</td><td>";
                        print formatDateDBToWeb($wcStart);
                        print "</td><td>";
                        print formatDateDBToWeb($dueDate);
                        print "</td>";
                        print "<td align='right'>$availableQty</td>";
                        print "<td align='right'>$rcvqty</td>";
                        $due=$cmpQty-$rcvqty;
                        print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
                        print "<td align='center'>";
						if ($showJob and $availableQty >0 ) {
							print "<input type='checkbox' name='sel$i' id='sel$i' value='$job' onclick=\"selectOnly('$item',this);\">";
						} else {
							if ($availableQty == 0) {
								print "Prior Step Not Done";
							} else {
								print $noCheckBoxMessage;
							}
						}
						print "</td>";
                        print "</tr>\n";
                    } else {
                        if (isset($_GET['debug'])) {
                            print "not showing because $rcvqty >= $qtycheck";
                        }            
                    }
                }
			}			
		}
	}
	print "</tbody>";
	print "</table>\n";
	print "<input type='hidden' name='totalrows' id='totalrows' value='$i'>";
	print "</form>";
}
print renderClosePanel();
?>
<script>
	function printPage() {
		self.print();
	}
	function page_init() {
		$('.datepicker').datepicker();
		$('#avj').dataTable();
	}
	function openBatch(batchid) {
		document.location.href='batchEdit.php?batch='+batchid+'&rand='+Math.random();
	}


	function selectOnly(part_to_select,obj) {
		if (obj.checked) {
			var totalQuantity = 0;
			$('tr').each(
			function(index) {
				tclass=$(this).attr('class');
				if (tclass!=part_to_select) {
					tid=$(this).attr('id');
					if (tid != 'header') {
						$(this).hide();
					}
				} else {
					var ck = $(this).attr('id');
					var cb=document.getElementById(ck.replace('row','sel'));
					if (cb.checked) {
						qty=parseInt($(this).data('qty'));
						totalQuantity = totalQuantity + qty;
					}
				}
			});

			url='listComponents.php?id='+part_to_select+'&qty='+parseInt(totalQuantity)+'&rand='+Math.random();
			$.ajax({url: url, success: function(data){ 
				$('#components').html(data);
			}});
		} else {
			var allCleared=1;
			var totalQuantity = 0;
			$('tr').each(
			function(index) {
				tclass=$(this).attr('class');
				var ck = $(this).attr('id');
				if (tclass==part_to_select) {
					var cb=document.getElementById(ck.replace('row','sel'));
					if (cb.checked) {
						qty=parseInt($(this).data('qty'));
						totalQuantity = totalQuantity + qty;
						allCleared=0;
					}
				}
			});
			if (allCleared == 1) {
				$('tr').each(
				function(index) {
					$(this).show();
				});
				$('#components').html(''); 			
			} else {
				url='listComponents.php?id='+part_to_select+'&qty='+parseInt(totalQuantity)+'&rand='+Math.random();
				$.ajax({url: url, success: function(data){ 
					$('#components').html(data);
				}});
			}
		}
	}
</script>
<?php
include('footer.php');
?>