<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Available Jobs - Staging For Assembly";
include('header.php');

$wc=$primaryWC;
if (isset($_GET['wc'])) {
	$wc=$_GET['wc'];
}
$start=Date("01/01/Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
} else {
	$end=Date("m/d/Y");
}
$searchpart="";
if (isset($_GET['part'])) {
	$searchpart=$_GET['part'];
}
if ($wc != 169) {
	print "<script>document.location.href='availableJobs.php?wc=$wc&start=$start&end=$end&part=$searchpart';</script>\n";
	include('footer.php');
	exit;
}
print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<form autocomplete='off' action='availableJobsAssembly.php' name='ajform' id='ajform' method='GET'>\n";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,true);
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderTextBox(TRUE,"part",$searchpart,"Part Prefix");
print "<div style='clear: both;'></div>\n";
print "<div id='btnSubmit' class='btn green hidden-print ' style='float: right;' onclick='document.ajform.submit();'>Find</div>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='btnStage' class='btn green hidden-print ' style='display: none; float: left;' onclick='setStatus()'>Stage At Assembly</div>\n";
print "<div id='labeldiv' style='display: none; float: left;'># Labels: <input type='text' id='labels' value='1'></div>";
print "</form>\n";
print "<div style='clear: both;'></div>\n";
print "<div id='components' style='min-height: 120px;'>&nbsp;</div>";
if ($wc) {
	$sql="select j.job_id, j.item_id, r.routing_id, j.quantity_scheduled, sum(p.quantity_good) as good, r.display_sequence from jobs j ";
	$sql.=" inner join production_results p on j.job_id=p.job_id inner join routing r on p.routing_id=r.routing_id and r.workcenter_id=? ";
	$sql.=" where 1> 0 ";
	$sql.=" and j.status = 1 and j.start_date >= '2021-01-01' ";
	if ($searchpart) {
		$sql.=" and j.item_id like '%" . $searchpart . "%' ";
	}
	$sql.=" group by j.job_id, r.routing_id, r.display_sequence, j.quantity_scheduled having sum(p.quantity_good) > 0 ";	
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach ($rs as $data) {
		$qs=$data['quantity_scheduled'];
		$good=$data['good'];
		$j=$data['job_id'];
		$r=$data['routing_id'];
		
		$ds=$data['display_sequence'];
		$part=$data['item_id'];
		$sql="select max(display_sequence) as max from routing where parent_part=?";
		list($mrs,$err)=runIQuery($db,$sql,array("s",$part));
		$mdata=$mrs[0];
		$max=$mdata[0];		
		if ($good >= $qs) {
			$sql="update production_results set complete=1 where job_id=? and routing_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("ii",$j,$r));
			if ($max == $ds) {
				$sql="update jobs set status=2 where job_id=?";
				list($updrs,$err)=runIQuery($db,$sql,array("i",$j));
			}
		}	
	}
	print "<table id='avj' class='table table-striped'>";
	print "<thead >";	
	print "<tr id='header'><th>WO</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th><th>Status</th></tr>\n";
	print "</thead><tbody>";
	$s=formatDateWebtoDB($start);
	$e=formatDateWebtoDB($end);

	$sql="select o.order_id, l.item_id, l.due_date as start_date, 0 as quantity_good, l.quantity as quantity_scheduled ";
	$sql.=" from orders o inner join order_lines l on o.order_id=l.order_id  left outer join routing r on l.item_id=r.parent_part and workcenter_id=? ";
	## 6/7/21 per Justin, removed status 13 from exclusion (staged at assembly)
	$sql.=" left outer join jobs j on l.line_id=j.line_id and  j.item_id not in (select part_number from stamped_inventory)  where o.status not in (3,4,5,6) ";
	$sql.=" and l.due_date >= '$s' and l.due_date <= '$e' ";
	$sql.=" and j.line_id is null  ";
	if ($searchpart) {
		$sql.=" and l.item_id like '%" . $searchpart . "%' ";
	}
	$sql.=" order by l.due_date ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach($rs as $data) {
		$item=$data['item_id'];
		$job=$data['order_id'];
		if (shouldIShowWC($db,$item,$wc,$job)) {
			$startDate = $data['start_date'];
			CreateJobsForOrder($db,$job);				
		}
	}
	$sql="select jobs.job_id, jobs.line_id, line_status, jobs.item_id, status_name, coalesce(schedule_date,start_date) as start_date, quantity_good, quantity_scheduled, l.order_id, priority_color from jobs ";
	$sql.=" left outer join routing r on jobs.item_id=r.parent_part and workcenter_id=? and operation_id=3100 ";
	$sql.=" left outer join order_lines l on jobs.line_id=l.line_id ";
	$sql.=" left outer join orders o on l.order_id=o.order_id ";
	$sql.=" left outer join order_status on line_status=status_id ";
	$sql.=" left outer join order_priorities op on o.priority=op.priority_id ";
	$sql.=" left outer join schedule_items s on jobs.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
	$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
	$sql.=" and jobs.job_id not in (select job_id from production_results p, routing r where coalesce(complete,0)=1 and r.workcenter_id=? and r.routing_id=p.routing_id ) ";
	$sql.= " and jobs.status=1 ";
	## 6/7/21 per Justin, removed status 13 from exclusion (staged at assembly)
    $sql.=" and line_status not in (3,4,5,6) ";
	if ($searchpart) {
		$sql.=" and jobs.item_id like '%" . $searchpart . "%' ";
	}
	$today=Date('Y-m-d');
	if ($s > $today) {
		$sql.=" and start_date >= '$s' and start_date <= '$e' ";
	}	else {
		$sql.=" and start_date >= '2020-01-01' and start_date <= '$e' ";
	}
	$sql.=" order by priority desc, start_date, job_id ";  
	list($rs,$err)=runIQuery($db,$sql,array("iii",$wc,$wc,$wc));
	$i=0;

	if (isset($_GET['debug'])) {
		print "<hr>";
		print renderQuery($sql,array("iii",$wc,$wc,$wc));
	}
	foreach ($rs as $data) {
		$job=$data['job_id'];
        $line=$data['line_id'];
		$status=$data['status_name'];
        $lineStatus=$data['line_status'];
		$priority=$data['priority_color'];
		$item=$data['item_id'];
		$order=$data['order_id'];
		$startDate = $data['start_date'];
		$cmpQty=$data['quantity_scheduled'];
		$goodQty=$data['quantity_good'];
		$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
		list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
		$ds=$wrs[0][0];
		$op=$wrs[0][1];
		$showJob=0;
		$sql="select min(display_sequence) from routing where parent_part=? ";
		list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
		if ($wrs[0][0]==$ds) {
			$showJob=1;
			$availableQty=$cmpQty;
			if (isset($_GET['debug'])) {
				print "showjob=1 because this is first step in routing<BR>";
			}
		} else {
			$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
			list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
			$ckroute=$wrs[0][0];
			$priorWCName=$wrs[0][1];
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results where job_id=? and routing_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$ckroute));			
			$tqty=0;
			## check this prior step and see if it is complete
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=1;
				}
				$tqty+= $wdata["good"];
			}
			$availableQty=$tqty;
			$showJob=1;			
		}
		if ($showJob) {
			$sql="select coalesce(complete,0) as complete, sum(coalesce(quantity_good,0)) as good from production_results r, routing where r.job_id=? and routing.routing_id=r.routing_id and workcenter_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$job,$wc));
			$tqty=0;
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=0;
				}
				$tqty+= $wdata["good"];
			}
			if ($tqty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because $tqty >= $cmpQty<BR>";
				}
			}
			$due=$cmpQty - $tqty;
		}
		if ($showJob) {
			if ($goodQty >= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because qty good >= qty scheduled<br>";
				}
			}
		}
		if ($showJob) {
			$sql="select sum(pl.quantity) from jobs j,  packing_slip_lines pl where j.job_id=? and j.line_id=pl.order_line ";
			list($prs,$err)=runIQuery($db,$sql,array("i",$job));
			$pdata=$prs[0];
			if ($pdata[0]>= $cmpQty) {
				$showJob=0;
				if (isset($_GET['debug'])) {
					print "not available because we have already shipped " . $pdata[0] . "<BR>";
				}
			} else {
				if (isset($_GET['debug'])) {
					print "still showing because we only shipped " . $pdata[0] . "<BR>";
				}
			}
		}
		if ($showJob) {
			$wcStart=$startDate;
			$sql="select schedule_date from schedule, schedule_items where job_id=? and operation_id=? and schedule_items.schedule_id=schedule.schedule_id";
			list($srs,$err)=runIQuery($db,$sql,array("ii",$job,$op));
			if (count($srs)>0) {
				$sdata=$srs[0];
				$wcStart=$sdata['schedule_date'];
			}
			if ($availableQty > 0) {
				$i++;
				print  "<tr class='$item' style='color: $priority;' id='row$i' data-qty='$cmpQty'>";
				print "<td>$job</td><td>$order</td><td>$item</td><td>";
				print formatDateDBToWeb($wcStart);
				print "</td><td>";
				print formatDateDBToWeb($startDate);
				print "</td>";
				print "<td align='right'>$availableQty</td>";
				$goodsofar=$cmpQty-$due;
				print "<td align='right'>$goodsofar</td>";
				print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
				print "<td>" . $status . "</td>";
                print "<td align='center'>";
				$rpartlist=array();
				$rqtylist=array();
				if ($lineStatus != 9 or $lineStatus == 9) {
					$allback=1;
                    $partial=0;
					$sql="select child_item, quantity_per from billofmaterial b, routing r where b.parent_item=? and b.parent_item=r.parent_part and r.operation_id=3106";
					list($crs,$err)=runIQuery($db,$sql,array("s",$item));
                    if (count($crs)==0) {
                        $sql="select child_item, quantity_per from billofmaterial where parent_item=? ";
                        list($crs,$err)=runIQuery($db,$sql,array("s",$item));
                        foreach ($crs as $cdata) {
                            $child=$cdata['child_item'];
                            $qtyper=$cdata['quantity_per'];
                            $originalQtyPer=$qtyper;
                            $sql="select child_item, quantity_per from billofmaterial b, routing r where b.parent_item=? and b.parent_item=r.parent_part and r.operation_id=3106";
                            list($crs2,$err)=runIQuery($db,$sql,array("s",$child));
                            foreach ($crs as $cdata) {
                                $child=$cdata['child_item'];
                                $qtyper=$originalQtyPer*$cdata['quantity_per'];
                                $qtycheck=$cmpQty*$qtyper;
                                $sql="select sum(pl.quantity_received) as qr from po_lines pl, jobs j, order_lines l where pl.job_id=? and pl.job_id=j.job_id and j.line_id=l.line_id and  l.item_id=?";
                                list($prs,$err)=runIQuery($db,$sql,array("is",$job,$child));
                                print renderQUery($sql,array("is",$job,$child));
                                $rcvqty=$prs[0][0];
                                print "checking $qtycheck versus $rcvqty<hr>";
                                if ($rcvqty > 0) {
                                    $partial=1;
                                    print "partial is true<hr>";
                                }
                                if ($rcvqty < $qtycheck) {
                                    $allback=0;
                                    print "set allback to zero<hr>";
                                    break(2);
                                } else {
                                    print "We have Some RECEIPTS<hr>";
                                }
                            }
                        }
                    } else {
                        foreach ($crs as $cdata) {
                            $child=$cdata['child_item'];
                            $qtyper=$cdata['quantity_per'];
                            $qtycheck=$cmpQty*$qtyper;
                            $sql="select sum(pl.quantity_received) as qr from po_lines pl, jobs j, order_lines l where pl.job_id=? and pl.job_id=j.job_id and j.line_id=l.line_id and  l.item_id=?";
                            list($prs,$err)=runIQuery($db,$sql,array("is",$job,$child));
                            $rcvqty=$prs[0][0];
                            if ($rcvqty > 0) {
                                $partial=1;
                            }
                            if ($rcvqty < $qtycheck) {
                                $allback=0;
                            }
                        }
                    }
					if ($allback) {
						$sql="select pl.quantity, pl.quantity_received, l.item_id from po_lines pl, jobs j, order_lines l, purchase_orders p, vendors v ";
						$sql.=" where pl.job_id=? and l.line_id=? and pl.job_id=j.job_id and j.line_id=l.line_id and pl.po_id=p.po_id and p.vendor_id=v.vendor_id and paint_vendor=1";
						list($prs,$err)=runIQuery($db,$sql,array("ii",$job,$line));
						foreach ($prs as $pdata) {
							$pqty=$pdata['quantity'];
							$preceived=$pdata['quantity_received'];
							$pl=$pdata['line_id'];
							$pitem=$pdata['item_id'];
							if (! in_array($pitem,$rpartlist)) {
								$rpartlist[]=$pitem;
								$rqtylist[$pitem]=$preceived;
							} else {
								$rqtylist[$pitem]+=$preceived;
							}
							if ($preceived < $pqty ) {
								$allback=0;
							}
						}
					}
					if ($allback) {
						foreach ($rpartlist as $rpart) {
							$sql="select quantity_per from billofmaterial where parent_item=? and child_item=? ";
							list($prs,$err)=runIQuery($db,$sql,array("ss",$item,$rpart));
							$qper=$prs[0][0];
							$qneed=$qper*$cmpQty;
							if ($qneed > $rqtylist[$rpart]) {
								$allback=0;
							}
						}
					}
					if ($allback) {
						$sql="update order_lines set line_status=9 where line_id=? and line_status not in (3,4,5,10)";
						list($updrs,$err)=runIQuery($db,$sql,array("i",$line));
						$lineStatus=9;
					} else {
                        if ($partial) {
                            $sql="update order_lines set line_status=12 where line_id=? and line_status not in (3,4,5,10)";
                            list($updrs,$err)=runIQuery($db,$sql,array("i",$line));
                            $lineStatus=12;
                        } else {
                            $sql="select * from jobs j, po_lines p where j.line_id=? and j.job_id=? and j.job_id=p.job_id ";
                            list($jrs,$err)=runIQuery($db,$sql,array("ii",$line,$job));
                            print renderQuery($sql,array("ii",$line,$job));
                            if (count($jrs)>0) {
                                $lineStatus=8;
                            } else {
                                $lineStatus=7;
                            }
                            $sql="update order_lines set line_status=? where line_id=? and line_status not in (3,4,5,10)";
                            print renderQuery($sql,array("ii",$lineStatus,$line));
                            list($updrs,$err)=runIQuery($db,$sql,array("ii",$lineStatus,$line));
                        }
                    }
				}
				if ($lineStatus == 9) {
					## ok to go
					print renderButton("List Components","green","listComponents('$line','$due','$job');");
				} else {
					print renderButton("List Components","red","listComponentsRed('$line','$due','$job');");
				}
                print "</td>";
				print "</tr>\n";
			}			
		}
	}
	print "</tbody>";
	print "</table>\n";
	print "</form>";
}
print renderClosePanel();
?>
<script>
var currentLine = 0;
var currentJob=0;
	function printPage() {
	}
	function page_init() {
		$('.datepicker').datepicker();
		//$('#avj').dataTable({"bPaginate" : false});
		$('#avj').dataTable();        
	}
    function listComponents(lineno,qty,jobno) {
        currentLine=lineno;
		currentJob=jobno;
        url='setOrderStatus.php?line='+currentLine+'&status=0&qty='+qty+'&job='+jobno;
        $.ajax({url: url, success: function(data){
			$('#components').html(data);
			window.scrollTo(0,0);
            $('#btnStage').show();
			$('#labeldiv').show();
        }});
    }

    function listComponentsRed(lineno,qty,jobno) {
        url='setOrderStatus.php?line='+lineno+'&status=0&qty='+qty+'&job='+jobno;
        $.ajax({url: url, success: function(data){
			$('#components').html(data);
			window.scrollTo(0,0);
            $('#btnStage').hide();
			$('#labeldiv').hide();
        }});
    }


    function setStatus() {
        if (currentLine > 0) {
            url='setOrderStatus.php?line='+currentLine+'&status=13';
            $.ajax({url: url, success: function(data){
	    		$('#components').html(data);
				nbrlabels=$('#labels').val();
				window.open('renderTCPDF.php?type=WO&id='+currentJob+'&copies='+nbrlabels,'_blank');
            }});
        }
    }
</script>
<?php
include('footer.php');
?>