<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

print renderPanel("Automated Reminders");
print "<p style='color:red'>*Please note that reminders shown on this page have not been sent out yet.</p>";

## reminders that haven't been completed yet
print "<h3>Order Status Reminders</h3>";
$sql="SELECT order_reminders.*, order_status.status_name, customers.name FROM order_reminders 
    INNER JOIN order_status ON order_reminders.order_status=order_status.status_id 
    INNER JOIN customers ON customers.customer_id=order_reminders.customer
    WHERE sent_on IS NULL";
list($rs,$err)=runIQuery($db,$sql);

print "<table class='table table-striped'><thead><th>Order</th><th>Customer</th><th>Message</th><th>Order Status</th><th>Send To</th><th>Repeat Reminder</th><th>Created On</th><th></th></thead><tbody>";

foreach($rs as $data) {
    $reminderID=$data['reminder_id'];
    $orderID=$data['order_id'];
    $status=$data['status_name'];
    $customer=$data['name'];
    $data['repeat_reminder'] == 1 ? $reminderRepeat = 'Yes' : $reminderRepeat = 'No';
    $message=$data['reminder_message'];
    $dateCreated=formatDateDBToWeb($data['created_on']);
    $reminderRecipients="";
    ## buttons
    $deleteReminder = renderButton("Delete","red","deleteReminder($reminderID);");
    $editReminder = "<a class='btn yellow' href='updateOrderReminders.php?id=$reminderID&action=edit' target='_blank'>Edit Reminder</a>";

    $sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
    list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
    foreach($employee_rs as $employee_data) {
        $reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
    }
    print "<tr id='hideReminder$reminderID'><td><a href='editOrders.php?id=$orderID' target='_blank'>$orderID</a></td><td>$customer</td><td>$message</td><td>$status</td><td>$reminderRecipients</td><td>$reminderRepeat</td><td>$dateCreated</td><td>$deleteReminder $editReminder</td></tr>";
}
print "</tbody></table>";

## repeating reminders by customer, want unique messages only
print "<h3>Repeating Reminders</h3>";
$sql="SELECT repeat_reminders.*, order_status.status_name, customers.name FROM repeat_reminders 
    INNER JOIN order_status ON repeat_reminders.order_status=order_status.status_id 
    INNER JOIN customers ON customers.customer_id=repeat_reminders.customer
    ORDER BY customers.name";
list($rs,$err)=runIQuery($db,$sql);

print "<table class='table table-striped'><thead><th>Customer</th><th>Message</th><th>Order Status</th><th>Send To</th><th></th></thead><tbody>";

foreach($rs as $data) {
    $repeatID=$data['repeat_id'];
    $message=$data['reminder_message'];
    $status=$data['status_name'];
    $statusID=$data['order_status'];
    $customer=$data['name'];
    $customerID=$data['customer'];
    $reminderRecipients="";
    
    ## taking most recent reminder to see who it was sent to
    $sql="SELECT reminder_id FROM order_reminders WHERE reminder_message=? AND order_status=? AND customer=? ORDER BY reminder_id DESC LIMIT 1";
    list($rs,$err)=runIQuery($db,$sql,array("sii",$message,$statusID,$customerID));
    $reminderID=$rs[0][0];
    ## get email recipients
    $sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
    list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
    foreach($employee_rs as $employee_data) {
        $reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
    }

    ## buttons
    $deleteRepeat = renderButton("Delete","red","deleteRepeat($repeatID);");
    $editRepeat = "<a class='btn yellow' href='updateRepeatReminders.php?id=$repeatID&action=edit' target='_blank'>Edit Reminder</a>";
    
    print "<tr id='hideRepeat$repeatID'><td>$customer</td><td>$message</td><td>$status</td><td>$reminderRecipients</td><td>$deleteRepeat $editRepeat</td></tr>";
}
print "</tbody></table>";

## create a new repeat reminder
print "<h3>Create a New Repeating Reminder</h3>";
print "<a class='btn green' href='updateRepeatReminders.php?&action=create' target='_blank'>Create New Repeat Reminder</a>";

## date reminder
## bdoss 11/7/22 add other types of reminders per conversation between Chris and Forrest
print "<h3>Date Reminders</h3>";
print "<table class='table table-striped'><thead><th>Send Date</th><th>Message</th><th>Send To</th><th>Created On</th><th></th></thead><tbody>";
$sql="SELECT * FROM date_reminders WHERE sent_on IS NULL ORDER BY send_on";
list($rs,$err)=runIQuery($db,$sql);
if ($rs) {
    foreach($rs as $data) {
        $dateID=$data['reminder_id'];
        $message=$data['reminder_message'];
        $sendDate=formatDateDBToWeb($data['send_on']);
        $createDate=formatDateDBToWeb($data['created_on']);
        $reminderRecipients="";

        $sql="SELECT first_name, last_name from employees INNER JOIN employee_date_reminders ON employees.employee_id=employee_date_reminders.employee_id WHERE employee_date_reminders.reminder_id=?";
        list($employee_rs, $err)=runIQuery($db,$sql,array("i",$dateID));
        foreach($employee_rs as $employee_data) {
            $reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
        }
        ## buttons
        $deleteDate = renderButton("Delete","red","deleteDate($dateID);");
        $editDate = "<a class='btn yellow' href='updateDateReminders.php?id=$dateID&action=edit' target='_blank'>Edit Reminder</a>";
        print "<tr id='hideDate$dateID'><td>$sendDate</td><td>$message</td><td>$reminderRecipients</td><td>$createDate</td><td>$deleteDate $editDate</td></tr>"; 
    }
}
print "</tbody></table>";
## bdoss creating a new date reminder
print "<h3>Create a New Date Reminder</h3>";
print "<a class='btn green' href='updateDateReminders.php?&action=create' target='_blank'>Create New Date Reminder</a>";

## bdoss 11/14/22 po reminders (triggered when a po is received)
print "<h3>PO Received Reminders</h3>";
print "<table class='table table-striped'><thead><th>PO</th><th>Message</th><th>Send To</th><th>Created On</th><th></th></thead><tbody>";
$sql="SELECT * FROM po_reminders WHERE sent_on IS NULL ORDER BY po_id";
list($rs,$err)=runIQuery($db,$sql);
if ($rs) {
    foreach($rs as $data) {
        $poID=$data['reminder_id'];
        $message=$data['reminder_message'];
        $po=$data['po_id'];
        $createDate=formatDateDBToWeb($data['created_on']);
        $reminderRecipients="";

        $sql="SELECT first_name, last_name from employees INNER JOIN employee_po_reminders ON employees.employee_id=employee_po_reminders.employee_id WHERE employee_po_reminders.reminder_id=?";
        list($employee_rs, $err)=runIQuery($db,$sql,array("i",$poID));
        foreach($employee_rs as $employee_data) {
            $reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
        }
        ## buttons
        $deletePO = renderButton("Delete","red","deletePO($poID);");
        $editPO = "<a class='btn yellow' href='updatePOReminders.php?id=$poID&po=$po&action=edit' target='_blank'>Edit Reminder</a>";
        print "<tr id='hidePO$poID'><td><a href='editPO.php?id=$po' target='_blank'>$po</a></td><td>$message</td><td>$reminderRecipients</td><td>$createDate</td><td>$deletePO $editPO</td></tr>";
    }
}
print "</tbody></table>";

## bdoss 11/16/22 so reminder (triggered when an so is received)
print "<h3>SO Received Reminders</h3>";
print "<table class='table table-striped'><thead><th>SO</th><th>Message</th><th>Send To</th><th>Created On</th><th></th></thead><tbody>";
$sql="SELECT * FROM so_reminders WHERE sent_on IS NULL ORDER BY so_id";
list($rs,$err)=runIQuery($db,$sql);
if ($rs) {
    foreach($rs as $data) {
        $soID=$data['reminder_id'];
        $message=$data['reminder_message'];
        $so=$data['so_id'];
        $createDate=formatDateDBToWeb($data['created_on']);
        $reminderRecipients="";

        $sql="SELECT first_name, last_name from employees INNER JOIN employee_so_reminders ON employees.employee_id=employee_so_reminders.employee_id WHERE employee_so_reminders.reminder_id=?";
        list($employee_rs, $err)=runIQuery($db,$sql,array("i",$soID));
        foreach($employee_rs as $employee_data) {
            $reminderRecipients.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
        }
        ## buttons
        $deleteSO = renderButton("Delete","red","deleteSO($soID);");
        $editSO = "<a class='btn yellow' href='updateSOReminders.php?id=$soID&so=$so&action=edit' target='_blank'>Edit Reminder</a>";
        print "<tr id='hideSO$soID'><td><a href='editOrders.php?id=$so' target='_blank'>$so</a></td><td>$message</td><td>$reminderRecipients</td><td>$createDate</td><td>$deleteSO $editSO</td></tr>";
    }
}
print "</tbody></table>";

print renderClosePanel();
include('footer.php');
?>
<script>

    function page_init() {
        
    }

    // bdoss adding functions for automated reminders
	function deleteReminder(reminder) {
        let hideRow = document.getElementById(`hideReminder${reminder}`);
		let reminderURL=`updateOrderReminders.php?id=${reminder}&action=delete`;
		$.ajax({url: reminderURL, success: function(){  
            $(hideRow).hide();
            $.gritter.add('Deleted Reminder');  }} );
	}

    function deleteRepeat(reminder) {
        let hideRow = document.getElementById(`hideRepeat${reminder}`);
		let reminderURL=`updateRepeatReminders.php?id=${reminder}&action=delete`;
		$.ajax({url: reminderURL, success: function(){  
            $(hideRow).hide();
            $.gritter.add('Deleted Repeating Reminder');  }} );
    }

    function deleteDate(reminder) {
        let hideRow = document.getElementById(`hideDate${reminder}`);
        let reminderURL=`updateDateReminders.php?id=${reminder}&action=delete`;
        $.ajax({url: reminderURL, success: function(){  
            $(hideRow).hide();
            $.gritter.add('Deleted Reminder');  
        }} );
	}

    function deletePO(reminder) {
        let hideRow = document.getElementById(`hidePO${reminder}`);
        let reminderURL=`updatePOReminders.php?id=${reminder}&action=delete`;
        $.ajax({url: reminderURL, success: function(){  
            $(hideRow).hide();
            $.gritter.add('Deleted Reminder');  
        }} );
	}

    function deleteSO(reminder) {
        let hideRow = document.getElementById(`hideSO${reminder}`);
        let reminderURL=`updateSOReminders.php?id=${reminder}&action=delete`;
        $.ajax({url: reminderURL, success: function(){  
            $(hideRow).hide();
            $.gritter.add('Deleted Reminder');  
        }} );
	}

</script>