<?php
include('functions.php');
include('dbConnection.php');
require_once('Mail/class.phpmailer.php');

$code=0;
if (isset($_POST["code"])) {
    $code=$_POST["code"];
}
if (isset($_GET["code"])) {
    $code=$_GET["code"];
}

if ($code != 8383) {
    die;
}

function getReport($url, $fallback) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HEADER, 1);

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_POST, 1);
        $parts = explode("?", $url);
    $fields="";
    if (count($parts) > 1) {
        $fields = $parts[1];
    }
    curl_setopt($ch, CURLOPT_POSTFIELDS,
            "user=chris.allen@worldsourcetech.com&password=Chris@443&$fields");
    $resp = curl_exec($ch);

    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($resp, 0, $header_size);
    $body = substr($resp, $header_size);

    preg_match("/content-disposition: .*? filename\=(.*?)(\n|$)/i",$header,$matches);

    $filename="$fallback.xls";
    if (count($matches) == 3) {
        $filename = trim($matches[1]);
    }

    if ($filename == "") $filename = "$fallback.xls";

    return [$filename, $body];
}

function initializeMailer($mail, $report_name, $report_to) {
    global $smtpUser, $smtpPassword;
    $mail->IsSMTP();
    $mail->SMTPDebug  = 0;
    $mail->Debugoutput = 'html';
    $mail->Host = "email-smtp.us-east-1.amazonaws.com";
    $mail->Port       =587;
    $mail->SMTPSecure = 'tls';
    $mail->SMTPAuth   = true;
    $mail->Username = $smtpUser;
    $mail->Password   = $smtpPassword;
    $mail->SetFrom("noreply@preferredmachinellc.com", "Report Auto Emailer");
    $mail->AddReplyTo("noreply@preferredmachinellc.com", "Report Auto Emailer");

    $msg = "Auto Generated $report_name report is attached";
    $mail->MsgHTML($msg);
    $mail->AltBody = $msg;
    $mail->Subject = "Auto Generated $report_name Report";

    foreach ($report_to as $email) {
        $mail->addBCC($email,$email);
    }

    return $mail;
}

$lastemailtime = 0;
function sendMail($mail, $auto_id) {
    global $db;

    $sent = true;
    if(!$mail->Send()) {
        if(!$mail->Send()) {
            if(!$mail->Send()) {
                $sent = false;
                print "Mailer Error on report $auto_id: " . $mail->ErrorInfo;
            }
        }
    }

    if ($sent) { // if it was sent, update the auto-report last_sent date
        $sql = "update auto_reports set last_sent=now() where auto_id=$auto_id";
        list($rs,$err)=runIQuery($db,$sql);
    }
}
$base_url = "https://preferredwelderp1.com";
$sql = "select * from auto_reports";
list($rs,$err)=runIQuery($db,$sql);

foreach ($rs as $data) {
    set_time_limit(120);
    $auto_id = $data["auto_id"];
    $frequency = $data["frequency"];
    $last_sent = $data["last_sent"];

    $report_to = $data["report_to"];
    $report_to = explode(",", $report_to);

    $report_url = $base_url . $data["report_url"];
    $report_name = $data["report_name"];

    $date_range = $data["date_range"];
    $ranges = array_map(
        fn($time) => date("m/d/Y", strtotime($time)), // turn each into a date string
        explode("~", $date_range) // split the ranges by ~
    );

    foreach ($ranges as $i => $range) { // used for setting start and end dates for certain reports
        if (str_contains($report_url, "{RANGE$i}")) { // if exists, format the url
            $report_url = str_replace("{RANGE$i}",$range,$report_url);
        }
    }

    if (str_starts_with($frequency,"data")) { // if the frequency is data based
        if (date("w") == 6) { // if it is X day of the week (0=sunday,6=saturday)
            if (date("Y-m-d", strtotime($last_sent)) != date("Y-m-d")) { // if it was not sent today (since we only send on saturday)
                $olderthan = substr($frequency,5);

                $sendit = false;

                list($filename,$report) = getReport($report_url,$report_name);
                if (count(explode("\n",$report)) > 3) { // data will contain 3 \n chars if no results
                    if ($olderthan == "") { // whenever there is any data reguardless of dates on the report
                        $sendit = true;
                    } else { // whenever there are ANY dates on the report older than $olderthan (such as -2 day" for data older than 2 days from today)
                        list($odate,$column)=explode(":",$olderthan);
                        $before = date("Y-m-d", strtotime($odate));
                        $lines = explode("\n",$report);

                        $hasolder = false;
                        foreach ($lines as $i => $line) {
                            if ($i > 0) { // first line often has a date, skip it
                                $columns = explode("\t",$line);
                                $col=$columns[$column];

                                if (strlen($col) >= 10 && (strstr($col,"/") || strstr($col,"-"))) { // must be at least 10 characters and have a / or - to make sure it is a date
                                    $timestamp = strtotime($col);
                                    if ($timestamp) {
                                        $tempdate = date("Y-m-d", $timestamp);

                                        if ($before > $tempdate) {
                                            $hasolder = true;
                                            break;
                                        }
                                    }
                                }
                            }
                            if ($hasolder) { // less processing = better
                                break;
                            }
                        }

                        if ($hasolder) {
                            $sendit = true;
                        }
                    }
                }

                if ($sendit) {
                    print "SEND REPORT #$auto_id $report_name to " . implode(",",$report_to) . "!<br>";

                    $mail = initializeMailer(new PHPMailer(), $report_name, $report_to);
                    $mail->addStringAttachment($report,$filename);

                    sendMail($mail, $auto_id);
                }
            }
        }
    } else { // else if it is date based
        $after = date("Y-m-d H:i:s", strtotime($frequency));

        // if it is on the right day, the last time it was sent was earlier than the given frequency, and it is after the given frequency
        if (date("w") == date("w", strtotime($frequency)) && $last_sent < $after && date("Y-m-d H:i:s") >= $after) {
            $mail = initializeMailer(new PHPMailer(), $report_name, $report_to);

            list($filename,$report) = getReport($report_url,$report_name);
            if (str_ends_with($report_url,"&html=1")) {
                $mail->MsgHTML($report_name . " Below<hr>" .$report);
                $mail->AltBody = "Your email client does not support html, cannot show report";
            } else {
                $mail->addStringAttachment($report,$filename);
            }

            if (!empty($report_to)) { // allows us to use the same logic for any reports that auto-email already on export
                sendMail($mail, $auto_id);
            } else { // used for any reports that handle emailing themselves
                $sql = "update auto_reports set last_sent=now() where auto_id=$auto_id";
                list($rs,$err)=runIQuery($db,$sql);
            }
            print "SEND REPORT #$auto_id $report_name to " . implode(",",$report_to) . "!<br>";
        }
    }
}
?>