<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Assigned Batches";
$wc=$primaryWC;
if (isset($_POST['wc'])) {
    $wc=$_POST['wc'];
}
include('header.php');
print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
if (! $wc) {
	if ($isAdmin) {
		print "<p>Please Select a Work Center to view assigned batched</p>";
		print "<form name='selform' action='assignedJobs.php' method='POST'>";
		$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
		$rs=mysqli_query($db,$sql);
		print renderSelect(TRUE,"wc",$wc,"Work Center","N",$rs,0,"document.selform.submit();");
		print renderButton("Select","green","document.selform.submit()");
		print "</form>";
	}
} else {
	print "<table id='avj' class='table table-striped'>";
	print "<thead><tr><th>Assigned To</th><th>Batch</th><th>Date Assigned</th><th>Part</th><th>Description</th><th>Quantity Scheduled</th><th>Good so Far</th></tr></thead><tbody>\n";
	$sql="select machine_name, b.batch_id, j.item_id, j.description, sum(quantity_scheduled) as scheduled, batch_date from machines m, jobs_batch b, jobs_batch_orders jbo, ";
	$sql.=" jobs j where m.workcenter_id=? and m.machine_id=b.machine_id and b.batch_id=jbo.batch_id and jbo.job_id=j.job_id ";
	$sql.=" and batch_ready=1 and batch_complete=0 ";
	$sql.=" group by machine_name, b.batch_id, j.item_id, j.description, batch_date ";
	$sql.=" order by machine_name, b.batch_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$wc));
	foreach ($rs as $data) {
		$machine=$data['machine_name'];
		$batch=$data['batch_id'];
		$part=$data['item_id'];
		$description=$data['description'];
		$quantity=$data['scheduled'];
		$bdt=$data['batch_date'];
		$dt=formatDateDBToWeb($data['batch_date']);
		$good=0;
		$sql="select sum(pr.quantity_good) as good from jobs_batch_orders jbo,  production_results pr, routing r where batch_id=? and jbo.job_id=pr.job_id  ";
		$sql.=" and pr.routing_id=r.routing_id and r.workcenter_id=? ";
		list($jrs,$err)=runIQuery($db,$sql,array("ii",$batch,$wc));
		if (count($jrs)>0) {
			$good=$jrs[0][0];
		}
		if ($good >= $quantity) {
			$sql="update jobs_batch set batch_complete=1 where batch_id=? ";
			list($updrs,$err)=runIQuery($db,$sql,array("i",$batch));	
		} else {
			print "<tr><td>$machine</td><td><a href='batchView.php?batch=$batch' target='_blank'>$batch</a></td><td>$dt</td><td>$part</td><td>$description</td><td>$quantity</td><td>$good</td></tr>\n";
		}
	}
	print "</tbody></table>";
}
print renderClosePanel();
include('footer.php');