<?php
session_start();
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Powder Quoting","Quote","green","col-md-12");
$color="0";
$quantity=0;
$part="";
$x=0;
$y=0;
$plugs=0;
$masking=0;
$customer=0;
$makeItAll=0;
$alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
if (isset($_POST['color'])) {
	$color=$_POST['color'];
	$customer=$_POST['customer'];
	if (isset($_POST['make'])) {
		$makeItAll=$_POST['make'];
		$sql="select name, address, city,state, zip, email from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
		$data=$rs[0];
		$name=$data['name'];
		$address=$data['address'];
		$city=$data['city'];
		$state=$data['state'];
		$zip=$data['zip'];
		$email=$data['email'];
		## status 6 is quote
		$sql="insert into orders (customer_id, date_order, date_due, status, ship_name, ship_address, ship_city, ship_state, ship_zip, email, salesperson_id) values (?, now(), now(), 6, ?, ?, ?, ?, ?, ?,?)  ";
		list($rs,$err)=runIQuery($db,$sql,array("issssssi",$customer,$name,$address,$city,$state,$zip,$email,$userSalesPersonID));
		$data=$rs[0];
		$orderID=$data['id'];
		print "Order Created: <a href='editOrders.php?id=$orderID' target='_blank'>$orderID</a><br>";
	}
	$setup=115;
	$packaging=10;
	$maskingCost=1.00;
	$plugging=.10;
	$i=0;
	$totalQuantity=0;
	while ($i < 20) {
		$i++;
		$totalQuantity+=$_POST['quantity'.$i];
	}
	$setupCost=($setup + $packaging) / $totalQuantity;
	$setupCost=number_format($setupCost,4); 
	## direct is in included in the setup, except for powder application
	$direct=.006;
	$paint=.0025;
	$yellow=.004;
	$red=.004;
	$orange=.004;
	$silver=.0034;
	$bsilver=.008;
	$totalPrice=0;
	print "<table style='width: 90%'><thead><th>Item</th><th>Width</th><th>Length</th><th>Quantity</th><th>Price</th><th>Extended</th></thead><tbody>";
	print "<tr><Td>Setup</td><td></td><td></td>	<td>1</td><td>";
	print number_format($setup,2);
	print "</td><td>";
	print number_format($setup,2);
	print "</td></tr>\n";
	print "<tr><td>Packaging</td><td></td><td></td><td>1</td><td>";
	print number_format($packaging,2);
	print "</td><td>";
	print number_format($packaging,2);
	print "</td></tr>\n";
	$setup+=$packaging;
	print "<tr><td>Total Overhead</td><td></td><td></td><td></td><td>";
	print number_format($setup,2);
	print "</td><td>";
	print number_format($setup,2);
	print "</td></tr>\n";
	print "<tr><td colspan='6'><hr></td></tr>\n";	
	$sql="select color_description from vendor_colors where vc_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$color));
	$data=$rs[0];
	$desc=$data[0];
	$grandTotal=0;
	$i=0;
	while ($i < 20) {
		$i++;
		$quantity=$_POST['quantity'.$i];		
		$part=trim($_POST['part'.$i]);
		if ($part) {
			$x=$_POST['xdimension'.$i];
			$y=$_POST['ydimension'.$i];
			$plugs=$_POST['plugs'.$i];
			$masking=0;
			if (isset($_POST['masking'.$i])) {
				$masking=$_POST['masking'.$i];
			}
			$surfaceArea=$x*$y*2;
			$price=$surfaceArea * $direct;
			$price=number_format($price,2);
			$totalPrice=$price;
			print "<tr><td><b>$part $desc</b></td>";
			print "<td>$x</td><td>$y</td>";
			print "<td>$quantity</td>";
			print "<td>$price</td>";
			$ext=$quantity * $price;
			print "<td>";
			print number_format($ext,2);
			print "</td></tr>\n";
			$paintCost=$paint;
			if (strstr(strtolower($desc),"yellow")) {
				$paintCost=$yellow;
			} 	
			if (strstr(strtolower($desc),"red")) {
				$paintCost=$red;
			} 	
			if (strstr(strtolower($desc),"orange")) {
				$paintCost=$orange;
			} 
			if (strstr(strtolower($desc),"silver")) {
				$paintCost=$silver;
			} 
			if (strstr(strtolower($desc),"bonded silver")) {
				$paintCost=$bsilver;
			} 	
			$paintCost=$paintCost * $surfaceArea;
			$paintCost=number_format($paintCost,2);
			$totalPrice+=$paintCost;
			print "<tr><td>Powder Cost</td><td>$x</td><td>$y</td><td>$quantity</td><td>$paintCost</td><td>";
			$ext=$quantity * $paintCost;
			print number_format($ext,2);
			print "</td></tr>\n";
			print "<tr><td>Overhead Cost</td><td></td><td></td><td>$quantity</td><td>$setupCost</td><td>";
			$totalPrice+=$setupCost;
			$ext=$quantity * $setupCost;
			print number_format($ext,2);
			print "</td></tr>\n";
			if ($masking) {
				print "<tr><td>Masking</td><td></td><td></td><td>$quantity</td><td>$maskingCost</td><td>";
				$ext=$quantity*$maskingCost;
				print number_format($ext,2);
				print "</td></tr>\n";
				$totalPrice+=$maskingCost;
			}
			if ($plugs) {
				$pluggingCost=$plugging*$plugs;
				print "<tr><td>$plugs Plugs</td><td></td><td></td><td>$quantity</td><td>$pluggingCost</td><td>";
				$ext=$pluggingCost * $quantity;
				print number_format($ext,2);
				print "</td></tr>\n";
				$totalPrice+=$pluggingCost;
			}
			if ($quantity > 20) {
				$margin=($totalPrice - $setupCost) * .30;
				$margin+=$setupCost * .15;
			} else {
				## do not mark up the setup at all
				$margin=($totalPrice - $setupCost) * .30;			
			}
			$margin=number_format($margin,4);
			print "<tr><td>30% Margin</td><td></td><td></td><td>$quantity</td><td>$margin</td><td>";
			$ext=$margin * $quantity;
			print number_format($ext,2);
			print "</td></tr>\n";
			$cost=$totalPrice;
			$totalPrice += $margin;
			$totalPrice = number_format($totalPrice,2);
			print "<tr><td>Sell Price</td><td></td><td></td><td>$quantity</td><td><b>$totalPrice</b></td><td>";
			$ext=$totalPrice * $quantity;
			print number_format($ext,2);
			print "</td></tr>\n";
			$grandTotal+=$ext;
			if ($makeItAll) {
				$sql="select item_id from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$part));
				$exists=$count($rs);
				$idx=0;
				while ($exists > 0 and $idx < 26) {
					$testPart="$part-" . substr($alphabet,$idx,1);
					$sql="select item_id from items where item_name=?";
					list($rs,$err)=runIQuery($db,$sql,array("s",$testPart));
					$exists=$count($rs);
					if (! $exists) {
						$part=$testPart;
					}
					$idx++;
				}
				$sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id, length, width, powder_color, plugs, masking) ";
				$sql.=" values (?, 21, ?, 7, ?, ?, 4, 0, 0, ?, ?, ?, ?, ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("ssddddiii",$part,$desc,$totalPrice,$cost,$x,$y,$color,$plugs,$masking));				
				$sql="insert into order_lines (order_id, item_id, item_description, quantity, cost, price, shipped_quantity, xdimension, ydimension,powder_color, due_date, plugs, masking, line_status) ";
				$sql.=" values (?, ?, ?, ?, ?, ?, 0, ?, ?, ?, now(), ?, ?, 6) ";
				list($rs,$err)=runIQuery($db,$sql,array("issiddddiii",$orderID,$part,$desc,$quantity,$cost,$totalPrice,$x,$y,$color,$plugs,$masking));
			}
		}
	}
	$grandTotal=number_format($grandTotal,2);
	print "<tr><td>&nbsp;</td></tr>\n";
	print "<tr><td>Total for Order</td><td colspan='4'><td><b>$grandTotal</b></td></tr>\n";
	print "</tbody></table>\n";
	print "<hr>";
}
print "<p>Remember, if this is a weldment, calculate total surface area, enter 1 in the length, half of the surface area in the width.</p>";
print "<form name='findform' action='paintInvoiceQuote.php' method='POST'>";
$i=0;
$sql="select customer_id, name from customers order by name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print renderCheckBox(TRUE,"make",0,"Create Items, Order, and Lines");
print "<div style='clear: both;'></div>";
$sql="select vc_id, concat(vendor_name, '-', color_code) as name  from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code ";
$vrs=mysqli_query($db,$sql);
print renderStartItem(TRUE,"color","Color");
print "<select name='color' id='color' style='width: 400px;'>";
print renderOptions($vrs,$color,1,0);
print "</select>";
print renderEndItem();
print "<div style='clear: both;'></div>";
print "<table class='table table-striped'><thead><tr><th>Part</th><th>Quantity</th><th>Width</th><th>Length</th><th>#Plugs (Taps)</th><th>Masking</th></tr></thead><tbody>";
while ($i < 20) {
	$i++;
	if (isset($_POST['color'])) {
		$quantity=$_POST['quantity'.$i];
		$part=$_POST['part'.$i];
		$x=$_POST['xdimension'.$i];
		$y=$_POST['ydimension'.$i];
		$plugs=$_POST['plugs'.$i];
		$masking=0;
		if (isset($_POST['masking'.$i])) {
			$masking=$_POST['masking'.$i];
		}
	}
	print "<tr>";
	print "<td>";
	print renderTextBox(FALSE,"part$i",$part,"Part Number");
	print "</td>";
	print "<td>";
	print renderTextBox(FALSE,"quantity$i",$quantity,"Quantity");
	print "</td>";
	print "<td>";
	print renderTextBox(FALSE,"xdimension$i",$x,"Length");
	print "</td>";
	print "<td>";
	print renderTextBox(FALSE,"ydimension$i",$y,"Width");
	print "</td>";
	print "<td>";
	print renderTextBox(FALSE,"plugs$i",$plugs,"# of Tapped Holes");
	print "</td>";
	print "<td>";
	print renderCheckBox(FALSE,"masking$i",$masking,"Parts need Masking");
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>";
print "<div style='clear: both;'></div>";
print "<br><BR>";
print renderButton("Calculate Powder Cost","green","document.findform.submit()");
print "</form>";
print renderClosePanel();
include('footer.php');
?>
