<?php
include('dbConnection.php');
include('functions.php');
$delim=",";
if ($_GET['code'] != '8383') {
	exit;
}

ini_set("display_errors","on");
error_reporting(E_ALL);

if (! isset($debug)) {
	$debug=0;
}


$job=0;
$folder=trim($_GET['folder']); //! folder is the ORDER ID
// cma 3/24/23 - unless it starts with wo
if (substr($folder,0,2)=="WO") {
	$job=substr($folder,2);
}
$part=trim($_GET['part']);

$material=trim($_GET['material']);
$process=trim($_GET['process']);


// operation 3123 is LASER
$sql = "SELECT i.item_name AS material_name, b.parent_item AS item_id FROM billofmaterial b, routing r, items i WHERE b.parent_item=? AND r.routing_id=b.routing_id AND r.operation_id=3123 AND b.child_item=i.item_name AND i.item_category=24";
list($rs,$err)=runIQuery($db,$sql,["s",$part]);
if (count($rs)==0) {
	$erpMaterial="Custom Material";
} else {
	$data=$rs[0];
	$part=$data['item_id'];
	$erpMaterial=$data['material_name'];
}


$minutes=trim($_GET['minutes']);
## minutes is actualy part of the hour
$minutes=$minutes*60;
$laserstarttime = date("Y-m-d H:i:s", strtotime($process)-($minutes*60));

$setup=trim($_GET['setup']);
$setup=$setup*60;
$setupstarttime = date("Y-m-d H:i:s", strtotime($process)-($setup*60));

$endtime = date("Y-m-d H:i:s", strtotime($process));

$qty=trim($_GET['qty']);
$nest=trim($_GET['nest']);
$employee=$_GET['by'];
$laser=$_GET['laser'];
$sql="SELECT * FROM sort_log WHERE sort_by=? AND nest_id=? ";
list($rs,$err)=runIQuery($db,$sql,array("ii",$employee,$nest));
if (count($rs)==0) {
	$sql="INSERT INTO sort_log (sort_by, nest_id, sort_when) VALUES (?, ?, now())";+
	list($rs,$err)=runIQuery($db,$sql,array("ii",$employee,$nest));
}

$employees = [];
if ($laser != "") {
	$hour=Date("H");
	if ($process) {
		$hour=substr($process,0,2);
	}
	$shift=2;
	if ($hour > 3) {
		$shift=1;
		if ($hour > 15) {
			$shift=2;
		}
	}

	$sql="INSERT INTO transaction_log (`who`, `when`, script_name, table_name, sql_statement)
	VALUES (0, now(), 'applyPF.php', 'none','Laser is $laser, Hour is $hour') ";
	list($rs,$err)=runIQuery($db,$sql);
	// TODO: Make sure this employee is set
	$sql="SELECT a.employee_id FROM laser_names l, employee_laser_assignment a WHERE l.laser_name=? AND l.laser_id=a.laserid ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$laser));

	foreach ($rs as $data) {
		$employees[] = $data["employee_id"];
	}


	$rsql=renderQuery($sql,array("si",$laser,$shift));
	$rsql=str_replace("'","",$rsql);
	$sql="INSERT INTO transaction_log (`who`, `when`, script_name, table_name, sql_statement)
	VALUES (0, now(), 'applyPF.php', 'none','$rsql') ";
	list($rs,$err)=runIQuery($db,$sql);



	$sql="INSERT INTO transaction_log (`who`, `when`, script_name, table_name, sql_statement)
	VALUES (0, now(), 'applyPF.php', 'none','Employees are " . implode(", ", $employees) . "') ";
	list($rs,$err)=runIQuery($db,$sql);

	$match=0;
	if ($erpMaterial == $material) {
		$match=1;
	}
}

// operation 3123 is LASER
$sql = "SELECT routing_id FROM routing WHERE operation_id=3123 AND parent_part=?";
list($rs,$err)=runIQuery($db,$sql,["s",$part]);
$routingID=0;
if (count($rs)) {
	$routingID=$rs[0][0];
}

if ($routingID) {
	$hours = floor($minutes / 60);
	$minutes = $minutes - ($hours * 60);

	if ($hours == 0 && $minutes < 1) {
		$minutes = 1;
	}

	$factor = count($employees);

	if (! $factor) {
		$employees[]=99;
		$factor=1;
	}

	$qtyinsert=floor($qty/$factor);
	$leftover=$qty - ($qtyinsert * $factor);

	foreach ($employees as $i => $employee) {
		$given = $qtyinsert;
		if ($i == 0) {
			$given += $leftover;
		}
		if ($laser) {
			if ($job > 0) {
				$sql="select * from jobs where job_id=?";
				list($rs,$err)=runIQuery($db,array("i",$job));
			} else {
				$sql="select j.* from order_lines l, jobs j where order_id=? and l.line_id=j.line_id and j.item_id=? ";
				list($rs,$er)=runIQuery($db,$sql,array("is",$folder,$part));	
			}
			$remainder=$given;
			foreach ($rs as $data) {
				if ($remainder > 0) {
					$job=$data['job_id'];
					$sql="select sum(quantity_good) from production_results pr, routing r  where pr.job_id=$job and pr.routing_id=r.routing_id ";
					list($qrs,$err)=runIQuery($db,$sql);
					$good=$qrs[0][0];
					if ($good < $remainder) {
						$qtytopost=$remainder-$good;
						$sql = "INSERT INTO production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete)
						VALUES (?, ?, ?, now(), ?, ?, ?, ?, 'Laser', ?, ?, 1)";
						list($rs,$err)=runIQuery($db,$sql,["iiiiiiiss", $job, $routingID, $employee, $hours, $minutes, $qtytopost, $shift, $laserstarttime, $endtime]);
						$remainder -= $qtytopost;
					}
				}	
				if ($remainder > 0)	{
					$sql = "INSERT INTO production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete)
					VALUES (?, ?, ?, now(), ?, ?, ?, ?, 'Laser', ?, ?, 1)";
					list($rs,$err)=runIQuery($db,$sql,["iiiiiiiss", $job, $routingID, $employee, $hours, $minutes, $remainder, $shift, $laserstarttime, $endtime]);
				}
			}

		} else {
			$remainder=$given;
			foreach ($rs as $data) {
				if ($remainder > 0) {
					$job=$data['job_id'];
					$sql="select sum(quantity_good) from production_results pr, routing r  where pr.job_id=$job and pr.routing_id=r.routing_id ";
					list($qrs,$err)=runIQuery($db,$sql);
					$good=$qrs[0][0];
					if ($good < $remainder) {
						$qtytopost=$remainder-$good;
						$sql = "INSERT INTO production_results (job_id, routing_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete)
						VALUES (?, ?, now(), ?, ?, ?, ?, 'Laser No Employee', ?, ?, 1)";
						list($rs,$err)=runIQuery($db,$sql,["iiiiiiss", $job, $routingID, $hours, $minutes, $qtytopost, $shift, $laserstarttime, $endtime]);
						$remainder -= $qtytopost;
					}
				}	
				if ($remainder > 0)	{
					$sql = "INSERT INTO production_results (job_id, routing_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete)
					VALUES (?, ?, now(), ?, ?, ?, ?, 'Laser No Employee', ?, ?, 1)";
					list($rs,$err)=runIQuery($db,$sql,["iiiiiiss", $job, $routingID, $hours, $minutes, $remainder, $shift, $laserstarttime, $endtime]);

				}
			}


		}
	}
}

$setup=0;
if (isset($_GET['setup'])) {
	$setup=$_GET['setup'];
	$setup=$setup * 60;
	if ($setup > 0 ) {

	}
}
$scrapQuantity=0;

if ($job == 0) {
	$sql="select j.job_id from order_lines l, jobs j where order_id=? and l.line_id=j.line_id and j.item_id=? ";
	list($rs,$er)=runIQuery($db,$sql,array("is",$folder,$part));
	if (count($rs)>0) {
		$data=$rs[0];
		$job=$data['job_id'];
	}
}

if (! $job) {
	## for when they delete an order line after production results are in
	$sql="select job_id from jobs j left outer join order_lines l on j.line_id=l.line_id where j.item_id=? and l.item_id is null ";
	list($rs,$er)=runIQuery($db,$sql,array("s",$part));
	if (count($rs)>0) {
		$data=$rs[0];
		$job=$data['job_id'];
	}
}

if (isset($_GET['scrap'])) {
	$scrapQuantity=$_GET['scrap'];
	if ($scrapQuantity > 0) {
		$scrapCode=$_GET['defect'];
		## 01 = Bad Etch
		## 02 = Cut Quality
		## 03 = Scratches/Gouges
		## 04 = Stuck In Sheet
		$defect_id=1;
		/*
		Bad Etch = 7
		Cut Quality = 1
		Scratches/Gouges = 8
		Stuck In Sheet = 9
		*/
		$reason="Cut Quality";
		if ($scrapCode == "01") {
			$defect_id=7;
			$reason="Bad Etch";
		}
		if ($scrapCode == "03") {
			$defect_id=8;
			$reason="Scratches/Gouges";
		}
		if ($scrapCode == "04") {
			$defect_id=9;
			$reason="Stuck In Sheet";
		}


		$employee=$_GET['by'];

		if ($routingID) {
			// operation 3123 is LASER
			$op = "3123";
			$sql = "INSERT INTO job_defects (job_id, date_reported, quantity, defect_type, caused_by, defect_notes, `user_id`, routing_id, defect_id)
			VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

			list($rs,$err)=runIQuery($db,$sql,["isiiisiii", $job, $endtime, $scrapQuantity, $defect_id, $employee, $reason, $employee, $routingID, $defect_id]);
		}
	}
}
if ($debug) {
	print "setup is $setup<hr>";
}
if ($setup && $routingID) {
	$hours = floor($setup / 60);
	$minutes = $setup - ($hours * 60);

	if ($hours == 0 && $minutes < 1) {
		$minutes = 1;
	}

	$employee=$_GET['by'];

	$sql="select employee_id from employees where card_number=? and coalesce(inactive,0) = 0";
	list($srs,$err)=runIQuery($db,$sql,array("i",$employee));
	if (count($srs)) {
		$employee=$srs[0][0];
	} else {
		$employee=99;
	}

	// NOTE: pushing results to laser with note of "SORT" for sort
	$sql = "INSERT INTO production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete)
	VALUES (?, ?, ?, now(), ?, ?, ?, ?, 'SORT', ?, ?, 1)";

	list($rs,$err)=runIQuery($db,$sql,["iiiiiiiss", $job, $routingID, $employee, $hours, $minutes, $qty, $shift, $setupstarttime, $endtime]);
}

if ($routingID) {
	$sql="select nesting_id from nesting where nesting_name=? and job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("si",$nest,$folder));
	if (count($rs)>0) {
		$nestingID=$rs[0][0];
		$sql="update nesting set nested_quantity=nested_quantity + ? where nesting_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$qty,$nestingID));
	} else {
		$nestingDate=$_GET['date'];
		## format is YYmmdd_HHMM
		$yr="20" .  substr($nestingDate,0,2); // will only have to change this every 100 years :)
		$mo=substr($nestingDate,4,2);
		$dy=substr($nestingDate,6,2);
		$hr=substr($nestingDate,9,2);
		$mn=substr($nestingDate,11,2);
		$nestingDate="$yr-$mo-$dy $hr:$mn:00";

		$sql="insert into nesting (nesting_name, job_id, nesting_date, nested_quantity) values (?, ?, now(), ?) ";
		list($rs,$err)=runIQuery($db,$sql,array("sii",$nest,$folder,$qty));
	}
}
print "DONE";