<?php
function multiLine($string,$max=60) {
	$lines=array();
	$stringlines=explode("\r\n",$string);
	foreach ($stringlines as $string) {
		$words=explode(" ",$string);
		$widx=0;
		$string="";
		while ($widx < count($words)) {
			$retstring="";
			$tooLong=0;
			while ($widx < count($words) and $tooLong==0 ) {
				if ($retstring) {
					$retstring.=" ";
				}
				$oldstring=$retstring;
				$retstring.=$words[$widx];
				if (strlen($words[$widx])>$max) {
					if ($oldstring == "") {
						$retstring=substr($words[$widx],0,$max);
						$words[$widx]=substr($words[$widx],$max);
					} else {
						$retstring=$oldstring;
					}
					$tooLong=1;
				} else {
					if ( strlen($retstring)>$max) {
						$retstring=$oldstring;
						$tooLong=1;
					} else {
						$widx++;
					}
				}
			}
			if (trim($retstring)) {
				$lines[]=$retstring;
			}
		}
	}
	return $lines;
}

function renderBox($pdf, $X, $Y, $size, $label = false, $checked = false) {
    if ($checked) {
        $pdf->SetLineWidth(2);
        $pdf->Line($X, $Y, $X+$size,$Y+$size);
        $pdf->Line($X, $Y+$size,$X+$size, $Y);
        $pdf->SetLineWidth(1);
    }
    $pdf->Line($X, $Y, $X + $size, $Y);
    $pdf->Line($X, $Y, $X, $Y + $size);
    $pdf->Line($X + $size, $Y, $X + $size, $Y + $size);
    $pdf->Line($X, $Y += $size, $X + $size, $Y);
    if ($label) {
        $pdf->SetXY($X + $size + 10, $Y - ($size/1.35));
        $pdf->Write(10, $label);
    }

    return $pdf;
}

$start = false;
$end = false;
$name = false;
$department = false;
$supervisor = false;
$notes = "";
$approved = false;
$copies = 1;

if (empty($_POST)) $_POST = $_GET;

if (isset($_POST["start"])) $start = date("m-d-Y h:i A", strtotime($_POST["start"]));
if (isset($_POST["end"])) $end = date("m-d-Y h:i A", strtotime($_POST["end"]));
if (isset($_POST["name"])) $name = $_POST["name"];
if (isset($_POST["department"])) $department = $_POST["department"];
if (isset($_POST["supervisor"])) $supervisor = $_POST["supervisor"];
if (isset($_POST["notes"])) $notes = $_POST["notes"];
if (isset($_POST["status"])) $approved = $_POST["status"] == "approved";
if (isset($_POST["copies"])) $copies = $_POST["copies"];
date_default_timezone_set("America/Detroit");
$now = date("m-d-Y h:i A");


if (!$start || !$end || !$name || !$department  || !$supervisor) {
    print_r($_POST);
    die();
}

include('../../tcpdf.php');
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100);
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
$i=0;
while ($i++ < $copies) {
    $pdf->AddPage();

    $LX = 72;
    $pdf->Image("logos/logocoatings.png",$LX,45,120.5,56,'','','',true);
    $pdf->Image("logos/logomachine.jpg",$LX += 120, 44, 115, 57,'','','',true);
    $pdf->Image("logos/logodelivery.png",$LX += 116,44,95,57,'','','',true);
    $pdf->Image("logos/logoweld.jpg",$LX += 96,36.5,119,64.5,'','','',true);


    $X = 72;
    $Y = 115;

    $pdf->SetXY($X + 50, $Y);
    $pdf->SetFont("helvetica","B",25,'',false);
    $pdf->Write(10,"Unpaid Time Off Request Form");
    $pdf->SetXY($X, $Y += 75);
    $pdf->SetFont("helvetica","",12,'',false);
    $pdf->Write(10,"Your request must be submitted and approved by management in advance. When more ");
    $pdf->SetXY($X, $Y += 15);
    $pdf->Write(10, "than one employee has requested the same time, it may make it difficult for Preferred");
    $pdf->SetXY($X, $Y += 15);
    $pdf->Write(10, "Machine, LLC, to provide quality service or meet projected schedule deadlines.");
    $pdf->SetXY($X, $Y += 15);
    $pdf->Write(10, "Requests will be considered in the order they were received. Though every effort will be");
    $pdf->SetXY($X, $Y += 15);
    $pdf->Write(10, "made to honor your PTO request, business operations may dictate that the employee");
    $pdf->SetXY($X, $Y += 15);
    $pdf->Write(10, "reschedule his/her PTO.");

    $pdf->SetFont("helvetica","",14,'',false);
    $pdf->SetXY($X, $Y += 44);
    $pdf->Write(10, "Today's Date: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, $now);
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY($X, $Y += 33);
    $pdf->Write(10, "Employee Name: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, $name);
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY($X, $Y += 31);
    $pdf->Write(10, "Department: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, $department);
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY($X, $Y += 32.5);
    $pdf->Write(10, "Unpaid Date(s) Requested: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, "$start - $end");
    $pdf->SetTextColor(0,0,0,100);

    $pdf->SetXY($X, $Y += 32.5);
    $pdf->Write(10, "Employee Signature: ");
    $pdf->SetTextColor(100,100,100);
    //$pdf->Write(10,"___________________________________");
    $pdf->Write(10, $name);
    $pdf->SetTextColor(0,0,0,100);

    $pdf->SetXY($X, $Y += 32.5);
    $pdf->Write(10, "Supervisor/Manager Name: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, $supervisor);
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY($X, $Y += 32.5);
    $pdf->Write(10, "Supervisor/Manager Signature: ");
    $pdf->SetTextColor(100,100,100);
    $pdf->Write(10, $supervisor);
    //$pdf->Write(10,"___________________________________");
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY($X, $Y += 32.5);
    $pdf->Write(10, "Remarks:"); //TODO: Multiline notes
    $pdf->SetXY($X, $Y += 32);

    $base = $Y;
    $pdf->Write(10, "____________________________________________________________");
    $pdf->SetXY($X, $Y += 32);
    $pdf->Write(10, "____________________________________________________________");
    $pdf->SetXY($X, $Y += 32);
    $pdf->Write(10, "____________________________________________________________");

    if (!empty($notes)) {
        $pdf->SetFont("helvetica","",12,'',false);
        $lines = multiLine($notes, 85);

        $pdf->SetTextColor(100,100,100);
        foreach ($lines as $line) {
            $pdf->SetXY($X, $base);
            $pdf->Write(10,$line);
            $base += 33;
        }
        $pdf->SetTextColor(0,0,0,100);
        $pdf->SetFont("helvetica","",14,'',false);
    }

    renderBox($pdf, $X, $Y+=50, 26, "Approved", $approved);
    renderBox($pdf, $X+180, $Y, 26, "Denied", !$approved);

    $pdf->SetXY($X, $Y+80);
}

$pdf->Output("UNPAID TIME OFF-$name", "I");
?>