<?php

function multiLine($string,$max=60) {
	$lines=array();
	$stringlines=explode("\r\n",$string);
	foreach ($stringlines as $string) {
		$words=explode(" ",$string);
		$widx=0;
		$string="";
		while ($widx < count($words)) {
			$retstring="";
			$tooLong=0;
			while ($widx < count($words) and $tooLong==0 ) {
				if ($retstring) {
					$retstring.=" ";
				}
				$oldstring=$retstring;
				$retstring.=$words[$widx];
				if (strlen($words[$widx])>$max) {
					if ($oldstring == "") {
						$retstring=substr($words[$widx],0,$max);
						$words[$widx]=substr($words[$widx],$max);
					} else {
						$retstring=$oldstring;
					}
					$tooLong=1;
				} else {
					if ( strlen($retstring)>$max) {
						$retstring=$oldstring;
						$tooLong=1;
					} else {
						$widx++;
					}
				}
			}
			if (trim($retstring)) {
				$lines[]=$retstring;
			}
		}
	}
	return $lines;
}

function renderBox($pdf, $X, $Y, $size, $label = false, $checked = false) {
    if ($checked) {
        $pdf->SetLineWidth(2);
        $pdf->Line($X, $Y, $X+$size,$Y+$size);
        $pdf->Line($X, $Y+$size,$X+$size, $Y);
        $pdf->SetLineWidth(1);
    }
    $pdf->Line($X, $Y, $X + $size, $Y);
    $pdf->Line($X, $Y, $X, $Y + $size);
    $pdf->Line($X + $size, $Y, $X + $size, $Y + $size);
    $pdf->Line($X, $Y += $size, $X + $size, $Y);
    if ($label) {
        $pdf->SetXY($X + $size + 5, $Y - ($size/0.8));
        $pdf->Write(10, $label);
    }

    return $pdf;
}

function renderRect($pdf, $X, $Y, $X2, $Y2) {
    $pdf->Line($X, $Y, $X + $X2, $Y);
    $pdf->Line($X, $Y, $X, $Y + $Y2);
    $pdf->Line($X + $X2, $Y, $X + $X2, $Y + $Y2);
    $pdf->Line($X, $Y += $Y2, $X + $X2, $Y);

    return $pdf;
}

$start = false;
$end = false;
$name = false;
$department = false;
$supervisor = false;
$notes = "";
$approved = false;
$copies = 1;

if (empty($_POST)) $_POST = $_GET;

if (isset($_POST["start"])) $start = date("m-d-Y h:i A", strtotime($_POST["start"]));
if (isset($_POST["end"])) $end = date("m-d-Y h:i A", strtotime($_POST["end"]));
if (isset($_POST["name"])) $name = $_POST["name"];
if (isset($_POST["department"])) $department = $_POST["department"];
if (isset($_POST["supervisor"])) $supervisor = $_POST["supervisor"];
if (isset($_POST["notes"])) $notes = $_POST["notes"];
if (isset($_POST["status"])) $approved = $_POST["status"] == "approved";
if (isset($_POST["copies"])) $copies = $_POST["copies"];
$now = date("m-d-Y h:i A");


if (!$start || !$end || !$name || !$department  || !$supervisor) {
    print_r($_POST);
    die();
}

include('../../tcpdf.php');
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100);
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
$i=0;

while ($i++ < $copies) {
    $pdf->AddPage();

    $LX = 72;
    $pdf->Image("logos/logocoatings.png",$LX,45,120.5,56,'','','',true);
    $pdf->Image("logos/logomachine.jpg",$LX += 120, 44, 115, 57,'','','',true);
    $pdf->Image("logos/logodelivery.png",$LX += 116,44,95,57,'','','',true);
    $pdf->Image("logos/logoweld.jpg",$LX += 96,36.5,119,64.5,'','','',true);

    $pdf->SetFont("helvetica","B",12,'',false);

    $pdf->SetXY(244, 114);
    $pdf->Write(10,"PTO REQUEST FORM");
    $pdf->Line(244, 127.5, 369, 127.5, ['width' => 1.3]);

    $pdf->SetFont("helvetica","",12,'',false);

    $pdf->SetXY(77, 169);
    $pdf->Write(10, "Your request for time off must be submitted and approved by management a minimum");
    $pdf->SetXY(239, 183);
    $pdf->Write(10, "of two weeks in advance.");

    $lx = 71;
    $ly = 263.5;

    $pdf->SetLineWidth(15.5);
    $pdf->Line($lx, $ly, $lx+487.7, $ly);

    $pdf->SetXY(232, 256.5);
    $pdf->SetTextColor(255,255,255);
    $pdf->SetFont("helvetica","B",12,'',false);
    $pdf->Write(10, "EMPLOYEE INFORMATION");

    $pdf->SetFont("helvetica","B",11,'',false);
    $pdf->SetTextColor(0,0,0,100);
    $pdf->SetXY(78, 216+60);
    $pdf->Write(10, "NAME: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, $name);
    $pdf->SetFont("helvetica","B",11,'',false);

    $pdf->SetXY(78, 241.5+60);
    $pdf->Write(10, "DEPARTMENT: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, $department);

    $pdf->SetFont("helvetica","B",11,'',false);
    $pdf->SetXY(322, 241.5+60);
    $pdf->Write(10, "PTO HOURS AVAILABLE: ");
    $pdf->Write(10, "TODO");

    $pdf->SetFont("helvetica","",11.15,'',false);

    $pdf->SetLineWidth(1.5);
    renderRect($pdf, 71.8, 210+60, 486.25, 53);


    $base = 288+60;
    $x = 72;
    $pdf->SetXY($x, $base += 13);
    $pdf->Write(10, "You may request PTO time throughout the year. When more than one employee has requested");
    $pdf->SetXY($x, $base += 12.5);
    $pdf->Write(10, "the same time, and when this would make it difficult to provide quality service or meet projected");
    $pdf->SetXY($x, $base += 12.5);
    $pdf->Write(10, "schedules, requests will be considered in the order in which they are  received.  Every effort will");
    $pdf->SetXY($x, $base += 12.5);
    $pdf->Write(10, "be  made  to  honor  your  PTO  request. Business  operations  may  dictate  that  the employee");
    $pdf->SetXY($x, $base += 12.5);
    $pdf->Write(10, "reschedule his/her PTO.");

    $pdf->SetXY($x, $base += 25.5);
    $pdf->Write(10, "PTO request should be in a minimum of half-day (4 hour) requests");
    $pdf->SetXY($x, $base += 25.5);
    $pdf->Write(10, "Directions:  Indicate your PTO choice(s) in the space(s) below. Sign,  date,  and forward to your");
    $pdf->SetXY($x, $base += 12.5);
    $pdf->Write(10, "supervisor for approval.");

    $pdf->SetLineWidth(0.1);
    $X = 72;
    $width = 468;
    $Y = 459+85;
    renderRect($pdf, $X, $Y, $width, 130);
    $pdf->Line($X, $Y += 19.5, $X + $width, $Y);
    $pdf->Line($X+313, $Y, $X+313, $Y += 18.5);
    $pdf->Line($X, $Y, $X + $width, $Y);
    $pdf->Line($X, $Y += 74.3, $X + $width, $Y);
    $pdf->Line($X+313, $Y, $X+313, $Y += 17.5);

    $pdf->SetFont("helvetica","B",11,'',false);

    $pdf->SetXY(78, 461.5+85);
    $pdf->Write(10,"PTO date(s) requested: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, $start . " - " . $end);
    $pdf->SetFont("helvetica","B",11,'',false);
    $pdf->SetXY(78, 480+85);
    $pdf->Write(10,"Employee Signature: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, $name);
    $pdf->SetFont("helvetica","B",11,'',false);
    $pdf->SetXY(391, 480+85);
    $pdf->Write(10,"Request Date: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, date("m-d-Y"));
    $pdf->SetFont("helvetica","B",11,'',false);
    renderBox($pdf, 79, 590, 10, "Approved", $approved);
    renderBox($pdf, 259, 590, 10, "Denied", !$approved);

    $pdf->SetXY(78, 605);
    $pdf->Write(10,"Remarks:");
    $X = 80;
    $base = 615;
    if (!empty($notes)) {
        $pdf->SetFont("helvetica","",11,'',false);
        $lines = multiLine($notes, 85);

        foreach ($lines as $line) {
            $pdf->SetXY($X, $base);
            $pdf->Write(10,$line);
            $base += 10;
        }
        $pdf->SetFont("helvetica","B",11,'',false);
    }


    $pdf->SetXY(78, 658);
    $pdf->Write(10,"Supervisor/Manager Signature: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, $supervisor);

    $pdf->SetFont("helvetica","B",11,'',false);
    $pdf->SetXY(391, 658);
    $pdf->Write(10,"Date: ");
    $pdf->SetFont("helvetica","",11,'',false);
    $pdf->Write(10, date("m-d-Y"));


}

$pdf->Output("TEST", "I");
?>